/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.quickr;

import com.flowbuilder.util.TDiag;
import com.flowbuilder.util.TString;
import com.flowbuilder.xsp.servlet.Context;
import com.flowbuilder.xsp.servlet.XSPServletContext;
import com.triloggroup.lotus.IServiceConnector;
import com.triloggroup.quickr.IProviderQuickrUtil;
import com.triloggroup.quickr.ProviderQuickrUtilAbstract;
import com.triloggroup.quickr.QuickrUtil;
import com.triloggroup.quickr.UPlaceService;
import com.triloggroup.quickr.XSPServiceConnector;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;

public class ProviderQuickrUtilDomino
extends ProviderQuickrUtilAbstract {
    public static final String MANAGER_ROLE_ID_DOMINO = "Manager";
    public static final String EDITOR_ROLE_ID_FOMINO = "Editor";
    private static final String CURRENT_PLACE_ID_KEY = "TgCurrentQuickrPlaceId";

    public boolean addMemberToCurrentTeamSpace(Context context, String string) {
        return this.addMemberWithRoleToCurrentTeamSpace(context, string, EDITOR_ROLE_ID_FOMINO);
    }

    public boolean addMemberWithRoleToCurrentTeamSpace(Context context, String string, String string2) {
        return this.addMemberWithRoleToTeamSpace(context, string, string2, this.getCurrentTeamSpaceId(context));
    }

    public boolean addMemberToTeamSpace(Context context, String string, String string2) {
        return this.addMemberWithRoleToTeamSpace(context, string, EDITOR_ROLE_ID_FOMINO, string2);
    }

    public boolean addMemberWithRoleToTeamSpace(Context context, String string, String string2, String string3) {
        return this.addMemberWithRoleToTeamSpace(new XSPServiceConnector(context), string, string2, string3);
    }

    public boolean addMemberWithRoleToTeamSpace(IServiceConnector iServiceConnector, String string, String string2, String string3) {
        if (string2 == "manager") {
            string2 = MANAGER_ROLE_ID_DOMINO;
        } else if (string2 == "user") {
            string2 = EDITOR_ROLE_ID_FOMINO;
        }
        if (string2 == null) {
            string2 = EDITOR_ROLE_ID_FOMINO;
        }
        try {
            UPlaceService.Role role = new UPlaceService.Role();
            role.title = string2;
            role.id = string2;
            UPlaceService.addMemberWithRoleToPlaceDomino(iServiceConnector, string3, role, string);
            return true;
        }
        catch (Exception exception) {
            System.out.println("Error when trying to add " + string + " with role " + string2 + " to place " + string3);
            TDiag.exception((Throwable)exception, (String)("Error when trying to add " + string + " with role " + string2 + " to place"));
            return false;
        }
    }

    public boolean removeMemberOfCurrentTeamSpace(Context context, String string) {
        return this.removeMemberOfTeamSpace(context, string, this.getCurrentTeamSpaceId(context));
    }

    public boolean removeMemberOfTeamSpace(Context context, String string, String string2) {
        try {
            XSPServiceConnector xSPServiceConnector = new XSPServiceConnector(context);
            UPlaceService.removeMemberOfPlaceDomino(xSPServiceConnector, string2, string);
            return true;
        }
        catch (Exception exception) {
            TDiag.exception((Throwable)exception, (String)("Error when trying to remove " + string + " of place " + string2));
            return false;
        }
    }

    public String[] getAllMembersDnOfCurrentTeamSpace(Context context) {
        try {
            XSPServiceConnector xSPServiceConnector = new XSPServiceConnector(context);
            String[] stringArray = UPlaceService.getMembersDnOfPlaceDomino(xSPServiceConnector, this.getCurrentTeamSpaceId(context));
            if (stringArray != null) {
                if (this.hasDnToBeConverted(context)) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = this.convertDnFromQDToExtLdap(stringArray[i]);
                    }
                }
                return stringArray;
            }
        }
        catch (Exception exception) {
            TDiag.exception((Throwable)exception, (String)"Error when trying to get All Members Dn of current place");
        }
        return new String[0];
    }

    public String[] getAllMembersDnByRoleOfCurrentTeamSpace(Context context, String string) {
        try {
            XSPServiceConnector xSPServiceConnector = new XSPServiceConnector(context);
            UPlaceService.Role role = new UPlaceService.Role();
            role.title = string;
            role.id = string;
            String[] stringArray = UPlaceService.getMembersDnByRoleOfPlaceDomino(xSPServiceConnector, this.getCurrentTeamSpaceId(context), role);
            if (stringArray != null) {
                if (this.hasDnToBeConverted(context)) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = this.convertDnFromQDToExtLdap(stringArray[i]);
                    }
                }
                return stringArray;
            }
        }
        catch (Exception exception) {
            TDiag.exception((Throwable)exception, (String)("Error when trying to get All Members Dn of Role " + string));
        }
        return new String[0];
    }

    public HashMap getAllMembersDnAndRolesOfCurrentTeamSpace(Context context) {
        return this.getAllMembersDnAndRolesOfTeamSpace(context, this.getCurrentTeamSpaceId(context));
    }

    public HashMap getAllMembersDnAndRolesOfTeamSpace(Context context, String string) {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        try {
            XSPServiceConnector xSPServiceConnector = new XSPServiceConnector(context);
            UPlaceService.Role[] roleArray = UPlaceService.getPlaceRolesDomino(xSPServiceConnector, string);
            if (roleArray != null) {
                for (int i = 0; i < roleArray.length; ++i) {
                    String[] stringArray = UPlaceService.getMembersDnByRoleOfPlaceDomino(xSPServiceConnector, string, roleArray[i]);
                    if (this.hasDnToBeConverted(context)) {
                        for (int j = 0; j < stringArray.length; ++j) {
                            stringArray[j] = this.convertDnFromQDToExtLdap(stringArray[j]);
                        }
                    }
                    hashMap.put(roleArray[i].id, stringArray);
                }
            }
        }
        catch (Exception exception) {
            TDiag.exception((Throwable)exception, (String)("Error when trying to get All Members Dn And Roles of place " + string));
        }
        return hashMap;
    }

    public IProviderQuickrUtil.QuickrRole getMemberRoleOfPlace(Context context, String string, String string2) {
        try {
            XSPServiceConnector xSPServiceConnector = new XSPServiceConnector(context);
            UPlaceService.Role[] roleArray = UPlaceService.getPlaceRolesDomino(xSPServiceConnector, string2);
            if (roleArray != null) {
                for (int i = 0; i < roleArray.length; ++i) {
                    String[] stringArray = UPlaceService.getMembersDnByRoleOfPlaceDomino(xSPServiceConnector, string2, roleArray[i]);
                    for (int j = 0; j < stringArray.length; ++j) {
                        if (this.hasDnToBeConverted(context)) {
                            stringArray[j] = this.convertDnFromQDToExtLdap(stringArray[j]);
                        }
                        if (!TString.equalsIgnoreCase((String)string, (String)stringArray[j])) continue;
                        IProviderQuickrUtil.QuickrRole quickrRole = new IProviderQuickrUtil.QuickrRole();
                        quickrRole.id = roleArray[i].id;
                        quickrRole.title = roleArray[i].title;
                        return quickrRole;
                    }
                }
            }
        }
        catch (Exception exception) {
            TDiag.exception((Throwable)exception, (String)("Error when trying to get Role of " + string + " for place " + string2));
        }
        return null;
    }

    public IProviderQuickrUtil.QuickrRole getMemberRoleOfCurrentPlace(Context context, String string) {
        try {
            return this.getMemberRoleOfPlace(context, string, this.getCurrentTeamSpaceId(context));
        }
        catch (Exception exception) {
            TDiag.exception((Throwable)exception, (String)("Error when trying to get role of " + string + " in current place"));
            return null;
        }
    }

    public IProviderQuickrUtil.QuickrRole getRoleOfPlaceById(Context context, String string, String string2) {
        try {
            XSPServiceConnector xSPServiceConnector = new XSPServiceConnector(context);
            UPlaceService.Role[] roleArray = UPlaceService.getPlaceRolesDomino(xSPServiceConnector, string);
            if (roleArray != null) {
                for (int i = 0; i < roleArray.length; ++i) {
                    if (!TString.equals((String)string2, (String)roleArray[i].id)) continue;
                    IProviderQuickrUtil.QuickrRole quickrRole = new IProviderQuickrUtil.QuickrRole();
                    quickrRole.id = roleArray[i].id;
                    quickrRole.title = roleArray[i].title;
                    return quickrRole;
                }
            }
        }
        catch (Exception exception) {
            TDiag.exception((Throwable)exception, (String)("Error when trying to get role by id " + string2 + " in place " + string));
        }
        return null;
    }

    public String getCurrentTeamSpaceId(Context context) {
        XSPServletContext xSPServletContext = (XSPServletContext)context.getXSPAbstractContext();
        String string = context.getUrlParameter("tgPlaceLoc");
        String string2 = this.extractPlaceIdFromUrl(string, context);
        if (string2 != null) {
            xSPServletContext.setSessionAttribute(CURRENT_PLACE_ID_KEY, (Object)string2);
        } else {
            string2 = (String)xSPServletContext.getSessionAttribute(CURRENT_PLACE_ID_KEY);
        }
        return string2;
    }

    private String extractPlaceIdFromUrl(String string, Context context) {
        int n;
        int n2 = string.indexOf("/Main.nsf");
        if (n2 != -1 && (n = string.substring(0, n2).lastIndexOf(47)) != -1 && n < n2) {
            if (QuickrUtil.isInQuickrDomino85(context)) {
                String string2 = string.substring(n + 1, n2);
                string2 = string2.substring(0, Math.min(64, string2.length()));
                string2 = string2.toLowerCase();
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < string2.length(); ++i) {
                    char c = string2.charAt(i);
                    if (c == '$') {
                        stringBuffer.append("_24");
                        continue;
                    }
                    if (c == '-') {
                        stringBuffer.append("_2d");
                        continue;
                    }
                    if (c == '_') {
                        stringBuffer.append("_5f");
                        continue;
                    }
                    if ((c < '0' || c > '9') && (c < 'a' || c > 'z')) continue;
                    stringBuffer.append(c);
                }
                StringBuffer stringBuffer2 = new StringBuffer("_P");
                stringBuffer2.append(stringBuffer);
                stringBuffer2.append("_RMain");
                return stringBuffer2.toString();
            }
            StringBuffer stringBuffer = new StringBuffer("%5B%40P");
            stringBuffer.append(URLEncoder.encode(string.substring(n + 1, n2)));
            stringBuffer.append("%2F%40R");
            stringBuffer.append(URLEncoder.encode(string.substring(n2 + 1, n2 + 9)));
            stringBuffer.append("%5D");
            return stringBuffer.toString();
        }
        return null;
    }

    private UPlaceService.Place getCurrentPlace(Context context) throws Exception {
        String string = this.getCurrentTeamSpaceId(context);
        if (!TString.isEmpty((String)string)) {
            return this.getPlaceById(context, string);
        }
        return null;
    }

    private UPlaceService.Place getPlaceById(Context context, String string) throws Exception {
        XSPServiceConnector xSPServiceConnector = new XSPServiceConnector(context);
        return UPlaceService.getPlaceInfoDomino(xSPServiceConnector, string);
    }

    public String[] getAllTeamSpaceIds(Context context) {
        XSPServiceConnector xSPServiceConnector = new XSPServiceConnector(context);
        try {
            return UPlaceService.getAllPlaceIds(xSPServiceConnector);
        }
        catch (Throwable throwable) {
            TDiag.exception((Throwable)throwable, (String)"Error when trying to get All place Ids");
            return null;
        }
    }

    public String getCurrentTeamSpaceMetaDataValue(Context context, String string) {
        System.out.println("getCurrentTeamSpaceMetaDataValue not implemented");
        return null;
    }

    public String getCurrentDocumentLibraryHrefId(Context context) {
        try {
            UPlaceService.Place place = this.getCurrentPlace(context);
            if (place != null) {
                return place.libHrefId;
            }
        }
        catch (Throwable throwable) {
            TDiag.exception((Throwable)throwable, (String)"Error when trying to get Current Document Library HrefId");
        }
        return null;
    }

    public String getDocumentLibraryHrefIdOfTeamSpace(Context context, String string) {
        try {
            UPlaceService.Place place = this.getPlaceById(context, string);
            if (place != null) {
                return place.libHrefId;
            }
        }
        catch (Throwable throwable) {
            TDiag.exception((Throwable)throwable, (String)("Error when trying to get Document Library HrefId of place " + string));
        }
        return null;
    }

    public HttpServletRequest getHttpServletRequest(Context context) {
        return context.getHttpRequest();
    }

    public IProviderQuickrUtil.QuickrRole[] getRolesOfPlace(Context context, String string) {
        XSPServiceConnector xSPServiceConnector = new XSPServiceConnector(context);
        try {
            UPlaceService.Role[] roleArray = UPlaceService.getPlaceRolesDomino(xSPServiceConnector, string);
            if (roleArray != null) {
                IProviderQuickrUtil.QuickrRole[] quickrRoleArray = new IProviderQuickrUtil.QuickrRole[roleArray.length];
                for (int i = 0; i < roleArray.length; ++i) {
                    quickrRoleArray[i] = new IProviderQuickrUtil.QuickrRole();
                    quickrRoleArray[i].id = roleArray[i].id;
                    quickrRoleArray[i].title = roleArray[i].title;
                }
                return quickrRoleArray;
            }
        }
        catch (Throwable throwable) {
            TDiag.exception((Throwable)throwable, (String)("Error when trying to get All roles of place " + string));
        }
        return null;
    }

    public String[] getRoleIdsOfPlace(IServiceConnector iServiceConnector, String string) {
        try {
            UPlaceService.Role[] roleArray = UPlaceService.getPlaceRolesDomino(iServiceConnector, string);
            if (roleArray != null) {
                String[] stringArray = new String[roleArray.length];
                for (int i = 0; i < roleArray.length; ++i) {
                    stringArray[i] = roleArray[i].id;
                }
                return stringArray;
            }
        }
        catch (Throwable throwable) {
            TDiag.exception((Throwable)throwable, (String)("Error when trying to get All Role Ids of place " + string));
        }
        return null;
    }

    private boolean hasDnToBeConverted(Context context) {
        String string;
        Principal principal;
        return !TString.equals((String)context.getDirectoryServer().getDirectory().getDirectoryManufacturer(), (String)"LDAPDomino") && (principal = context.getHttpRequest().getUserPrincipal()) != null && !TString.isEmpty((String)principal.getName()) && !TString.equals((String)this.convertDnFromQDToExtLdap(string = principal.getName()), (String)string);
    }

    private String convertDnFromQDToExtLdap(String string) {
        String string2 = TString.replace((String)string, (char)'/', (char)',');
        string2 = this.convertDn2ndAttrFromOuToCn(string2);
        return string2;
    }

    private String convertDn2ndAttrFromOuToCn(String string) {
        int n = 0;
        int n2 = string.indexOf(61);
        int n3 = string.indexOf(44);
        while (n3 > 0 && string.charAt(n3 - 1) == '\\') {
            n = n3 + 1;
            n3 = string.indexOf(44, n);
        }
        if (n3 > 0 && n2 > 0 && n2 < n3) {
            int n4 = string.indexOf(61, n3 + 1);
            while (n4 > 0 && string.charAt(n4 - 1) == '\\') {
                n = n4 + 1;
                n4 = string.indexOf(61, n);
            }
            if (n4 > 0 && "ou".equals(string.substring(n3 + 1, n4))) {
                String string2 = "cn";
                if (Character.isUpperCase(string.charAt(0))) {
                    string2 = Character.isUpperCase(string.charAt(1)) ? "CN" : "Cn";
                }
                return string.substring(0, n3 + 1) + string2 + string.substring(n4);
            }
        }
        return string;
    }
}

