/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.quickr;

import com.flowbuilder.util.TDiag;
import com.flowbuilder.util.TString;
import com.triloggroup.lotus.ClientServiceConnector;
import com.triloggroup.lotus.IServiceConnector;
import com.triloggroup.quickr.UPlaceService;
import com.triloggroup.quickr.doclib.DocumentLibraryExport;
import com.triloggroup.quickr.doclib.DocumentLibraryImport;
import com.triloggroup.quickr.doclib.IDocumentLibraryMoverForQuickr;
import com.triloggroup.quickr.doclib.UDocumentLibrary;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipFile;

public class PlaceCloner
implements IDocumentLibraryMoverForQuickr {
    private UPlaceService.Place sourcePlace;
    private String newPlaceName;
    private String newPlaceSummary;
    private String templateName;
    private IServiceConnector serviceConnector;
    private HashMap docLibEntriesMap;

    public PlaceCloner(IServiceConnector iServiceConnector, String string, String string2) throws Exception {
        this(iServiceConnector, string, string2, null, null);
    }

    public PlaceCloner(IServiceConnector iServiceConnector, String string, String string2, String string3, String string4) throws Exception {
        this.serviceConnector = iServiceConnector;
        this.newPlaceName = string3;
        this.newPlaceSummary = string4;
        this.templateName = string2;
        try {
            this.sourcePlace = UPlaceService.getPlaceInfo(iServiceConnector, string);
        }
        catch (Exception exception) {
            throw new Exception("Error to get information about the place to clone : " + string, exception);
        }
        if (TString.isEmpty((String)string3)) {
            this.newPlaceName = this.sourcePlace.title;
        }
        if (TString.isEmpty((String)string4)) {
            this.newPlaceSummary = !TString.isEmpty((String)this.sourcePlace.summary) && !this.sourcePlace.summary.startsWith("{fr=") ? this.sourcePlace.summary : " ";
        }
    }

    public UPlaceService.Place clonePlace() throws Exception {
        this.docLibEntriesMap = null;
        UPlaceService.Place place = UPlaceService.createPlace(this.serviceConnector, this.newPlaceName, this.newPlaceSummary, this.templateName);
        this.updateMembers(place);
        this.cloneDocumentLibrary(place);
        return place;
    }

    public void renameSourcePlace(String string) throws Exception {
        UPlaceService.updatePlace(this.serviceConnector, this.sourcePlace.id, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cloneDocumentLibrary(UPlaceService.Place place) throws Exception {
        if (TString.isEmpty((String)this.sourcePlace.libHrefId) || TString.isEmpty((String)place.libHrefId)) {
            return;
        }
        File file = File.createTempFile("doclib", ".zip");
        try {
            DocumentLibraryExport documentLibraryExport = new DocumentLibraryExport(this.serviceConnector);
            documentLibraryExport.exportLibrary(this.sourcePlace.libHrefId, new FileOutputStream(file));
            DocumentLibraryImport documentLibraryImport = new DocumentLibraryImport(this.serviceConnector);
            ZipFile zipFile = new ZipFile(file);
            documentLibraryImport.importLibrary(place.libHrefId, zipFile);
            this.docLibEntriesMap = documentLibraryImport.getDocEntriesMap();
            zipFile.close();
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    public UDocumentLibrary.Entry getNewDocumentEntryByOldContentUrl(String string) {
        if (this.docLibEntriesMap != null) {
            int n;
            UDocumentLibrary.Entry entry = (UDocumentLibrary.Entry)this.docLibEntriesMap.get(string);
            if (entry == null && (n = string.indexOf(DocumentLibraryImport.START_LIB_URL)) != -1) {
                String string2 = string.substring(n);
                for (Map.Entry entry2 : this.docLibEntriesMap.entrySet()) {
                    UDocumentLibrary.Entry entry3 = (UDocumentLibrary.Entry)entry2.getValue();
                    String string3 = entry3.contentUrl;
                    n = string3.indexOf(DocumentLibraryImport.START_LIB_URL);
                    if (n == -1 || !TString.equals((String)string3.substring(n), (String)string2)) continue;
                    return entry3;
                }
            }
            return entry;
        }
        return null;
    }

    protected void updateMembers(UPlaceService.Place place) throws Exception {
        HashMap hashMap = UPlaceService.getMembersDnAndRolesOfPlace(this.serviceConnector, this.sourcePlace.id);
        if (hashMap != null) {
            UPlaceService.Role[] roleArray = UPlaceService.getPlaceRoles(this.serviceConnector, place.id);
            for (Map.Entry entry : hashMap.entrySet()) {
                UPlaceService.Role role;
                UPlaceService.Role role2 = (UPlaceService.Role)entry.getKey();
                String[] stringArray = (String[])entry.getValue();
                if (stringArray == null || stringArray.length <= 0 || (role = this.getRoleByTitle(roleArray, role2.title)) == null) continue;
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        UPlaceService.addMemberWithRoleToPlace(this.serviceConnector, place.id, role, stringArray[i]);
                        continue;
                    }
                    catch (Exception exception) {
                        TDiag.exception((Throwable)exception, (String)("Could not add member " + stringArray[i] + " with role " + role.title + " to Place " + place.title));
                    }
                }
            }
        }
    }

    private UPlaceService.Role getRoleByTitle(UPlaceService.Role[] roleArray, String string) {
        if (!TString.isEmpty((String)string) && roleArray != null) {
            for (int i = 0; i < roleArray.length; ++i) {
                if (!TString.equals((String)roleArray[i].title, (String)string)) continue;
                return roleArray[i];
            }
        }
        return null;
    }

    public static void main(String[] stringArray) {
        try {
            ClientServiceConnector clientServiceConnector = new ClientServiceConnector("http://belouga.triloggroup.com:10038/", "quikradm", "quikradm");
            PlaceCloner placeCloner = new PlaceCloner(clientServiceConnector, "11_8000CB1A0843D0IG8JGPHV20G7", "ProjExec Project Place", "peApp1 - clone", null);
            UPlaceService.Place place = placeCloner.clonePlace();
            System.out.println("description of the new place");
            UPlaceService.dump(place);
            placeCloner.renameSourcePlace("peApp1 - OLD");
            System.out.println("Original Place renamed");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

