/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.lotus.atom.cmis.test;

import com.triloggroup.lotus.ClientServiceConnector;
import com.triloggroup.lotus.atom.cmis.CmisConnection;
import com.triloggroup.lotus.atom.cmis.CmisContentAlreadyExistsException;
import com.triloggroup.lotus.atom.cmis.CmisEntry;
import com.triloggroup.lotus.atom.cmis.test.CmisExplorer;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class TestCmis {
    private static Env env = Env.TGLC45FR;
    private static final String BASE_URL;
    private static final String LOGIN;
    private static final String PWD;
    private CmisConnection connection;

    public static void main(String[] stringArray) {
        try {
            TestCmis.disableHttpsCertificateValidation();
            TestCmis testCmis = new TestCmis();
            testCmis.startCmisExplorer(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private TestCmis() throws Exception {
        ClientServiceConnector clientServiceConnector = new ClientServiceConnector(BASE_URL, LOGIN, PWD);
        this.connection = new CmisConnection(clientServiceConnector);
        this.connection.init();
    }

    private void startCmisExplorer(CmisEntry cmisEntry) throws Exception {
        if (cmisEntry == null) {
            cmisEntry = this.connection.getObjectById(this.connection.getRepository().getRootFolderId());
        }
        new CmisExplorer(this.connection, cmisEntry);
    }

    private void runReferenceTests() throws Exception {
        CmisEntry cmisEntry = this.connection.getObjectById(this.connection.getRepository().getRootFolderId());
        EntryNode entryNode = new EntryNode(cmisEntry);
        this.populateChildren(entryNode, true);
    }

    private void populateChildren(EntryNode entryNode, boolean bl) throws Exception {
        CmisEntry[] cmisEntryArray = this.connection.getFolderContent(entryNode.entry);
        entryNode.children = new ArrayList<EntryNode>();
        for (CmisEntry cmisEntry : cmisEntryArray) {
            EntryNode entryNode2 = new EntryNode(cmisEntry);
            entryNode.children.add(entryNode2);
            if (!bl || !cmisEntry.isFolder()) continue;
            this.populateChildren(entryNode2, true);
        }
    }

    private void runDevTests() throws Exception {
        block2: {
            CmisConnection cmisConnection = this.connection;
            CmisEntry cmisEntry = cmisConnection.getObjectById(cmisConnection.getRepository().getRootFolderId());
            System.out.println("============== Root Folder content============");
            CmisEntry[] cmisEntryArray = cmisConnection.getFolderContent(cmisEntry);
            System.out.println("==============First child folder content===============");
            cmisConnection.getFolderContent(cmisEntryArray[0]);
            CmisEntry cmisEntry2 = cmisEntryArray[0];
            String string = "c:\\download\\DSCF0544.jpg";
            String string2 = "island.jpg";
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                CmisEntry cmisEntry3 = cmisConnection.createDocument(cmisEntry2, string2, "image/jpeg", (InputStream)fileInputStream);
            }
            catch (CmisContentAlreadyExistsException cmisContentAlreadyExistsException) {
                CmisEntry cmisEntry4 = cmisContentAlreadyExistsException.getRepositoryEntry();
                if (cmisEntry4 == null) break block2;
                FileInputStream fileInputStream = new FileInputStream(string);
                CmisEntry cmisEntry5 = cmisConnection.createDocumentVersion(cmisEntry4.cmisObjectId, fileInputStream, true, "updated by projexec");
            }
        }
        System.out.println("done");
    }

    private static void disableHttpsCertificateValidation() throws KeyManagementException, NoSuchAlgorithmException {
        TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        SSLContext sSLContext = SSLContext.getInstance("SSL");
        sSLContext.init(null, trustManagerArray, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
    }

    static {
        switch (env) {
            case LIVE_TEST: {
                BASE_URL = "https://apps.na.collabservtest.lotus.com";
                LOGIN = "lpoublan@triloggroup.com";
                PWD = "live2004";
                break;
            }
            case LIVE_STAGE: {
                BASE_URL = "https://apps.stage.lotuslive.com";
                LOGIN = "lpoublan@triloggroup.com";
                PWD = "live2004";
                break;
            }
            case LIVE: {
                BASE_URL = "https://apps.lotuslive.com";
                LOGIN = "lpoublan@triloggroup.com";
                PWD = "live2004";
                break;
            }
            case GREENHOUSE: {
                BASE_URL = "https://greenhouse.lotus.com";
                LOGIN = "sgrenier@triloggroup.com";
                PWD = "gemini13";
                break;
            }
            case SUSE64FR: {
                BASE_URL = "http://suse64fr.triloggroup.com";
                LOGIN = "pcollins";
                PWD = "floflo";
                break;
            }
            case TGLC45FR: {
                BASE_URL = "http://tglc45fr.triloggroup.com";
                LOGIN = "pcollins";
                PWD = "floflo";
                break;
            }
            default: {
                throw new IllegalStateException("Unknown env: " + (Object)((Object)env));
            }
        }
    }

    private class EntryNode {
        final CmisEntry entry;
        List<EntryNode> children;

        EntryNode(CmisEntry cmisEntry) {
            this.entry = cmisEntry;
        }

        public String toString() {
            return String.valueOf(this.entry);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Env {
        LIVE_TEST,
        LIVE_STAGE,
        LIVE,
        GREENHOUSE,
        SUSE64FR,
        TGLC45FR;

    }
}

