/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.lotus.atom.cmis.test;

import com.triloggroup.lotus.atom.cmis.CmisConnection;
import com.triloggroup.lotus.atom.cmis.CmisContentAlreadyExistsException;
import com.triloggroup.lotus.atom.cmis.CmisEntry;
import com.triloggroup.util.UString;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CmisExplorer
extends JFrame {
    private static final long serialVersionUID = 1315179273796438360L;
    private JTextArea textArea;
    private JTree tree;
    private JProgressBar progress;
    private boolean actionInProgress = false;
    private CmisConnection connection;

    CmisExplorer(CmisConnection cmisConnection, CmisEntry cmisEntry) {
        super("CMIS Explorer");
        this.connection = cmisConnection;
        this.init(cmisEntry);
    }

    private void init(CmisEntry cmisEntry) {
        this.setDefaultCloseOperation(3);
        CmisTreeNode cmisTreeNode = new CmisTreeNode(null, cmisEntry);
        this.tree = new JTree(cmisTreeNode);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.textArea = new JTextArea();
        JSplitPane jSplitPane = new JSplitPane(0, new JScrollPane(this.tree), new JScrollPane(this.textArea));
        jSplitPane.setDividerLocation(300);
        this.progress = new JProgressBar();
        this.getContentPane().add((Component)jSplitPane, "Center");
        this.getContentPane().add((Component)this.progress, "South");
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                if (treePath == null) {
                    CmisExplorer.this.textArea.setText("");
                    return;
                }
                CmisTreeNode cmisTreeNode = (CmisTreeNode)treePath.getLastPathComponent();
                StringWriter stringWriter = new StringWriter();
                cmisTreeNode.entry.dump(new PrintWriter(stringWriter));
                CmisExplorer.this.textArea.setText(stringWriter.toString());
            }
        });
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Actions");
        UIAction uIAction = new UIAction("Delete"){

            protected void perform() throws Exception {
                CmisExplorer.this.delete(CmisExplorer.this.getSelection());
            }
        };
        jMenu.add(new JMenuItem(uIAction));
        UIAction uIAction2 = new UIAction("Add document"){

            protected void perform() throws Exception {
                CmisExplorer.this.addDocument(CmisExplorer.this.getSelection());
            }
        };
        jMenu.add(new JMenuItem(uIAction2));
        UIAction uIAction3 = new UIAction("Create new version"){

            protected void perform() throws Exception {
                CmisExplorer.this.createNewDocumentVersion(CmisExplorer.this.getSelection());
            }
        };
        jMenu.add(new JMenuItem(uIAction3));
        UIAction uIAction4 = new UIAction("Add folder"){

            protected void perform() throws Exception {
                CmisExplorer.this.addFolder(CmisExplorer.this.getSelection());
            }
        };
        jMenu.add(new JMenuItem(uIAction4));
        UIAction uIAction5 = new UIAction("Refresh"){

            protected void perform() throws Exception {
                CmisExplorer.this.refresh(CmisExplorer.this.getSelection());
            }
        };
        jMenu.add(new JMenuItem(uIAction5));
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        ActionMap actionMap = this.getRootPane().getActionMap();
        actionMap.put("REFRESH", uIAction5);
        actionMap.put("DELETE", uIAction);
        InputMap inputMap = this.getRootPane().getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(116, 0), "REFRESH");
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "DELETE");
        this.pack();
        this.setSize(800, 600);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private CmisTreeNode getSelection() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        return (CmisTreeNode)treePath.getLastPathComponent();
    }

    private void delete(CmisTreeNode cmisTreeNode) throws Exception {
        if (cmisTreeNode == null) {
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "Delete " + cmisTreeNode + "?", "", 0) != 0) {
            return;
        }
        this.connection.deleteEntry(cmisTreeNode.entry);
        this.refresh(cmisTreeNode.parent);
    }

    private void addDocument(CmisTreeNode cmisTreeNode) throws Exception {
        if (cmisTreeNode == null) {
            JOptionPane.showMessageDialog(this, "Please select parent");
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.showDialog(this, "Select");
        File file = jFileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        String string = URLConnection.guessContentTypeFromName(file.getName());
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            this.connection.createDocument(cmisTreeNode.entry, file.getName(), string, (InputStream)fileInputStream);
        }
        catch (CmisContentAlreadyExistsException cmisContentAlreadyExistsException) {
            CmisEntry cmisEntry = cmisContentAlreadyExistsException.getRepositoryEntry();
            if (cmisEntry == null) {
                JOptionPane.showMessageDialog(this, "Document already exists.");
                return;
            }
            if (JOptionPane.showConfirmDialog(this, "<html>A document with the same name already exists.<br>Create a new version ?</html>", "", 0) != 0) {
                return;
            }
            fileInputStream = new FileInputStream(file);
            this.connection.createDocumentVersion(cmisEntry.cmisObjectId, fileInputStream, true, "");
        }
        this.refresh(cmisTreeNode);
    }

    private void createNewDocumentVersion(CmisTreeNode cmisTreeNode) throws Exception {
        if (cmisTreeNode == null) {
            JOptionPane.showMessageDialog(this, "Please select document to update");
            return;
        }
        if (!cmisTreeNode.entry.isFile()) {
            JOptionPane.showMessageDialog(this, "Document to update must be a file");
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.showDialog(this, "Select");
        File file = jFileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        this.connection.createDocumentVersion(((CmisTreeNode)cmisTreeNode).entry.cmisObjectId, fileInputStream, true, "");
        this.refresh(cmisTreeNode.parent);
    }

    private void addFolder(CmisTreeNode cmisTreeNode) throws Exception {
        if (cmisTreeNode == null) {
            JOptionPane.showMessageDialog(this, "Please select parent");
            return;
        }
        String string = JOptionPane.showInputDialog(this, (Object)"Please enter folder name");
        if (UString.isEmpty((String)string)) {
            return;
        }
        this.connection.createFolder(cmisTreeNode.entry, string);
        this.refresh(cmisTreeNode);
    }

    private void refresh(CmisTreeNode cmisTreeNode) {
        if (cmisTreeNode == null) {
            cmisTreeNode = (CmisTreeNode)this.tree.getModel().getRoot();
        }
        this.refreshNode(cmisTreeNode, false);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        defaultTreeModel.nodeStructureChanged(cmisTreeNode);
    }

    private void refreshNode(CmisTreeNode cmisTreeNode, boolean bl) {
        try {
            CmisTreeNode.access$1002(cmisTreeNode, null);
            if (!cmisTreeNode.entry.isFolder()) {
                return;
            }
            CmisEntry[] cmisEntryArray = this.connection.getFolderContent(cmisTreeNode.entry);
            CmisTreeNode.access$1002(cmisTreeNode, new CmisTreeNode[cmisEntryArray.length]);
            for (int i = 0; i < cmisEntryArray.length; ++i) {
                ((CmisTreeNode)cmisTreeNode).children[i] = new CmisTreeNode(cmisTreeNode, cmisEntryArray[i]);
                if (!bl || !cmisEntryArray[i].isFolder()) continue;
                this.refreshNode(cmisTreeNode.children[i], true);
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private abstract class UIAction
    extends AbstractAction
    implements Runnable {
        UIAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (CmisExplorer.this.actionInProgress) {
                JOptionPane.showMessageDialog(CmisExplorer.this, "There is already an action in progress");
                return;
            }
            CmisExplorer.this.actionInProgress = true;
            CmisExplorer.this.progress.setIndeterminate(true);
            new Thread(this).start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            try {
                this.perform();
            }
            catch (Exception exception) {
                try {
                    exception.printStackTrace();
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            CmisExplorer.this.actionInProgress = false;
                            CmisExplorer.this.progress.setIndeterminate(false);
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        protected abstract void perform() throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CmisTreeNode
    implements TreeNode {
        private CmisTreeNode parent;
        private CmisTreeNode[] children;
        private CmisEntry entry;

        private CmisTreeNode(CmisTreeNode cmisTreeNode, CmisEntry cmisEntry) {
            this.parent = cmisTreeNode;
            this.entry = cmisEntry;
        }

        private CmisTreeNode[] getChildren() {
            if (this.children == null) {
                CmisExplorer.this.refreshNode(this, false);
            }
            return this.children;
        }

        @Override
        public TreeNode getChildAt(int n) {
            return this.getChildren()[n];
        }

        @Override
        public int getChildCount() {
            return this.getChildren().length;
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public int getIndex(TreeNode treeNode) {
            for (int i = 0; i < this.children.length; ++i) {
                if (treeNode != this.children[i]) continue;
                return i;
            }
            return -1;
        }

        @Override
        public boolean getAllowsChildren() {
            return this.entry.isFolder();
        }

        @Override
        public boolean isLeaf() {
            return this.entry.isFile();
        }

        public Enumeration<CmisTreeNode> children() {
            return Collections.enumeration(Arrays.asList(this.getChildren()));
        }

        public String toString() {
            return this.entry.toString();
        }

        static /* synthetic */ CmisTreeNode[] access$1002(CmisTreeNode cmisTreeNode, CmisTreeNode[] cmisTreeNodeArray) {
            cmisTreeNode.children = cmisTreeNodeArray;
            return cmisTreeNodeArray;
        }
    }
}

