/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.lotus.atom;

import com.flowbuilder.lib.NamespaceContext;
import com.flowbuilder.util.TString;
import com.flowbuilder.util.xml.JDOMUtil;
import com.flowbuilder.util.xml.XMLException;
import com.flowbuilder.util.xml.XPathEngine;
import com.triloggroup.lotus.UService;
import com.triloggroup.lotus.atom.Entry;
import com.triloggroup.lotus.atom.Member;
import java.io.PrintWriter;
import java.io.Serializable;
import org.jdom.Element;

public class Profile
extends Entry
implements Serializable {
    private static final String XHTML_NS_URI = "http://www.w3.org/1999/xhtml";
    private static final NamespaceContext NS_CONTEXT = new NamespaceContext();
    public String summary;
    public String selfUrl;
    public String viewUrl;
    public String vcardUrl;
    public String photoUrl;
    public String audioUrl;
    private String managerUid;
    private boolean isManager;

    public Member toMember() {
        Member member = new Member();
        member.name = this.title;
        member.userId = this.contributor != null ? this.contributor.userId : null;
        member.category = "person";
        return member;
    }

    public static Profile readProfile(Element element) {
        Profile profile = new Profile();
        profile.initProfileFromXml(element);
        return profile;
    }

    public void initProfileFromXml(Element element) {
        this.initEntryFromXml(element);
        this.summary = UService.getChildText(element, "summary", UService.atomNs);
        Element element2 = element.getChild("content", UService.atomNs);
        this.managerUid = this.getVCardDivText(element2, "x-manager-uid");
        this.isManager = "Y".equals(this.getVCardDivText(element2, "x-is-manager"));
    }

    private String getVCardDivText(Element element, String string) {
        if (element == null) {
            return null;
        }
        try {
            Element element2 = (Element)JDOMUtil.node((Element)element, (String)("//xhtml:div[@class='" + string + "']"), (XPathEngine.INamespaceContext)NS_CONTEXT);
            return element2 != null ? element2.getText() : null;
        }
        catch (XMLException xMLException) {
            xMLException.printStackTrace();
            return null;
        }
    }

    protected void setLinkUrl(String string, String string2, String string3) {
        super.setLinkUrl(string, string2, string3);
        if (TString.equals((String)string2, (String)"alternate")) {
            this.vcardUrl = string;
        } else if (TString.equals((String)string2, (String)"self")) {
            this.selfUrl = string;
        } else if (TString.equals((String)string2, (String)"related")) {
            this.viewUrl = string;
        } else if (TString.equals((String)string2, (String)"http://www.ibm.com/xmlns/prod/sn/image")) {
            this.photoUrl = string;
        } else if (TString.equals((String)string2, (String)"http://www.ibm.com/xmlns/prod/sn/pronunciation")) {
            this.audioUrl = string;
        }
    }

    public void dump(PrintWriter printWriter, String string) {
        super.dump(printWriter, string);
        if (string == null) {
            string = "";
        }
        printWriter.println(string + "summary = " + this.summary);
        printWriter.println(string + "   vcardUrl = " + this.vcardUrl);
        printWriter.println(string + "   selfUrl = " + this.selfUrl);
        printWriter.println(string + "   viewUrl = " + this.viewUrl);
        printWriter.println(string + "   photoUrl = " + this.photoUrl);
        printWriter.println(string + "   audioUrl = " + this.audioUrl);
    }

    public String getManagerUid() {
        return this.managerUid;
    }

    public boolean isManager() {
        return this.isManager;
    }

    static {
        NS_CONTEXT.addNamespace("xhtml", XHTML_NS_URI);
    }
}

