/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.lotus.atom;

import com.flowbuilder.util.TString;
import com.triloggroup.lotus.UService;
import com.triloggroup.lotus.atom.Profile;
import java.io.PrintWriter;
import java.io.Serializable;
import org.jdom.Element;

public class Member
implements Serializable {
    public static String OWNER_ROLE = "owner";
    public static String READER_ROLE = "reader";
    public static String MEMBER_ROLE = "member";
    public String name;
    public String userId;
    public String email;
    public String userState;
    public String role;
    public String category;

    public Member() {
    }

    public Member(String string, String string2) {
        this.name = string;
        this.email = string2;
    }

    public static Member readMember(Element element) {
        Member member = new Member();
        member.initMemberFromXml(element);
        return member;
    }

    public void initMemberFromXml(Element element) {
        if (element != null) {
            Element element2 = element;
            String string = element.getName();
            if ("entry".equals(string)) {
                Element element3 = element.getChild("category");
                if (element3 != null) {
                    this.category = element3.getAttributeValue("term");
                }
                this.role = TString.trim((String)UService.getChildText(element, "role", UService.snxNs));
                element2 = element.getChild("contributor", UService.atomNs);
            }
            if (element2 != null && ("contributor".equals(string = element2.getName()) || "author".equals(string))) {
                this.name = TString.trim((String)UService.getChildText(element2, "name", UService.atomNs));
                this.userId = TString.trim((String)UService.getChildText(element2, "userid", UService.snxNs));
                this.email = TString.trim((String)UService.getChildText(element2, "email", UService.atomNs));
                this.userState = TString.trim((String)UService.getChildText(element2, "userState", UService.snxNs));
                if (TString.isEmpty((String)this.role)) {
                    this.role = TString.trim((String)UService.getChildText(element2, "role", UService.snxNs));
                }
            }
        }
    }

    public String toXmlEntryAtom() {
        StringBuilder stringBuilder = new StringBuilder("<entry xmlns=\"http://www.w3.org/2005/Atom\" xmlns:snx=\"http://www.ibm.com/xmlns/prod/sn\">\n");
        stringBuilder.append("<title type=\"text\">").append(this.name).append("</title>\n");
        stringBuilder.append("<contributor>\n");
        stringBuilder.append("<name>").append(this.name).append("</name>\n");
        stringBuilder.append("<email>").append(this.email).append("</email>\n");
        if (!TString.isEmpty((String)this.userId)) {
            stringBuilder.append("<snx:userid>").append(this.userId).append("</snx:userid>\n");
        }
        if (!TString.isEmpty((String)this.role)) {
            stringBuilder.append("<snx:role>").append(this.role).append("</snx:role>\n");
        }
        stringBuilder.append("</contributor>\n");
        if (!TString.isEmpty((String)this.category)) {
            stringBuilder.append("<category scheme=\"http://www.ibm.com/xmlns/prod/sn/type\" term=\"").append(this.category).append("\" />\n");
        }
        if (!TString.isEmpty((String)this.role)) {
            stringBuilder.append("<snx:role component=\"http://www.ibm.com/xmlns/prod/sn/activities\">").append(this.role).append("</snx:role>\n");
        }
        stringBuilder.append("</entry>");
        return stringBuilder.toString();
    }

    public static Member createMemberFromProfile(Profile profile) {
        Member member = new Member();
        member.name = profile.contributor.name;
        member.userId = profile.contributor.userId;
        member.email = profile.contributor.email;
        member.userState = profile.contributor.userState;
        member.category = "person";
        return member;
    }

    public final void dump(String string) {
        this.dump(new PrintWriter(System.out), string);
    }

    public void dump(PrintWriter printWriter, String string) {
        if (string == null) {
            string = "";
        }
        printWriter.println(string + "name = " + this.name);
        printWriter.println(string + "userid = " + this.userId);
        printWriter.println(string + "email = " + this.email);
        printWriter.println(string + "userState = " + this.userState);
        printWriter.println(string + "role = " + this.role);
        printWriter.println(string + "category = " + this.category);
        printWriter.flush();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Member: ");
        if (this.name != null) {
            stringBuilder.append(" - name ").append(this.name);
        }
        if (this.email != null) {
            stringBuilder.append(" - ").append(this.email);
        }
        if (this.userId != null) {
            stringBuilder.append(" - ").append(this.userId);
        }
        if (this.userState != null) {
            stringBuilder.append(" - ").append(this.userState);
        }
        if (this.role != null) {
            stringBuilder.append(" - ").append(this.role);
        }
        if (this.category != null) {
            stringBuilder.append(" - ").append(this.category);
        }
        return stringBuilder.toString();
    }
}

