/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.lotus.atom;

import com.flowbuilder.util.TString;
import com.flowbuilder.util.xml.JDOMUtil;
import com.triloggroup.lotus.UService;
import com.triloggroup.lotus.atom.Category;
import com.triloggroup.lotus.atom.Content;
import com.triloggroup.lotus.atom.EntryInterface;
import com.triloggroup.lotus.atom.Member;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import org.jdom.Element;

public class Entry
implements EntryInterface {
    public String id;
    public String title;
    public Category[] categories = new Category[0];
    public Content content = new Content();
    public Member contributor;
    public Member author;
    public String selfUrl;
    public String editUrl;
    public String viewHtmlUrl;
    public Date publishedDate;
    public Date updatedDate;

    public void addCategory(Category category) {
        if (this.categories == null || this.categories.length == 0) {
            this.categories = new Category[1];
        } else {
            Category[] categoryArray = this.categories;
            this.categories = new Category[categoryArray.length + 1];
            System.arraycopy(categoryArray, 0, this.categories, 0, categoryArray.length);
        }
        this.categories[this.categories.length - 1] = category;
    }

    public void addCategory(String string, String string2) {
        this.addCategory(new Category(string, string2));
    }

    public void addCategories(Category[] categoryArray) {
        if (this.categories == null || this.categories.length == 0) {
            this.categories = categoryArray;
        } else {
            Category[] categoryArray2 = this.categories;
            this.categories = new Category[categoryArray2.length + categoryArray.length];
            System.arraycopy(categoryArray2, 0, this.categories, 0, categoryArray2.length);
            System.arraycopy(categoryArray, 0, this.categories, categoryArray2.length, categoryArray.length);
        }
    }

    public void addCategories(String[] stringArray) {
        Category[] categoryArray = new Category[stringArray.length];
        for (int i = 0; i < categoryArray.length; ++i) {
            categoryArray[i] = new Category(stringArray[i]);
        }
        this.addCategories(categoryArray);
    }

    public static Entry readEntry(Element element) {
        Entry entry = new Entry();
        entry.initEntryFromXml(element);
        return entry;
    }

    public void initEntryFromXml(Element element) {
        String string;
        Element element2;
        Element element3;
        this.id = UService.getChildText(element, "id", UService.atomNs);
        this.title = UService.getChildText(element, "title", UService.atomNs);
        List list = element.getChildren("category", UService.atomNs);
        if (list != null) {
            this.categories = new Category[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                element3 = (Element)list.get(i);
                this.categories[i] = Category.readCategory(element3);
            }
        }
        if ((element2 = element.getChild("contributor", UService.atomNs)) != null) {
            this.contributor = Member.readMember(element2);
        }
        element3 = element.getChild("author", UService.atomNs);
        this.author = Member.readMember(element3);
        Element element4 = element.getChild("content", UService.atomNs);
        this.content = Content.readContent(element4);
        List list2 = element.getChildren("link", UService.atomNs);
        if (list2 != null) {
            for (int i = 0; i < list2.size(); ++i) {
                Element element5 = (Element)list2.get(i);
                String string2 = element5.getAttributeValue("href");
                String string3 = element5.getAttributeValue("rel");
                String string4 = element5.getAttributeValue("type");
                this.setLinkUrl(string2, string3, string4);
            }
        }
        if (!TString.isEmpty((String)(string = UService.getChildText(element, "published", UService.atomNs)))) {
            this.publishedDate = JDOMUtil.parseUtilDate((String)string);
        }
        if (!TString.isEmpty((String)(string = UService.getChildText(element, "updated", UService.atomNs)))) {
            this.updatedDate = JDOMUtil.parseUtilDate((String)string);
        }
    }

    protected void setLinkUrl(String string, String string2, String string3) {
        if (TString.equals((String)string2, (String)"self")) {
            this.selfUrl = string;
        } else if (TString.equals((String)string2, (String)"edit")) {
            this.editUrl = string;
        } else if (TString.equals((String)string2, (String)"alternate") && TString.equals((String)string3, (String)"text/html")) {
            this.viewHtmlUrl = string;
        }
    }

    public final void dump() {
        this.dump("");
    }

    public final void dump(PrintWriter printWriter) {
        this.dump(printWriter, "");
    }

    public final void dump(String string) {
        this.dump(new PrintWriter(System.out), string);
    }

    public void dump(PrintWriter printWriter, String string) {
        if (string == null) {
            string = "";
        }
        printWriter.println(string + "id = " + this.id);
        printWriter.println(string + "title = " + this.title);
        printWriter.println(string + "categories =");
        for (int i = 0; i < this.categories.length; ++i) {
            printWriter.println(string + "\t term: " + this.categories[i].term + " - label: " + this.categories[i].label);
        }
        if (this.contributor != null) {
            printWriter.println(string + "contributor = ");
            this.contributor.dump(printWriter, string + "     ");
        }
        if (this.author != null) {
            printWriter.println(string + "author = ");
            this.author.dump(printWriter, string + "     ");
        }
        printWriter.println(string + "published =" + this.publishedDate);
        printWriter.println(string + "updated =" + this.updatedDate);
        printWriter.println(string + "content (" + this.content.type + ") =" + this.content.value);
        printWriter.println(string + "self URL =" + this.selfUrl);
        printWriter.println(string + "edit URL =" + this.editUrl);
        printWriter.println(string + "viewHtmlURL = " + this.viewHtmlUrl);
        printWriter.flush();
    }

    public String toXmlEntryAtom() {
        StringBuffer stringBuffer = new StringBuffer("<entry xmlns=\"http://www.w3.org/2005/Atom\" xmlns:snx=\"http://www.ibm.com/xmlns/prod/sn\">\n");
        stringBuffer.append(" <title type=\"text\">").append(TString.toXMLString((String)this.title)).append("</title>\n");
        if (!TString.isEmpty((String)this.id)) {
            stringBuffer.append("  <id>").append(this.id).append("</id>\n");
        }
        if (this.categories != null) {
            for (int i = 0; i < this.categories.length; ++i) {
                stringBuffer.append(this.categories[i].toXmlCategoryAtom());
            }
        }
        if (this.content != null && this.content.value != null) {
            this.content.toXmlContentAtom(stringBuffer);
        }
        this.insertAdditionalDataXmlEntryAtom(stringBuffer);
        stringBuffer.append("</entry>");
        return stringBuffer.toString();
    }

    protected void insertAdditionalDataXmlEntryAtom(StringBuffer stringBuffer) {
    }

    public static String extractUuidOfId(String string) {
        if (!TString.isEmpty((String)string)) {
            return string.substring(string.lastIndexOf(58) + 1);
        }
        return string;
    }
}

