/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.lotus;

import com.flowbuilder.lib.NamespaceContext;
import com.flowbuilder.util.NeedAuthenticationSignal;
import com.flowbuilder.util.TDiag;
import com.flowbuilder.util.TString;
import com.flowbuilder.util.xml.JDOMUtil;
import com.triloggroup.lotus.IServiceConnector;
import com.triloggroup.lotus.LotusUtil;
import com.triloggroup.lotus.ServiceException;
import com.triloggroup.util.UString;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.mail.internet.MimeUtility;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;

public class UService {
    public static boolean DEV_ENV = false;
    public static final String atomNsPrefix = "atom";
    public static final String atomNsUri = "http://www.w3.org/2005/Atom";
    public static final Namespace atomNs = Namespace.getNamespace((String)"atom", (String)"http://www.w3.org/2005/Atom");
    public static final String atomAppNsPrefix = "";
    public static final String atomAppNsUri = "http://purl.org/atom/app#";
    public static final Namespace atomAppNs = Namespace.getNamespace((String)"", (String)"http://purl.org/atom/app#");
    public static final String ibmTdNsPrefix = "td";
    public static final String ibmTdNsUri = "urn:ibm.com/td";
    public static final Namespace ibmTdNs = Namespace.getNamespace((String)"td", (String)"urn:ibm.com/td");
    public static final String xmlNsPrefix = "xml";
    public static final String xmlNsUri = "http://www.w3.org/XML/1998/namespace";
    public static final Namespace xmlNs = Namespace.getNamespace((String)"xml", (String)"http://www.w3.org/XML/1998/namespace");
    public static String openSearchNsPrefix = "opensearch";
    public static String openSearchNsUri = "http://a9.com/-/spec/opensearch/1.1/";
    public static final Namespace openSearchNs = Namespace.getNamespace((String)openSearchNsPrefix, (String)openSearchNsUri);
    public static final String quickrNsPrefix = "quickr";
    public static final String quickrNsUri = "http://www.ibm.com/xmlns/prod/composite-applications/v1.0";
    public static final Namespace quickrNs = Namespace.getNamespace((String)"quickr", (String)"http://www.ibm.com/xmlns/prod/composite-applications/v1.0");
    public static final String snxNsPrefix = "snx";
    public static final String snxNsUri = "http://www.ibm.com/xmlns/prod/sn";
    public static final Namespace snxNs = Namespace.getNamespace((String)"snx", (String)"http://www.ibm.com/xmlns/prod/sn");
    public static final String appNsPrefix = "app";
    public static final String appNsUri = "http://www.w3.org/2007/app";
    public static final Namespace appNs = Namespace.getNamespace((String)"app", (String)"http://www.w3.org/2007/app");
    public static final String thrNsPrefix = "thr";
    public static final String thrNsUri = "http://purl.org/syndication/thread/1.0";
    public static final Namespace thrNs = Namespace.getNamespace((String)"thr", (String)"http://purl.org/syndication/thread/1.0");
    public static final NamespaceContext NAMESAPCE_CONTEXT = new NamespaceContext();
    private static HashMap<String, TimeException> connectionErrorMap;
    private static final long DEFAULT_CONNECTION_TIME_WAITING_ERROR = 60000L;
    private static long connectionWaitingTimeBeforeRetry;
    private static boolean redirectToLoginExceptionIfAuthenticationError;
    protected int lastResponseCode;
    protected Map<String, List<String>> lastResponseHeader;

    protected String extractId(String string) {
        if (TString.isEmpty((String)string)) {
            return null;
        }
        int n = string.lastIndexOf(58);
        if (n != -1 && n < string.length() - 1) {
            String string2 = string.substring(n + 1);
            return string2;
        }
        if (string.startsWith("[@P") && string.endsWith("]")) {
            try {
                return URLEncoder.encode(string, "UTF-8");
            }
            catch (Exception exception) {
                return URLEncoder.encode(string);
            }
        }
        if (string.startsWith("%5B%40P") && string.endsWith("%5D")) {
            return string;
        }
        return string;
    }

    public Document callService(String string, IServiceConnector iServiceConnector) throws Exception {
        if (DEV_ENV) {
            System.out.println("--- callService --- " + string);
        }
        URL uRL = new URL(string);
        URLConnection uRLConnection = uRL.openConnection();
        this.forceDisableKeepAlive(uRLConnection);
        iServiceConnector.setAuthorization(uRLConnection);
        uRLConnection.setRequestProperty("Content-Type", "text/xml");
        uRLConnection.setIfModifiedSince(0L);
        uRLConnection.setUseCaches(false);
        try {
            return this.callService(uRLConnection, true);
        }
        catch (RedirectException redirectException) {
            return this.callService(redirectException.getRedirectUrl(), iServiceConnector);
        }
    }

    public Document callService(String string, IServiceConnector iServiceConnector, String string2) throws Exception {
        return this.callService(string, iServiceConnector, string2, null);
    }

    public Document callService(String string, IServiceConnector iServiceConnector, String string2, String[][] stringArray) throws Exception {
        return this.callService(string, iServiceConnector, string2, stringArray, true);
    }

    public Document callService(String string, IServiceConnector iServiceConnector, String string2, String[][] stringArray, boolean bl) throws Exception {
        return this.callService(string, iServiceConnector, string2, stringArray, null, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document callService(String string, IServiceConnector iServiceConnector, String string2, String[][] stringArray, String string3, boolean bl) throws Exception {
        if (DEV_ENV) {
            System.out.println("--- callService --- " + string);
        }
        URL uRL = new URL(string);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        this.forceDisableKeepAlive(httpURLConnection);
        iServiceConnector.setAuthorization(httpURLConnection);
        if (!TString.isEmpty((String)string2)) {
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Content-Type", "application/atom+xml");
        }
        if (!TString.isEmpty((String)string3)) {
            httpURLConnection.setRequestMethod(string3);
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                httpURLConnection.setRequestProperty(stringArray[i][0], stringArray[i][1]);
            }
        }
        httpURLConnection.setDoInput(true);
        if (!TString.isEmpty((String)string2)) {
            httpURLConnection.setDoOutput(true);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(httpURLConnection.getOutputStream(), "UTF-8");
            try {
                outputStreamWriter.write(string2);
                outputStreamWriter.flush();
            }
            finally {
                outputStreamWriter.close();
            }
        }
        try {
            return this.callService(httpURLConnection, bl);
        }
        catch (RedirectException redirectException) {
            return this.callService(redirectException.getRedirectUrl(), iServiceConnector, string2, stringArray, string3, bl);
        }
    }

    private void dumpRequestInfo(HttpURLConnection httpURLConnection, String string) {
        System.out.println("-------- Request info ---------");
        System.out.println(httpURLConnection.toString());
        System.out.println("Request Method: " + httpURLConnection.getRequestMethod());
        Map<String, List<String>> map = httpURLConnection.getRequestProperties();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            System.out.println(entry.getKey() + " : " + entry.getValue());
        }
        if (!TString.isEmpty((String)string)) {
            System.out.println("---------Request Document------");
            System.out.println(string);
        }
        System.out.println("-------------------------------");
    }

    public Document callService(String string, IServiceConnector iServiceConnector, String string2, InputStream inputStream, String string3) throws Exception {
        return this.callService("POST", string, iServiceConnector, string2, inputStream, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document callService(String string, String string2, IServiceConnector iServiceConnector, String string3, InputStream inputStream, String string4) throws Exception {
        URL uRL = new URL(string2);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        this.forceDisableKeepAlive(httpURLConnection);
        iServiceConnector.setAuthorization(httpURLConnection);
        httpURLConnection.setRequestMethod(string);
        httpURLConnection.setRequestProperty("Content-Type", string4);
        if (string3.indexOf(39) != -1) {
            string3 = TString.replace((String)string3, (char)'\'', (char)' ');
        }
        String string5 = MimeUtility.encodeText((String)string3, (String)"UTF-8", null);
        httpURLConnection.setRequestProperty("Slug", string5);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        OutputStream outputStream = httpURLConnection.getOutputStream();
        try {
            byte[] byArray = new byte[1024];
            int n = inputStream.read(byArray);
            while (n != -1) {
                outputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
            outputStream.flush();
        }
        finally {
            outputStream.close();
            inputStream.close();
        }
        try {
            return this.callService(httpURLConnection, true);
        }
        catch (RedirectException redirectException) {
            return this.callService(redirectException.getRedirectUrl(), iServiceConnector, string3, inputStream, string4);
        }
    }

    public Document callDeleteService(String string, IServiceConnector iServiceConnector, boolean bl) throws Exception {
        if (DEV_ENV) {
            System.out.println("--- callDeleteService --- " + string);
        }
        URL uRL = new URL(string);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        this.forceDisableKeepAlive(httpURLConnection);
        iServiceConnector.setAuthorization(httpURLConnection);
        httpURLConnection.setRequestMethod("DELETE");
        try {
            return this.callService(httpURLConnection, bl);
        }
        catch (RedirectException redirectException) {
            return this.callDeleteService(redirectException.getRedirectUrl(), iServiceConnector, bl);
        }
    }

    protected Document callService(URLConnection uRLConnection, boolean bl) throws ServiceException, RedirectException {
        ServiceException serviceException = this.getSocketExceptionForHost(uRLConnection.getURL().getHost());
        if (serviceException != null) {
            throw serviceException;
        }
        if (uRLConnection instanceof HttpURLConnection) {
            ((HttpURLConnection)uRLConnection).setInstanceFollowRedirects(false);
        }
        try {
            if (uRLConnection instanceof HttpURLConnection) {
                this.lastResponseCode = ((HttpURLConnection)uRLConnection).getResponseCode();
                this.lastResponseHeader = uRLConnection.getHeaderFields();
                if (this.lastResponseCode < 200 || this.lastResponseCode > 299) {
                    String string;
                    if (this.lastResponseCode == 302 || this.lastResponseCode == 301) {
                        String string2 = uRLConnection.getHeaderField("Location");
                        if (!UString.equals((String)string2, (String)uRLConnection.getURL().toExternalForm())) {
                            TDiag.println((String)("Redirect service invokation to " + string2));
                            throw new RedirectException(string2);
                        }
                        throw new ServiceException("Infinite redirect loop", this.lastResponseCode, uRLConnection.getURL().toString());
                    }
                    if (this.lastResponseCode == 401 && redirectToLoginExceptionIfAuthenticationError) {
                        throw new NeedAuthenticationSignal();
                    }
                    String string3 = UService.readErrorStream(uRLConnection);
                    String string4 = ((HttpURLConnection)uRLConnection).getResponseMessage();
                    String string5 = string = TString.isEmpty((String)string3) ? string4 : string4 + " : " + string3;
                    if (this.lastResponseCode == 500 && string.indexOf("<title>500 Internal Server Error</title>") != -1) {
                        this.storeSocketExceptionForHost(uRLConnection.getURL().getHost(), new Exception("Error Code 500 - " + string));
                    }
                    throw new ServiceException(string, this.lastResponseCode, uRLConnection.getURL().toString());
                }
            }
            if (bl) {
                StringBuilder stringBuilder = UService.readStream(uRLConnection, false);
                if (DEV_ENV) {
                    TDiag.println((String)"---- callService url response stream ---");
                    TDiag.println((String)stringBuilder.toString());
                    TDiag.println((String)"--------------------------------------");
                }
                if (stringBuilder.length() == 0) {
                    return null;
                }
                if (stringBuilder.indexOf("<entry ") == 0) {
                    int n = stringBuilder.indexOf("<?xml version=");
                    if (n != -1) {
                        String string = stringBuilder.substring(n);
                        stringBuilder = stringBuilder.delete(n, stringBuilder.length() - 1);
                        if (string.endsWith("</feed>")) {
                            stringBuilder.insert(0, string.substring(0, string.length() - 7));
                            stringBuilder.append("</feed>");
                        }
                    }
                } else {
                    int n = stringBuilder.indexOf("rsion=\"1.0\" encoding=\"utf-8\"?>", 10);
                    if (n > 0 && stringBuilder.charAt(n - 1) == '>') {
                        stringBuilder = stringBuilder.delete(n, stringBuilder.length());
                    } else if (stringBuilder.length() == "<?xml version=\"1.0\" encoding=\"UTF-8\"?>".length() && stringBuilder.indexOf("<?xml version=\"1.0\" encoding=\"UTF-8\"?>") == 0) {
                        return null;
                    }
                }
                return JDOMUtil.read((String)stringBuilder.toString());
            }
            return null;
        }
        catch (Exception exception) {
            if (exception instanceof RedirectException) {
                throw (RedirectException)exception;
            }
            if (exception instanceof ServiceException) {
                throw (ServiceException)exception;
            }
            if (exception instanceof SocketException || exception instanceof UnknownHostException) {
                this.storeSocketExceptionForHost(uRLConnection.getURL().getHost(), exception);
            }
            TDiag.error((String)("Error during  service invokation - " + uRLConnection.getURL().toString() + " - " + exception.toString()));
            String string = UService.readErrorStream(uRLConnection);
            if (!TString.isEmpty((String)string)) {
                throw new ServiceException(string, exception, uRLConnection.getURL().toString());
            }
            throw new ServiceException("Error during  service invokation", exception, uRLConnection.getURL().toString());
        }
    }

    private static String readInputStream(URLConnection uRLConnection) {
        return UService.readStream(uRLConnection, false).toString();
    }

    private static String readErrorStream(URLConnection uRLConnection) {
        return UService.readStream(uRLConnection, true).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StringBuilder readStream(URLConnection uRLConnection, boolean bl) {
        StringBuilder stringBuilder;
        block7: {
            stringBuilder = new StringBuilder();
            try {
                String string = uRLConnection.getContentEncoding();
                InputStream inputStream = bl ? ((HttpURLConnection)uRLConnection).getErrorStream() : uRLConnection.getInputStream();
                if (inputStream == null) break block7;
                if ("gzip".equals(string)) {
                    inputStream = new GZIPInputStream(inputStream);
                }
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
                char[] cArray = new char[128];
                try {
                    int n = inputStreamReader.read(cArray);
                    while (n != -1) {
                        stringBuilder.append(cArray, 0, n);
                        n = inputStreamReader.read(cArray);
                    }
                }
                finally {
                    inputStreamReader.close();
                }
            }
            catch (Exception exception) {
                if (!DEV_ENV) break block7;
                TDiag.exception((Throwable)exception);
            }
        }
        return stringBuilder;
    }

    public static String getChildText(Element element, String string, Namespace namespace) {
        Element element2 = element.getChild(string, namespace);
        if (element2 != null) {
            return TString.trim((String)element2.getText());
        }
        return null;
    }

    public static int getChildTextAsInteger(Element element, String string, Namespace namespace) {
        String string2 = UService.getChildText(element, string, namespace);
        if (!TString.isEmpty((String)string2)) {
            try {
                return Integer.parseInt(string2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return 0;
    }

    public static boolean getChildTextAsBoolean(Element element, String string, Namespace namespace) {
        String string2 = UService.getChildText(element, string, namespace);
        if (!TString.isEmpty((String)string2)) {
            return Boolean.parseBoolean(string2);
        }
        return false;
    }

    protected void forceDisableKeepAlive(URLConnection uRLConnection) {
        uRLConnection.setRequestProperty("Connection", "close");
        if (uRLConnection instanceof HttpsURLConnection) {
            try {
                CaseInsensitiveHostnameVerifier caseInsensitiveHostnameVerifier = new CaseInsensitiveHostnameVerifier(((HttpsURLConnection)uRLConnection).getHostnameVerifier());
                ((HttpsURLConnection)uRLConnection).setHostnameVerifier(caseInsensitiveHostnameVerifier);
            }
            catch (Throwable throwable) {
                System.out.println("Cannot set Insensitive HostnameVerifier");
            }
        }
    }

    public String callUrl(String string, IServiceConnector iServiceConnector, boolean bl) throws Exception {
        return this.callUrl(string, iServiceConnector, null, null, bl);
    }

    public String callUrl(String string, IServiceConnector iServiceConnector, String string2, String string3, boolean bl) throws Exception {
        try {
            return this.callUrlThrowRedirect(string, iServiceConnector, string2, string3, bl);
        }
        catch (RedirectException redirectException) {
            return this.callUrlThrowRedirect(redirectException.getRedirectUrl(), iServiceConnector, string2, string3, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String callUrlThrowRedirect(String string, IServiceConnector iServiceConnector, String string2, String string3, boolean bl) throws Exception {
        Object object;
        URL uRL = new URL(string);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        this.forceDisableKeepAlive(httpURLConnection);
        iServiceConnector.setAuthorization(httpURLConnection);
        if (!TString.isEmpty((String)string2)) {
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Content-Type", string3);
        }
        httpURLConnection.setDoInput(true);
        if (!TString.isEmpty((String)string2)) {
            httpURLConnection.setDoOutput(true);
            object = new OutputStreamWriter(httpURLConnection.getOutputStream(), "UTF-8");
            try {
                ((Writer)object).write(string2);
                ((OutputStreamWriter)object).flush();
            }
            finally {
                ((OutputStreamWriter)object).close();
            }
        }
        httpURLConnection.setInstanceFollowRedirects(false);
        try {
            this.lastResponseCode = httpURLConnection.getResponseCode();
            this.lastResponseHeader = httpURLConnection.getHeaderFields();
            object = httpURLConnection.getResponseMessage();
            if (this.lastResponseCode != 200 && this.lastResponseCode != 201) {
                Object object2;
                if (this.lastResponseCode == 302 || this.lastResponseCode == 301) {
                    String string4 = httpURLConnection.getHeaderField("Location");
                    TDiag.println((String)("Redirect service invokation to " + string4));
                    throw new RedirectException(string4);
                }
                if (this.lastResponseCode == 401 && redirectToLoginExceptionIfAuthenticationError) {
                    throw new NeedAuthenticationSignal();
                }
                String string5 = UService.readErrorStream(httpURLConnection);
                Object object3 = object2 = TString.isEmpty((String)string5) ? object : (String)object + " : " + string5;
                if (this.lastResponseCode == 500 && ((String)object2).indexOf("<title>500 Internal Server Error</title>") != -1) {
                    this.storeSocketExceptionForHost(httpURLConnection.getURL().getHost(), new Exception("Error Code 500 - " + (String)object2));
                }
                throw new ServiceException((String)object2, this.lastResponseCode, httpURLConnection.getURL().toString());
            }
            if (bl) {
                String string6 = UService.readInputStream(httpURLConnection);
                if (DEV_ENV) {
                    TDiag.println((String)"---- callUrl response stream ---");
                    TDiag.println((String)string6);
                    TDiag.println((String)"--------------------------------------");
                }
                return string6;
            }
            return null;
        }
        catch (Exception exception) {
            if (exception instanceof RedirectException) {
                throw (RedirectException)exception;
            }
            TDiag.error((String)("Error during Url invokation - " + string + " - " + exception.toString()));
            String string7 = UService.readErrorStream(httpURLConnection);
            if (UString.isEmpty((String)string7)) {
                TDiag.println((String)"No Error Stream");
            } else {
                TDiag.println((String)("Error stream of the Url invokation :\n" + string7));
            }
            throw exception;
        }
    }

    private void storeSocketExceptionForHost(String string, Throwable throwable) {
        connectionErrorMap.put(string, new TimeException(throwable, System.currentTimeMillis()));
    }

    private ServiceException getSocketExceptionForHost(String string) {
        TimeException timeException = connectionErrorMap.get(string);
        if (timeException != null) {
            if (timeException.time + connectionWaitingTimeBeforeRetry > System.currentTimeMillis()) {
                return new ServiceException("Waiting for remote server error to be solved ", timeException.oriTh);
            }
            connectionErrorMap.remove(string);
        }
        return null;
    }

    static {
        NAMESAPCE_CONTEXT.addNamespace(atomNsPrefix, atomNsUri);
        NAMESAPCE_CONTEXT.addNamespace(atomAppNsPrefix, atomAppNsUri);
        NAMESAPCE_CONTEXT.addNamespace(appNsPrefix, appNsUri);
        connectionErrorMap = new HashMap();
        connectionWaitingTimeBeforeRetry = 60000L;
        redirectToLoginExceptionIfAuthenticationError = false;
        try {
            String string = LotusUtil.get().getProjExecProperty("remoteServer.connection.waitingTimeBeforeRetry");
            if (!TString.isEmpty((String)string)) {
                connectionWaitingTimeBeforeRetry = Integer.parseInt(string) * 1000;
            }
            string = LotusUtil.get().getProjExecProperty("remoteServer.connection.redirectToLoginIfAuthenticationError");
            redirectToLoginExceptionIfAuthenticationError = TString.equalsIgnoreCase((String)string, (String)"true");
        }
        catch (Throwable throwable) {
            TDiag.println((String)"Could not read default waiting time before retry in case of server connection error");
        }
    }

    private static class CaseInsensitiveHostnameVerifier
    implements HostnameVerifier {
        private HostnameVerifier originalHostNameVerifier;

        public CaseInsensitiveHostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.originalHostNameVerifier = hostnameVerifier;
        }

        public boolean verify(String string, SSLSession sSLSession) {
            if (TString.equalsIgnoreCase((String)string, (String)sSLSession.getPeerHost())) {
                return true;
            }
            return this.originalHostNameVerifier.verify(string, sSLSession);
        }
    }

    private static class RedirectException
    extends Exception {
        private String redirectUrl;

        private RedirectException(String string) {
            this.redirectUrl = string;
        }

        public String getRedirectUrl() {
            return this.redirectUrl;
        }
    }

    private static class TimeException {
        private Throwable oriTh;
        private long time;

        private TimeException(Throwable throwable, long l) {
            this.oriTh = throwable;
            this.time = l;
        }
    }
}

