/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.lc.test;

import com.triloggroup.lotus.ClientServiceConnector;
import com.triloggroup.lotus.IServiceConnector;
import com.triloggroup.quickr.doclib.UDocumentLibrary;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DocumentLibraryExplorer
extends JFrame {
    private static final String FILE_CATEGORY = "document";
    private static final String FOLDER_CATEGORY = "folder";
    private static final String LIBRARY_CATEGORY = "library";
    private JTextArea textArea;
    private JTree tree;
    private JProgressBar progress;
    private boolean actionInProgress = false;
    private IServiceConnector serviceConnector;
    private static final FileTreeNode[] EMPTY_NODES_ARRAY = new FileTreeNode[0];

    DocumentLibraryExplorer(IServiceConnector iServiceConnector, UDocumentLibrary.Library ... libraryArray) {
        super("Files Explorer");
        this.serviceConnector = iServiceConnector;
        if (libraryArray.length == 1) {
            FileTreeNode fileTreeNode = new FileTreeNode(null, libraryArray[0]);
            this.init(fileTreeNode, false);
        } else {
            UDocumentLibrary.Entry entry = new UDocumentLibrary.Entry();
            entry.category = FOLDER_CATEGORY;
            FileTreeNode fileTreeNode = new FileTreeNode(null, entry);
            FileTreeNode[] fileTreeNodeArray = new FileTreeNode[libraryArray.length];
            for (int i = 0; i < libraryArray.length; ++i) {
                fileTreeNodeArray[i] = new FileTreeNode(fileTreeNode, libraryArray[i]);
            }
            FileTreeNode.access$202(fileTreeNode, fileTreeNodeArray);
            this.init(fileTreeNode, true);
        }
    }

    private void init(FileTreeNode fileTreeNode, boolean bl) {
        this.setDefaultCloseOperation(3);
        this.tree = new JTree(fileTreeNode);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.textArea = new JTextArea();
        JSplitPane jSplitPane = new JSplitPane(0, new JScrollPane(this.tree), new JScrollPane(this.textArea));
        jSplitPane.setDividerLocation(300);
        this.progress = new JProgressBar();
        this.getContentPane().add((Component)jSplitPane, "Center");
        this.getContentPane().add((Component)this.progress, "South");
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                if (treePath == null) {
                    DocumentLibraryExplorer.this.textArea.setText("");
                    return;
                }
                FileTreeNode fileTreeNode = (FileTreeNode)treePath.getLastPathComponent();
                if (fileTreeNode.getEntry() != null) {
                    DocumentLibraryExplorer.this.textArea.setText(fileTreeNode.getEntry().toXmlEntryAtom());
                } else if (fileTreeNode.getLibrary() != null) {
                    DocumentLibraryExplorer.this.textArea.setText(((FileTreeNode)fileTreeNode).getLibrary().title + "\n" + ((FileTreeNode)fileTreeNode).getLibrary().url);
                }
            }
        });
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Actions");
        UIAction uIAction = new UIAction("Refresh"){

            protected void perform() throws Exception {
                DocumentLibraryExplorer.this.refresh(DocumentLibraryExplorer.this.getSelection());
            }
        };
        jMenu.add(new JMenuItem(uIAction));
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        ActionMap actionMap = this.getRootPane().getActionMap();
        actionMap.put("REFRESH", uIAction);
        InputMap inputMap = this.getRootPane().getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(116, 0), "REFRESH");
        this.pack();
        this.setSize(800, 600);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private FileTreeNode getSelection() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        return (FileTreeNode)treePath.getLastPathComponent();
    }

    private void refresh(FileTreeNode fileTreeNode) {
        if (fileTreeNode == null) {
            fileTreeNode = (FileTreeNode)this.tree.getModel().getRoot();
        }
        this.refreshNode(fileTreeNode, false);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        defaultTreeModel.nodeStructureChanged(fileTreeNode);
    }

    private void refreshNode(FileTreeNode fileTreeNode, boolean bl) {
        try {
            if (fileTreeNode.entry == null || DocumentLibraryExplorer.isFile(fileTreeNode.getEntry())) {
                FileTreeNode.access$202(fileTreeNode, EMPTY_NODES_ARRAY);
                return;
            }
            if (DocumentLibraryExplorer.isDirectory(fileTreeNode.getEntry())) {
                UDocumentLibrary.Entry entry = fileTreeNode.getEntry();
                if (entry.contentUrl == null) {
                    if (fileTreeNode.children == null) {
                        FileTreeNode.access$202(fileTreeNode, EMPTY_NODES_ARRAY);
                        return;
                    }
                    if (bl) {
                        for (int i = 0; i < fileTreeNode.children.length; ++i) {
                            this.refreshNode(fileTreeNode.children[i], true);
                        }
                    }
                } else {
                    UDocumentLibrary.ListResult listResult = UDocumentLibrary.getFolderContent(this.serviceConnector, entry.contentUrl, 0, 20);
                    UDocumentLibrary.Entry[] entryArray = listResult.entries;
                    if (entryArray == null) {
                        FileTreeNode.access$202(fileTreeNode, EMPTY_NODES_ARRAY);
                        return;
                    }
                    FileTreeNode.access$202(fileTreeNode, new FileTreeNode[entryArray.length]);
                    for (int i = 0; i < entryArray.length; ++i) {
                        ((FileTreeNode)fileTreeNode).children[i] = new FileTreeNode(fileTreeNode, entryArray[i]);
                        if (!bl) continue;
                        this.refreshNode(fileTreeNode.children[i], true);
                    }
                }
            } else if (fileTreeNode.getLibrary() != null) {
                UDocumentLibrary.Library library = fileTreeNode.getLibrary();
                UDocumentLibrary.ListResult listResult = UDocumentLibrary.getLibraryContent(this.serviceConnector, library, null, 0, 20);
                UDocumentLibrary.Entry[] entryArray = listResult.entries;
                if (entryArray == null) {
                    FileTreeNode.access$202(fileTreeNode, EMPTY_NODES_ARRAY);
                    return;
                }
                FileTreeNode.access$202(fileTreeNode, new FileTreeNode[entryArray.length]);
                for (int i = 0; i < entryArray.length; ++i) {
                    UDocumentLibrary.Entry entry = entryArray[i];
                    if (LIBRARY_CATEGORY.equals(entry.category)) {
                        UDocumentLibrary.Library library2 = new UDocumentLibrary.Library();
                        library2.title = entry.title;
                        library2.url = entry.contentUrl;
                        ((FileTreeNode)fileTreeNode).children[i] = new FileTreeNode(fileTreeNode, library2);
                    } else {
                        ((FileTreeNode)fileTreeNode).children[i] = new FileTreeNode(fileTreeNode, entry);
                    }
                    if (!bl) continue;
                    this.refreshNode(fileTreeNode.children[i], true);
                }
            } else {
                System.out.println("What is this node?");
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static boolean isFile(UDocumentLibrary.Entry entry) {
        return entry != null && FILE_CATEGORY.equals(entry.category);
    }

    private static boolean isDirectory(UDocumentLibrary.Entry entry) {
        return entry != null && FOLDER_CATEGORY.equals(entry.category);
    }

    public static void main(String[] stringArray) throws Exception {
        DocumentLibraryExplorer.disableHttpsCertificateValidation();
        ClientServiceConnector clientServiceConnector = new ClientServiceConnector("https://tglc45fr.triloggroup.com/", "pcollins", "floflo");
        UDocumentLibrary.Library[] libraryArray = UDocumentLibrary.getLibrariesInfo(clientServiceConnector);
        new DocumentLibraryExplorer(clientServiceConnector, libraryArray);
    }

    public static void disableHttpsCertificateValidation() {
        TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            }
        }};
        try {
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, trustManagerArray, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private abstract class UIAction
    extends AbstractAction
    implements Runnable {
        UIAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (DocumentLibraryExplorer.this.actionInProgress) {
                JOptionPane.showMessageDialog(DocumentLibraryExplorer.this, "There is already an action in progress");
                return;
            }
            DocumentLibraryExplorer.this.actionInProgress = true;
            DocumentLibraryExplorer.this.progress.setIndeterminate(true);
            new Thread(this).start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            try {
                this.perform();
            }
            catch (Exception exception) {
                try {
                    exception.printStackTrace();
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DocumentLibraryExplorer.this.actionInProgress = false;
                            DocumentLibraryExplorer.this.progress.setIndeterminate(false);
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        protected abstract void perform() throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileTreeNode
    implements TreeNode {
        private FileTreeNode parent;
        private FileTreeNode[] children;
        private Object entry;

        private FileTreeNode(FileTreeNode fileTreeNode, UDocumentLibrary.Entry entry) {
            this.parent = fileTreeNode;
            this.entry = entry;
        }

        private FileTreeNode(FileTreeNode fileTreeNode, UDocumentLibrary.Library library) {
            this.parent = fileTreeNode;
            this.entry = library;
        }

        private FileTreeNode[] getChildren() {
            if (this.children == null) {
                DocumentLibraryExplorer.this.refreshNode(this, false);
            }
            return this.children;
        }

        @Override
        public TreeNode getChildAt(int n) {
            return this.getChildren()[n];
        }

        @Override
        public int getChildCount() {
            return this.getChildren().length;
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public int getIndex(TreeNode treeNode) {
            for (int i = 0; i < this.children.length; ++i) {
                if (treeNode != this.children[i]) continue;
                return i;
            }
            return -1;
        }

        @Override
        public boolean getAllowsChildren() {
            if (this.getLibrary() != null) {
                return true;
            }
            UDocumentLibrary.Entry entry = this.getEntry();
            if (entry == null) {
                return false;
            }
            return DocumentLibraryExplorer.isDirectory(entry);
        }

        @Override
        public boolean isLeaf() {
            UDocumentLibrary.Entry entry = this.getEntry();
            if (entry == null) {
                return false;
            }
            return DocumentLibraryExplorer.isFile(entry);
        }

        public Enumeration<FileTreeNode> children() {
            return Collections.enumeration(Arrays.asList(this.getChildren()));
        }

        public String toString() {
            if (this.entry == null) {
                return "<?>";
            }
            if (this.getLibrary() != null) {
                return this.getLibrary().title;
            }
            if (this.getEntry() != null) {
                return this.getEntry().title;
            }
            return this.entry.toString();
        }

        private UDocumentLibrary.Library getLibrary() {
            if (this.entry instanceof UDocumentLibrary.Library) {
                return (UDocumentLibrary.Library)this.entry;
            }
            return null;
        }

        private UDocumentLibrary.Entry getEntry() {
            if (this.entry instanceof UDocumentLibrary.Entry) {
                return (UDocumentLibrary.Entry)this.entry;
            }
            return null;
        }

        static /* synthetic */ FileTreeNode[] access$202(FileTreeNode fileTreeNode, FileTreeNode[] fileTreeNodeArray) {
            fileTreeNode.children = fileTreeNodeArray;
            return fileTreeNodeArray;
        }
    }
}

