/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.lc.test;

import com.triloggroup.lc.Activity;
import com.triloggroup.lc.ActivityConnection;
import com.triloggroup.lc.ActivityCriteriaParameters;
import com.triloggroup.lc.ActivityEntry;
import com.triloggroup.lc.ActivityTemplate;
import com.triloggroup.lc.ProfileConnection;
import com.triloggroup.lc.SearchResult;
import com.triloggroup.lotus.ClientServiceConnector;
import com.triloggroup.lotus.atom.Entry;
import com.triloggroup.lotus.atom.Field;
import com.triloggroup.lotus.atom.Member;
import com.triloggroup.lotus.atom.Profile;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ActivityConnectionTest {
    ActivityConnection activityCon;

    public ActivityConnectionTest(String string, String string2, String string3) {
        this.activityCon = new ActivityConnection(new ClientServiceConnector(string, string2, string3));
    }

    public Activity[] getAndDumpAllActivitiesByEmail(String string, boolean bl) throws Exception {
        Activity[] activityArray = this.activityCon.getUserActivitiesByEmail(string);
        if (activityArray == null || activityArray.length == 0) {
            System.out.println("No Activity found");
        } else {
            System.out.println(activityArray.length + " activities found");
            for (int i = 0; i < activityArray.length; ++i) {
                Entry[] entryArray;
                activityArray[i].dump("\t");
                if (bl && (entryArray = this.activityCon.getActivityHistory(activityArray[i])) != null) {
                    System.out.println("----------- history ---------");
                    for (int j = 0; j < entryArray.length; ++j) {
                        entryArray[j].dump("\t");
                        System.out.println("------------------------------");
                    }
                }
                System.out.println("\n------------------------------------------------------------\n");
            }
        }
        return activityArray;
    }

    public Activity[] getAndDumpAllToDolActivities() throws Exception {
        Activity[] activityArray = this.activityCon.getAllToDoActivities();
        if (activityArray == null || activityArray.length == 0) {
            System.out.println("No Activity found");
        } else {
            System.out.println(activityArray.length + " activities found");
            for (int i = 0; i < activityArray.length; ++i) {
                activityArray[i].dump("\t");
                System.out.println("\n------------------------------------------------------------\n");
            }
        }
        return activityArray;
    }

    public SearchResult getAndDumpAllToDolActivities(ActivityCriteriaParameters activityCriteriaParameters) throws Exception {
        SearchResult searchResult = this.activityCon.getAllToDoActivities(activityCriteriaParameters);
        System.out.println("Total Nb activies = " + searchResult.totalResult);
        searchResult.dump(null);
        return searchResult;
    }

    public SearchResult searchActivities(ActivityCriteriaParameters activityCriteriaParameters) throws Exception {
        SearchResult searchResult = this.activityCon.searchActivities(activityCriteriaParameters);
        return searchResult;
    }

    public Activity createActivity(String string, String string2, String[] stringArray, Date date) throws Exception {
        return this.createActivity(string, string2, stringArray, date);
    }

    public Activity getActivityByUuid(String string) throws Exception {
        return this.activityCon.getActivityByUuid(string);
    }

    public boolean delecteActivity(Activity activity) throws Exception {
        return this.activityCon.deleteActivity(activity);
    }

    public boolean delecteActivityByUuid(String string) throws Exception {
        return this.activityCon.deleteActivityByUuid(string);
    }

    public Member[] getActivityMembers(Activity activity) throws Exception {
        return this.activityCon.getActivityMembers(activity);
    }

    public ActivityEntry[] getAndDumpActivityEntries(Activity activity) throws Exception {
        ActivityEntry[] activityEntryArray = this.activityCon.getActivityEntries(activity);
        if (activityEntryArray == null || activityEntryArray.length == 0) {
            System.out.println("No Activity Entry found");
        } else {
            System.out.println(activityEntryArray.length + " activity entries found");
            for (int i = 0; i < activityEntryArray.length; ++i) {
                activityEntryArray[i].dump("\t");
                System.out.println("\n------------------------------------------------------------\n");
            }
        }
        return activityEntryArray;
    }

    public void addaActivityMember(Activity activity, String string, String string2) throws Exception {
        ProfileConnection profileConnection = new ProfileConnection(this.activityCon.getServiceConnector());
        Profile profile = profileConnection.getProfileByEmail(string);
        if (profile == null) {
            throw new Exception("Profile not found by email " + string);
        }
        Member member = Member.createMemberFromProfile(profile);
        member.role = string2;
        this.activityCon.addActivityMember(activity, member);
    }

    public ActivityEntry createActivityEntry(Activity activity, String string, String string2, String[] stringArray) throws Exception {
        return this.activityCon.createActivityEntry(activity, string, string2, stringArray, null);
    }

    public ActivityEntry createProjExecTaskActivityEntry(Activity activity, String string, String string2) throws Exception {
        String[] stringArray = new String[]{"projexec"};
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Field[] fieldArray = new Field[]{new Field("Start date", "date", simpleDateFormat.parse("2010-10-14"), "100"), new Field("End date", "date", simpleDateFormat.parse("2010-11-14"), "200"), new Field("Resource", "person", new Member("Laurent Poublan", "lpoublan@triloggroup.com"), "300"), new Field("Resource", "person", new Member("Valerie Berthie", "vberthie@triloggroup.com"), "301"), new Field("ProjExec Link", "link", "http://tgquickr.triloggroup.com/lotus/myquickr", "400"), new Field("Task Description", "text", "Description of a task in ProjExec", "500")};
        return this.activityCon.createActivityEntry(activity, string, string2, stringArray, fieldArray);
    }

    public ActivityTemplate[] getAndDumpAllActivityTemplates() throws Exception {
        ActivityCriteriaParameters activityCriteriaParameters = new ActivityCriteriaParameters();
        activityCriteriaParameters.publicEntry = "yes";
        SearchResult searchResult = this.activityCon.getActivityTemplates(activityCriteriaParameters);
        System.out.println("---------------Search Result Total Nb activity template = " + searchResult.totalResult);
        searchResult.dump(null);
        return (ActivityTemplate[])searchResult.entries;
    }

    public static void main(String[] stringArray) {
        try {
            ActivityConnectionTest activityConnectionTest = new ActivityConnectionTest("https://apps.test.lotuslive.com/", "vberthie@triloggroup.com", "live2002");
            Activity[] activityArray = activityConnectionTest.getAndDumpAllActivitiesByEmail("vberthie@triloggroup.com", false);
            String string = "FFFG8d51245f5f2243c4a77677695b99f43a";
            System.out.println(" -------------- get Activity By UUID ------------------");
            Activity activity = activityConnectionTest.getActivityByUuid(string);
            activity.dump();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

