/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.lc;

import com.flowbuilder.util.TString;
import com.triloggroup.lc.CriteriaParameters;
import com.triloggroup.lc.SearchResult;
import com.triloggroup.lc.vcard.VCard;
import com.triloggroup.lc.vcard.VCardParser;
import com.triloggroup.lotus.IServiceConnector;
import com.triloggroup.lotus.ServiceException;
import com.triloggroup.lotus.atom.AbstractConnection;
import com.triloggroup.lotus.atom.Profile;
import java.net.URLEncoder;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;

public class ProfileConnection
extends AbstractConnection {
    public ProfileConnection(IServiceConnector iServiceConnector) {
        super(iServiceConnector);
    }

    public Profile[] getProfilesByName(String string) throws Exception {
        String string2 = this.getProfileEntryUrl() + "?name=" + URLEncoder.encode(string, "UTF-8");
        return this.doGetProfiles(string2);
    }

    public SearchResult searchProfiles(String string) throws Exception {
        String string2 = this.getProfileSearchUrl() + "?search=" + URLEncoder.encode(string, "UTF-8");
        return this.doSearchProfiles(string2);
    }

    public SearchResult searchProfiles(String string, int n, int n2) throws Exception {
        CriteriaParameters criteriaParameters = new CriteriaParameters();
        criteriaParameters.searchQuery = string;
        criteriaParameters.pageNumber = n;
        criteriaParameters.pageSize = n2;
        return this.searchProfiles(criteriaParameters);
    }

    public SearchResult searchProfiles(CriteriaParameters criteriaParameters) throws Exception {
        String string = criteriaParameters.appendCriteriaParametersToUrl(this.getProfileSearchUrl());
        return this.doSearchProfiles(string);
    }

    public SearchResult searchProfilesByTags(String[] stringArray, int n, int n2) throws Exception {
        CriteriaParameters criteriaParameters = new CriteriaParameters();
        criteriaParameters.pageNumber = n;
        criteriaParameters.pageSize = n2;
        return this.searchProfilesByTags(stringArray, criteriaParameters);
    }

    public SearchResult searchProfilesByTags(String[] stringArray, CriteriaParameters criteriaParameters) throws Exception {
        String string = this.getProfileSearchUrl() + "?profileTags=";
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(URLEncoder.encode(stringArray[i], "UTF-8"));
        }
        string = criteriaParameters.appendCriteriaParametersToUrl(stringBuilder.toString());
        return this.doSearchProfiles(string);
    }

    public Profile getProfileByUserId(String string) throws Exception {
        String string2 = this.getProfileEntryUrl() + "?userid=" + URLEncoder.encode(string, "UTF-8");
        Profile[] profileArray = this.doGetProfiles(string2);
        if (profileArray != null && profileArray.length > 0) {
            return profileArray[0];
        }
        return null;
    }

    public Profile getProfileByEmail(String string) throws Exception {
        String string2 = this.getProfileEntryUrl() + "?email=" + URLEncoder.encode(string, "UTF-8");
        Profile[] profileArray = this.doGetProfiles(string2);
        if (profileArray != null && profileArray.length > 0) {
            return profileArray[0];
        }
        return null;
    }

    public Profile getCurrentUserProfile() throws Exception {
        String string = this.getCurrentUserId();
        if (TString.isEmpty((String)string)) {
            return null;
        }
        return this.getProfileByUserId(string);
    }

    public String getCurrentUserId() throws Exception {
        String string = this.serviceConnector.getBaseUrl() + "profiles/atom/profileService.do";
        Document document = null;
        try {
            document = this.callService(string, this.serviceConnector);
        }
        catch (ServiceException serviceException) {
            if (serviceException.getErrorCode() == 404) {
                System.out.println("getCurrentUserUserId: profileService not found. Url: " + string);
                return null;
            }
            System.out.println("getCurrentUserUserId: call failed. Url: " + string);
            throw serviceException;
        }
        if (document == null || document.getRootElement() == null) {
            System.out.println("getCurrentUserUserId: profileService document is empty");
            return null;
        }
        Element element = document.getRootElement();
        Element element2 = element.getChild("workspace", appNs);
        if (element2 == null) {
            System.out.println("getCurrentUserUserId: workspace element not found");
            return null;
        }
        Element element3 = element2.getChild("collection", appNs);
        if (element3 == null) {
            System.out.println("getCurrentUserUserId: collection element not found");
            return null;
        }
        return element3.getChildText("userid", snxNs);
    }

    public String[] getProfileTagsByEmail(String string) throws Exception {
        String string2 = this.getProfileTagsUrl() + "?targetEmail=" + URLEncoder.encode(string, "UTF-8");
        try {
            List list;
            Element element;
            Document document = this.callService(string2, this.serviceConnector);
            if (document != null && (element = document.getRootElement()) != null && (list = element.getChildren("category", atomNs)) != null && list.size() > 0) {
                String[] stringArray = new String[list.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = ((Element)list.get(i)).getAttributeValue("term");
                }
                return stringArray;
            }
        }
        catch (ServiceException serviceException) {
            if (serviceException.getErrorCode() == 404) {
                return null;
            }
            throw serviceException;
        }
        return null;
    }

    public VCard getVCardByProfile(Profile profile) throws Exception {
        String string;
        if (!TString.isEmpty((String)profile.vcardUrl) && !TString.isEmpty((String)(string = this.callUrl(profile.vcardUrl, this.serviceConnector, true)))) {
            VCardParser vCardParser = new VCardParser();
            return vCardParser.parse(string);
        }
        return null;
    }

    protected Profile[] doGetProfiles(String string) throws Exception {
        Element element;
        Document document = null;
        try {
            document = this.callService(string, this.serviceConnector);
        }
        catch (ServiceException serviceException) {
            if (serviceException.getErrorCode() == 404) {
                return null;
            }
            throw serviceException;
        }
        if (document != null && (element = document.getRootElement()) != null) {
            Profile[] profileArray = null;
            if (element.getName().equals("entry")) {
                profileArray = new Profile[]{Profile.readProfile(element)};
            } else {
                List list = element.getChildren("entry", atomNs);
                if (list != null && list.size() > 0) {
                    profileArray = new Profile[list.size()];
                    for (int i = 0; i < profileArray.length; ++i) {
                        profileArray[i] = Profile.readProfile((Element)list.get(i));
                    }
                }
            }
            return profileArray;
        }
        return null;
    }

    protected SearchResult doSearchProfiles(String string) throws Exception {
        Element element;
        Document document = null;
        try {
            document = this.callService(string, this.serviceConnector);
        }
        catch (ServiceException serviceException) {
            if (serviceException.getErrorCode() == 404) {
                return null;
            }
            throw serviceException;
        }
        if (document != null && (element = document.getRootElement()) != null) {
            List list;
            SearchResult searchResult = new SearchResult();
            List list2 = element.getChildren("link", atomNs);
            if (list2 != null && list2.size() > 0) {
                for (int i = 0; i < list2.size(); ++i) {
                    Element element2 = (Element)list2.get(i);
                    String string2 = element2.getAttributeValue("rel");
                    if ("first".equals(string2)) {
                        searchResult.firstUrl = element2.getAttributeValue("href");
                        continue;
                    }
                    if ("last".equals(string2)) {
                        searchResult.lastUrl = element2.getAttributeValue("href");
                        continue;
                    }
                    if ("previous".equals(string2)) {
                        searchResult.previousUrl = element2.getAttributeValue("href");
                        continue;
                    }
                    if (!"next".equals(string2)) continue;
                    searchResult.nextUrl = element2.getAttributeValue("href");
                }
            }
            searchResult.totalResult = Integer.parseInt(ProfileConnection.getChildText(element, "totalResults", openSearchNs));
            searchResult.startIndex = Integer.parseInt(ProfileConnection.getChildText(element, "startIndex", openSearchNs));
            searchResult.itemsPerPage = Integer.parseInt(ProfileConnection.getChildText(element, "itemsPerPage", openSearchNs));
            if (searchResult.totalResult < searchResult.startIndex * searchResult.itemsPerPage) {
                searchResult.nextUrl = null;
            }
            if ((list = element.getChildren("entry", atomNs)) != null && list.size() > 0) {
                searchResult.entries = new Profile[list.size()];
                for (int i = 0; i < searchResult.entries.length; ++i) {
                    searchResult.entries[i] = Profile.readProfile((Element)list.get(i));
                }
            }
            return searchResult;
        }
        return null;
    }

    private String getProfileEntryUrl() {
        return this.serviceConnector.getBaseUrl() + "profiles/atom/profileEntry.do";
    }

    private String getProfileTagsUrl() {
        return this.serviceConnector.getBaseUrl() + "profiles/atom/profileTags.do";
    }

    private String getProfileSearchUrl() {
        return this.serviceConnector.getBaseUrl() + "profiles/atom/search.do";
    }
}

