/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.lc;

import com.flowbuilder.docdb.TDBDatabase;
import com.flowbuilder.docdb.TDBDocument;
import com.flowbuilder.docdb.TDBDocumentCollection;
import com.flowbuilder.docdb.TDBServer;
import com.flowbuilder.docdb.TDBSession;
import com.flowbuilder.lib.Application;
import com.flowbuilder.server.directory.DirectoryEntry;
import com.flowbuilder.server.directory.DirectoryException;
import com.flowbuilder.server.directory.IDirectory;
import com.flowbuilder.server.directory.server.DirectoryServer;
import com.flowbuilder.server.util.ResourcesPoolException;
import com.flowbuilder.util.TDiag;
import com.flowbuilder.util.TString;
import com.flowbuilder.util.xml.JDOMUtil;
import com.flowbuilder.xsp.servlet.Context;
import com.triloggroup.auth.OAuthData;
import com.triloggroup.auth.OAuthManager;
import com.triloggroup.auth.OAuthServiceConnector;
import com.triloggroup.lc.CommunityConnection;
import com.triloggroup.lc.ProfileConnection;
import com.triloggroup.lc.XSPServiceConnector;
import com.triloggroup.lotus.IServiceConnector;
import com.triloggroup.lotus.LotusUtil;
import com.triloggroup.lotus.ServletServiceConnector;
import com.triloggroup.lotus.UService;
import com.triloggroup.lotus.atom.Profile;
import com.triloggroup.util.UString;
import com.triloggroup.util.VersionComparator;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;

public class ConnectionUtil {
    public static final String LC_INTEGRATION_KEY = "lc.integration";
    public static final String LC_SERVER_HOST = "lc.server.host";
    public static final String LC_SERVER_PORT = "lc.server.port";
    public static final String LC_SERVER_PROTOCOL = "lc.server.protocol";
    public static final String LC_SERVER_REST_URL_PREFIX = "lc.server.rest.url.prefix";
    public static final String PROXY_LC_DEFINED = "proxy.lc.defined";
    public static final String PROXY_LC_SERVER_HOST = "proxy.lc.server.host";
    public static final String PROXY_LC_SERVER_PORT = "proxy.lc.server.port";
    public static final String PROXY_LC_SERVER_PROTOCOL = "proxy.lc.server.protocol";
    public static final String PROXY_LC_SERVER_REST_URL_PREFIX = "proxy.lc.server.rest.url.prefix";
    public static final String LC_ACTIVITY_DISABLED = "lc.activity.disabled";
    public static final String LC_COMMUNITY_DISABLED = "lc.community.disabled";
    public static final String LC_USER_SESSIONDATA_KEY = "lotusConnectionUserProfile";
    private static ConnectionUtil singleton;
    private static final String DB_NAME = "tg_pe_projexec";
    private static final String SCHEMA_NAME = "lotusconnection";
    protected Properties dbProperties;
    protected boolean forceUseProjExecPropertiesFile = true;
    protected String connectionsVersion;
    private Boolean isConnections4 = null;
    private Boolean isConnections5 = null;
    private String staticRootUri = null;

    protected ConnectionUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConnectionUtil get() {
        if (singleton != null) return singleton;
        Class<LotusUtil> clazz = LotusUtil.class;
        synchronized (LotusUtil.class) {
            singleton = new ConnectionUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public boolean isLCIntegrationEnable() {
        String string = this.getProperty(LC_INTEGRATION_KEY);
        return !TString.isEmpty((String)string) && TString.equalsIgnoreCase((String)string, (String)"true");
    }

    public IServiceConnector createServiceConnector(Context context) {
        OAuthData oAuthData = OAuthManager.get().getOAuthDataFromSession(context.getHttpSession());
        if (oAuthData != null) {
            return new OAuthServiceConnector(this.getLCServerBaseUrl(context), oAuthData);
        }
        return new XSPServiceConnector(context);
    }

    public IServiceConnector createServiceConnector(HttpServletRequest httpServletRequest) {
        OAuthData oAuthData = OAuthManager.get().getOAuthDataFromSession(httpServletRequest.getSession());
        if (oAuthData != null) {
            return new OAuthServiceConnector(this.getLCServerBaseUrl(httpServletRequest), oAuthData);
        }
        return new ServletServiceConnector(httpServletRequest);
    }

    public DirectoryEntry getDirectoryEntryByProfile(String string, Profile profile) throws DirectoryException, ResourcesPoolException {
        DirectoryServer directoryServer = Application.getDirectoryServer((String)string);
        IDirectory iDirectory = directoryServer.getDirectory();
        if (profile.contributor != null) {
            DirectoryEntry[] directoryEntryArray;
            String string2;
            if (!TString.isEmpty((String)profile.contributor.email)) {
                try {
                    string2 = iDirectory.getLDAPSchema().getUserMailAttribute();
                    directoryEntryArray = iDirectory.searchUsers(string2 + "=" + profile.contributor.email, null, false);
                    if (directoryEntryArray != null && directoryEntryArray.length != 0) {
                        return directoryEntryArray[0];
                    }
                }
                catch (DirectoryException directoryException) {
                    TDiag.println((String)("Info: User not present in the directory by email: " + profile.contributor.email));
                }
            }
            if (!TString.isEmpty((String)profile.contributor.name)) {
                try {
                    string2 = iDirectory.getLDAPSchema().getUserCnAttribute();
                    directoryEntryArray = iDirectory.searchUsers(string2 + "=" + profile.contributor.name, null, false);
                    if (directoryEntryArray != null) {
                        if (directoryEntryArray.length == 1) {
                            return directoryEntryArray[0];
                        }
                        if (directoryEntryArray.length > 1) {
                            throw new DirectoryException(null, "Too much users found in LDAP for this profile");
                        }
                    }
                }
                catch (DirectoryException directoryException) {
                    TDiag.println((String)("Info: User not present in the directory by name: " + profile.contributor.name));
                }
            }
        }
        return null;
    }

    public String getLCServerHost(Context context) {
        return this.getLCServerHost(LotusUtil.get().getHttpServletRequest(context));
    }

    public String getLCServerHost(HttpServletRequest httpServletRequest) {
        String string = this.getProperty(LC_SERVER_HOST);
        if (TString.isEmpty((String)string) && httpServletRequest != null) {
            string = httpServletRequest.getServerName();
        }
        return string;
    }

    public String getLCServerHostProxy(Context context) {
        return this.getLCServerHostProxy(LotusUtil.get().getHttpServletRequest(context));
    }

    public String getLCServerHostProxy(HttpServletRequest httpServletRequest) {
        if (!this.isProxyPropertiesDefined()) {
            return this.getLCServerHost(httpServletRequest);
        }
        String string = this.getProperty(PROXY_LC_SERVER_HOST);
        if (TString.isEmpty((String)string) && httpServletRequest != null) {
            string = httpServletRequest.getServerName();
        }
        return string;
    }

    public String getLCServerPort(Context context) {
        return this.getLCServerPort(LotusUtil.get().getHttpServletRequest(context));
    }

    public String getLCServerPort(HttpServletRequest httpServletRequest) {
        String string = this.getProperty(LC_SERVER_PORT);
        if (TString.isEmpty((String)string) && httpServletRequest != null) {
            string = String.valueOf(httpServletRequest.getServerPort());
        }
        return string;
    }

    public String getLCServerPortProxy(Context context) {
        return this.getLCServerPortProxy(LotusUtil.get().getHttpServletRequest(context));
    }

    public String getLCServerPortProxy(HttpServletRequest httpServletRequest) {
        if (!this.isProxyPropertiesDefined()) {
            return this.getLCServerPort(httpServletRequest);
        }
        String string = this.getProperty(PROXY_LC_SERVER_PORT);
        if (TString.isEmpty((String)string) && httpServletRequest != null) {
            string = String.valueOf(httpServletRequest.getServerPort());
        }
        return string;
    }

    public String getLCServerProtocol(Context context) {
        return this.getLCServerProtocol(LotusUtil.get().getHttpServletRequest(context));
    }

    public String getLCServerProtocol(HttpServletRequest httpServletRequest) {
        String string = this.getProperty(LC_SERVER_PROTOCOL);
        if (TString.isEmpty((String)string) && httpServletRequest != null) {
            string = httpServletRequest.getScheme();
        }
        return string;
    }

    public String getLCServerProtocolProxy(Context context) {
        return this.getLCServerProtocolProxy(LotusUtil.get().getHttpServletRequest(context));
    }

    public String getLCServerProtocolProxy(HttpServletRequest httpServletRequest) {
        if (!this.isProxyPropertiesDefined()) {
            return this.getLCServerProtocol(httpServletRequest);
        }
        String string = this.getProperty(PROXY_LC_SERVER_PROTOCOL);
        if (TString.isEmpty((String)string) && httpServletRequest != null) {
            string = httpServletRequest.getScheme();
        }
        return string;
    }

    public String getLCServerRestUrlPrefix() {
        return this.getProperty(LC_SERVER_REST_URL_PREFIX);
    }

    public String getLCServerRestUrlPrefixProxy() {
        if (!this.isProxyPropertiesDefined()) {
            return this.getLCServerRestUrlPrefix();
        }
        return this.getProperty(PROXY_LC_SERVER_REST_URL_PREFIX);
    }

    public String getLCServerBaseUrl(Context context) {
        return this.getLCServerBaseUrl(LotusUtil.get().getHttpServletRequest(context));
    }

    public String getLCServerBaseUrl(HttpServletRequest httpServletRequest) {
        String string = this.getLCServerProtocol(httpServletRequest);
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append("://");
        stringBuffer.append(this.getLCServerHost(httpServletRequest));
        String string2 = this.getLCServerPort(httpServletRequest);
        if (!TString.isEmpty((String)string2) && (!"80".equals(string2) && "http".equalsIgnoreCase(string) || !"443".equals(string2) && "https".equalsIgnoreCase(string))) {
            stringBuffer.append(":");
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public String getLCServerBaseUrlProxy(Context context) {
        return this.getLCServerBaseUrlProxy(LotusUtil.get().getHttpServletRequest(context));
    }

    public String getLCServerBaseUrlProxy(HttpServletRequest httpServletRequest) {
        if (!this.isProxyPropertiesDefined()) {
            return this.getLCServerBaseUrl(httpServletRequest);
        }
        String string = this.getLCServerProtocolProxy(httpServletRequest);
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append("://");
        stringBuffer.append(this.getLCServerHostProxy(httpServletRequest));
        String string2 = this.getLCServerPortProxy(httpServletRequest);
        if (!TString.isEmpty((String)string2) && (!"80".equals(string2) && "http".equalsIgnoreCase(string) || !"443".equals(string2) && "https".equalsIgnoreCase(string))) {
            stringBuffer.append(":");
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public String getLCServerBaseRestUrl(Context context) {
        return this.getLCServerBaseRestUrl(LotusUtil.get().getHttpServletRequest(context));
    }

    public String getLCServerBaseRestUrl(HttpServletRequest httpServletRequest) {
        String string = this.getLCServerBaseUrl(httpServletRequest);
        String string2 = this.getLCServerRestUrlPrefix();
        if (!TString.isEmpty((String)string2)) {
            if (!string2.startsWith("/")) {
                string = string + "/";
            }
            string = string + string2;
        }
        return string;
    }

    public String getLCServerBaseRestUrlProxy(Context context) {
        return this.getLCServerBaseRestUrlProxy(LotusUtil.get().getHttpServletRequest(context));
    }

    public String getLCServerBaseRestUrlProxy(HttpServletRequest httpServletRequest) {
        if (!this.isProxyPropertiesDefined()) {
            return this.getLCServerBaseRestUrl(httpServletRequest);
        }
        String string = this.getLCServerBaseUrlProxy(httpServletRequest);
        String string2 = this.getLCServerRestUrlPrefixProxy();
        if (!TString.isEmpty((String)string2)) {
            if (!string2.startsWith("/")) {
                string = string + "/";
            }
            string = string + string2;
        }
        return string;
    }

    public String convertLCProxyRestUrlToServer(HttpServletRequest httpServletRequest, String string) {
        String string2 = this.getLCServerBaseRestUrl(httpServletRequest);
        String string3 = this.getLCServerBaseRestUrlProxy(httpServletRequest);
        return LotusUtil.get().convertUrl(string, string3, string2, this.getLCServerRestUrlPrefixProxy(), this.getLCServerHostProxy(httpServletRequest));
    }

    public String convertLCServerRestUrlToProxy(HttpServletRequest httpServletRequest, String string) {
        String string2 = this.getLCServerBaseRestUrl(httpServletRequest);
        String string3 = this.getLCServerBaseRestUrlProxy(httpServletRequest);
        return LotusUtil.get().convertUrl(string, string2, string3, this.getLCServerRestUrlPrefix(), this.getLCServerHost(httpServletRequest));
    }

    public boolean isActivityDisabled() {
        return this.getBooleanProperty(LC_ACTIVITY_DISABLED);
    }

    public boolean isCommunityDisabled() {
        return this.getBooleanProperty(LC_COMMUNITY_DISABLED);
    }

    protected String getProperty(String string) {
        if (this.forceUseProjExecPropertiesFile) {
            return LotusUtil.get().getProjExecProperty(string);
        }
        if (this.dbProperties == null) {
            this.loadPropertiesFromDatabase();
        }
        if (this.dbProperties != null) {
            return this.dbProperties.getProperty(string);
        }
        return null;
    }

    protected boolean getBooleanProperty(String string) {
        String string2 = this.getProperty(string);
        return TString.equalsIgnoreCase((String)string2, (String)"true");
    }

    protected boolean isProxyPropertiesDefined() {
        return TString.equalsIgnoreCase((String)this.getProperty(PROXY_LC_DEFINED), (String)"true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadPropertiesFromDatabase() {
        TDBServer tDBServer = null;
        TDBSession tDBSession = null;
        TDBDatabase tDBDatabase = null;
        TDBDocumentCollection tDBDocumentCollection = null;
        try {
            List list;
            Document document;
            Element element;
            TDBDocument tDBDocument;
            this.dbProperties = new Properties();
            tDBServer = Application.getDBServer(null);
            tDBSession = tDBServer.createSession();
            tDBDatabase = tDBSession.openDatabase(DB_NAME);
            tDBDocumentCollection = tDBDatabase.getAllDocuments(SCHEMA_NAME);
            if (tDBDocumentCollection != null && (tDBDocument = tDBDocumentCollection.getFirstDocument()) != null && (element = (document = tDBDocument.getDOM()).getRootElement()) != null && (list = element.getChildren("property")) != null && list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    Element element2 = (Element)list.get(i);
                    String string = JDOMUtil.getStringValue((Element)element2, (String)"key");
                    if (TString.isEmpty((String)string)) continue;
                    String string2 = JDOMUtil.getStringValue((Element)element2, (String)"value");
                    this.dbProperties.setProperty(string, string2);
                }
            }
        }
        catch (Exception exception) {
            TDiag.exception((Throwable)exception, (String)"Could not get Lotus Connection properties from database");
        }
        finally {
            if (tDBDocumentCollection != null) {
                tDBDocumentCollection.close();
            }
            if (tDBDatabase != null) {
                tDBDatabase.close();
            }
            if (tDBSession != null) {
                tDBSession.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadProperties() {
        ConnectionUtil connectionUtil = this;
        synchronized (connectionUtil) {
            this.dbProperties = null;
            if (this.forceUseProjExecPropertiesFile) {
                LotusUtil.get().reloadProperties();
            }
        }
    }

    public void setForceUseProjExecPropertiesFile(boolean bl) {
        this.forceUseProjExecPropertiesFile = bl;
    }

    public String getCurrentUserId(Context context) throws Exception {
        Profile profile = this.getCurrentUserProfile(context);
        if (profile == null) {
            return null;
        }
        return profile.contributor.userId;
    }

    public Profile getCurrentUserProfile(Context context) throws Exception {
        Profile profile = (Profile)context.getSessionDataAsObject(LC_USER_SESSIONDATA_KEY);
        if (profile == null) {
            String string = context.getUser().getMail();
            IServiceConnector iServiceConnector = this.createServiceConnector(context);
            ProfileConnection profileConnection = new ProfileConnection(iServiceConnector);
            if (TString.isEmpty((String)string)) {
                TDiag.println((String)"ConnectionUtil.getCurrentUserProfile called for a user without email address defined.");
                profile = profileConnection.getCurrentUserProfile();
            } else {
                profile = profileConnection.getProfileByEmail(string);
            }
            if (profile == null) {
                TDiag.println((String)("ConnectionUtil.getCurrentUserProfile: not UserProfile found for user: " + string));
            } else {
                context.setSessionData(LC_USER_SESSIONDATA_KEY, (Object)profile);
            }
        }
        return profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStaticRootUri(Context context) {
        if (this.staticRootUri == null) {
            ConnectionUtil connectionUtil = this;
            synchronized (connectionUtil) {
                if (this.staticRootUri == null && this.staticRootUri == null) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd.HHmmss");
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                    this.staticRootUri = this.getLCServerBaseUrlProxy(context) + "/profiles/static/" + simpleDateFormat.format(new Date(System.currentTimeMillis()));
                }
            }
        }
        return this.staticRootUri;
    }

    public boolean isConnection4(Context context) {
        if (this.isConnections4 == null) {
            return this.isConnection4(this.createServiceConnector(context));
        }
        return this.isConnections4;
    }

    public boolean isConnection4(IServiceConnector iServiceConnector) {
        if (this.isConnections4 == null) {
            this.isConnections4 = this.isVersionSuperiorOrEqualsTo(iServiceConnector, "4.0.0.0");
        }
        return this.isConnections4;
    }

    public boolean isConnection5orHigher(Context context) {
        if (this.isConnections5 == null) {
            return this.isConnection5orHigher(this.createServiceConnector(context));
        }
        return this.isConnections5;
    }

    public boolean isConnection5orHigher(IServiceConnector iServiceConnector) {
        if (this.isConnections5 == null) {
            this.isConnections5 = this.isVersionSuperiorOrEqualsTo(iServiceConnector, "5");
        }
        return this.isConnections5;
    }

    public boolean isVersionSuperiorOrEqualsTo(IServiceConnector iServiceConnector, String string) {
        try {
            String string2 = this.getConnectionsVersion(iServiceConnector);
            TDiag.println((String)("Connections Version from generator tag = " + string2));
            if (!TString.isEmpty((String)string2)) {
                VersionComparator versionComparator = new VersionComparator();
                return versionComparator.compare((Object)string2, (Object)string) >= 0;
            }
        }
        catch (Exception exception) {
            TDiag.exception((Throwable)exception, (String)"Could not get Connections version from generator tag");
        }
        return false;
    }

    protected String getConnectionsVersion(IServiceConnector iServiceConnector) throws Exception {
        if (UString.isEmpty((String)this.connectionsVersion)) {
            UService uService = new UService();
            String string = new CommunityConnection(iServiceConnector).getCommunitiesServiceDocumentUrl();
            Document document = uService.callService(string, iServiceConnector, null);
            if (document == null || document.getRootElement() == null) {
                return null;
            }
            Element element = document.getRootElement();
            Element element2 = element.getChild("generator", UService.atomNs);
            if (element2 != null) {
                this.connectionsVersion = element2.getAttributeValue("version");
            }
        }
        return this.connectionsVersion;
    }
}

