/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.lc;

import com.flowbuilder.util.TString;
import com.triloggroup.lc.Community;
import com.triloggroup.lc.ListResult;
import com.triloggroup.lotus.IServiceConnector;
import com.triloggroup.lotus.ServiceException;
import com.triloggroup.lotus.atom.AbstractConnection;
import com.triloggroup.lotus.atom.Category;
import com.triloggroup.lotus.atom.Content;
import com.triloggroup.lotus.atom.Member;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;

public class CommunityConnection
extends AbstractConnection {
    protected String allCommunitiesUrl;
    protected String myCommunitiesUrl;
    protected String myInvitCommunitiesUrl;

    public CommunityConnection(IServiceConnector iServiceConnector) throws Exception {
        super(iServiceConnector);
        this.initCommunitiesUrl();
    }

    public ListResult getAllPublicCommunities() throws Exception {
        return this.getResult(this.allCommunitiesUrl);
    }

    public ListResult getCurrentUserCommunities() throws Exception {
        return this.getResult(this.myCommunitiesUrl + "?ps=10000");
    }

    public Community getCommunityByUid(String string) throws Exception {
        String string2 = this.serviceConnector.getBaseUrl();
        if (!string2.endsWith("/")) {
            string2 = string2 + '/';
        }
        string2 = string2 + "communities/service/atom/community/instance?communityUuid=" + string;
        return this.doGetCommunity(string2);
    }

    public Member[] getCommunityMembersByCommunityUuid(String string) throws Exception {
        String string2 = this.serviceConnector.getBaseUrl();
        if (!string2.endsWith("/")) {
            string2 = string2 + '/';
        }
        string2 = string2 + "communities/service/atom/community/members?ps=10000&communityUuid=" + string;
        return this.doGetMembers(string2);
    }

    public ListResult getSubCommunities(Community community) throws Exception {
        if (TString.isEmpty((String)community.subCommunitiesUrl)) {
            return ListResult.EMPTY;
        }
        return this.getResult(community.subCommunitiesUrl);
    }

    public Community getParentCommunity(Community community) throws Exception {
        if (community.parentCommunityUrl == null) {
            return null;
        }
        return this.doGetCommunity(community.parentCommunityUrl);
    }

    public Community createCommunity(String string, String string2, String[] stringArray, String string3) throws Exception {
        Community community = new Community();
        community.title = string;
        community.content = new Content(string2 == null ? "" : string2, "text");
        community.type = string3;
        community.preModeration = true;
        community.postModeration = true;
        Category category = new Category();
        category.term = "community";
        category.scheme = "http://www.ibm.com/xmlns/prod/sn/type";
        Category[] categoryArray = null;
        if (stringArray == null || stringArray.length == 0) {
            categoryArray = new Category[]{category};
        } else {
            categoryArray = new Category[stringArray.length + 1];
            for (int i = 0; i < stringArray.length; ++i) {
                community.categories[i] = new Category(stringArray[i]);
            }
            categoryArray[stringArray.length] = category;
        }
        community.addCategories(categoryArray);
        try {
            return this.createCommunity(community);
        }
        catch (Exception exception) {
            System.out.println("Failed to create community:");
            community.dump();
            throw exception;
        }
    }

    public void addCommunityMember(Community community, Member member) throws Exception {
        String string = member.toXmlEntryAtom();
        this.callService(community.membersUrl, this.serviceConnector, string);
    }

    public Community createCommunity(Community community) throws Exception {
        Element element;
        String string = community.toXmlEntryAtom();
        Document document = this.callService(this.myCommunitiesUrl, this.serviceConnector, string);
        List list = (List)this.lastResponseHeader.get("location");
        if (list == null) {
            list = (List)this.lastResponseHeader.get("Location");
        }
        if (list != null && list.size() > 0 && (document = this.callService((String)list.get(0), this.serviceConnector)) != null && (element = document.getRootElement()) != null) {
            return Community.readCommunity(element);
        }
        return null;
    }

    public String getCommunitiesServiceDocumentUrl() {
        String string = this.serviceConnector.getBaseUrl();
        if (!string.endsWith("/")) {
            string = string + '/';
        }
        string = string + "communities/service/atom/service";
        return string;
    }

    protected String getMyCommunitiesUrl() {
        String string = this.serviceConnector.getBaseUrl();
        if (!string.endsWith("/")) {
            string = string + '/';
        }
        string = string + this.myCommunitiesUrl;
        return string;
    }

    protected void initCommunitiesUrl() throws Exception {
        List list;
        Element element;
        String[][] stringArray = new String[1][2];
        stringArray[0][0] = "Accept-Language";
        stringArray[0][1] = "en";
        Document document = this.callService(this.getCommunitiesServiceDocumentUrl(), this.serviceConnector);
        if (document != null && (element = document.getRootElement()) != null && (list = element.getChildren()) != null) {
            for (int i = 0; i < list.size(); ++i) {
                List list2 = ((Element)list.get(i)).getChildren();
                if (list2 == null) continue;
                for (int j = 0; j < list2.size(); ++j) {
                    Element element2 = (Element)list2.get(j);
                    Element element3 = element2.getChild("category", atomNs);
                    if (element3 == null) continue;
                    String string = element3.getAttributeValue("term");
                    if ("public".equals(string)) {
                        this.allCommunitiesUrl = element2.getAttributeValue("href");
                        continue;
                    }
                    if ("personal".equals(string)) {
                        this.myCommunitiesUrl = element2.getAttributeValue("href");
                        continue;
                    }
                    if (!"my-invitations".equals(string)) continue;
                    this.myInvitCommunitiesUrl = element2.getAttributeValue("href");
                }
            }
        }
    }

    protected ListResult getResult(String string) throws Exception {
        Element element;
        Document document = null;
        try {
            document = this.callService(string, this.serviceConnector);
        }
        catch (ServiceException serviceException) {
            if (serviceException.getErrorCode() == 404) {
                return null;
            }
            throw serviceException;
        }
        if (document != null && (element = document.getRootElement()) != null) {
            List list;
            ListResult listResult = new ListResult();
            List list2 = element.getChildren("link", atomNs);
            if (list2 != null && list2.size() > 0) {
                for (int i = 0; i < list2.size(); ++i) {
                    Element element2 = (Element)list2.get(i);
                    String string2 = element2.getAttributeValue("rel");
                    if ("first".equals(string2)) {
                        listResult.firstUrl = element2.getAttributeValue("href");
                        continue;
                    }
                    if ("last".equals(string2)) {
                        listResult.lastUrl = element2.getAttributeValue("href");
                        continue;
                    }
                    if ("previous".equals(string2)) {
                        listResult.previousUrl = element2.getAttributeValue("href");
                        continue;
                    }
                    if (!"next".equals(string2)) continue;
                    listResult.nextUrl = element2.getAttributeValue("href");
                }
            }
            try {
                listResult.totalResult = Integer.parseInt(CommunityConnection.getChildText(element, "totalResults", openSearchNs));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                listResult.startIndex = Integer.parseInt(CommunityConnection.getChildText(element, "startIndex", openSearchNs));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                listResult.itemsPerPage = Integer.parseInt(CommunityConnection.getChildText(element, "itemsPerPage", openSearchNs));
            }
            catch (NumberFormatException numberFormatException) {
                listResult.itemsPerPage = 0;
            }
            if (listResult.totalResult < listResult.startIndex * listResult.itemsPerPage) {
                listResult.nextUrl = null;
            }
            if ((list = element.getChildren("entry", atomNs)) != null && list.size() > 0) {
                listResult.entries = new Community[list.size()];
                for (int i = 0; i < listResult.entries.length; ++i) {
                    listResult.entries[i] = Community.readCommunity((Element)list.get(i));
                }
            } else {
                listResult.entries = new Community[0];
            }
            return listResult;
        }
        return null;
    }

    protected Community doGetCommunity(String string) throws Exception {
        Document document;
        block2: {
            document = null;
            try {
                document = this.callService(string, this.serviceConnector);
            }
            catch (ServiceException serviceException) {
                if (serviceException.getErrorCode() != 404) break block2;
                return null;
            }
        }
        return this.readCommunity(document);
    }

    protected Community readCommunity(Document document) throws Exception {
        Element element;
        if (document != null && (element = document.getRootElement()) != null) {
            return Community.readCommunity(element);
        }
        return null;
    }
}

