/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.lc;

import com.triloggroup.lc.ActivityAbstract;
import com.triloggroup.lc.InReplyTo;
import com.triloggroup.lotus.UService;
import com.triloggroup.lotus.atom.Category;
import com.triloggroup.lotus.atom.Field;
import java.io.PrintWriter;
import java.util.List;
import org.jdom.Element;

public class ActivityEntry
extends ActivityAbstract {
    public static Category ACTIVITY_ENTRY_CATEGORY = new Category("entry", "Entry", "http://www.ibm.com/xmlns/prod/sn/type");
    public Field[] fields = new Field[0];
    public InReplyTo inReplyTo;

    public ActivityEntry() {
        this.categories = new Category[1];
        this.categories[0] = ACTIVITY_ENTRY_CATEGORY;
    }

    public void addField(Field field) {
        if (this.fields == null || this.fields.length == 0) {
            this.fields = new Field[1];
        } else {
            Field[] fieldArray = this.fields;
            this.fields = new Field[fieldArray.length + 1];
            System.arraycopy(fieldArray, 0, this.fields, 0, fieldArray.length);
        }
        this.fields[this.fields.length - 1] = field;
    }

    public void addFields(Field[] fieldArray) {
        if (this.fields == null || this.fields.length == 0) {
            this.fields = fieldArray;
        } else {
            Field[] fieldArray2 = this.fields;
            this.fields = new Field[fieldArray2.length + fieldArray.length];
            System.arraycopy(fieldArray2, 0, this.fields, 0, fieldArray2.length);
            System.arraycopy(fieldArray, 0, this.fields, fieldArray2.length, fieldArray.length);
        }
    }

    public static ActivityEntry readActivityEntry(Element element) {
        ActivityEntry activityEntry = new ActivityEntry();
        activityEntry.initActivityEntryFromXml(element);
        return activityEntry;
    }

    public void initActivityEntryFromXml(Element element) {
        this.initAbstractActivityFromXml(element);
        this.inReplyTo = InReplyTo.readInReplyTo(element.getChild("in-reply-to", UService.thrNs));
        List list = element.getChildren("field", UService.snxNs);
        if (list != null && list.size() > 0) {
            this.fields = new Field[list.size()];
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i] = Field.readField((Element)list.get(i));
            }
        }
    }

    public void dump(PrintWriter printWriter, String string) {
        super.dump(printWriter, string);
        if (string == null) {
            string = "";
        }
        if (this.inReplyTo != null) {
            this.inReplyTo.dump(printWriter, string);
        }
        if (this.fields != null && this.fields.length > 0) {
            printWriter.println(string + " Fields : ");
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i].dump(printWriter, string + "       ");
            }
        }
        printWriter.flush();
    }

    protected void insertAdditionalDataXmlEntryAtom(StringBuffer stringBuffer) {
        super.insertAdditionalDataXmlEntryAtom(stringBuffer);
        stringBuffer.append(" <category scheme=\"http://www.ibm.com/xmlns/prod/sn/type\" term=\"entry\" label=\"Entry\" /> \n");
        if (this.fields != null && this.fields.length > 0) {
            for (int i = 0; i < this.fields.length; ++i) {
                stringBuffer.append(this.fields[i].toXmlAtom()).append('\n');
            }
        }
    }
}

