/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.lc;

import com.flowbuilder.util.TDiag;
import com.flowbuilder.util.TString;
import com.flowbuilder.util.xml.JDOMUtil;
import com.triloggroup.lc.Activity;
import com.triloggroup.lc.ActivityCriteriaParameters;
import com.triloggroup.lc.ActivityEntry;
import com.triloggroup.lc.ActivityTemplate;
import com.triloggroup.lc.SearchResult;
import com.triloggroup.lotus.IServiceConnector;
import com.triloggroup.lotus.ServiceException;
import com.triloggroup.lotus.atom.AbstractConnection;
import com.triloggroup.lotus.atom.Category;
import com.triloggroup.lotus.atom.Content;
import com.triloggroup.lotus.atom.Entry;
import com.triloggroup.lotus.atom.Field;
import com.triloggroup.lotus.atom.Member;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;

public class ActivityConnection
extends AbstractConnection {
    public static final int COMPLETED = 0;
    public static final int TURNED_OUT = 1;
    public static final int TRASH = 2;
    public static final int PUBLIC = 3;
    public static final int EVERYTHING = 4;
    public static final int TODO = 5;
    private static final int ACTIVITY = 0;
    private static final int TEMPLATE = 1;
    protected String activitiesOverviewUrl;

    public ActivityConnection(IServiceConnector iServiceConnector) {
        super(iServiceConnector);
    }

    public Activity createActivity(String string, String string2, String[] stringArray, Date date) throws Exception {
        Activity activity = new Activity();
        activity.title = string;
        activity.content = new Content(string2, "text");
        if (stringArray != null && stringArray.length > 0) {
            activity.categories = new Category[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                activity.categories[i] = new Category(stringArray[i]);
            }
        }
        activity.dueDate = date;
        return this.createActivity(activity);
    }

    public Activity createActivity(Activity activity) throws Exception {
        Element element;
        String string = activity.toXmlEntryAtom();
        String string2 = this.getActivitiesServiceOverviewUrl();
        Document document = this.callService(string2, this.serviceConnector, string);
        if (document != null && (element = document.getRootElement()) != null) {
            return Activity.readActivity(element);
        }
        return null;
    }

    public boolean deleteActivity(Activity activity) throws Exception {
        try {
            this.callDeleteService(activity.editUrl, this.serviceConnector, false);
        }
        catch (ServiceException serviceException) {
            if (serviceException.getErrorCode() == 204) {
                return true;
            }
            throw serviceException;
        }
        return false;
    }

    public boolean deleteActivityByUuid(String string) throws Exception {
        Activity activity = this.getActivityByUuid(string);
        if (activity == null) {
            return true;
        }
        return this.deleteActivity(activity);
    }

    public ActivityEntry createActivityEntry(Activity activity, String string, String string2, String[] stringArray, Field[] fieldArray) throws Exception {
        ActivityEntry activityEntry = new ActivityEntry();
        activityEntry.title = string;
        activityEntry.content = new Content(string2);
        if (stringArray != null) {
            activityEntry.addCategories(stringArray);
        }
        if (fieldArray != null) {
            activityEntry.addFields(fieldArray);
        }
        return this.createActivityEntry(activity, activityEntry);
    }

    public ActivityEntry createActivityEntry(Activity activity, ActivityEntry activityEntry) throws Exception {
        Element element;
        Document document = this.callService(activity.nodeListUrl, this.serviceConnector, activityEntry.toXmlEntryAtom());
        if (document != null && (element = document.getRootElement()) != null) {
            return ActivityEntry.readActivityEntry(element);
        }
        return null;
    }

    public Activity[] getCurrentUserActivities() throws Exception {
        SearchResult searchResult = this.getCurrentUserActivities(null);
        return (Activity[])searchResult.entries;
    }

    public SearchResult getCurrentUserActivities(ActivityCriteriaParameters activityCriteriaParameters) throws Exception {
        String string = this.serviceConnector.getBaseUrl() + "activities/service/atom2/activities";
        if (activityCriteriaParameters == null) {
            activityCriteriaParameters = new ActivityCriteriaParameters();
            activityCriteriaParameters.pageSize = 10000;
        }
        string = activityCriteriaParameters.appendCriteriaParametersToUrl(string);
        return this.doSearchActivities(string);
    }

    public Activity[] getUserActivitiesByEmail(String string) throws Exception {
        SearchResult searchResult = this.getUserActivitiesByEmail(string, null);
        return (Activity[])searchResult.entries;
    }

    public SearchResult getUserActivitiesByEmail(String string, ActivityCriteriaParameters activityCriteriaParameters) throws Exception {
        String string2 = this.serviceConnector.getBaseUrl() + "activities/service/atom2/activities";
        if (activityCriteriaParameters == null) {
            activityCriteriaParameters = new ActivityCriteriaParameters();
            activityCriteriaParameters.pageSize = 10000;
        }
        activityCriteriaParameters.email = string;
        string2 = activityCriteriaParameters.appendCriteriaParametersToUrl(string2);
        return this.doSearchActivities(string2);
    }

    public Activity[] getUserCompletedActivitiesByEmail(String string) throws Exception {
        SearchResult searchResult = this.getUserCompletedActivitiesByEmail(string, null);
        return (Activity[])searchResult.entries;
    }

    public SearchResult getUserCompletedActivitiesByEmail(String string, ActivityCriteriaParameters activityCriteriaParameters) throws Exception {
        String string2 = this.serviceConnector.getBaseUrl() + "activities/service/atom2/completed";
        if (activityCriteriaParameters == null) {
            activityCriteriaParameters = new ActivityCriteriaParameters();
            activityCriteriaParameters.email = string;
        }
        string2 = activityCriteriaParameters.appendCriteriaParametersToUrl(string2);
        return this.doSearchActivities(string2);
    }

    public Activity[] getUserToDoActivitiesByEmail(String string) throws Exception {
        SearchResult searchResult = this.getUserToDoActivitiesByEmail(string, null);
        return (Activity[])searchResult.entries;
    }

    public SearchResult getUserToDoActivitiesByEmail(String string, ActivityCriteriaParameters activityCriteriaParameters) throws Exception {
        String string2 = this.serviceConnector.getBaseUrl() + "activities/service/atom2/todos";
        string2 = string2 + "?assignedto=" + URLEncoder.encode(string, "UTF-8");
        if (activityCriteriaParameters != null) {
            string2 = activityCriteriaParameters.appendCriteriaParametersToUrl(string2);
        }
        return this.doSearchActivities(string2);
    }

    public Activity[] getAllToDoActivities() throws Exception {
        SearchResult searchResult = this.getAllToDoActivities(null);
        return (Activity[])searchResult.entries;
    }

    public SearchResult getAllToDoActivities(ActivityCriteriaParameters activityCriteriaParameters) throws Exception {
        String string = this.serviceConnector.getBaseUrl() + "activities/service/atom2/todos";
        string = string + "?includeunassigned=yes";
        if (activityCriteriaParameters != null) {
            string = activityCriteriaParameters.appendCriteriaParametersToUrl(string);
        }
        return this.doSearchActivities(string);
    }

    public Activity getActivityByUuid(String string) throws Exception {
        String string2 = this.serviceConnector.getBaseUrl() + "activities/service/atom2/activitynode?activityNodeUuid=" + string;
        Activity[] activityArray = this.doGetActivities(string2);
        if (activityArray != null && activityArray.length > 0) {
            return activityArray[0];
        }
        return null;
    }

    public Member[] getActivityMembers(Activity activity) throws Exception {
        return this.getActivityMembersByActivityUuid(this.serviceConnector, activity.uuid);
    }

    public Member[] getActivityMembersByActivityUuid(IServiceConnector iServiceConnector, String string) throws Exception {
        String string2 = iServiceConnector.getBaseUrl() + "activities/service/atom2/acl?ps=10000&activityUuid=" + string;
        return this.doGetMembers(string2);
    }

    public void addActivityMember(Activity activity, Member member) throws Exception {
        String string = member.toXmlEntryAtom();
        this.callService(activity.membersUrl, this.serviceConnector, string, (String[][])null, false);
    }

    public ActivityEntry[] getActivityEntries(Activity activity) throws Exception {
        Document document = this.callService(activity.nodeListUrl, this.serviceConnector);
        return this.readActivityEntries(document);
    }

    public Entry[] getActivityHistory(Activity activity) throws Exception {
        Document document = this.callService(activity.historyUrl, this.serviceConnector);
        return this.readEntries(document);
    }

    public SearchResult searchActivities(ActivityCriteriaParameters activityCriteriaParameters) throws Exception {
        String string = activityCriteriaParameters.appendCriteriaParametersToUrl(this.getAllActivitiesUrl());
        return this.doSearchActivities(string);
    }

    public SearchResult getActivityTemplates(ActivityCriteriaParameters activityCriteriaParameters) throws Exception {
        activityCriteriaParameters.templates = "only";
        String string = activityCriteriaParameters.appendCriteriaParametersToUrl(this.getActivitiesServiceUrl());
        return this.doSearch(string, 1);
    }

    protected Activity[] doGetActivities(String string) throws Exception {
        Document document = null;
        try {
            document = this.callService(string, this.serviceConnector);
        }
        catch (ServiceException serviceException) {
            if (serviceException.getErrorCode() == 404) {
                return null;
            }
            throw serviceException;
        }
        return this.readActivities(document);
    }

    protected Activity[] readActivities(Document document) throws Exception {
        Element element;
        if (document != null && (element = document.getRootElement()) != null) {
            Activity[] activityArray = null;
            if (element.getName().equals("entry")) {
                activityArray = new Activity[]{Activity.readActivity(element)};
            } else {
                List list = element.getChildren("entry", atomNs);
                if (list != null && list.size() > 0) {
                    activityArray = new Activity[list.size()];
                    for (int i = 0; i < activityArray.length; ++i) {
                        activityArray[i] = Activity.readActivity((Element)list.get(i));
                    }
                }
            }
            return activityArray;
        }
        return new Activity[0];
    }

    protected Activity doGetActivity(String string) throws Exception {
        Document document;
        block2: {
            document = null;
            try {
                document = this.callService(string, this.serviceConnector);
            }
            catch (ServiceException serviceException) {
                if (serviceException.getErrorCode() != 404) break block2;
                return null;
            }
        }
        return this.readActivity(document);
    }

    protected Activity readActivity(Document document) throws Exception {
        Element element;
        if (document != null && (element = document.getRootElement()) != null) {
            return Activity.readActivity(element);
        }
        return null;
    }

    protected ActivityEntry[] readActivityEntries(Document document) throws Exception {
        Element element;
        if (document != null && (element = document.getRootElement()) != null) {
            ActivityEntry[] activityEntryArray = null;
            if (element.getName().equals("entry")) {
                if (this.isActivityEntryElement(element)) {
                    activityEntryArray = new ActivityEntry[]{ActivityEntry.readActivityEntry(element)};
                }
            } else {
                ArrayList<ActivityEntry> arrayList = new ArrayList<ActivityEntry>();
                List list = element.getChildren("entry", atomNs);
                if (list != null && list.size() > 0) {
                    for (int i = 0; i < list.size(); ++i) {
                        Element element2 = (Element)list.get(i);
                        if (!this.isActivityEntryElement(element2)) continue;
                        arrayList.add(ActivityEntry.readActivityEntry(element2));
                    }
                    activityEntryArray = new ActivityEntry[arrayList.size()];
                    activityEntryArray = arrayList.toArray(activityEntryArray);
                }
            }
            return activityEntryArray;
        }
        return new ActivityEntry[0];
    }

    protected boolean isActivityEntryElement(Element element) {
        List list = element.getChildren("category", atomNs);
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Element element2 = (Element)list.get(i);
                if (!TString.equals((String)element2.getAttributeValue("scheme"), (String)"http://www.ibm.com/xmlns/prod/sn/type") || !TString.equals((String)element2.getAttributeValue("term"), (String)"entry")) continue;
                return true;
            }
        }
        return false;
    }

    protected SearchResult doSearchActivities(String string) throws Exception {
        return this.doSearch(string, 0);
    }

    protected SearchResult doSearch(String string, int n) throws Exception {
        Element element;
        Document document = null;
        try {
            document = this.callService(string, this.serviceConnector);
        }
        catch (ServiceException serviceException) {
            if (serviceException.getErrorCode() == 404) {
                return null;
            }
            throw serviceException;
        }
        if (document != null && (element = document.getRootElement()) != null) {
            SearchResult searchResult = new SearchResult();
            List list = element.getChildren("link", atomNs);
            if (list != null && list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    Element element2 = (Element)list.get(i);
                    String string2 = element2.getAttributeValue("rel");
                    if ("first".equals(string2)) {
                        searchResult.firstUrl = element2.getAttributeValue("href");
                        continue;
                    }
                    if ("last".equals(string2)) {
                        searchResult.lastUrl = element2.getAttributeValue("href");
                        continue;
                    }
                    if ("previous".equals(string2)) {
                        searchResult.previousUrl = element2.getAttributeValue("href");
                        continue;
                    }
                    if (!"next".equals(string2)) continue;
                    searchResult.nextUrl = element2.getAttributeValue("href");
                }
            }
            try {
                searchResult.totalResult = Integer.parseInt(ActivityConnection.getChildText(element, "totalResults", openSearchNs));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                searchResult.startIndex = Integer.parseInt(ActivityConnection.getChildText(element, "startIndex", openSearchNs));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                searchResult.itemsPerPage = Integer.parseInt(ActivityConnection.getChildText(element, "itemsPerPage", openSearchNs));
            }
            catch (NumberFormatException numberFormatException) {
                searchResult.itemsPerPage = 0;
            }
            if (searchResult.totalResult < searchResult.startIndex * searchResult.itemsPerPage) {
                searchResult.nextUrl = null;
            }
            List list2 = element.getChildren("entry", atomNs);
            if (n == 0) {
                if (list2 != null && list2.size() > 0) {
                    searchResult.entries = new Activity[list2.size()];
                    for (int i = 0; i < searchResult.entries.length; ++i) {
                        searchResult.entries[i] = Activity.readActivity((Element)list2.get(i));
                    }
                } else {
                    searchResult.entries = new Activity[0];
                }
            } else if (n == 1) {
                if (list2 != null && list2.size() > 0) {
                    searchResult.entries = new ActivityTemplate[list2.size()];
                    for (int i = 0; i < searchResult.entries.length; ++i) {
                        searchResult.entries[i] = ActivityTemplate.readActivityTemplate((Element)list2.get(i));
                    }
                } else {
                    searchResult.entries = new ActivityTemplate[0];
                }
            }
            return searchResult;
        }
        return null;
    }

    protected void appendCustomDateField(StringBuffer stringBuffer, String string, Date date) {
        stringBuffer.append(" <snx:field name=\"").append(string).append("\" type=\"date\">").append(JDOMUtil.toString((Date)date)).append("</snx:field>\n");
    }

    protected String getActivitiesServiceUrl() {
        return this.serviceConnector.getBaseUrl() + "activities/service/atom2/activities";
    }

    protected String getActivitiesServiceDocumentUrl() {
        return this.serviceConnector.getBaseUrl() + "activities/service/atom2/service";
    }

    protected String getAllActivitiesUrl() {
        return this.serviceConnector.getBaseUrl() + "activities/service/atom2/everything";
    }

    protected String getActivitiesServiceOverviewUrl() throws Exception {
        block7: {
            if (this.activitiesOverviewUrl == null) {
                try {
                    List list;
                    Element element;
                    String[][] stringArray = new String[1][2];
                    stringArray[0][0] = "Accept-Language";
                    stringArray[0][1] = "en";
                    Document document = this.callService(this.getActivitiesServiceDocumentUrl(), this.serviceConnector, null, stringArray);
                    if (document == null || (element = document.getRootElement()) == null || (list = element.getChildren()) == null) break block7;
                    for (int i = 0; i < list.size(); ++i) {
                        List list2 = ((Element)list.get(i)).getChildren();
                        if (list2 == null) continue;
                        for (int j = 0; j < list2.size(); ++j) {
                            Element element2 = (Element)list2.get(j);
                            Element element3 = element2.getChild("title", atomNs);
                            if (element3 == null || !TString.equals((String)element3.getText(), (String)"Overview")) continue;
                            this.activitiesOverviewUrl = element2.getAttributeValue("href");
                            break;
                        }
                        if (this.activitiesOverviewUrl == null) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    TDiag.exception((Throwable)exception, (String)"Error: Cannot get Activities Service Document");
                }
            }
        }
        if (this.activitiesOverviewUrl == null) {
            TDiag.println((String)"Error: Overview Activities Url not found in Activities Service Document so construct default one");
            this.activitiesOverviewUrl = this.serviceConnector.getBaseUrl() + "activities/service/atom/activities";
        }
        return this.activitiesOverviewUrl;
    }
}

