/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.auth;

import com.flowbuilder.Application;
import com.flowbuilder.util.TDiag;
import com.flowbuilder.util.TString;
import com.flowbuilder.util.io.FileEncoder;
import com.flowbuilder.util.io.vfs.VFS;
import com.flowbuilder.util.io.vfs.VFSFile;
import com.triloggroup.auth.OAuthData;
import com.triloggroup.lotus.ClientServiceConnector;
import com.triloggroup.lotus.UService;
import com.triloggroup.util.UProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpSession;

public class OAuthManager {
    private static final String PROJEXEC_PROP_PATH = "WEB-INF/projexec.properties";
    private static final String OAUTH_SRV_URL = "oauth.server.url";
    private static final String OAUTH_SRV_REALM = "oauth.server.realm";
    private static final String OAUTH_SRV_REQUEST_TOKEN_URL = "oauth.server.requestToken.url";
    private static final String OAUTH_SRV_AUTHORIZATION_URL = "oauth.server.authorization.url";
    private static final String OAUTH_SRV_ACCESS_TOKEN_URL = "oauth.server.accessToken.url";
    private static final String OAUTH_SIGNATURE_METHOD = "oauth.signature.method";
    private static final String OAUTH_VERSION = "oauth.version";
    private static final String OAUHT_CONSUMER_KEY = "oauth.consumer.key";
    private static final String OAUHT_CONSUMER_SECRET = "oauth.consumer.secret";
    public static final String OAUTHDATA_ATTR_NAME = "TG_OAuthData";
    private static OAuthManager singleton;
    private String srvUrl;
    private String srvRealm;
    private String requestTokenUrl;
    private String authorizationUrl;
    private String accessTokenUrl;
    private String consumerKey;
    private String consumerSecret;
    private String signatureMethod;
    private String version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized OAuthManager get() {
        if (singleton != null) return singleton;
        Class<OAuthManager> clazz = OAuthManager.class;
        synchronized (OAuthManager.class) {
            singleton = new OAuthManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    protected OAuthManager() {
        this.initializeOAuthProperties();
    }

    protected void initializeOAuthProperties() {
        block10: {
            try {
                if (Application.get().isInitialized()) {
                    FileEncoder fileEncoder;
                    VFS vFS = Application.get().getVFS();
                    VFSFile vFSFile = vFS.getFile(PROJEXEC_PROP_PATH);
                    if (!vFSFile.exists()) break block10;
                    UProperties uProperties = new UProperties(true);
                    uProperties.load(vFSFile.getSystemFile(), true);
                    this.srvUrl = uProperties.getProperty(OAUTH_SRV_URL);
                    this.srvRealm = uProperties.getProperty(OAUTH_SRV_REALM, "");
                    this.requestTokenUrl = uProperties.getProperty(OAUTH_SRV_REQUEST_TOKEN_URL);
                    this.authorizationUrl = uProperties.getProperty(OAUTH_SRV_AUTHORIZATION_URL);
                    this.accessTokenUrl = uProperties.getProperty(OAUTH_SRV_ACCESS_TOKEN_URL);
                    this.consumerKey = uProperties.getProperty(OAUHT_CONSUMER_KEY);
                    this.consumerSecret = uProperties.getProperty(OAUHT_CONSUMER_SECRET);
                    this.signatureMethod = uProperties.getProperty(OAUTH_SIGNATURE_METHOD);
                    this.version = uProperties.getProperty(OAUTH_VERSION, "1.0");
                    if (TString.isEmpty((String)this.consumerKey) || TString.isEmpty((String)this.consumerSecret) || !(fileEncoder = new FileEncoder()).isResourcesEncryptRequired()) break block10;
                    boolean bl = false;
                    boolean bl2 = false;
                    if (this.consumerKey.startsWith("FB_Encoded")) {
                        this.consumerKey = fileEncoder.decrypt(this.consumerKey.substring("FB_Encoded".length()));
                    } else {
                        bl = true;
                    }
                    if (this.consumerSecret.startsWith("FB_Encoded")) {
                        this.consumerSecret = fileEncoder.decrypt(this.consumerSecret.substring("FB_Encoded".length()));
                    } else {
                        bl2 = true;
                    }
                    try {
                        if (bl || bl2) {
                            String string = "FB_Encoded" + fileEncoder.encrypt(this.consumerKey);
                            uProperties.setPropertyInExtensionIfExistOtherwiseInBase(OAUHT_CONSUMER_KEY, string);
                            String string2 = "FB_Encoded" + fileEncoder.encrypt(this.consumerSecret);
                            uProperties.setPropertyInExtensionIfExistOtherwiseInBase(OAUHT_CONSUMER_SECRET, string2);
                            File file = UProperties.getPropertiesExtensionFile((File)vFSFile.getSystemFile());
                            uProperties.save(vFSFile.getSystemFile(), file);
                        }
                        break block10;
                    }
                    catch (Exception exception) {
                        TDiag.exception((Throwable)exception, (String)"Error to encode OAuth consumer properties in WEB-INF/projexec.properties");
                    }
                    break block10;
                }
                TDiag.println((String)"Application VFS is not initialized - could not read properties file WEB-INF/projexec.properties");
            }
            catch (Exception exception) {
                TDiag.exception((Throwable)exception, (String)"Error to initialize OAuth properties");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadProperties() {
        OAuthManager oAuthManager = this;
        synchronized (oAuthManager) {
            this.initializeOAuthProperties();
        }
    }

    public OAuthData getRequestToken(String string) throws Exception {
        String[] stringArray;
        OAuthData oAuthData = new OAuthData();
        String string2 = this.srvUrl + this.requestTokenUrl;
        StringBuffer stringBuffer = new StringBuffer("oauth_consumer_key=" + URLEncoder.encode(this.consumerKey, "UTF-8"));
        stringBuffer.append("&oauth_nonce=" + URLEncoder.encode(oAuthData.oauthNonce, "UTF-8"));
        stringBuffer.append("&oauth_signature_method=" + URLEncoder.encode(this.signatureMethod, "UTF-8"));
        stringBuffer.append("&oauth_signature=" + URLEncoder.encode(this.consumerSecret + "&", "UTF-8"));
        stringBuffer.append("&oauth_timestamp=" + URLEncoder.encode(oAuthData.oauthTimestamp, "UTF-8"));
        stringBuffer.append("&oauth_callback=" + URLEncoder.encode(string, "UTF-8"));
        stringBuffer.append("&oauth_version=" + URLEncoder.encode(this.version, "UTF-8"));
        ClientServiceConnector clientServiceConnector = new ClientServiceConnector(string2, null, null);
        UService uService = new UService();
        String string3 = uService.callUrl(string2, clientServiceConnector, stringBuffer.toString(), "application/x-www-form-urlencoded", true);
        if (!TString.isEmpty((String)string3) && (stringArray = TString.splitString((String)string3, (char)'&', (boolean)true)) != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = TString.splitString((String)stringArray[i], (char)'=', (boolean)true);
                if (stringArray2 == null || stringArray2.length != 2) continue;
                if ("oauth_token".equals(stringArray2[0])) {
                    oAuthData.token = stringArray2[1];
                    continue;
                }
                if (!"oauth_token_secret".equals(stringArray2[0])) continue;
                oAuthData.secret = stringArray2[1];
            }
        }
        return oAuthData;
    }

    public String getAuthorizationUrl(OAuthData oAuthData) {
        StringBuffer stringBuffer = new StringBuffer(this.srvUrl);
        stringBuffer.append(this.authorizationUrl);
        stringBuffer.append("?oauth_token=").append(oAuthData.token);
        return stringBuffer.toString();
    }

    public OAuthData getAccessToken(OAuthData oAuthData, String string) throws Exception {
        this.extractAuthorizationCallbackParams(oAuthData, string);
        String string2 = this.srvUrl + this.accessTokenUrl;
        StringBuffer stringBuffer = new StringBuffer("oauth_consumer_key=" + URLEncoder.encode(this.consumerKey, "UTF-8"));
        stringBuffer.append("&oauth_nonce=" + URLEncoder.encode(oAuthData.oauthNonce, "UTF-8"));
        stringBuffer.append("&oauth_timestamp=" + URLEncoder.encode(oAuthData.oauthTimestamp, "UTF-8"));
        stringBuffer.append("&oauth_signature_method=" + URLEncoder.encode(this.signatureMethod, "UTF-8"));
        stringBuffer.append("&oauth_signature=" + URLEncoder.encode(this.consumerSecret + "&" + oAuthData.secret, "UTF-8"));
        stringBuffer.append("&oauth_token=" + URLEncoder.encode(oAuthData.token, "UTF-8"));
        if (!TString.isEmpty((String)oAuthData.verifier)) {
            stringBuffer.append("&oauth_verifier=" + URLEncoder.encode(oAuthData.verifier, "UTF-8"));
        }
        stringBuffer.append("&oauth_version=" + URLEncoder.encode(this.version, "UTF-8"));
        ClientServiceConnector clientServiceConnector = new ClientServiceConnector(string2, null, null);
        UService uService = new UService();
        String string3 = uService.callUrl(string2, clientServiceConnector, stringBuffer.toString(), "application/x-www-form-urlencoded", true);
        String[] stringArray = TString.splitString((String)string3, (char)'&', (boolean)true);
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = TString.splitString((String)stringArray[i], (char)'=', (boolean)true);
            if (stringArray2 == null || stringArray2.length != 2) continue;
            if ("oauth_token".equals(stringArray2[0])) {
                oAuthData.token = stringArray2[1];
                continue;
            }
            if (!"oauth_token_secret".equals(stringArray2[0])) continue;
            oAuthData.secret = stringArray2[1];
        }
        return oAuthData;
    }

    private void extractAuthorizationCallbackParams(OAuthData oAuthData, String string) {
        if (string != null) {
            if (string.startsWith("?")) {
                string = string.substring(1);
            }
            String[] stringArray = TString.splitString((String)string, (char)'&', (boolean)true);
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = TString.splitString((String)stringArray[i], (char)'=', (boolean)true);
                if (stringArray2 == null || stringArray2.length != 2 || !"oauth_verifier".equals(stringArray2[0])) continue;
                oAuthData.verifier = stringArray2[1];
            }
        }
    }

    public void storeOAuthDataInSession(HttpSession httpSession, OAuthData oAuthData) {
        httpSession.setAttribute(OAUTHDATA_ATTR_NAME, (Object)oAuthData);
    }

    public OAuthData getOAuthDataFromSession(HttpSession httpSession) {
        return (OAuthData)httpSession.getAttribute(OAUTHDATA_ATTR_NAME);
    }

    public void resetOAuthDataInSession(HttpSession httpSession) {
        httpSession.removeAttribute(OAUTHDATA_ATTR_NAME);
    }

    public boolean isOAuthAuthorized(HttpSession httpSession) {
        OAuthData oAuthData = (OAuthData)httpSession.getAttribute(OAUTHDATA_ATTR_NAME);
        return oAuthData != null && oAuthData.isValid();
    }

    public String getOAuthHeaderString(OAuthData oAuthData) {
        try {
            StringBuffer stringBuffer = new StringBuffer("OAuth realm=\"\", ");
            stringBuffer.append("oauth_consumer_key=\"").append(URLEncoder.encode(this.consumerKey, "UTF-8")).append("\", ");
            stringBuffer.append("oauth_nonce=\"").append(URLEncoder.encode(oAuthData.oauthNonce, "UTF-8")).append("\", ");
            stringBuffer.append("oauth_signature_method=\"").append(URLEncoder.encode(this.signatureMethod, "UTF-8")).append("\", ");
            stringBuffer.append("oauth_signature=\"").append(URLEncoder.encode(this.consumerSecret + "&" + oAuthData.secret, "UTF-8")).append("\", ");
            stringBuffer.append("oauth_timestamp=\"").append(URLEncoder.encode(oAuthData.oauthTimestamp, "UTF-8")).append("\", ");
            stringBuffer.append("oauth_token=\"").append(URLEncoder.encode(oAuthData.token, "UTF-8")).append("\", ");
            stringBuffer.append("oauth_version=\"").append(URLEncoder.encode(this.version, "UTF-8") + "\"");
            return stringBuffer.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public static void main(String[] stringArray) {
        String string = "https://apps.na.collabservtest.lotus.com";
        try {
            OAuthManager.get().srvUrl = string;
            OAuthManager.get().requestTokenUrl = "/manage/oauth/getRequestToken";
            OAuthManager.get().authorizationUrl = "/manage/oauth/authorizeToken";
            OAuthManager.get().accessTokenUrl = "/manage/oauth/getAccessToken";
            OAuthManager.get().signatureMethod = "PLAINTEXT";
            OAuthManager.get().version = "1.0";
            OAuthData oAuthData = new OAuthData();
            OAuthData oAuthData2 = OAuthManager.get().getRequestToken("http://www.google.com");
            System.out.println("request Token: " + oAuthData.token + "  -  secret: " + oAuthData.secret);
            System.out.println("Authorization URL: " + OAuthManager.get().getAuthorizationUrl(oAuthData2));
            System.out.println("Enter Authorization Callback Params:");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            String string2 = bufferedReader.readLine().trim();
            oAuthData = OAuthManager.get().getAccessToken(oAuthData2, string2);
            oAuthData.dump();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

