/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.util;

public class UStringParser {
    private StringProvider provider;
    private int count;
    private int pointer;

    public UStringParser() {
    }

    public UStringParser(String string) {
        this.setString(string);
    }

    public void setString(String string) {
        this.provider = new StringProvider(string);
        this.count = this.provider.length();
        this.pointer = 0;
    }

    public boolean isEOF() {
        return this.pointer >= this.count;
    }

    public int getCurrentPosition() {
        return this.pointer;
    }

    public void setCurrentPosition(int n) {
        this.pointer = n;
    }

    public int getChar() {
        if (this.pointer < this.count) {
            return this.provider.charAt(this.pointer);
        }
        return -1;
    }

    public int nextChar() {
        if (this.pointer < this.count) {
            return this.provider.charAt(this.pointer++);
        }
        return -1;
    }

    public int getChar(int n) {
        if (this.pointer + n < this.count) {
            return this.provider.charAt(this.pointer + n);
        }
        return -1;
    }

    public int getAvailable() {
        return this.count - this.pointer;
    }

    public boolean startsWith(char c) {
        if (this.pointer + 1 <= this.count) {
            return this.provider.charAt(this.pointer) == c;
        }
        return false;
    }

    public boolean match(char c) {
        if (this.startsWith(c)) {
            ++this.pointer;
            return true;
        }
        return false;
    }

    public boolean startsWith(String string) {
        int n = string.length();
        if (this.pointer + n <= this.count) {
            for (int i = 0; i < n; ++i) {
                if (this.provider.charAt(this.pointer + i) == string.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean startsWithIgnoreCase(String string) {
        int n = string.length();
        if (this.pointer + n <= this.count) {
            for (int i = 0; i < n; ++i) {
                if (Character.toUpperCase(this.provider.charAt(this.pointer + i)) == Character.toUpperCase(string.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean match(String string) {
        if (this.startsWith(string)) {
            this.pointer += string.length();
            return true;
        }
        return false;
    }

    public boolean matchIgnoreCase(String string) {
        if (this.startsWithIgnoreCase(string)) {
            this.pointer += string.length();
            return true;
        }
        return false;
    }

    public boolean startsWithKeyWord(String string) {
        int n = string.length();
        if (this.pointer + n <= this.count) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                if (this.provider.charAt(this.pointer + n2) == string.charAt(n2)) continue;
                return false;
            }
            if (this.pointer + n < this.count) {
                n2 = this.provider.charAt(this.pointer + n);
                if (!Character.isJavaIdentifierPart((char)n2)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public boolean matchKeyWord(String string) {
        if (this.startsWithKeyWord(string)) {
            this.pointer += string.length();
            return true;
        }
        return false;
    }

    public String upto(char c) {
        int n = this.pointer;
        while (this.pointer < this.count && this.provider.charAt(this.pointer) != c) {
            ++this.pointer;
        }
        return this.provider.getString(n, this.pointer);
    }

    public String uptoEnd() {
        int n = this.pointer;
        this.pointer = this.count;
        return this.provider.getString(n, this.pointer);
    }

    public void skip() {
        if (this.pointer + 1 <= this.count) {
            ++this.pointer;
        }
    }

    public void skip(int n) {
        if (this.pointer + n <= this.count) {
            this.pointer += n;
        }
    }

    public void skipUpto(char c) {
        while (this.pointer < this.count && this.provider.charAt(this.pointer) != c) {
            ++this.pointer;
        }
    }

    public void skipUpto(String string) {
        int n = string.length();
        if (n > 0) {
            int n2 = this.count - n - 1;
            char c = string.charAt(0);
            while (this.pointer < n2) {
                block5: {
                    if (this.provider.charAt(this.pointer) == c) {
                        for (int i = 1; i < n; ++i) {
                            if (this.provider.charAt(this.pointer + i) == string.charAt(i)) {
                                continue;
                            }
                            break block5;
                        }
                        return;
                    }
                }
                ++this.pointer;
            }
        }
    }

    public void skipSpaces() {
        char c;
        while (this.pointer < this.count && ((c = this.provider.charAt(this.pointer)) == ' ' || c == '\t' || c == '\n' || c == '\r')) {
            ++this.pointer;
        }
    }

    public boolean matchJavaIdentifier() {
        if (this.pointer + 1 <= this.count && Character.isJavaIdentifierStart(this.provider.charAt(this.pointer))) {
            ++this.pointer;
            while (this.pointer + 1 <= this.count && Character.isJavaIdentifierPart(this.provider.charAt(this.pointer))) {
                ++this.pointer;
            }
            return true;
        }
        return false;
    }

    public int getNextInteger() {
        char c;
        int n = this.pointer;
        boolean bl = false;
        if (n < this.count && this.provider.charAt(n) == '-') {
            bl = true;
            ++n;
        }
        int n2 = 0;
        while (n < this.count && Character.isDigit(c = this.provider.charAt(n))) {
            n2 = n2 * 10 + (c - 48);
            ++n;
        }
        if (n > this.pointer + (bl ? 1 : 0)) {
            this.pointer = n;
            return bl ? -n2 : n2;
        }
        return Integer.MIN_VALUE;
    }

    private static class StringProvider {
        private String str;

        public StringProvider() {
        }

        public StringProvider(String string) {
            this.setString(string);
        }

        public void setString(String string) {
            this.str = string;
        }

        public int length() {
            return this.str.length();
        }

        public char charAt(int n) {
            return this.str.charAt(n);
        }

        public String getString(int n, int n2) {
            return this.str.substring(n, n2);
        }

        public char[] getChars(int n, int n2, char[] cArray, int n3) {
            this.str.getChars(n, n2, cArray, n3);
            return cArray;
        }
    }
}

