/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.util;

import com.triloggroup.util.NLSFileLoader;
import com.triloggroup.util.UString;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NLSBundle {
    protected static Logger log = Logger.getLogger("util.nlsbundle");
    protected static final String DEFAULT_LANGUAGE = "en";
    public static boolean FORCE_LOAD_DEFAULT_LANG = false;
    private static URL baseUrl = null;
    private static HashSet<String> ignoreBaseUrlForLocales;
    private static HashSet<String> ignoreLocales;
    protected HashMap<String, String> map;
    protected NLSBundle linkedBundle;
    protected NLSBundle defaultLangBundle;

    protected NLSBundle() {
        this.map = new HashMap();
    }

    protected NLSBundle(HashMap<String, String> hashMap) {
        this.map = hashMap;
    }

    protected NLSBundle(String string, String string2, ClassLoader classLoader, Locale locale, NLSBundle nLSBundle) {
        try {
            this.map = new HashMap();
            this.loadNlsFile(string, string2, classLoader, locale);
            NLSBundle nLSBundle2 = this.getLastBundleOfChain();
            nLSBundle2.linkedBundle = nLSBundle;
            if (FORCE_LOAD_DEFAULT_LANG && locale != null && !UString.equals(locale.getLanguage(), DEFAULT_LANGUAGE)) {
                this.defaultLangBundle = new NLSBundle(string, string2, classLoader, new Locale(DEFAULT_LANGUAGE), null);
            }
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "NLS File '" + string + "' not loaded");
        }
    }

    public static NLSBundle getBundle(String string) {
        return new NLSBundle(string, null, null, Locale.getDefault(), null);
    }

    public static NLSBundle getBundle(String string, NLSBundle nLSBundle) {
        return new NLSBundle(string, null, null, Locale.getDefault(), nLSBundle);
    }

    public static NLSBundle getBundle(String string, Locale locale) {
        return new NLSBundle(string, null, null, locale, null);
    }

    public static NLSBundle getBundle(String string, Locale locale, NLSBundle nLSBundle) {
        return new NLSBundle(string, null, null, locale, nLSBundle);
    }

    public static NLSBundle getBundle(String string, String string2) {
        return new NLSBundle(string, string2, null, Locale.getDefault(), null);
    }

    public static NLSBundle getBundle(String string, String string2, NLSBundle nLSBundle) {
        return new NLSBundle(string, string2, null, Locale.getDefault(), nLSBundle);
    }

    public static NLSBundle getBundle(String string, String string2, Locale locale) {
        return new NLSBundle(string, string2, null, locale, null);
    }

    public static NLSBundle getBundle(String string, String string2, Locale locale, NLSBundle nLSBundle) {
        return new NLSBundle(string, string2, null, locale, nLSBundle);
    }

    public static NLSBundle getBundle(String string, ClassLoader classLoader) {
        return new NLSBundle(string, null, classLoader, Locale.getDefault(), null);
    }

    public static NLSBundle getBundle(String string, ClassLoader classLoader, NLSBundle nLSBundle) {
        return new NLSBundle(string, null, classLoader, Locale.getDefault(), nLSBundle);
    }

    public static NLSBundle getBundle(String string, ClassLoader classLoader, Locale locale) {
        return new NLSBundle(string, null, classLoader, locale, null);
    }

    public static NLSBundle getBundle(String string, ClassLoader classLoader, Locale locale, NLSBundle nLSBundle) {
        return new NLSBundle(string, null, classLoader, locale, nLSBundle);
    }

    protected NLSBundle getLastBundleOfChain() {
        if (this.linkedBundle != null) {
            return this.linkedBundle.getLastBundleOfChain();
        }
        return this;
    }

    public String getString(String string) {
        return this.getString(string, null);
    }

    public String getString(String string, Object ... objectArray) {
        try {
            String string2 = this.map.get(string);
            if (string2 == null) {
                if (this.linkedBundle != null && (string2 = this.linkedBundle.getString(string)) == string) {
                    string2 = null;
                }
                if (string2 == null) {
                    string2 = this.defaultLangBundle != null ? this.defaultLangBundle.getString(string) : string;
                }
            }
            if (objectArray != null && objectArray.length > 0 && string2 != string) {
                return MessageFormat.format(string2, objectArray);
            }
            return string2;
        }
        catch (Exception exception) {
            log.log(Level.INFO, "key '" + string + "' not found in NLS resource bundle");
            return string;
        }
    }

    protected void loadNlsFile(String string, String string2, ClassLoader classLoader, Locale locale) {
        Object object;
        if (UString.isEmpty(string)) {
            throw new IllegalArgumentException("Base Name of NLS file is empty");
        }
        String string3 = string;
        String string4 = locale.toString();
        string3 = UString.equals(DEFAULT_LANGUAGE, string4) ? string3 + ".nls" : string3 + "_" + string4 + ".nls";
        InputStream inputStream = null;
        if (UString.isEmpty(string2)) {
            object = classLoader == null ? this.getClass().getClassLoader() : classLoader;
            inputStream = this.getResourceAsStream((ClassLoader)object, string3, string4);
            if (inputStream == null) {
                if (!UString.isEmpty(locale.getCountry())) {
                    this.loadNlsFile(string, string2, classLoader, new Locale(locale.getLanguage()));
                    return;
                }
                if (!UString.equals(DEFAULT_LANGUAGE, string4)) {
                    log.log(Level.INFO, "NLS file '" + string3 + "' not found. Try to load default one");
                }
                inputStream = this.getResourceAsStream((ClassLoader)object, string + ".nls", "");
            }
            if (inputStream == null) {
                throw new IllegalArgumentException("No NLS file available for base name " + string);
            }
        } else {
            object = new File(string2, string3);
            if (((File)object).exists() && ((File)object).isFile()) {
                try {
                    inputStream = new FileInputStream((File)object);
                }
                catch (Exception exception) {}
            } else {
                if (!UString.isEmpty(locale.getCountry())) {
                    this.loadNlsFile(string, string2, classLoader, new Locale(locale.getLanguage()));
                    return;
                }
                if (!UString.equals(DEFAULT_LANGUAGE, string4)) {
                    log.log(Level.INFO, "NLS file '" + string3 + "' not found in directory " + string2 + ". Try to load default one");
                }
                if (((File)(object = new File(string2, string + ".nls"))).exists() && ((File)object).isFile()) {
                    try {
                        inputStream = new FileInputStream((File)object);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (inputStream == null) {
                throw new IllegalArgumentException("No NLS file available for base name " + string + " in directory " + string2);
            }
        }
        try {
            this.loadNls(inputStream, string2, classLoader, locale);
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Cannot load NLS file '" + string + "' ", exception);
        }
    }

    protected InputStream getResourceAsStream(ClassLoader classLoader, String string, String string2) {
        if (ignoreLocales != null && ignoreLocales.contains(string2)) {
            return null;
        }
        if (!(baseUrl == null || ignoreBaseUrlForLocales != null && ignoreBaseUrlForLocales.contains(string2))) {
            try {
                URL uRL = new URL(baseUrl, string);
                InputStream inputStream = this.getUrlStream(uRL);
                return inputStream;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return classLoader.getResourceAsStream(string);
    }

    protected InputStream getUrlStream(URL uRL) throws Exception {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setInstanceFollowRedirects(false);
        int n = httpURLConnection.getResponseCode();
        if (n >= 200 && n < 299) {
            return httpURLConnection.getInputStream();
        }
        return null;
    }

    protected void loadNls(InputStream inputStream) throws Exception {
        this.loadNls(inputStream, null, null, null);
    }

    protected void loadNls(InputStream inputStream, String string, ClassLoader classLoader, Locale locale) throws Exception {
        String string2 = NLSFileLoader.load(inputStream, this.map);
        if (string2 != null && this.linkedBundle == null) {
            this.linkedBundle = new NLSBundle(string2, string, classLoader, locale, null);
        }
    }

    public static URL getBaseUrl() {
        return baseUrl;
    }

    public static void setBaseUrl(URL uRL) {
        baseUrl = uRL;
    }

    public static void addIgnoreBaseUrlForLocale(String string) {
        NLSBundle.addIgnoreBaseUrlForLocales(string);
    }

    public static void addIgnoreBaseUrlForLocales(String ... stringArray) {
        if (ignoreBaseUrlForLocales == null) {
            ignoreBaseUrlForLocales = new HashSet();
        }
        for (String string : stringArray) {
            ignoreBaseUrlForLocales.add(string);
        }
    }

    public static void addIgnoreLocales(String ... stringArray) {
        if (ignoreLocales == null) {
            ignoreLocales = new HashSet();
        }
        for (String string : stringArray) {
            ignoreLocales.add(string);
        }
    }
}

