/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.util;

import com.triloggroup.util.Message;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Messages {
    private List<Message> messages = new ArrayList<Message>();

    public boolean hasErrorMessage() {
        return this.hasMessageOfLevel(3);
    }

    public boolean hasWarningMessage() {
        return this.hasMessageOfLevel(2);
    }

    public boolean hasWarningOrErrorMessage() {
        for (Message message : this.messages) {
            if (!message.isError() && !message.isWarning()) continue;
            return true;
        }
        return false;
    }

    public boolean hasInfoMessage() {
        return this.hasMessageOfLevel(1);
    }

    public boolean hasDebugMessage() {
        return this.hasMessageOfLevel(0);
    }

    private boolean hasMessageOfLevel(int n) {
        for (Message message : this.messages) {
            if (message.level != n) continue;
            return true;
        }
        return false;
    }

    public boolean hasMessage() {
        return !this.messages.isEmpty();
    }

    public List<Message> getAllMessages() {
        return this.messages;
    }

    public List<Message> getErrorMessages() {
        return this.getMessagesOfLevel(3);
    }

    public List<Message> getWarningMessages() {
        return this.getMessagesOfLevel(2);
    }

    public List<Message> getWarningAndErrorMessages() {
        ArrayList<Message> arrayList = new ArrayList<Message>();
        for (Message message : this.messages) {
            if (!message.isError() && !message.isWarning()) continue;
            arrayList.add(message);
        }
        return arrayList;
    }

    public List<Message> getInfoMessages() {
        return this.getMessagesOfLevel(1);
    }

    public List<Message> getDebugMessages() {
        return this.getMessagesOfLevel(0);
    }

    public List<Message> getMessagesOfLevel(int n) {
        ArrayList<Message> arrayList = new ArrayList<Message>();
        for (Message message : this.messages) {
            if (message.level != n) continue;
            arrayList.add(message);
        }
        return arrayList;
    }

    public void addMessage(Message message) {
        this.messages.add(message);
    }

    public void addErrorMessage(String string, Throwable throwable) {
        Message message = Message.newError(string);
        message.cause = throwable;
        this.addMessage(message);
    }

    public void addErrorMessage(String string) {
        this.addMessage(Message.newError(string));
    }

    public void addWarningMessage(String string, Throwable throwable) {
        Message message = Message.newWarning(string);
        message.cause = throwable;
        this.addMessage(message);
    }

    public void addWarningMessage(String string) {
        this.addMessage(Message.newWarning(string));
    }

    public void addInfoMessage(String string) {
        this.addMessage(Message.newInfo(string));
    }

    public void addDebugMessage(String string) {
        this.addMessage(Message.newDebug(string));
    }

    public String printAllMessages() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Message message : this.messages) {
            message.toString(stringBuffer);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String printAllMessages(boolean bl) {
        if (!bl) {
            return this.printAllMessages();
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        for (Message message : this.messages) {
            message.toVerboseString(printWriter);
            printWriter.println();
        }
        return stringWriter.toString();
    }
}

