/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ErrorDialog
extends JDialog {
    private static final int DEFAULT_HEIGHT = 120;
    private static final int DEFAULT_HEIGHT_DETAILS = 300;
    private static final int MIN_WIDTH = 250;
    private static final int MAX_WIDTH = 780;
    private boolean details = false;
    private final Throwable error;
    private JComponent detailsComponent;
    private JComponent mainComponent;

    public static void showError(final Component component, final Throwable throwable) {
        Runnable runnable = new Runnable(){

            public void run() {
                Window window;
                Object object;
                Component component2 = component;
                if (component == null) {
                    object = JFrame.getFrames();
                    window = ((Frame[])object).length > 0 ? object[((Frame[])object).length - 1] : null;
                } else if (component instanceof Frame || component instanceof Dialog) {
                    window = (Window)component;
                } else {
                    window = SwingUtilities.windowForComponent(component);
                    component2 = ErrorDialog.adjustParentComponent(component);
                }
                object = window instanceof Dialog ? new ErrorDialog((Dialog)window, throwable) : new ErrorDialog((Frame)window, throwable);
                ((Window)object).setLocationRelativeTo(component2);
                ((Dialog)object).show();
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public ErrorDialog(Dialog dialog, Throwable throwable) {
        super(dialog, "Error", true);
        this.error = throwable;
        this.init();
    }

    public ErrorDialog(Frame frame, Throwable throwable) {
        super(frame, "Error", true);
        this.error = throwable;
        this.init();
    }

    private void init() {
        String string = this.error.getMessage() == null || this.error.getMessage().trim().length() == 0 ? "Error" : this.error.getMessage();
        JLabel jLabel = new JLabel(string, UIManager.getIcon("OptionPane.errorIcon"), 2);
        jLabel.setIconTextGap(20);
        int n = jLabel.getPreferredSize().width + 30;
        if (n < 250) {
            n = 250;
        } else if (n > 780) {
            n = 780;
        }
        Dimension dimension = new Dimension(n, 120);
        this.setSize(dimension);
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.add((Component)jLabel, "Center");
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ErrorDialog.this.setVisible(false);
                ErrorDialog.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(jButton);
        InputMap inputMap = jButton.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(27, 0, false), "pressed");
        inputMap.put(KeyStroke.getKeyStroke(27, 0, true), "released");
        final JButton jButton2 = new JButton("Details >>");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ErrorDialog.this.details) {
                    Dimension dimension = ErrorDialog.this.getSize();
                    dimension.height = 120;
                    ErrorDialog.this.setSize(dimension);
                    jButton2.setText("Details >>");
                    ErrorDialog.this.mainComponent.remove(ErrorDialog.this.detailsComponent);
                } else {
                    jButton2.setText("Details <<");
                    Dimension dimension = ErrorDialog.this.getSize();
                    dimension.height = 300;
                    ErrorDialog.this.setSize(dimension);
                    ErrorDialog.this.mainComponent.add((Component)ErrorDialog.this.getDetailsComponent(), "Center");
                }
                ErrorDialog.this.details = !ErrorDialog.this.details;
                ErrorDialog.this.validate();
                ErrorDialog.this.repaint();
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel.add((Component)jPanel2, "South");
        this.mainComponent = new JPanel(new BorderLayout());
        this.mainComponent.add((Component)jPanel, "North");
        this.getContentPane().add(this.mainComponent);
    }

    private JComponent getDetailsComponent() {
        if (this.detailsComponent == null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            this.error.printStackTrace(printWriter);
            printWriter.flush();
            printWriter.close();
            JTextArea jTextArea = new JTextArea();
            jTextArea.setEditable(false);
            jTextArea.setText(stringWriter.toString());
            JScrollPane jScrollPane = new JScrollPane(jTextArea, 20, 30);
            jTextArea.select(0, 0);
            this.detailsComponent = jScrollPane;
        }
        return this.detailsComponent;
    }

    protected static Component adjustParentComponent(Component component) {
        if (component == null) {
            return null;
        }
        Container container = component.getParent();
        if (container instanceof JViewport) {
            return container;
        }
        while (container != null) {
            if (container instanceof JViewport) {
                Point point = SwingUtilities.convertPoint(component, component.getWidth() / 2, component.getHeight() / 2, container);
                Dimension dimension = container.getSize();
                if (point.x <= dimension.width && point.y <= dimension.height && point.x >= 0 && point.y >= 0) break;
                return container;
            }
            container = container.getParent();
        }
        return component;
    }
}

