/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.ui;

import com.triloggroup.ui.NumberTextField;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public class DoubleTextField
extends NumberTextField {
    private NumberFormat format2;

    public DoubleTextField() {
        this((Locale)null);
    }

    public DoubleTextField(Locale locale) {
        DecimalFormat decimalFormat;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.format = NumberFormat.getNumberInstance(locale);
        if (this.format instanceof DecimalFormat && (decimalFormat = (DecimalFormat)this.format).getDecimalFormatSymbols().getDecimalSeparator() != '.') {
            this.format2 = NumberFormat.getNumberInstance(Locale.ENGLISH);
        }
        this.init(this.format);
    }

    public DoubleTextField(DecimalFormat decimalFormat) {
        this.init(decimalFormat);
    }

    public Double getValue() {
        return (Double)this.getNumberValue();
    }

    public void setValue(Double d) {
        this.setNumberValue(d);
    }

    public double getDoubleValue() {
        return this.getDoubleValue(0.0);
    }

    public double getDoubleValue(double d) {
        Double d2 = this.getValue();
        return d2 == null ? d : d2;
    }

    public void setValue(double d) {
        this.setValue(new Double(d));
    }

    protected String format(Number number) {
        if (number == null) {
            return "";
        }
        return this.format.format(number.doubleValue());
    }

    protected NumberTextField.ParseResult parse(String string) {
        NumberTextField.ParseResult parseResult = new NumberTextField.ParseResult(this);
        Double d = this.getValue();
        if (d != null && string.equals(this.format(d))) {
            parseResult.valid = true;
            parseResult.value = d;
            return parseResult;
        }
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = this.format.parse(string, parsePosition);
        if (parsePosition.getIndex() != string.length()) {
            boolean bl = false;
            if (this.format2 != null) {
                parsePosition = new ParsePosition(0);
                number = this.format2.parse(string, parsePosition);
                if (parsePosition.getIndex() == string.length()) {
                    bl = true;
                }
            }
            if (!bl) {
                return parseResult;
            }
        }
        parseResult.value = number == null || number instanceof Double ? (Number)number : (Number)new Double(number.doubleValue());
        parseResult.valid = true;
        return parseResult;
    }
}

