/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.schedule;

import com.flowbuilder.util.TString;
import com.flowbuilder.util.xml.JDOMUtil;
import com.triloggroup.util.date.TGTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduleCalendar {
    protected String id;
    protected String baseCalendarId;
    protected String name;
    protected boolean isBaseCalendar;
    protected boolean isMerged = false;
    protected Weekday[] weekdays = new Weekday[7];
    protected ArrayList<ExceptionWeekday> exceptionWeekdays = new ArrayList();

    public ScheduleCalendar(Document document) throws Exception {
        if (document != null) {
            this.init(document.getRootElement());
        }
    }

    public ScheduleCalendar(Element element) throws Exception {
        this.init(element);
    }

    protected void init(Element element) throws Exception {
        if (element != null) {
            this.id = element.getChildText("id");
            this.baseCalendarId = element.getChildText("basecalendarid");
            this.name = element.getChildText("name");
            this.isBaseCalendar = JDOMUtil.getBoolean(element, "isbasecalendar");
            Element element2 = element.getChild("weekdays");
            if (element2 != null) {
                List list = element2.getChildren("weekday");
                for (int i = 0; i < list.size(); ++i) {
                    Weekday weekday;
                    Element element3 = (Element)list.get(i);
                    int n = JDOMUtil.getInteger(element3, "daytype");
                    if (n == 0) {
                        weekday = new ExceptionWeekday(element3);
                        this.exceptionWeekdays.add((ExceptionWeekday)weekday);
                        continue;
                    }
                    weekday = new Weekday(element3);
                    this.weekdays[n - 1] = weekday;
                }
            }
        }
    }

    public String getCalendarId() {
        return this.id;
    }

    public String getBaseCalendarId() {
        return this.baseCalendarId;
    }

    public String getName() {
        return this.name;
    }

    public boolean isBaseCalendar() {
        return this.isBaseCalendar;
    }

    public WorkingTime[] getWorkingHours(Date date) {
        Weekday weekday;
        int n;
        for (n = 0; n < this.exceptionWeekdays.size(); ++n) {
            weekday = this.exceptionWeekdays.get(n);
            if (date.compareTo(weekday.period.fromDate) < 0 || date.compareTo(weekday.period.toDate) > 0) continue;
            if (weekday.isDayWorking) {
                return weekday.workingTimes;
            }
            return null;
        }
        n = date.getDay();
        weekday = this.weekdays[n];
        if (weekday != null && weekday.isDayWorking) {
            return weekday.workingTimes;
        }
        return null;
    }

    public TGTime getFirstWorkingTime(Date date) {
        WorkingTime[] workingTimeArray = this.getWorkingHours(date);
        if (workingTimeArray != null && workingTimeArray.length > 0) {
            return workingTimeArray[0].fromTime;
        }
        return null;
    }

    public TGTime getLastWorkingTime(Date date) {
        WorkingTime[] workingTimeArray = this.getWorkingHours(date);
        if (workingTimeArray != null && workingTimeArray.length > 0) {
            return workingTimeArray[workingTimeArray.length - 1].toTime;
        }
        return null;
    }

    public boolean isWorkingDay(Date date) {
        return this.getWorkingHours(date) != null;
    }

    public Weekday getWeekdayByDayType(int n) {
        return this.weekdays[n - 1];
    }

    public Weekday getWeekdayAt(int n) {
        return this.weekdays[n];
    }

    public ArrayList<ExceptionWeekday> getExceptionWeekDays() {
        return this.exceptionWeekdays;
    }

    public void mergeWithBaseCalendar(ScheduleCalendar scheduleCalendar) {
        if (this.isMerged) {
            throw new IllegalStateException("This calendar is already merged with its base calendar");
        }
        if (scheduleCalendar != null) {
            if (!TString.equals(scheduleCalendar.getCalendarId(), this.getBaseCalendarId())) {
                throw new IllegalStateException("Invalid base calendar");
            }
            this.mergeWithCalendar(scheduleCalendar);
        }
        this.isMerged = true;
    }

    public boolean isMergedWithBaseCalendar() {
        return this.isMerged;
    }

    protected void mergeWithCalendar(ScheduleCalendar scheduleCalendar) {
        Weekday weekday;
        if (scheduleCalendar == null) {
            return;
        }
        for (int i = 0; i < 7; ++i) {
            Weekday weekday2 = this.weekdays[i];
            if (weekday2 != null || (weekday = scheduleCalendar.getWeekdayAt(i)) == null) continue;
            this.weekdays[i] = weekday.clone();
        }
        ArrayList<ExceptionWeekday> arrayList = scheduleCalendar.getExceptionWeekDays();
        for (int i = 0; i < arrayList.size(); ++i) {
            weekday = arrayList.get(i);
            this.exceptionWeekdays.add((ExceptionWeekday)weekday.clone());
        }
    }

    public static class ExceptionWeekday
    extends Weekday {
        public Period period;

        public ExceptionWeekday(Element element) throws Exception {
            super(element);
            this.setTimePeriod(element.getChild("timeperiod"));
        }

        protected void setTimePeriod(Element element) throws Exception {
            if (element != null) {
                Date date = JDOMUtil.getDateValue(element.getChild("fromdate"));
                Date date2 = JDOMUtil.getDateValue(element.getChild("todate"));
                this.period = new Period(date, date2);
            }
        }
    }

    public static class Period
    implements Cloneable {
        public Date fromDate;
        public Date toDate;

        public Period(Date date, Date date2) {
            this.fromDate = date;
            this.toDate = date2;
        }
    }

    public static class Weekday
    implements Cloneable {
        public WorkingTime[] workingTimes = new WorkingTime[0];
        public boolean isDayWorking;
        public int dayType;

        public Weekday(Element element) throws Exception {
            this.dayType = JDOMUtil.getInteger(element, "daytype");
            this.isDayWorking = JDOMUtil.getBoolean(element, "dayworking");
            this.setWorkingTime(element.getChild("workingtimes"));
        }

        protected void setWorkingTime(Element element) {
            ArrayList<WorkingTime> arrayList = new ArrayList<WorkingTime>();
            if (element != null) {
                List list = element.getChildren("workingtime");
                for (int i = 0; i < list.size(); ++i) {
                    Element element2 = (Element)list.get(i);
                    String string = element2.getChildText("fromtime");
                    String string2 = element2.getChildText("totime");
                    if (TString.isEmpty(string) || TString.isEmpty(string2)) continue;
                    arrayList.add(new WorkingTime(string, string2));
                }
            }
            this.workingTimes = new WorkingTime[arrayList.size()];
            this.workingTimes = arrayList.toArray(this.workingTimes);
        }

        public Weekday clone() {
            Weekday weekday = null;
            try {
                weekday = (Weekday)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return weekday;
        }
    }

    public static class WorkingTime
    implements Cloneable {
        public TGTime fromTime;
        public TGTime toTime;

        public WorkingTime(TGTime tGTime, TGTime tGTime2) {
            this.fromTime = tGTime;
            this.toTime = tGTime2;
        }

        public WorkingTime(String string, String string2) {
            this.fromTime = this.convertToTime(string, false);
            this.toTime = this.convertToTime(string2, true);
        }

        protected TGTime convertToTime(String string, boolean bl) {
            if (bl && TString.equals(string, "00:00:00")) {
                string = "24:00:00";
            }
            String[] stringArray = TString.splitString(string, ':');
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            return new TGTime(n, n2);
        }
    }
}

