/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.financial;

import com.flowbuilder.util.xml.JDOMUtil;
import com.flowbuilder.util.xml.XMLException;
import com.triloggroup.util.UString;
import java.util.Currency;
import java.util.Locale;
import org.jdom.Element;

public class FinancialSettings {
    public static final String CURRENCY_SYMBOL_PLACEMENT_BEFORE = "before";
    public static final String CURRENCY_SYMBOL_PLACEMENT_AFTER = "after";
    private static final String FRACTION_DIGIT_ELT_NAME = "fractionDigit";
    protected String siteId;
    protected String projectId;
    protected String currencySymbol;
    protected String currencySymbolPlacement = "after";
    protected int currencyFractionDigit = 2;
    protected String currencyISOCode;
    protected double warningThreshold = 0.1;
    protected double criticalThreshold = 0.15;
    protected double budget = 0.0;

    public FinancialSettings(String string) {
        this(string, null);
    }

    public FinancialSettings(String string, String string2) {
        this.siteId = string;
        this.projectId = string2;
    }

    public void initDefaultCurrencyForLocale(Locale locale) {
        Currency currency = Currency.getInstance(locale);
        this.setCurrencySymbol(currency.getSymbol(locale));
        this.setCurrencyFractionDigit(currency.getDefaultFractionDigits());
        this.setCurrencyISOCode(currency.getCurrencyCode());
    }

    public void setCurrencySymbol(String string) {
        if (!UString.isEmpty(string)) {
            this.currencySymbol = string;
        }
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbolPlacement(String string) {
        if (!UString.isEmpty(string)) {
            this.currencySymbolPlacement = string;
        }
    }

    public String getCurrencySymbolPlacement() {
        return this.currencySymbolPlacement;
    }

    public void setCurrencyFractionDigit(int n) {
        if (n >= 0) {
            this.currencyFractionDigit = n;
        }
    }

    public int getCurrencyFractionDigit() {
        return this.currencyFractionDigit;
    }

    public void setCurrencyISOCode(String string) {
        if (!UString.isEmpty(string)) {
            this.currencyISOCode = string;
        }
    }

    public String getCurrencyISOCode() {
        return this.currencyISOCode;
    }

    public void setWarningThreshold(double d) {
        this.warningThreshold = d;
    }

    public double getWarningThreshold() {
        return this.warningThreshold;
    }

    public void setCriticalThreshold(double d) {
        this.criticalThreshold = d;
    }

    public double getCriticalThreshold() {
        return this.criticalThreshold;
    }

    public void setBudget(double d) {
        this.budget = d;
    }

    public double getBudget() {
        return this.budget;
    }

    public void initFromFinancialNode(Element element) throws XMLException {
        if (element != null && UString.equals(element.getName(), "financial")) {
            String string;
            String string2;
            Element element2 = element.getChild("currency");
            if (element2 != null) {
                string2 = JDOMUtil.getString(element2, "symbol");
                if (!UString.isEmpty(string2)) {
                    this.setCurrencySymbol(string2);
                }
                if (!UString.isEmpty(string2 = JDOMUtil.getString(element2, "symbolPlacement"))) {
                    this.setCurrencySymbolPlacement(string2);
                }
                if (!UString.isEmpty(string2 = JDOMUtil.getString(element2, "isoCode"))) {
                    this.setCurrencyISOCode(string2);
                }
                try {
                    string2 = JDOMUtil.getString(element2, FRACTION_DIGIT_ELT_NAME);
                    if (!UString.isEmpty(string2)) {
                        this.setCurrencyFractionDigit(JDOMUtil.getInteger(element2, FRACTION_DIGIT_ELT_NAME));
                    }
                }
                catch (Exception exception) {
                    System.out.println("Unable to read currency fraction digits");
                    exception.printStackTrace();
                }
            }
            if ((string2 = element.getChild("thresholds")) != null) {
                string = JDOMUtil.getString((Element)string2, "warning");
                if (!UString.isEmpty(string)) {
                    this.setWarningThreshold(Double.parseDouble(string));
                }
                if (!UString.isEmpty(string = JDOMUtil.getString((Element)string2, "critical"))) {
                    this.setCriticalThreshold(Double.parseDouble(string));
                }
            }
            if ((string = element.getChild("budget")) != null) {
                this.setBudget(JDOMUtil.getDouble((Element)string, "value"));
            }
        }
    }

    public void setFinancialNode(Element element) throws XMLException {
        if (element == null || !UString.equals(element.getName(), "financial")) {
            throw new XMLException(null, "Invalid Financial element");
        }
        Element element2 = element.getChild("currency");
        if (element2 == null) {
            element2 = new Element("currency");
            element.addContent(element2);
        }
        JDOMUtil.setString(element2, "symbol", this.getCurrencySymbol());
        JDOMUtil.setString(element2, "symbolPlacement", this.getCurrencySymbolPlacement());
        JDOMUtil.setString(element2, "isoCode", this.getCurrencyISOCode());
        JDOMUtil.setInteger(element2, FRACTION_DIGIT_ELT_NAME, this.getCurrencyFractionDigit());
        Element element3 = element.getChild("thresholds");
        if (element3 == null) {
            element3 = new Element("thresholds");
            element.addContent(element3);
        }
        JDOMUtil.setDouble(element3, "warning", this.getWarningThreshold());
        JDOMUtil.setDouble(element3, "critical", this.getCriticalThreshold());
        if (!UString.isEmpty(this.projectId)) {
            Element element4 = element.getChild("budget");
            if (element4 == null) {
                element4 = new Element("budget");
                element.addContent(element4);
            }
            JDOMUtil.setDouble(element4, "value", this.getBudget());
        }
    }
}

