/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.ui.table;

import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.project.components.ui.table.ComboEditor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public abstract class ComboEditorWithEditLink
extends ComboEditor {
    protected CreationDialog creationDialog;

    public ComboEditorWithEditLink(Object[] objectArray, String string) {
        super((JComboBox)new InternalComboBox(objectArray));
        ((InternalComboBox)this.editorComponent).setMainEditor(this);
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)((JComboBox)this.editorComponent).getModel();
        defaultComboBoxModel.addElement(new EditLink(string));
        ((JComboBox)this.editorComponent).setRenderer(new ComboBoxRendererWithLink());
    }

    protected void showCreationPanel() {
        if (this.creationDialog == null) {
            this.creationDialog = CreationDialog.createDialog(this);
            this.creationDialog.getContentPane().add(this.getEditionPanel());
        }
        if (this.creationDialog.isVisible()) {
            return;
        }
        this.creationDialog.setLocationRelativeTo(this.getComponent());
        Dimension dimension = this.getComponent().getSize();
        Point point = this.getComponent().getLocationOnScreen();
        this.creationDialog.setLocation(point.x, (int)((double)point.y + dimension.getHeight()));
        this.creationDialog.ensureFullyVisible();
        this.creationDialog.setVisible(true);
    }

    protected void cancelEditionPanel() {
        this.creationDialog.setVisible(false);
        this.editorComponent.requestFocus();
        ((JComboBox)this.editorComponent).showPopup();
    }

    protected void setNewCreatedValue(Object object) {
        this.creationDialog.setVisible(false);
        if (object != null) {
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)((JComboBox)this.editorComponent).getModel();
            defaultComboBoxModel.insertElementAt(object, 0);
            defaultComboBoxModel.setSelectedItem(object);
            ((InternalComboBox)this.editorComponent).hidePopup();
            this.stopCellEditing();
        }
    }

    protected abstract JComponent getEditionPanel();

    protected static class ComboBoxModel
    extends DefaultComboBoxModel {
        protected ComboEditorWithEditLink editor;

        public ComboBoxModel() {
        }

        public ComboBoxModel(Object[] objectArray) {
            super(objectArray);
        }

        protected void setMainEditor(ComboEditorWithEditLink comboEditorWithEditLink) {
            this.editor = comboEditorWithEditLink;
        }

        public Object[] getValues(Object[] objectArray) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object e = this.getElementAt(i);
                if (e instanceof EditLink) continue;
                objectArray[i] = this.getElementAt(i);
            }
            return objectArray;
        }

        public void setSelectedItem(Object object) {
            if (object instanceof EditLink) {
                this.editor.showCreationPanel();
                return;
            }
            super.setSelectedItem(object);
        }
    }

    protected static class ComboBoxRendererWithLink
    extends BasicComboBoxRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            this.setHorizontalAlignment(2);
            return this;
        }
    }

    protected static class CreationDialog
    extends WDDialog
    implements WindowFocusListener {
        protected ComboEditorWithEditLink editorWithLink;

        public CreationDialog(Window window, GraphicsConfiguration graphicsConfiguration) {
            super(window, graphicsConfiguration);
            this.init();
        }

        protected void init() {
            this.setDragHeader(false);
            this.setHighlightBorder(false);
            this.setDefaultCloseOperation(2);
            this.setMaximizable(false);
            this.setModal(false);
        }

        public void setVisible(boolean bl) {
            super.setVisible(bl);
            if (bl) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        CreationDialog.this.getFocusTraversalPolicy().getDefaultComponent(CreationDialog.this.getContentPane()).requestFocus();
                        CreationDialog.this.addWindowFocusListener(CreationDialog.this);
                    }
                });
            } else {
                this.removeWindowFocusListener(this);
            }
        }

        public void windowGainedFocus(WindowEvent windowEvent) {
        }

        public void windowLostFocus(WindowEvent windowEvent) {
            this.setVisible(false);
        }

        public static CreationDialog createDialog(ComboEditorWithEditLink comboEditorWithEditLink) {
            GraphicsConfiguration graphicsConfiguration = WDUtil.getGraphicsConfiguration(comboEditorWithEditLink.getComponent());
            Window window = SwingUtilities.getWindowAncestor(comboEditorWithEditLink.getComponent());
            return new CreationDialog(window, graphicsConfiguration);
        }
    }

    protected static class EditLink {
        protected String link;

        EditLink(String string) {
            this.link = "<html><a href='javascript:void(0);' >" + string + "</a></html>";
        }

        public String toString() {
            return this.link;
        }
    }

    protected static class InternalComboBox
    extends ComboEditor.InternalComboBox {
        protected ComboEditorWithEditLink editor;

        public InternalComboBox(Object[] objectArray) {
            this.setModel(new ComboBoxModel(objectArray));
        }

        protected void setMainEditor(ComboEditorWithEditLink comboEditorWithEditLink) {
            this.editor = comboEditorWithEditLink;
            ((ComboBoxModel)this.getModel()).setMainEditor(comboEditorWithEditLink);
        }

        public void setSelectedItem(Object object) {
            if (object instanceof EditLink) {
                this.editor.showCreationPanel();
                return;
            }
            super.setSelectedItem(object);
        }
    }
}

