/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.ui.table;

import com.triloggroup.project.components.ui.table.TextCellEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class CellEditorWithLabel
extends TextCellEditor
implements FocusListener {
    private static Border EMPTY_BORDER = BorderFactory.createEmptyBorder();
    protected JComponent label;
    protected JPanel panel;

    public CellEditorWithLabel(String string) {
        this(string, true);
    }

    public CellEditorWithLabel(String string, boolean bl) {
        this(new JLabel(string), bl);
    }

    public CellEditorWithLabel(JComponent jComponent, boolean bl) {
        super(new TextField());
        this.label = jComponent;
        jComponent.setFont(UIManager.getFont("Table.font"));
        this.panel = new JPanel(new BorderLayout()){

            protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
                return ((TextField)CellEditorWithLabel.this.getTextComponent()).processKeyBinding(keyStroke, keyEvent, n, bl);
            }
        };
        this.panel.add((Component)this.getTextComponent(), "Center");
        this.panel.add((Component)jComponent, bl ? "East" : "West");
        this.panel.addFocusListener(this);
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        this.getTextComponent().setBorder(EMPTY_BORDER);
        this.panel.setBorder(DEFAULT_BORDER);
        return this.panel;
    }

    protected void setLabelText(String string) {
        ((JLabel)this.label).setText(string);
    }

    public void focusGained(FocusEvent focusEvent) {
        this.getTextComponent().requestFocus();
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public static class TextField
    extends JTextField {
        public boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            return super.processKeyBinding(keyStroke, keyEvent, n, bl);
        }
    }
}

