/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.ui.table;

import com.triloggroup.project.components.ui.table.TextCellEditor;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CellEditorWithDialog<T>
extends AbstractCellEditor
implements TableCellEditor {
    protected JLabel lb = new JLabel();
    private int clickCountToStart = 1;
    protected T currentValue;

    protected CellEditorWithDialog() {
        this.lb.setFocusable(true);
        this.lb.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                CellEditorWithDialog.this.showDialog();
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.lb.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                CellEditorWithDialog.this.showDialog();
            }
        });
        this.lb.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                CellEditorWithDialog.this.showDialog();
            }
        });
    }

    public void setClickCountToStart(int n) {
        this.clickCountToStart = n;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    protected abstract void showDialog();

    @Override
    public Object getCellEditorValue() {
        return this.currentValue;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() == this.clickCountToStart;
        }
        if (eventObject instanceof KeyEvent) {
            return TextCellEditor.isKeyEventTriggerEdit((KeyEvent)eventObject);
        }
        return true;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.currentValue = object;
        return this.lb;
    }
}

