/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.ui;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NetworkImageIcon
extends ImageIcon
implements Runnable,
ImageObserver {
    private final URL url;
    private final String cookies;
    private final boolean resize;
    private ChangeListener changeLsnr;

    public NetworkImageIcon(URL uRL, Image image, boolean bl, String string) {
        super(image);
        this.url = uRL;
        this.resize = bl;
        this.cookies = string;
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            int n;
            BufferedImage bufferedImage;
            InputStream inputStream = this.openConnectionCheckRedirects(this.url.openConnection());
            try {
                bufferedImage = ImageIO.read(inputStream);
            }
            finally {
                inputStream.close();
            }
            int n2 = ((Image)bufferedImage).getWidth(this);
            if (n2 > 0 && (n = ((Image)bufferedImage).getHeight(this)) > 0) {
                this.imageUpdate(bufferedImage, 32, 0, 0, n2, n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private InputStream openConnectionCheckRedirects(URLConnection uRLConnection) throws IOException {
        boolean bl;
        int n = 0;
        InputStream inputStream = null;
        do {
            HttpURLConnection httpURLConnection;
            int n2;
            if (uRLConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)uRLConnection).setInstanceFollowRedirects(false);
            }
            if (this.cookies != null) {
                uRLConnection.setRequestProperty("Cookie", this.cookies);
            }
            inputStream = uRLConnection.getInputStream();
            bl = false;
            if (!(uRLConnection instanceof HttpURLConnection) || (n2 = (httpURLConnection = (HttpURLConnection)uRLConnection).getResponseCode()) < 300 || n2 > 307 || n2 == 306 || n2 == 304) continue;
            URL uRL = httpURLConnection.getURL();
            String string = httpURLConnection.getHeaderField("Location");
            URL uRL2 = null;
            if (string != null) {
                uRL2 = new URL(uRL, string);
            }
            httpURLConnection.disconnect();
            if (uRL2 == null || !uRL2.getProtocol().equals("http") && !uRL2.getProtocol().equals("https") || n >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            bl = true;
            uRLConnection = uRL2.openConnection();
            ++n;
        } while (bl);
        return inputStream;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x20) == 32) {
            if (this.resize && (this.getIconWidth() != n4 || this.getIconHeight() != n5)) {
                image = image.getScaledInstance(this.getIconWidth(), this.getIconHeight(), 4);
            }
            this.setNewImage(image);
            return false;
        }
        return (n & 0xC0) == 0;
    }

    private void setNewImage(final Image image) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NetworkImageIcon.this.setImage(image);
                if (NetworkImageIcon.this.changeLsnr != null) {
                    NetworkImageIcon.this.changeLsnr.stateChanged(new ChangeEvent(this));
                    NetworkImageIcon.this.changeLsnr = null;
                }
            }
        });
    }

    public void setChangeListener(ChangeListener changeListener) {
        this.changeLsnr = changeListener;
    }
}

