/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.resourceeditor.table;

import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.app.GanttKeyStrokes;
import com.triloggroup.gantt.app.GanttWorkbenchPage;
import com.triloggroup.gantt.app.applet.GanttAppletBase;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.project.components.IProjectResourceModel;
import com.triloggroup.project.components.allocations.ResourceAllocationsDialog;
import com.triloggroup.project.components.resourceeditor.NewRoleDialog;
import com.triloggroup.project.components.resourceeditor.NewTeamDialog;
import com.triloggroup.project.components.resourceeditor.ProjectResource;
import com.triloggroup.project.components.resourceeditor.ResourceView;
import com.triloggroup.project.components.resourceeditor.XSPResourceActions;
import com.triloggroup.project.components.resourceeditor.table.EmailEditor;
import com.triloggroup.project.components.resourceeditor.table.EmailRenderer;
import com.triloggroup.project.components.resourceeditor.table.NameEditor;
import com.triloggroup.project.components.resourceeditor.table.NameRenderer;
import com.triloggroup.project.components.resourceeditor.table.ResourceTableModel;
import com.triloggroup.project.components.resourceeditor.table.ResourceTableTransferHandler;
import com.triloggroup.project.components.resourceeditor.table.RoleEditor;
import com.triloggroup.project.components.resourceeditor.table.TeamEditor;
import com.triloggroup.project.components.resourceeditor.table.costrate.CostRatesEditor;
import com.triloggroup.project.components.resourceeditor.table.costrate.CostRatesRenderer;
import com.triloggroup.project.components.schedulecalendar.ScheduleCalendarEditor;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.project.components.ui.table.DateTableCellRenderer;
import com.triloggroup.project.components.ui.table.TGTable;
import com.triloggroup.project.components.ui.table.TGTableCellRenderer;
import com.triloggroup.project.components.ui.table.TGTableCellRendererWithEditIcon;
import com.triloggroup.project.components.ui.table.TGTableHeaderRenderer;
import com.triloggroup.project.financial.FinancialSettings;
import com.triloggroup.project.schedule.ScheduleCalendar;
import com.triloggroup.util.UString;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.HashSet;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ResourceTable
extends TGTable {
    protected NameRenderer nameRenderer;
    protected CostRatesRenderer costsRenderer;
    protected EmailRenderer emailRenderer;
    protected TGTableCellRendererWithEditIcon rendererWithEditIcon;
    protected TableCellRenderer dateRenderer;
    private Boolean cellHasFocusBeforeMouseClick = null;

    public ResourceTable(ResourceView resourceView, ResourceTableModel resourceTableModel) {
        super(resourceTableModel);
        this.setView(resourceView);
        this.initUI();
        if (resourceTableModel.view.getProjectModel().isScheduleEditable()) {
            this.setDragEnabled(true);
            this.setTransferHandler(new ResourceTableTransferHandler());
        } else {
            this.setDragEnabled(false);
            this.setTransferHandler(null);
        }
    }

    public ResourceTableModel getModel() {
        return (ResourceTableModel)super.getModel();
    }

    public ResourceView getView() {
        return (ResourceView)this.view;
    }

    private void initUI() {
        this.setSelectionMode(2);
        this.getTableHeader().setDefaultRenderer(new TGTableHeaderRenderer(false));
        this.setDefaultRenderer(Object.class, new TGTableCellRenderer());
        this.initRenderersAndEditors();
    }

    protected void initRenderersAndEditors() {
        IProjectResourceModel iProjectResourceModel = this.getView().getProjectModel();
        this.nameRenderer = new NameRenderer();
        Locale locale = Workbench.get().getFormatLocale();
        if (iProjectResourceModel.isFinancialModuleAvailable()) {
            FinancialSettings financialSettings = iProjectResourceModel.getFinancialSettings();
            this.costsRenderer = new CostRatesRenderer(locale, financialSettings);
        }
        this.emailRenderer = new EmailRenderer();
        this.rendererWithEditIcon = new TGTableCellRendererWithEditIcon();
        this.dateRenderer = new DateTableCellRenderer(locale, Workbench.get().getTimeZone());
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        String string = this.getModel().getColumnKeyName(this.convertColumnIndexToModel(n2));
        if (string == "Name") {
            return this.nameRenderer;
        }
        if (string == "CostRate") {
            this.costsRenderer.setFinancialEditable(this.getView().getProjectModel().isFinancialEditable());
            return this.costsRenderer;
        }
        if (string == "Email") {
            return this.emailRenderer;
        }
        if (string == "Role" || string == "Team") {
            return this.rendererWithEditIcon;
        }
        if (string == "InvitationDate") {
            return this.dateRenderer;
        }
        return this.getDefaultRenderer(this.getColumnClass(n2));
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        String string = this.getModel().getColumnKeyName(this.convertColumnIndexToModel(n2));
        if (string == "CostRate") {
            CostRatesEditor costRatesEditor = new CostRatesEditor(this);
            costRatesEditor.setEditable(this.getView().getProjectModel().isFinancialEditable());
            return costRatesEditor;
        }
        if (string == "Team") {
            return new TeamEditor(this.getView());
        }
        if (string == "Role") {
            return new RoleEditor(this.getView());
        }
        if (string == "Name") {
            return new NameEditor(this.getView(), this.getModel().getResourceAtRow(n));
        }
        if (string == "Email") {
            return new EmailEditor(this.getView(), this.getModel().getResourceAtRow(n));
        }
        return null;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        IProjectResourceModel iProjectResourceModel;
        if (this.view != null && (iProjectResourceModel = this.getView().getProjectModel()).isFinancialModuleAvailable()) {
            FinancialSettings financialSettings = iProjectResourceModel.getFinancialSettings();
            this.costsRenderer = new CostRatesRenderer(Workbench.get().getFormatLocale(), financialSettings);
        }
        super.tableChanged(tableModelEvent);
    }

    public void categorizeBy(String string) {
        this.cancelCellEditing();
        String[] stringArray = this.getModel().availableColumns;
        this.getModel().setVisibleColumns(stringArray, string, false);
    }

    public String getCategorization() {
        return this.getModel().categorizeBy;
    }

    public ProjectResource[] getSelectedResources() {
        int[] nArray = this.getSelectedRows();
        ProjectResource[] objectArray = new ProjectResource[nArray.length];
        ResourceTableModel resourceTableModel = this.getModel();
        int n = 0;
        for (int n2 : nArray) {
            ProjectResource projectResource = resourceTableModel.getResourceAtRow(n2);
            if (projectResource == null) continue;
            objectArray[n++] = projectResource;
        }
        if (objectArray.length != n) {
            ProjectResource[] projectResourceArray = new ProjectResource[n];
            System.arraycopy(objectArray, 0, projectResourceArray, 0, n);
            objectArray = projectResourceArray;
        }
        return objectArray;
    }

    public void setSelectedResources(ProjectResource ... projectResourceArray) {
        if (projectResourceArray.length > 0) {
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < projectResourceArray.length; ++i) {
                if (projectResourceArray[i] == null) continue;
                hashSet.add(projectResourceArray[i].getDn());
            }
            ResourceTableModel resourceTableModel = this.getModel();
            ListSelectionModel listSelectionModel = this.getSelectionModel();
            for (int i = 0; i < this.getRowCount(); ++i) {
                ProjectResource projectResource = resourceTableModel.getResourceAtRow(i);
                if (projectResource == null || !hashSet.contains(projectResource.getDn())) continue;
                listSelectionModel.addSelectionInterval(i, i);
            }
        }
    }

    public void rebuildTable() {
        ProjectResource[] projectResourceArray = this.getSelectedResources();
        this.getModel().rebuild();
        this.setSelectedResources(projectResourceArray);
    }

    public void rebuildTableKeepOrder() {
        ProjectResource[] projectResourceArray = this.getSelectedResources();
        this.getModel().lightRebuildKeepOrder();
        this.setSelectedResources(projectResourceArray);
    }

    public JPopupMenu getPopupMenuForCurrentSelection(final Point point) {
        JMenuItem jMenuItem;
        Object object;
        final ProjectResource[] projectResourceArray = this.getSelectedResources();
        final ProjectResource projectResource = projectResourceArray.length == 1 ? projectResourceArray[0] : null;
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (this.getModel().isEditable()) {
            JMenuItem jMenuItem2;
            if (projectResourceArray.length > 0 && (object = this.view.getAction(1)) != null) {
                jMenuItem2 = new JMenuItem(Workbench.getNLSString("deleteResource", new Object[0]));
                jMenuItem2.setAccelerator(GanttKeyStrokes.DELETE);
                if (object.isEnabled()) {
                    jMenuItem2.addActionListener((ActionListener)object);
                } else {
                    jMenuItem2.setEnabled(false);
                }
                jPopupMenu.add(jMenuItem2);
            }
            object = new JMenuItem(Workbench.getNLSString("addResource", new Object[0]));
            ((AbstractButton)object).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ResourceTable.this.addResourceInline();
                }
            });
            ((JMenuItem)object).setAccelerator(GanttKeyStrokes.ADD_RESOURCE);
            jPopupMenu.add((JMenuItem)object);
            if (projectResource != null && !projectResource.isRegistered()) {
                jMenuItem2 = new JMenuItem(Workbench.getNLSString("findResource", new Object[0]));
                jMenuItem2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        new XSPResourceActions(ResourceTable.this.getView()).replaceResource(projectResource);
                    }
                });
                jPopupMenu.add(jMenuItem2);
            }
            if (projectResource != null) {
                final boolean bl = projectResource.isEnabled();
                jMenuItem = new JMenuItem(Workbench.getNLSString(bl ? "disable" : "enable", new Object[0]));
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ResourceTable.this.getView().setResourceEnabled(projectResource, !bl);
                        ResourceTable.this.repaint();
                    }
                });
                jPopupMenu.add(jMenuItem);
            }
            if (projectResourceArray.length > 0) {
                JMenuItem jMenuItem3 = new JMenuItem(Workbench.getNLSString("inviteResource", new Object[0]));
                jMenuItem3.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ResourceTable.this.getView().inviteUsers(projectResourceArray);
                    }
                });
                jPopupMenu.add(jMenuItem3);
            }
        }
        if (projectResource != null) {
            object = new JMenuItem(Workbench.getNLSString("calendar", new Object[0]));
            String string = projectResource.getCalendarId();
            if (UString.isEmpty(string)) {
                ((JMenuItem)object).setEnabled(false);
            } else {
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ResourceTable.this.showCalendar(projectResource);
                    }
                });
            }
            jPopupMenu.add((JMenuItem)object);
        }
        if (projectResource != null) {
            object = new JMenuItem(Workbench.getNLSString("showAvailability", new Object[0]));
            ((AbstractButton)object).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ResourceTable.this.showAllocations(projectResource);
                }
            });
            jPopupMenu.add((JMenuItem)object);
        }
        boolean bl = false;
        if (projectResource != null && !UString.isEmpty(projectResource.getProfileUrl())) {
            JMenuItem jMenuItem4 = new JMenuItem(Workbench.getNLSString("showProfile", new Object[0]));
            jMenuItem4.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        GanttAppletBase ganttAppletBase = ((GanttWorkbenchPage)ResourceTable.this.view.getWorkbenchPage()).getApplet();
                        if (ganttAppletBase != null) {
                            URL uRL = new URL(projectResource.getProfileUrl());
                            ganttAppletBase.getAppletContext().showDocument(uRL, "_blank");
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            if (!bl) {
                jPopupMenu.addSeparator();
                bl = true;
            }
            jPopupMenu.add(jMenuItem4);
        }
        if (this.getModel().isEditable()) {
            jPopupMenu.addSeparator();
            JMenuItem jMenuItem5 = new JMenuItem(Workbench.getNLSString("newTeam", new Object[0]));
            jMenuItem5.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ResourceTable.this.view.getWorkbenchPage().stopEditInProgress(true);
                    NewTeamDialog.showDialog(ResourceTable.this.getView(), point);
                }
            });
            jPopupMenu.add(jMenuItem5);
            jMenuItem = new JMenuItem(Workbench.getNLSString("newRole", new Object[0]));
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ResourceTable.this.view.getWorkbenchPage().stopEditInProgress(true);
                    NewRoleDialog.showDialog(ResourceTable.this.getView(), point);
                }
            });
            jPopupMenu.add(jMenuItem);
        }
        if (jPopupMenu.getComponentCount() == 0) {
            return null;
        }
        return jPopupMenu;
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501) {
            int n = this.rowAtPoint(mouseEvent.getPoint());
            int n2 = this.columnAtPoint(mouseEvent.getPoint());
            boolean bl = super.cellHasFocus(n, n2);
            this.cellHasFocusBeforeMouseClick = bl;
        }
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.getID() == 502) {
            this.cellHasFocusBeforeMouseClick = null;
        }
    }

    public boolean cellHasFocus(int n, int n2) {
        if (this.cellHasFocusBeforeMouseClick != null) {
            return this.cellHasFocusBeforeMouseClick;
        }
        return super.cellHasFocus(n, n2);
    }

    protected void showCalendar(Resource resource) {
        String string = resource.getCalendarId();
        if (!UString.isEmpty(string)) {
            ScheduleCalendar scheduleCalendar = this.getView().getProjectModel().getScheduleCalendar(string);
            if (scheduleCalendar == null) {
                System.out.println("Calendar " + string + " not found. Resource: " + resource.getDn());
                WDDialog.showMsgDialog(this, "Calendar not found");
                return;
            }
            WDDialog wDDialog = WDDialog.createWDDialog(this, true, false);
            wDDialog.setMaximizable(false);
            ScheduleCalendarEditor scheduleCalendarEditor = new ScheduleCalendarEditor(Workbench.get().getFormatLocale());
            scheduleCalendarEditor.setScheduleCalendar(scheduleCalendar);
            wDDialog.getContentPane().add(scheduleCalendarEditor.getComponent());
            wDDialog.pack();
            wDDialog.setLocationRelativeTo(this);
            wDDialog.setVisible(true);
        }
    }

    protected void showAllocations(Resource resource) {
        ResourceAllocationsDialog resourceAllocationsDialog = ResourceAllocationsDialog.create(resource, (ResourceView)this.view);
        resourceAllocationsDialog.setVisible(true);
    }

    public void addResourceInline() {
        int n = this.selectionModel.getLeadSelectionIndex();
        if (n < 0) {
            return;
        }
        this.getModel().addResourceInline(n);
        this.requestFocus();
        int n2 = n + 1;
        this.scrollTo(n2);
        int n3 = this.convertColumnIndexToView(0);
        this.getSelectionModel().setSelectionInterval(n2, n2);
        this.getColumnModel().getSelectionModel().setSelectionInterval(n3, n3);
        this.editCellAt(n2, 0);
    }

    public void scrollTo(String string) {
        this.scrollTo(this.getModel().getIndexForResourceDn(string));
    }

    public void scrollTo(int n) {
        if (n < 0) {
            return;
        }
        Rectangle rectangle = this.getCellRect(n, 0, true);
        this.scrollRectToVisible(rectangle);
    }

    public void selectAndScroll(String string) {
        int n = this.getModel().getIndexForResourceDn(string);
        if (n < 0) {
            return;
        }
        this.getSelectionModel().setSelectionInterval(n, n);
        this.scrollTo(n);
    }
}

