/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.resourceeditor.table;

import com.triloggroup.gantt.Debug;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.project.components.resourceeditor.ProjectResource;
import com.triloggroup.project.components.resourceeditor.ResourceView;
import com.triloggroup.project.components.resourceeditor.table.ITableItem;
import com.triloggroup.project.components.resourceeditor.table.ResourceTable;
import com.triloggroup.project.components.resourceeditor.table.SearchedResource;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.project.components.ui.table.AutoCompleteEditor;
import com.triloggroup.util.UString;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class NameEditor
extends AutoCompleteEditor {
    protected ResourceView view;
    protected ProjectResource currentResource;
    protected boolean ignoreNameRendererIcons = false;

    public NameEditor(ResourceView resourceView, ProjectResource projectResource) {
        this.view = resourceView;
        this.currentResource = projectResource;
        this.trimText = true;
        this.setClientSearchEnabled(true);
    }

    protected Object[] search(String string) throws Exception {
        if (Debug.DEBUG) {
            System.out.println("run new server search: " + string);
        }
        String[] stringArray = this.view.getWSHelper().searchResources(string);
        Object[] objectArray = new SearchedResource[stringArray.length];
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            String[] stringArray2 = UString.splitString(stringArray[i], '|');
            String string2 = stringArray2[0];
            String string3 = stringArray2[1];
            String string4 = stringArray2[2];
            boolean bl = "true".equals(stringArray2[3]);
            if (!this.acceptProjectResources() && this.view.getProjectModel().getProjectResource(string3) != null) continue;
            ProjectResource projectResource = this.getResourceByEmail(string4);
            if (projectResource != null) {
                System.out.println("Search resource: Resource found on the project with same email [" + string4 + "], but different dn: " + projectResource.getDn() + " vs " + string3);
                if (!this.acceptProjectResources()) continue;
                string3 = projectResource.getDn();
                string4 = projectResource.getEmail();
                string2 = projectResource.getCn();
                bl = projectResource.isRegistered();
            }
            SearchedResource searchedResource = new SearchedResource(string2, string3, string4);
            searchedResource.registered = bl;
            objectArray[n++] = searchedResource;
        }
        if (n != objectArray.length) {
            SearchedResource[] searchedResourceArray = new SearchedResource[n];
            System.arraycopy(objectArray, 0, searchedResourceArray, 0, n);
            objectArray = searchedResourceArray;
        }
        return objectArray;
    }

    protected Object[] filter(Object[] objectArray, String string, String string2) {
        if (Debug.DEBUG) {
            System.out.println("client-side filter: " + string + "->" + string2);
        }
        ArrayList<SearchedResource> arrayList = new ArrayList<SearchedResource>();
        string2 = string2.toLowerCase();
        for (int i = 0; i < objectArray.length; ++i) {
            String string3;
            SearchedResource searchedResource = (SearchedResource)objectArray[i];
            String string4 = string3 = searchedResource.cn == null ? null : searchedResource.cn.toLowerCase();
            if (!(string3 != null && string3.startsWith(string2) || searchedResource.email != null && searchedResource.email.toLowerCase().startsWith(string2)) && (string3 == null || string3.indexOf(" " + string2) < 0)) continue;
            arrayList.add(searchedResource);
        }
        return arrayList.toArray();
    }

    protected void selectValueForText(String string) {
        if (UString.isEmpty(string)) {
            return;
        }
        String string2 = Workbench.checkInvalidCharacters(string);
        if (string2 != null) {
            WDDialog.showMsgDialog(this.view.getMainTable(), string2);
            return;
        }
        ProjectResource projectResource = this.getResourceByCn(string);
        if (projectResource != null) {
            if (this.acceptProjectResources()) {
                SearchedResource searchedResource = new SearchedResource(projectResource.getCn(), projectResource.getDn(), projectResource.getEmail());
                this.selectValue(searchedResource);
            } else {
                WDDialog.showMsgDialog(this.view.getMainTable(), Workbench.getNLSString("resourceExists_name", new Object[0]));
            }
            return;
        }
        if (this.acceptResourceNotExisting()) {
            SearchedResource searchedResource = new SearchedResource(string, null, null);
            this.selectValue(searchedResource);
        }
    }

    protected boolean acceptUniqueValue(Object object, String string) {
        if (object == null) {
            return false;
        }
        return string.equalsIgnoreCase(((SearchedResource)object).cn);
    }

    protected ProjectResource getResourceByCn(String string) {
        ProjectResource[] projectResourceArray = this.view.getProjectModel().getProjectResources();
        for (int i = 0; i < projectResourceArray.length; ++i) {
            if (!string.equalsIgnoreCase(projectResourceArray[i].getCn())) continue;
            return projectResourceArray[i];
        }
        return null;
    }

    protected ProjectResource getResourceByEmail(String string) {
        if (UString.isEmpty(string)) {
            return null;
        }
        ProjectResource[] projectResourceArray = this.view.getProjectModel().getProjectResources();
        for (int i = 0; i < projectResourceArray.length; ++i) {
            if (!string.equalsIgnoreCase(projectResourceArray[i].getEmail())) continue;
            return projectResourceArray[i];
        }
        return null;
    }

    protected boolean acceptProjectResources() {
        return this.currentResource != null;
    }

    protected boolean acceptResourceNotExisting() {
        return true;
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (this.ignoreNameRendererIcons) {
            return super.isCellEditable(eventObject);
        }
        if (super.isCellEditable(eventObject)) {
            if (eventObject instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                ResourceTable resourceTable = this.view.getMainTable();
                int n = resourceTable.rowAtPoint(mouseEvent.getPoint());
                ITableItem iTableItem = resourceTable.getModel().getItemAtRow(n);
                int n2 = resourceTable.nameRenderer.getXTextOffset(iTableItem);
                if (n2 > mouseEvent.getX()) {
                    n2 = mouseEvent.getX();
                }
                mouseEvent.translatePoint(-n2, 0);
            }
            return true;
        }
        return false;
    }

    protected boolean equivalent(Object object, String string) {
        if (string == null) {
            return object == null;
        }
        if (object instanceof String) {
            return string.equals(object);
        }
        return object instanceof SearchedResource && string.equalsIgnoreCase(((SearchedResource)object).cn);
    }

    protected ListCellRenderer createRenderer() {
        return this.createRenderer(false);
    }

    protected ListCellRenderer createRenderer(final boolean bl) {
        return new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl3, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl3, bl2);
                if (object instanceof SearchedResource) {
                    AutoCompleteEditor.AutoCompleteComboBoxModel autoCompleteComboBoxModel = (AutoCompleteEditor.AutoCompleteComboBoxModel)NameEditor.this.getCombo().getModel();
                    String string = autoCompleteComboBoxModel.getSearchText();
                    SearchedResource searchedResource = (SearchedResource)object;
                    StringBuilder stringBuilder = new StringBuilder();
                    if (UString.isEmpty(string)) {
                        if (bl) {
                            stringBuilder.append(searchedResource.email);
                            stringBuilder.append(" <").append(searchedResource.cn).append('>');
                        } else {
                            stringBuilder.append(searchedResource.cn);
                            if (!UString.isEmpty(searchedResource.email)) {
                                stringBuilder.append(" <").append(searchedResource.email).append('>');
                            }
                        }
                    } else {
                        stringBuilder.append("<html>");
                        if (bl) {
                            this.highlightSubString(stringBuilder, searchedResource.email, string, false);
                        } else {
                            this.highlightSubString(stringBuilder, searchedResource.cn, string, true);
                        }
                        if (bl && !UString.isEmpty(searchedResource.cn) || !bl && !UString.isEmpty(searchedResource.email)) {
                            stringBuilder.append(" &lt;");
                            if (bl) {
                                this.highlightSubString(stringBuilder, searchedResource.cn, string, true);
                            } else {
                                this.highlightSubString(stringBuilder, searchedResource.email, string, false);
                            }
                            stringBuilder.append("&gt;</html>");
                        }
                    }
                    this.setText(stringBuilder.toString());
                }
                return this;
            }

            protected void highlightSubString(StringBuilder stringBuilder, String string, String string2, boolean bl2) {
                int n;
                if (string == null) {
                    return;
                }
                string2 = string2.toLowerCase();
                String string3 = string.toLowerCase();
                if (string3.startsWith(string2)) {
                    stringBuilder.append("<b>");
                    stringBuilder.append(WDUtil.swingHtmlEscape(string.substring(0, string2.length())));
                    stringBuilder.append("</b>");
                    stringBuilder.append(WDUtil.swingHtmlEscape(string.substring(string2.length())));
                    return;
                }
                if (bl2 && (n = string3.indexOf(" " + string2)) >= 0) {
                    int n2 = n + string2.length() + 1;
                    stringBuilder.append(WDUtil.swingHtmlEscape(string.substring(0, n)));
                    stringBuilder.append("<b>");
                    stringBuilder.append(WDUtil.swingHtmlEscape(string.substring(n, n2)));
                    stringBuilder.append("</b>");
                    stringBuilder.append(WDUtil.swingHtmlEscape(string.substring(n2)));
                    return;
                }
                stringBuilder.append(WDUtil.swingHtmlEscape(string));
            }
        };
    }
}

