/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.resourceeditor.change;

import com.triloggroup.gantt.Debug;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.TaskResource;
import com.triloggroup.gantt.app.change.Change;
import com.triloggroup.gantt.app.change.ChangeException;
import com.triloggroup.gantt.app.change.FieldModification;
import com.triloggroup.gantt.app.change.IChangeHandler;
import com.triloggroup.project.components.IProjectResourceModel;
import com.triloggroup.project.components.ObjectType;
import com.triloggroup.project.components.resourceeditor.ProjectResource;
import com.triloggroup.project.components.resourceeditor.ProjectRole;
import com.triloggroup.project.components.resourceeditor.ProjectTeam;
import com.triloggroup.project.components.resourceeditor.ResourceView;
import com.triloggroup.project.components.resourceeditor.change.DeleteResourceChange;
import com.triloggroup.project.components.resourceeditor.change.ReplaceResourceChange;
import com.triloggroup.project.financial.CostRates;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceChangeHandler
implements IChangeHandler {
    private ResourceView view;

    public ResourceChangeHandler(ResourceView resourceView) {
        this.view = resourceView;
    }

    @Override
    public boolean canHandleChange(Change change) {
        ObjectType objectType = change.getTargetType();
        return objectType == ProjectResource.TYPE || objectType == ProjectTeam.TYPE || objectType == ProjectRole.TYPE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void applyChange(Change change, boolean bl, boolean bl2, List<Change> list) throws ChangeException {
        int n = change.getOperation();
        ObjectType objectType = change.getTargetType();
        if (objectType == ProjectResource.TYPE) {
            boolean bl3;
            ProjectResource projectResource = (ProjectResource)change.getTarget();
            if (bl2 && !bl && n != 1) {
                String string = projectResource.getDn();
                projectResource = this.getProjectModel(change).getProjectResource(string);
                if (projectResource == null) {
                    throw new IllegalStateException("Resource does not exist anymore: " + string);
                }
            }
            boolean bl4 = bl3 = Debug.CHECK_UNDO && !bl2;
            if (n == 0) {
                this.applyUpdateChange(change, bl, projectResource, bl3, list);
                return;
            } else if (n == 1) {
                this.applyCreateChange(change, bl, projectResource, bl3, list);
                return;
            } else if (n == 2) {
                this.applyDeleteChange((DeleteResourceChange)change, bl, projectResource, bl3, list);
                return;
            } else {
                if (n != 5) throw new UnsupportedOperationException("Change operation not supported: " + n);
                this.applyReplaceChange((ReplaceResourceChange)change, bl, projectResource, bl3, list);
            }
            return;
        } else if (objectType == ProjectTeam.TYPE) {
            boolean bl5;
            ProjectTeam projectTeam = (ProjectTeam)change.getTarget();
            boolean bl6 = bl5 = Debug.CHECK_UNDO && !bl2;
            if (n != 1) throw new UnsupportedOperationException("Change operation not supported: " + n);
            this.applyTeamCreateChange(change, bl, projectTeam, bl5, list);
            return;
        } else {
            boolean bl7;
            if (objectType != ProjectRole.TYPE) return;
            ProjectRole projectRole = (ProjectRole)change.getTarget();
            boolean bl8 = bl7 = Debug.CHECK_UNDO && !bl2;
            if (n != 1) throw new UnsupportedOperationException("Change operation not supported: " + n);
            this.applyRoleCreateChange(change, bl, projectRole, bl7, list);
        }
    }

    private IProjectResourceModel getProjectModel(Change change) {
        String string = change.getTarget().getProjectId();
        return this.view.getChartModel().getProjectModel(string);
    }

    private boolean isCurrentViewProject(Change change) {
        IProjectResourceModel iProjectResourceModel = this.view.getProjectModel();
        if (iProjectResourceModel == null) {
            return false;
        }
        String string = change.getTarget().getProjectId();
        return string.equals(iProjectResourceModel.getProjectContext().getProjectId());
    }

    protected void applyCreateChange(Change change, boolean bl, ProjectResource projectResource, boolean bl2, List<Change> list) throws ChangeException {
        if (bl) {
            DeleteResourceChange deleteResourceChange = this.getProjectModel(change).deleteResource(projectResource);
            Debug.assertTrue(deleteResourceChange.removals.isEmpty());
        } else {
            Change change2 = this.isCurrentViewProject(change) ? this.view.addResource(projectResource) : this.getProjectModel(change).addResourceForChange(projectResource);
            if (change != null && list != null) {
                change2.copyLinkedToPreviousAndTextFromOtherChange(change);
                list.add(change2);
            }
        }
    }

    protected void applyUpdateChange(Change change, boolean bl, ProjectResource projectResource, boolean bl2, List<Change> list) throws ChangeException {
        Change change2 = null;
        if (list != null) {
            change2 = Change.newUpdateChange(projectResource);
            change2.copyLinkedToPreviousAndTextFromOtherChange(change);
        }
        List<FieldModification> list2 = change.getFieldModifications();
        String string = this.view.getMainTable().getCategorization();
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < list2.size(); ++i) {
            FieldModification fieldModification = list2.get(i);
            Object object = bl ? fieldModification.newValue : fieldModification.oldValue;
            Object object2 = bl ? fieldModification.oldValue : fieldModification.newValue;
            this.applyFieldModification(projectResource, fieldModification.field, object, object2, change2, bl2);
            if (string == fieldModification.field) {
                bl3 = true;
                continue;
            }
            if (fieldModification.field != "CostRate") continue;
            bl4 = true;
        }
        if (bl4) {
            this.getProjectModel(change).updateResourcesCost();
        }
        if (this.isCurrentViewProject(change)) {
            if (bl3) {
                this.view.getMainTable().rebuildTable();
            } else {
                this.view.getMainTable().repaint();
            }
        }
        if (list != null) {
            list.add(change2);
        }
    }

    public void applyFieldModification(ProjectResource projectResource, String string, Object object, Object object2, Change change, boolean bl) {
        if (string == "CostRate") {
            CostRates costRates = projectResource.getCostRates();
            if (bl && !ProjectResource.costRatesEquals(costRates, (CostRates)object)) {
                throw new IllegalStateException(string + ": values not equal");
            }
            if (change != null) {
                change.addModification(string, costRates, object2);
            }
            projectResource.setCostRates((CostRates)object2);
            return;
        }
        if (string == "Team") {
            String string2 = projectResource.getTeamId();
            if (bl) {
                this.checkEquals(string2, object, string);
            }
            if (change != null) {
                change.addModification(string, string2, object2);
            }
            projectResource.setTeamId((String)object2);
            return;
        }
        if (string == "Role") {
            String string3 = projectResource.getRoleId();
            if (bl) {
                this.checkEquals(string3, object, string);
            }
            if (change != null) {
                change.addModification(string, string3, object2);
            }
            projectResource.setRoleId((String)object2);
            return;
        }
        if (string == "Email") {
            String string4 = projectResource.getEmail();
            if (bl) {
                this.checkEquals(string4, object, string);
            }
            if (change != null) {
                change.addModification(string, string4, object2);
            }
            projectResource.setEmail((String)object2);
            return;
        }
        if (string == "Enabled") {
            boolean bl2 = projectResource.isEnabled();
            boolean bl3 = (Boolean)object2;
            if (bl) {
                this.checkEquals(bl2, object, string);
            }
            if (change != null) {
                change.addBooleanModification(string, bl2, bl3);
            }
            projectResource.setEnabled(bl3);
            return;
        }
        if (string == "Name") {
            String string5 = projectResource.getCn();
            if (bl) {
                this.checkEquals(string5, object, string);
            }
            if (change != null) {
                change.addModification(string, string5, object2);
            }
            projectResource.setCn((String)object2);
            return;
        }
    }

    protected void applyTeamCreateChange(Change change, boolean bl, ProjectTeam projectTeam, boolean bl2, List<Change> list) throws ChangeException {
        if (bl) {
            this.getProjectModel(change).removeProjectTeam(projectTeam);
        } else {
            Change change2 = this.getProjectModel(change).addProjectTeam(projectTeam);
            if (list != null && change2 != null) {
                change2.copyLinkedToPreviousAndTextFromOtherChange(change);
                list.add(change2);
            }
        }
    }

    protected void applyRoleCreateChange(Change change, boolean bl, ProjectRole projectRole, boolean bl2, List<Change> list) throws ChangeException {
        if (bl) {
            this.getProjectModel(change).removeProjectRole(projectRole);
        } else {
            Change change2 = this.getProjectModel(change).addProjectRole(projectRole);
            if (list != null && change2 != null) {
                change2.copyLinkedToPreviousAndTextFromOtherChange(change);
                list.add(change2);
            }
        }
    }

    private void checkEquals(Object object, Object object2, String string) throws RuntimeException {
        if (object == null && object2 == null || object != null && object.equals(object2)) {
            return;
        }
        String string2 = string != null ? string + " - " : "";
        string2 = string2 + "Objects not equal: [" + object + "]/[" + object2 + ']';
        throw new IllegalStateException(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyDeleteChange(DeleteResourceChange deleteResourceChange, boolean bl, ProjectResource projectResource, boolean bl2, List<Change> list) throws ChangeException {
        if (bl) {
            IProjectResourceModel iProjectResourceModel = this.getProjectModel(deleteResourceChange);
            iProjectResourceModel.addResource(projectResource);
            if (deleteResourceChange.removals != null) {
                try {
                    Object object;
                    iProjectResourceModel.setUpdatingResources(true);
                    for (String string : deleteResourceChange.removals.wbs) {
                        GanttWBS ganttWBS = (GanttWBS)iProjectResourceModel.getNodeByUid(string);
                        Resource[] object2 = ganttWBS.getResources();
                        object = new Resource[object2.length + 1];
                        System.arraycopy(object2, 0, object, 0, object2.length);
                        object[object2.length] = projectResource;
                        ganttWBS.setResources((Resource[])object);
                    }
                    boolean bl3 = false;
                    for (String string : deleteResourceChange.removals.tasks.keySet()) {
                        object = (GanttTask)iProjectResourceModel.getNodeByUid(string);
                        int n = deleteResourceChange.removals.tasks.get(string);
                        TaskResource[] taskResourceArray = ((GanttTask)object).getResources();
                        TaskResource[] taskResourceArray2 = new TaskResource[taskResourceArray.length + 1];
                        System.arraycopy(taskResourceArray, 0, taskResourceArray2, 0, taskResourceArray.length);
                        taskResourceArray2[taskResourceArray.length] = new TaskResource(projectResource, n);
                        ((GanttTask)object).setResources(taskResourceArray2);
                        if (((GanttNode)object).isDone()) continue;
                        bl3 = true;
                    }
                    if (bl3) {
                        iProjectResourceModel.runFullReschedule();
                    }
                    iProjectResourceModel.updateResourcesCost();
                }
                finally {
                    iProjectResourceModel.setUpdatingResources(false);
                    iProjectResourceModel.refresh();
                }
            }
            if (this.isCurrentViewProject(deleteResourceChange)) {
                this.view.resourcesUpdated(1);
            }
            return;
        }
        DeleteResourceChange deleteResourceChange2 = this.getProjectModel(deleteResourceChange).deleteResource(projectResource);
        if (list != null && deleteResourceChange2 != null) {
            deleteResourceChange2.copyLinkedToPreviousAndTextFromOtherChange(deleteResourceChange);
            list.add(deleteResourceChange2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyReplaceChange(ReplaceResourceChange replaceResourceChange, boolean bl, ProjectResource projectResource, boolean bl2, List<Change> list) throws ChangeException {
        ProjectResource projectResource2;
        IProjectResourceModel iProjectResourceModel = this.getProjectModel(replaceResourceChange);
        ProjectResource projectResource3 = iProjectResourceModel.getProjectResource((projectResource2 = replaceResourceChange.getNewResource()).getDn());
        if (projectResource3 != null) {
            projectResource2 = projectResource3;
        }
        projectResource3 = projectResource;
        if (bl) {
            iProjectResourceModel.addResource(projectResource3);
            ReplaceResourceChange.Replacements replacements = replaceResourceChange.getReplacements();
            if (replacements != null) {
                try {
                    Object object;
                    iProjectResourceModel.setUpdatingResources(true);
                    for (String string : replacements.wbs.keySet()) {
                        Resource[] resourceArray;
                        GanttWBS ganttWBS = (GanttWBS)iProjectResourceModel.getNodeByUid(string);
                        boolean bl3 = replacements.wbs.get(string);
                        object = ganttWBS.getResources();
                        if (bl3) {
                            resourceArray = new Resource[((Resource[])object).length + 1];
                            System.arraycopy(object, 0, resourceArray, 0, ((Object)object).length);
                            resourceArray[((Object)object).length] = projectResource3;
                        } else {
                            resourceArray = (Resource[])object.clone();
                            for (int i = 0; i < resourceArray.length; ++i) {
                                if (projectResource2 != resourceArray[i]) continue;
                                resourceArray[i] = projectResource3;
                                break;
                            }
                        }
                        ganttWBS.setResources(resourceArray);
                    }
                    boolean bl4 = false;
                    for (String string : replacements.tasksOldRes.keySet()) {
                        int n;
                        TaskResource[] taskResourceArray;
                        object = (GanttTask)iProjectResourceModel.getNodeByUid(string);
                        int n2 = replacements.tasksOldRes.get(string);
                        Integer n3 = replacements.tasksNewRes.get(string);
                        TaskResource[] taskResourceArray2 = ((GanttTask)object).getResources();
                        if (n3 != null) {
                            taskResourceArray = new TaskResource[taskResourceArray2.length + 1];
                            System.arraycopy(taskResourceArray2, 0, taskResourceArray, 0, taskResourceArray2.length);
                            taskResourceArray[taskResourceArray2.length] = new TaskResource(projectResource3, n2);
                            for (n = 0; n < taskResourceArray.length; ++n) {
                                if (projectResource2 != taskResourceArray[n].getResource()) continue;
                                taskResourceArray[n] = new TaskResource(projectResource2, n3);
                                break;
                            }
                        } else {
                            taskResourceArray = (TaskResource[])taskResourceArray2.clone();
                            for (n = 0; n < taskResourceArray.length; ++n) {
                                if (projectResource2 != taskResourceArray[n].getResource()) continue;
                                taskResourceArray[n] = new TaskResource(projectResource3, n2);
                                break;
                            }
                        }
                        ((GanttTask)object).setResources(taskResourceArray);
                        if (((GanttNode)object).isDone()) continue;
                        bl4 = true;
                    }
                    if (bl4) {
                        iProjectResourceModel.runFullReschedule();
                    }
                }
                finally {
                    iProjectResourceModel.setUpdatingResources(false);
                    iProjectResourceModel.refresh();
                }
            }
            if (!replaceResourceChange.newResourceAlreadyOnProject) {
                DeleteResourceChange deleteResourceChange = iProjectResourceModel.deleteResource(projectResource2);
                Debug.assertTrue(deleteResourceChange.removals.isEmpty());
            } else if (this.isCurrentViewProject(replaceResourceChange)) {
                this.view.resourcesUpdated(1);
            }
            iProjectResourceModel.updateResourcesCost();
            return;
        }
        ReplaceResourceChange replaceResourceChange2 = iProjectResourceModel.replaceResource(projectResource3, projectResource2, replaceResourceChange.options);
        if (list != null && replaceResourceChange2 != null) {
            replaceResourceChange2.copyLinkedToPreviousAndTextFromOtherChange(replaceResourceChange);
            list.add(replaceResourceChange2);
        }
        if (this.isCurrentViewProject(replaceResourceChange)) {
            this.view.getMainTable().setSelectedResources(projectResource2);
        }
    }
}

