/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.pe.util;

public class StringValidationUtil {
    public static final int DEFAULT_TYPE = 0;
    public static final int PRJ_NAME_TYPE = 0;
    public static final int ISSUE_TYPE_LIST_FIELD_TYPE = 1;
    public static final int ISSUE_TYPE_FIELD = 2;
    private static final char[] basicForbiddenChars = new char[]{'|', '~', '^'};
    private static final char[] issueTypeListFieldForbiddenChars = new char[]{'|', ','};

    public static String getJSStringValidation(String string, String string2, int n) {
        return StringValidationUtil.getJSStringValidation(string, string2, n, true);
    }

    public static String getJSStringValidation(String string, String string2, int n, boolean bl) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("if (isStringContainsAnyChar(");
        stringBuilder.append(string);
        stringBuilder.append(", [");
        char[] cArray = StringValidationUtil.getForbiddenCharsForType(n);
        for (n2 = 0; n2 < cArray.length; ++n2) {
            if (n2 > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append("'").append(cArray[n2]).append("'");
        }
        stringBuilder.append("])){");
        stringBuilder.append("alert(\"").append(string2);
        if (bl) {
            for (n2 = 0; n2 < cArray.length; ++n2) {
                stringBuilder.append(" ").append(cArray[n2]);
            }
        }
        stringBuilder.append("\");");
        stringBuilder.append("return false;");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static boolean isStringValid(String string) {
        return StringValidationUtil.isStringValid(string, 0);
    }

    public static boolean isStringValid(String string, int n) {
        char[] cArray = StringValidationUtil.getForbiddenCharsForType(n);
        return !StringValidationUtil.isStringContainsAnyChar(string, cArray);
    }

    public static boolean isStringContainsAnyChar(String string, char[] cArray) {
        if (string != null && cArray != null) {
            for (int i = 0; i < cArray.length; ++i) {
                if (string.indexOf(cArray[i]) == -1) continue;
                return true;
            }
        }
        return false;
    }

    public static char[] getForbiddenChars() {
        return StringValidationUtil.getForbiddenCharsForType(0);
    }

    private static char[] getForbiddenCharsForType(int n) {
        switch (n) {
            case 1: 
            case 2: {
                return issueTypeListFieldForbiddenChars;
            }
        }
        return basicForbiddenChars;
    }
}

