/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.pe.timesheet;

import com.triloggroup.pe.timesheet.ItemResourceData;
import com.triloggroup.pe.timesheet.TimeSheetLevel;
import java.util.Date;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemTimeSheetData {
    private TimeSheetLevel level;
    private double hours;
    private HashMap<String, ItemResourceData> byResourceDn;

    public ItemTimeSheetData(TimeSheetLevel timeSheetLevel) {
        if (timeSheetLevel == TimeSheetLevel.NONE) {
            throw new IllegalArgumentException("NONE timesheet level not accepted");
        }
        this.level = timeSheetLevel;
    }

    public double getItemHours() {
        return this.hours;
    }

    public void add(double d, String string, Date date) {
        ItemResourceData itemResourceData;
        this.hours += d;
        if (this.level == TimeSheetLevel.TOTAL_ONLY) {
            return;
        }
        if (this.byResourceDn == null) {
            this.byResourceDn = new HashMap();
            itemResourceData = null;
        } else {
            itemResourceData = this.byResourceDn.get(string);
        }
        if (itemResourceData == null) {
            itemResourceData = new ItemResourceData();
            this.byResourceDn.put(string, itemResourceData);
        }
        if (this.level == TimeSheetLevel.TOTAL_PER_RESOURCE) {
            itemResourceData.add(d);
        } else {
            itemResourceData.add(d, date);
        }
    }

    public ItemResourceData getResourceData(String string) {
        return this.byResourceDn.get(string);
    }

    public HashMap<String, ItemResourceData> getResourceData() {
        return this.byResourceDn;
    }

    public TimeSheetLevel getLevel() {
        return this.level;
    }
}

