/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.treetable;

import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.TGChartModel;
import com.triloggroup.gantt.TaskResource;
import com.triloggroup.gantt.TimeUnit;
import com.triloggroup.project.components.ui.table.TGTableCellRenderer;
import java.text.NumberFormat;
import java.util.Locale;

public class ResourcesRenderer
extends TGTableCellRenderer {
    private Locale formatLocale;
    private NumberFormat workFormat;
    private TimeUnit hr;

    public ResourcesRenderer(TGChartModel tGChartModel, Locale locale) {
        this.formatLocale = locale;
        this.hr = tGChartModel.getGlobalContext().getTimeUnits().getHourTimeUnit();
    }

    protected void setValue(Object object) {
        StringBuilder stringBuilder = null;
        if (object != null) {
            TaskResource[] taskResourceArray;
            if (object instanceof Resource[]) {
                Resource[] resourceArray = (Resource[])object;
                if (resourceArray.length > 0) {
                    stringBuilder = new StringBuilder();
                    for (int i = 0; i < resourceArray.length; ++i) {
                        if (i > 0) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(resourceArray[i].getCn());
                    }
                }
            } else if (object instanceof TaskResource[] && (taskResourceArray = (TaskResource[])object).length > 0) {
                stringBuilder = new StringBuilder();
                for (int i = 0; i < taskResourceArray.length; ++i) {
                    if (i > 0) {
                        stringBuilder.append(", ");
                    }
                    this.appendTaskResource(taskResourceArray[i], stringBuilder);
                }
            }
        }
        this.setText(stringBuilder == null ? "" : stringBuilder.toString());
    }

    protected void appendTaskResource(TaskResource taskResource, StringBuilder stringBuilder) {
        stringBuilder.append(taskResource.getCn());
        this.appendResourceUnits(taskResource, stringBuilder);
    }

    public void appendResourceUnits(TaskResource taskResource, StringBuilder stringBuilder) {
        if (taskResource.getUnit() == 100 && !taskResource.isWorkSpecified()) {
            return;
        }
        stringBuilder.append('[');
        if (taskResource.isWorkSpecified()) {
            stringBuilder.append(this.getWorkFormat().format(taskResource.getWork()));
            stringBuilder.append(taskResource.getWork() > 1.0 ? this.hr.getShortLabelPlural() : this.hr.getShortLabel());
            stringBuilder.append(": ");
        }
        stringBuilder.append(taskResource.getUnit());
        stringBuilder.append("%]");
    }

    private NumberFormat getWorkFormat() {
        if (this.workFormat == null) {
            this.workFormat = NumberFormat.getNumberInstance(this.formatLocale);
            this.workFormat.setMinimumFractionDigits(0);
            this.workFormat.setMaximumFractionDigits(2);
        }
        return this.workFormat;
    }
}

