/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.treetable;

import com.triloggroup.gantt.treetable.DurationRenderer;
import com.triloggroup.gantt.treetable.GanttTreeTableModel;
import com.triloggroup.gantt.treetable.TGTreeTable;
import com.triloggroup.gantt.treetable.TableCellRendererWithLabel;
import com.triloggroup.project.components.ui.table.TGTableCellNumberRenderer;
import com.triloggroup.project.components.ui.table.TGTableCellRendererWithEditIcon;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class GanttTreeTable
extends TGTreeTable {
    protected TableCellRenderer durationRenderer;
    protected TableCellRenderer priorityRenderer;
    protected TableCellRenderer progressRenderer;
    protected TableCellRenderer statusRenderer;
    protected TableCellRenderer predecessorsRenderer;
    protected TableCellRenderer costRenderer;
    protected TableCellRenderer actualAdditionalCostRenderer;

    public GanttTreeTable(GanttTreeTableModel ganttTreeTableModel, Locale locale, TimeZone timeZone) {
        super(ganttTreeTableModel, locale, timeZone);
    }

    protected void initRenderers() {
        if (this.durationRenderer != null) {
            return;
        }
        this.durationRenderer = new DurationRenderer(this.getLocale());
        this.priorityRenderer = new TGTableCellNumberRenderer();
        this.progressRenderer = new TableCellRendererWithLabel("%");
        ((TableCellRendererWithLabel)this.progressRenderer).setHideLabelIfNull(true);
        this.statusRenderer = new TGTableCellRendererWithEditIcon();
    }

    protected void updateRenderers() {
        this.initRenderers();
        GanttTreeTableModel ganttTreeTableModel = (GanttTreeTableModel)this.getModel();
        TableColumnModel tableColumnModel = this.getColumnModel();
        boolean bl = false;
        for (int i = 0; i < ganttTreeTableModel.getColumnCount(); ++i) {
            String string = ganttTreeTableModel.getColumnKeyName(i);
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            if (string == "Name" || string == "Id") {
                if (bl) continue;
                tableColumn.setCellRenderer(this.treeRenderer);
                bl = true;
                continue;
            }
            if (string == "Priority") {
                tableColumn.setCellRenderer(this.priorityRenderer);
                continue;
            }
            if (string == "Progress") {
                tableColumn.setCellRenderer(this.progressRenderer);
                continue;
            }
            if (string == "Duration" || string == "Work" || string == "ActualWork" || string == "RemainingWork" || string == "WorkedHours" || string == "TotalSlack") {
                tableColumn.setCellRenderer(this.durationRenderer);
                continue;
            }
            if (string == "Resources") {
                tableColumn.setCellRenderer(this.resourcesRenderer);
                continue;
            }
            if (string == "Status") {
                tableColumn.setCellRenderer(this.statusRenderer);
                continue;
            }
            if (string == "predecessors") {
                tableColumn.setCellRenderer(this.predecessorsRenderer);
                continue;
            }
            if (string == "AdditionalCost" || string == "ActualAdditionalCostSum" || string == "ActualCostSum" || string == "ActualResourceCostSum" || string == "ProjectedAdditionalCostSum" || string == "ProjectedCostSum" || string == "ProjectedResourceCostSum" || string == "InitiallyPlannedAdditionalCostSum" || string == "InitiallyPlannedCostSum" || string == "InitiallyPlannedResourceCostSum") {
                tableColumn.setCellRenderer(this.costRenderer);
                continue;
            }
            if (string == "ActualAdditionalCost") {
                tableColumn.setCellRenderer(this.actualAdditionalCostRenderer);
                continue;
            }
            tableColumn.setCellRenderer(null);
        }
        this.computePreferredWidth();
    }

    public boolean isNameColumnVisible() {
        return this.getModel().isColumnVisible("Name");
    }

    public boolean isIdColumnVisible() {
        return this.getModel().isColumnVisible("Id");
    }

    public boolean isDateColumnVisible() {
        return this.getModel().isColumnVisible("StartDate");
    }

    public boolean isResourcesColumnVisible() {
        return this.getModel().isColumnVisible("Resources");
    }
}

