/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.renderer;

import com.triloggroup.gantt.CriticalPathRuntimeConf;
import com.triloggroup.gantt.GanttCategoryPlot;
import com.triloggroup.gantt.GanttChart;
import com.triloggroup.gantt.GanttDataset;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.IGanttGlobalContext;
import com.triloggroup.gantt.TGCategoryPlot;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.TaskPredecessor;
import com.triloggroup.gantt.renderer.PredecessorPath;
import com.triloggroup.gantt.renderer.TGEntity;
import com.triloggroup.gantt.renderer.TGNodeRenderer;
import com.triloggroup.project.components.IGlobalContext;
import com.triloggroup.project.components.ui.UIConstants;
import com.triloggroup.project.schedule.Predecessor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Date;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.time.TimePeriod;
import org.jfree.text.TextBlockAnchor;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.Size2D;

public class GanttNodeRenderer
extends TGNodeRenderer {
    private boolean paintActualDates = false;
    private boolean paintDeadline = false;
    private boolean paintWBSColor = !GanttChart.isServerMode;
    private boolean paintMilestoneColor = true;
    protected static final int WBS_TRIANGLE_HALF_WITDH = 4;
    public static final int MILESTONE_HALF_WITDH = 4;
    private static final int GAP_WIDTH = 8;
    private static final int ARROW_HEIGHT = 4;
    protected static final Stroke BASIC_STROKE;
    protected static final Stroke CRITICAL_TASK_STROKE;
    protected static final Color CRITICAL_TASK_COLOR;
    protected static final Stroke NEAR_CRITICAL_TASK_STROKE;
    protected static final Color NEAR_CRITICAL_TASK_COLOR;
    protected static final Stroke LATE_DATES_STROKE;
    protected static final Color LATE_DATES_COLOR;
    protected static final Color DEADLINE_COLOR_OK;
    protected static final Color DEADLINE_COLOR_NG;
    protected static final Color LOW_COLOR;
    private Stroke lineStroke;
    private Stroke selectedLineStroke;

    public GanttNodeRenderer() {
        this.setDrawBarOutline(false);
        this.lineStroke = new BasicStroke(1.0f, 0, 0, 10.0f, null, 0.0f);
        this.selectedLineStroke = new BasicStroke(3.0f, 0, 0, 10.0f, null, 0.0f);
    }

    public boolean isPaintActualDates() {
        return this.paintActualDates;
    }

    public void setPaintActualDates(boolean bl) {
        this.paintActualDates = bl;
    }

    public boolean isPaintDeadline() {
        return this.paintDeadline;
    }

    public void setPaintDeadline(boolean bl) {
        this.paintDeadline = bl;
    }

    protected void drawNode(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, TGCategoryPlot tGCategoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, GanttDataset ganttDataset, int n, int n2) {
        IGanttGlobalContext iGanttGlobalContext;
        CriticalPathRuntimeConf criticalPathRuntimeConf;
        this.checkHorizontalOrientation(tGCategoryPlot);
        double d = this.calculateBarW0(tGCategoryPlot, tGCategoryPlot.getOrientation(), rectangle2D, categoryAxis, categoryItemRendererState, n, n2);
        Rectangle rectangle = graphics2D.getClipBounds();
        if (d + (double)GanttChart.getRowHeight() < rectangle.getMinY() || d > rectangle.getMaxY()) {
            return;
        }
        TGNode tGNode = ganttDataset.getNode(n, n2);
        if (tGCategoryPlot.isSelectedNode(tGNode)) {
            this.drawBackgroundSelection(tGNode, graphics2D, d, rectangle2D, tGCategoryPlot);
        } else if (tGNode.getGlobalContext() instanceof IGanttGlobalContext && (criticalPathRuntimeConf = (iGanttGlobalContext = (IGanttGlobalContext)tGNode.getGlobalContext()).getCriticalPathConf()).getDisplayCriticalPath() && !(tGNode instanceof GanttTask)) {
            this.drawRowBackground(LOW_COLOR, graphics2D, d, rectangle2D, tGCategoryPlot);
        }
        if (tGNode instanceof GanttWBS) {
            this.drawWBSNode(graphics2D, categoryItemRendererState, rectangle2D, tGCategoryPlot, categoryAxis, valueAxis, ganttDataset, n, n2, (GanttWBS)tGNode, d);
        } else if (tGNode instanceof GanttTask) {
            this.drawTaskNode(graphics2D, categoryItemRendererState, rectangle2D, tGCategoryPlot, categoryAxis, valueAxis, ganttDataset, n, n2, (GanttTask)tGNode, d);
        }
    }

    protected void drawTaskNode(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, TGCategoryPlot tGCategoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, GanttDataset ganttDataset, int n, int n2, GanttTask ganttTask, double d) {
        double d2;
        IGanttGlobalContext iGanttGlobalContext;
        CriticalPathRuntimeConf criticalPathRuntimeConf;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (ganttTask.getGlobalContext() instanceof IGanttGlobalContext && (criticalPathRuntimeConf = (iGanttGlobalContext = (IGanttGlobalContext)ganttTask.getGlobalContext()).getCriticalPathConf()).getDisplayCriticalPath()) {
            bl2 = criticalPathRuntimeConf.getDisplayLateDates();
            d2 = ganttTask.getTotalSlack();
            if (d2 == -1.0 || d2 > 0.0 && d2 < criticalPathRuntimeConf.getNearCriticalSlackHours()) {
                bl3 = true;
            } else {
                bl = true;
            }
        }
        if (ganttTask.isMilestone()) {
            this.drawMilestoneNode(graphics2D, categoryItemRendererState, rectangle2D, tGCategoryPlot, categoryAxis, valueAxis, ganttDataset, n, n2, ganttTask, d);
        } else {
            Object object;
            double d3;
            iGanttGlobalContext = tGCategoryPlot.getRangeAxisEdge();
            criticalPathRuntimeConf = ganttTask.getDuration();
            d2 = criticalPathRuntimeConf.getEnd().getTime();
            double d4 = criticalPathRuntimeConf.getStart().getTime();
            if (d4 == d2) {
                d2 += ganttTask.getDurationInHours() * 3600000.0;
            }
            double d5 = valueAxis.valueToJava2D(d2, rectangle2D, (RectangleEdge)iGanttGlobalContext);
            double d6 = valueAxis.valueToJava2D(d4, rectangle2D, (RectangleEdge)iGanttGlobalContext);
            d5 = Math.round(d5);
            if ((d6 = (double)Math.round(d6)) < d5) {
                d3 = d6;
                d6 = d5;
                d5 = d3;
            }
            d3 = categoryItemRendererState.getBarWidth();
            double d7 = d6 - d5;
            if (this.paintActualDates) {
                d3 = 8.0;
            }
            if (d7 <= 0.0) {
                d7 = 1.0;
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double(d5, d, d7, d3);
            if (bl3) {
                if (ganttTask.getTotalSlack() == -1.0) {
                    graphics2D.setStroke(CRITICAL_TASK_STROKE);
                    graphics2D.setPaint(CRITICAL_TASK_COLOR);
                } else {
                    graphics2D.setStroke(NEAR_CRITICAL_TASK_STROKE);
                    graphics2D.setPaint(NEAR_CRITICAL_TASK_COLOR);
                }
                graphics2D.draw(new Rectangle2D.Double(((RectangularShape)double_).getX() - 2.0, ((RectangularShape)double_).getY() - 2.0, ((RectangularShape)double_).getWidth() + 3.0, ((RectangularShape)double_).getHeight() + 3.0));
            }
            graphics2D.setPaint(this.getGanttTaskColor(ganttTask));
            graphics2D.fill(double_);
            boolean bl4 = ganttTask.getProjectContext().showPercentComplete();
            if (bl4) {
                this.drawPercentComplete(graphics2D, ganttTask, double_);
            }
            this.drawShapeOutline(graphics2D, double_, categoryItemRendererState, n, n2);
            this.paintActualDates(graphics2D, rectangle2D, tGCategoryPlot, categoryAxis, valueAxis, ganttTask, double_);
            this.paintDeadline(graphics2D, categoryItemRendererState, rectangle2D, tGCategoryPlot, categoryAxis, valueAxis, ganttDataset, n, n2, d, ganttTask);
            this.drawTaskLabel(graphics2D, rectangle2D, categoryAxis, n, n2, ganttTask, d5, d, d7, bl4);
            if (bl2 && ganttTask.getTotalSlack() != -1.0 && ganttTask.getTotalSlack() != -99.0) {
                object = ganttTask.getLateStart();
                Date date = ganttTask.getLateFinish();
                if (object != null && date != null) {
                    double d8 = valueAxis.valueToJava2D((double)((Date)object).getTime(), rectangle2D, (RectangleEdge)iGanttGlobalContext);
                    double d9 = valueAxis.valueToJava2D((double)date.getTime(), rectangle2D, (RectangleEdge)iGanttGlobalContext);
                    Rectangle2D.Double double_2 = new Rectangle2D.Double(d8, d, d9 - d8, d3);
                    graphics2D.setStroke(LATE_DATES_STROKE);
                    graphics2D.setPaint(LATE_DATES_COLOR);
                    graphics2D.draw(double_2);
                }
            }
            if (!GanttChart.isServerMode && (object = categoryItemRendererState.getEntityCollection()) != null) {
                object.add((ChartEntity)TGEntity.create((CategoryDataset)ganttDataset, n, n2, ganttTask, double_));
            }
        }
        if (bl && !tGCategoryPlot.isSelectedNode(ganttTask)) {
            this.drawRowBackground(LOW_COLOR, graphics2D, d, rectangle2D, tGCategoryPlot);
        }
    }

    protected void paintDeadline(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, TGCategoryPlot tGCategoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, GanttDataset ganttDataset, int n, int n2, double d, GanttTask ganttTask) {
        if (!this.paintDeadline || ganttTask.getDeadlineDate() == null) {
            return;
        }
        Date date = ganttTask.getDeadlineDate();
        RectangleEdge rectangleEdge = tGCategoryPlot.getRangeAxisEdge();
        int n3 = (int)Math.round(valueAxis.valueToJava2D((double)date.getTime(), rectangle2D, rectangleEdge));
        boolean bl = date.before(ganttTask.getFinishDate());
        graphics2D.setPaint(bl ? DEADLINE_COLOR_NG : DEADLINE_COLOR_OK);
        int n4 = (int)(d - 2.0 - 1.0);
        int n5 = n4 + GanttChart.getRowHeight() / 2;
        int[] nArray = new int[]{n3, n3 + 5, n3 - 5};
        int[] nArray2 = new int[]{n4 + 1, n5, n5};
        Polygon polygon = new Polygon(nArray, nArray2, 3);
        graphics2D.fillPolygon(polygon);
        if (bl) {
            graphics2D.setColor(Color.DARK_GRAY);
            graphics2D.setStroke(BASIC_STROKE);
            graphics2D.drawPolygon(polygon);
        }
    }

    protected void paintActualDates(Graphics2D graphics2D, Rectangle2D rectangle2D, TGCategoryPlot tGCategoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, GanttTask ganttTask, Rectangle2D rectangle2D2) {
        boolean bl;
        if (!this.paintActualDates) {
            return;
        }
        boolean bl2 = ganttTask.getActualStartDate() != null;
        boolean bl3 = bl = ganttTask.getActualFinishDate() != null;
        if (!bl2 && !bl) {
            return;
        }
        Color color = this.getGanttTaskColor(ganttTask);
        graphics2D.setColor(color);
        graphics2D.setStroke(BASIC_STROKE);
        int n = (int)Math.round(rectangle2D2.getY()) + 8;
        int n2 = n + 4;
        int n3 = 0;
        int n4 = 0;
        RectangleEdge rectangleEdge = tGCategoryPlot.getRangeAxisEdge();
        if (bl2) {
            n3 = (int)Math.round(valueAxis.valueToJava2D((double)ganttTask.getActualStartDate().getTime(), rectangle2D, rectangleEdge));
            graphics2D.drawLine(n3, n, n3, n2);
        }
        if (bl) {
            n4 = (int)Math.round(valueAxis.valueToJava2D((double)ganttTask.getActualFinishDate().getTime(), rectangle2D, rectangleEdge));
            graphics2D.drawLine(n4, n, n4, n2);
        }
        if (bl2) {
            int n5 = Integer.MIN_VALUE;
            if (bl) {
                n5 = n4;
            } else {
                IGlobalContext iGlobalContext = ganttTask.getGlobalContext();
                Date date = iGlobalContext.convertToServerTimeZone(iGlobalContext.getCurrentDate());
                if (date.after(ganttTask.getActualStartDate())) {
                    n5 = (int)Math.round(valueAxis.valueToJava2D((double)date.getTime(), rectangle2D, tGCategoryPlot.getRangeAxisEdge()));
                }
            }
            if (n5 != Integer.MIN_VALUE && n5 - n3 > 2) {
                int n6 = 4;
                int n7 = 4;
                BufferedImage bufferedImage = new BufferedImage(n6, n7, 2);
                Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
                graphics2D2.setColor(new Color(255, 255, 255, 0));
                graphics2D2.fillRect(0, 0, n6, n7);
                graphics2D2.setColor(color);
                graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D2.drawLine(0, 0, n6 - 1, n7 - 1);
                TexturePaint texturePaint = new TexturePaint(bufferedImage, new Rectangle2D.Double(0.0, 0.0, n6, n7));
                graphics2D.setPaint(texturePaint);
                graphics2D.fillRect(n3, n, n5 - n3, 4);
            }
        }
    }

    protected void drawMilestoneNode(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, GanttDataset ganttDataset, int n, int n2, GanttTask ganttTask, double d) {
        EntityCollection entityCollection;
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        double d2 = ganttTask.getDuration().getStart().getTime();
        int n3 = (int)valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge);
        double d3 = categoryItemRendererState.getBarWidth();
        int[] nArray = new int[]{n3, n3 + 4, n3, n3 - 4};
        int n4 = (int)(d + d3 / 2.0);
        int[] nArray2 = new int[]{(int)d, n4, (int)(d + d3), n4};
        Polygon polygon = new Polygon(nArray, nArray2, 4);
        graphics2D.setPaint(Color.BLACK);
        graphics2D.fill(polygon);
        nArray = new int[]{n3, n3 + 2, n3, n3 - 2};
        nArray2 = new int[]{(int)d + 2, n4, (int)(d + d3 - 2.0), n4};
        graphics2D.setPaint(this.getGanttMilestoneColor(ganttTask));
        graphics2D.fillPolygon(nArray, nArray2, 4);
        this.drawTaskLabel(graphics2D, rectangle2D, categoryAxis, n, n2, ganttTask, n3, d, d3, false);
        if (!GanttChart.isServerMode && (entityCollection = categoryItemRendererState.getEntityCollection()) != null) {
            entityCollection.add((ChartEntity)TGEntity.createMilestone((CategoryDataset)ganttDataset, n, n2, ganttTask, polygon));
        }
    }

    protected void drawWBSNode(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, GanttDataset ganttDataset, int n, int n2, GanttWBS ganttWBS, double d) {
        EntityCollection entityCollection;
        int n3;
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        TimePeriod timePeriod = ganttWBS.getDuration();
        double d2 = timePeriod.getStart().getTime();
        int n4 = (int)Math.round(valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge));
        double d3 = timePeriod.getEnd().getTime();
        int n5 = (int)Math.round(valueAxis.valueToJava2D(d3, rectangle2D, rectangleEdge));
        if (n5 < n4) {
            n3 = n5;
            n5 = n4;
            n4 = n3;
        }
        n3 = n4 - 4;
        int n6 = n5 + 4;
        double d4 = categoryItemRendererState.getBarWidth() / 2.0;
        double d5 = n6 - n3;
        Rectangle2D.Double double_ = new Rectangle2D.Double(n3, d, d5, d4);
        int[] nArray = new int[]{n3, n4, n4 + 4};
        int[] nArray2 = new int[]{(int)(d + d4), (int)(d + categoryItemRendererState.getBarWidth()), (int)(d + d4)};
        Polygon polygon = new Polygon(nArray, nArray2, 3);
        int[] nArray3 = new int[]{n6, n5, n5 - 4};
        Polygon polygon2 = new Polygon(nArray3, nArray2, 3);
        Area area = new Area(double_);
        area.add(new Area(polygon));
        area.add(new Area(polygon2));
        graphics2D.setPaint(this.getGanttWBSColor(ganttWBS));
        graphics2D.fill(area);
        this.drawShapeOutline(graphics2D, area, categoryItemRendererState, n, n2);
        if (this.paintWBSColor && (ganttWBS.hasSubTask() || ganttWBS.isSubProject())) {
            int n7;
            graphics2D.setPaint(this.getHealthStatusColor(ganttWBS));
            int n8 = nArray2[0];
            graphics2D.setStroke(new BasicStroke(2.0f, 0, 2));
            if (nArray[2] < nArray3[2]) {
                graphics2D.drawLine(nArray[2], n8, nArray3[2], n8);
            }
            if (n4 != n5 && (n7 = nArray[2] - nArray3[2]) > 1) {
                double d6 = d + d4 + (double)(n7 / 2) * d4 / 4.0;
                nArray2[2] = (int)Math.round(d6);
                nArray[2] = nArray3[2] = (n3 + n6) / 2;
            }
            graphics2D.drawPolyline(nArray, nArray2, 3);
            graphics2D.drawPolyline(nArray3, nArray2, 3);
        }
        this.drawTaskLabel(graphics2D, rectangle2D, categoryAxis, n, n2, ganttWBS, n3, d, d5, !GanttChart.isServerMode);
        if (!GanttChart.isServerMode && (entityCollection = categoryItemRendererState.getEntityCollection()) != null) {
            entityCollection.add((ChartEntity)TGEntity.create((CategoryDataset)ganttDataset, n, n2, ganttWBS, area));
        }
    }

    protected void drawPredecessors(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, GanttDataset ganttDataset, int n, int n2) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        TGNode tGNode = ganttDataset.getNode(n, n2);
        if (tGNode instanceof GanttTask) {
            GanttTask ganttTask = (GanttTask)tGNode;
            ArrayList<Predecessor> arrayList = ganttTask.getPredecessorsList();
            if (arrayList == null) {
                return;
            }
            TaskPredecessor taskPredecessor = ((GanttCategoryPlot)categoryPlot).getSelectedPredecessor();
            Predecessor predecessor = null;
            if (taskPredecessor != null && taskPredecessor.task == tGNode) {
                predecessor = taskPredecessor.predecessor;
            }
            String string = ganttTask.getProjectId();
            for (int i = 0; i < arrayList.size(); ++i) {
                Predecessor predecessor2 = (Predecessor)arrayList.get(i);
                GanttTask ganttTask2 = (GanttTask)ganttDataset.getNode(n, string, predecessor2.getId());
                if (ganttTask2 == null) continue;
                boolean bl = predecessor2 == predecessor;
                this.drawPredecessorLink(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, ganttDataset, n, n2, ganttTask, ganttTask2, predecessor2.getType(), bl, predecessor2);
            }
        }
    }

    protected void drawPredecessorLink(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, GanttDataset ganttDataset, int n, int n2, GanttTask ganttTask, GanttTask ganttTask2, int n3, boolean bl, Predecessor predecessor) {
        CriticalPathRuntimeConf criticalPathRuntimeConf;
        double d;
        this.checkHorizontalOrientation(categoryPlot);
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        double d2 = ganttTask.getDuration().getStart().getTime();
        double d3 = ganttTask.getDuration().getEnd().getTime();
        double d4 = ganttTask2.getDuration().getStart().getTime();
        double d5 = ganttTask2.getDuration().getEnd().getTime();
        double d6 = valueAxis.valueToJava2D(d3, rectangle2D, rectangleEdge);
        double d7 = valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge);
        if (d7 < d6) {
            d = d7;
            d7 = d6;
            d6 = d;
        }
        if (ganttTask.isMilestone()) {
            d6 -= 4.0;
            d7 += 4.0;
        }
        d = this.calculateBarW0(categoryPlot, plotOrientation, rectangle2D, categoryAxis, categoryItemRendererState, n, n2);
        double d8 = categoryItemRendererState.getBarWidth();
        double d9 = valueAxis.valueToJava2D(d5, rectangle2D, rectangleEdge);
        double d10 = valueAxis.valueToJava2D(d4, rectangle2D, rectangleEdge);
        if (d10 < d9) {
            double d11 = d10;
            d10 = d9;
            d9 = d11;
        }
        if (ganttTask2.isMilestone()) {
            d9 -= 4.0;
            d10 += 4.0;
        }
        int n4 = ganttDataset.getColumnIndex((Comparable)((Object)ganttTask2.getDescription()));
        double d12 = this.calculateBarW0(categoryPlot, plotOrientation, rectangle2D, categoryAxis, categoryItemRendererState, n, n4);
        Rectangle rectangle = graphics2D.getClipBounds();
        int n5 = (int)rectangle.getMinY() - GanttChart.getRowHeight();
        int n6 = (int)rectangle.getMaxY();
        if (d12 < (double)n5 && d < (double)n5) {
            return;
        }
        if (d12 > (double)n6 && d > (double)n6) {
            return;
        }
        Polygon polygon = null;
        PredecessorPath predecessorPath = null;
        double d13 = d + d8 / 2.0;
        switch (n3) {
            case 3: {
                double d14 = Math.min(d6, d9) - 8.0;
                double d15 = d12 + d8 / 2.0;
                predecessorPath = new PredecessorPath(d6, d13);
                predecessorPath.moveX(d14);
                predecessorPath.moveY(d15);
                predecessorPath.moveX(d9);
                polygon = this.getArrowShape((int)d6, (int)(d + d8 / 2.0), true);
                break;
            }
            case 2: {
                double d16 = d7 + 8.0;
                predecessorPath = new PredecessorPath(d7, d13);
                predecessorPath.moveX(d16);
                if (d7 + 8.0 < d9 - 8.0) {
                    double d17 = d12 + d8 / 2.0;
                    predecessorPath.moveY(d17);
                    predecessorPath.moveX(d9);
                } else {
                    double d18 = d9 - 8.0;
                    double d19 = d12 - 2.0;
                    double d20 = d12 + d8 / 2.0;
                    if (d12 < d) {
                        d19 = d12 + d8 + 2.0;
                    }
                    predecessorPath.moveY(d19);
                    predecessorPath.moveX(d18);
                    predecessorPath.moveY(d20);
                    predecessorPath.moveX(d9);
                }
                polygon = this.getArrowShape((int)d7, (int)(d + d8 / 2.0), false);
                break;
            }
            case 1: {
                if (d6 - 8.0 < d10 + 8.0) {
                    double d21 = d12 - 2.0;
                    double d22 = d12 + d8 / 2.0;
                    if (d12 < d) {
                        d21 = d12 + d8 + 2.0;
                    }
                    predecessorPath = new PredecessorPath(d6, d13);
                    predecessorPath.moveX(d6 - 8.0);
                    predecessorPath.moveY(d21);
                    predecessorPath.moveX(d10 + 8.0);
                    predecessorPath.moveY(d22);
                    predecessorPath.moveX(d10);
                } else {
                    double d23 = d10 + 8.0;
                    double d24 = d12 + d8 / 2.0;
                    predecessorPath = new PredecessorPath(d6, d13);
                    predecessorPath.moveX(d23);
                    predecessorPath.moveY(d24);
                    predecessorPath.moveX(d10);
                }
                polygon = this.getArrowShape((int)d6, (int)(d + d8 / 2.0), true);
                break;
            }
            case 0: {
                double d25 = Math.max(d7, d10) + 8.0;
                double d26 = d12 + d8 / 2.0;
                predecessorPath = new PredecessorPath(d7, d13);
                predecessorPath.moveX(d25);
                predecessorPath.moveY(d26);
                predecessorPath.moveX(d10);
                polygon = this.getArrowShape((int)d7, (int)(d + d8 / 2.0), false);
            }
        }
        boolean bl2 = false;
        if (ganttTask.getGlobalContext() instanceof IGanttGlobalContext && (criticalPathRuntimeConf = ((IGanttGlobalContext)ganttTask.getGlobalContext()).getCriticalPathConf()).getDisplayCriticalPath() && ganttTask.getTotalSlack() == -1.0 && ganttTask2.getTotalSlack() == -1.0) {
            bl2 = true;
        }
        graphics2D.setPaint(bl2 ? new Color(255, 0, 115) : Color.DARK_GRAY);
        graphics2D.setStroke(bl ? this.selectedLineStroke : this.lineStroke);
        predecessorPath.draw(graphics2D);
        graphics2D.drawPolygon(polygon);
        graphics2D.fillPolygon(polygon);
        if (!GanttChart.isServerMode && (criticalPathRuntimeConf = categoryItemRendererState.getEntityCollection()) != null) {
            criticalPathRuntimeConf.add((ChartEntity)TGEntity.createPredecessor((CategoryDataset)ganttDataset, n, n2, new TaskPredecessor(ganttTask, predecessor), predecessorPath.createThickPath(2)));
        }
    }

    protected Polygon getArrowShape(int n, int n2, boolean bl) {
        int n3 = 2;
        int[] nArray = new int[]{n2, n2 + n3, n2 - n3};
        if (bl) {
            int[] nArray2 = new int[]{n, n - 4, n - 4};
            return new Polygon(nArray2, nArray, 3);
        }
        int[] nArray3 = new int[]{n, n + 4, n + 4};
        return new Polygon(nArray3, nArray, 3);
    }

    protected void drawTaskLabel(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryAxis categoryAxis, int n, int n2, GanttNode ganttNode, double d, double d2, double d3, boolean bl) {
        if (this.isSeriesItemLabelsVisible(n)) {
            Size2D size2D;
            double d4;
            Double d5;
            categoryAxis.getTickLabelPaint();
            StringBuilder stringBuilder = new StringBuilder(ganttNode.getName());
            if (bl && (d5 = ganttNode.getPercentComplete()) != null && d5 >= 0.0) {
                double d6 = d5;
                stringBuilder.append(" - ");
                stringBuilder.append((int)(d6 * 100.0));
                stringBuilder.append("%");
            }
            if ((d4 = d + d3 + 10.0) + (size2D = (d5 = TextUtilities.createTextBlock((String)stringBuilder.toString(), (Font)UIConstants.DEFAULT_FONT, (Paint)categoryAxis.getTickLabelPaint())).calculateDimensions(graphics2D)).getWidth() > rectangle2D.getWidth() && d - 10.0 - size2D.getWidth() > rectangle2D.getX()) {
                d4 = d - 10.0 - size2D.getWidth();
            }
            d5.draw(graphics2D, (float)d4, (float)d2, TextBlockAnchor.TOP_LEFT);
        }
    }

    protected Color getGanttWBSColor(GanttWBS ganttWBS) {
        if (ganttWBS.isProjectRoot() && ganttWBS.getParent() != null || ganttWBS.isSubProject() && ganttWBS.getAllSubTaskCount() == 0) {
            return SUBPROJECT_COLOR;
        }
        return WBS_COLOR;
    }

    protected Color getGanttMilestoneColor(GanttTask ganttTask) {
        return this.paintMilestoneColor ? this.getGanttTaskColor(ganttTask) : Color.black;
    }

    protected Color getGanttTaskColor(GanttTask ganttTask) {
        return this.getHealthStatusColor(ganttTask);
    }

    static {
        CRITICAL_TASK_STROKE = BASIC_STROKE = new BasicStroke();
        CRITICAL_TASK_COLOR = new Color(255, 0, 115);
        NEAR_CRITICAL_TASK_STROKE = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{4.0f, 2.0f}, 0.0f);
        NEAR_CRITICAL_TASK_COLOR = CRITICAL_TASK_COLOR;
        LATE_DATES_STROKE = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{4.0f, 2.0f, 1.0f, 2.0f}, 0.0f);
        LATE_DATES_COLOR = Color.BLUE;
        DEADLINE_COLOR_OK = new Color(153, 153, 153);
        DEADLINE_COLOR_NG = new Color(255, 0, 0);
        LOW_COLOR = new Color(240, 240, 240, 148);
    }
}

