/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.pe.app.dialog;

import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.app.dialog.ItemPickerDialog;
import com.triloggroup.gantt.app.ui.WDButton;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.pe.app.PEAppProjectContext;
import com.triloggroup.gantt.pe.app.WBSUpdater;
import com.triloggroup.project.NameId;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.util.UString;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SubProjectPicker
extends JPanel
implements ActionListener,
Runnable {
    private static final int MIN_DIALOG_WIDTH = 250;
    private static final int MIN_DIALOG_HEIGHT = 150;
    static final String PROJECT_PROPERTY_NAME = "project";
    private JTextField nameTf;
    private WDButton bt;
    private PEAppProjectContext prjContext;
    private NameId project;
    private ItemPickerDialog<NameId> dialog;

    SubProjectPicker(PEAppProjectContext pEAppProjectContext) {
        super(new BorderLayout(2, 2));
        this.prjContext = pEAppProjectContext;
        this.nameTf = new JTextField();
        this.nameTf.setEditable(false);
        this.bt = new WDButton(" ... ");
        Dimension dimension = this.bt.getPreferredSize();
        dimension.height = this.nameTf.getPreferredSize().height;
        this.bt.setPreferredSize(dimension);
        this.bt.addActionListener(this);
        this.add((Component)this.nameTf, "Center");
        this.add((Component)this.bt, "East");
    }

    public void setProject(NameId nameId) {
        if (nameId == this.project) {
            return;
        }
        NameId nameId2 = this.project;
        this.project = nameId;
        if (nameId == null || nameId == WBSUpdater.DUMMY_SUBPROJECT) {
            this.nameTf.setText("");
        } else if (UString.isEmpty(nameId.getName())) {
            String string = Workbench.getNLSString("unknowProject", new Object[0]);
            string = "<" + string.toUpperCase(Workbench.get().getLocale()) + ">";
            this.nameTf.setText(string);
        } else {
            this.nameTf.setText(nameId.getName());
        }
        this.firePropertyChange(PROJECT_PROPERTY_NAME, nameId2, nameId);
    }

    public NameId getProject() {
        return this.project;
    }

    public boolean isEditable() {
        return this.bt.isEnabled();
    }

    public void setEditable(boolean bl) {
        this.bt.setEnabled(bl);
    }

    @Override
    public void requestFocus() {
        this.bt.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.dialog != null) {
            return;
        }
        Window window = SwingUtilities.getWindowAncestor(this);
        this.dialog = new ItemPickerDialog(window, this.getGraphicsConfiguration());
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                if (SubProjectPicker.this.dialog != windowEvent.getSource()) {
                    return;
                }
                NameId nameId = (NameId)SubProjectPicker.this.dialog.getSingleSelection();
                if (nameId != null) {
                    SubProjectPicker.this.setProject(nameId);
                }
                SubProjectPicker.this.dialog = null;
            }
        });
        this.dialog.initWaiting();
        new Thread(this).start();
        this.dialog.setVisible(250, 150, -1, -1, this);
    }

    @Override
    public void run() {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        Throwable throwable = null;
        Object[] objectArray = null;
        try {
            arrayList2 = new ArrayList();
            arrayList = new ArrayList<String>();
            TGNode tGNode = this.prjContext.getModel().getRootNode();
            while (tGNode.getParent() != null) {
                tGNode = tGNode.getParent();
            }
            this.walkNodes(tGNode, arrayList2, arrayList);
            objectArray = this.prjContext.getWSHelper().getAvailableSubprojects(arrayList2.toArray(new String[0]), arrayList.toArray(new String[0]));
            Arrays.sort(objectArray);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throwable2.printStackTrace();
        }
        arrayList2 = throwable;
        arrayList = objectArray;
        SwingUtilities.invokeLater(new Runnable((Throwable)((Object)arrayList2), (NameId[])arrayList){
            final /* synthetic */ Throwable val$ft;
            final /* synthetic */ NameId[] val$favailable;
            {
                this.val$ft = throwable;
                this.val$favailable = nameIdArray;
            }

            public void run() {
                if (SubProjectPicker.this.dialog == null) {
                    return;
                }
                if (this.val$ft != null) {
                    WDDialog.showErrorMsgDialog(SubProjectPicker.this, this.val$ft);
                    SubProjectPicker.this.dialog.dispose();
                    return;
                }
                SubProjectPicker.this.dialog.setResizable(true);
                if (this.val$favailable == null || this.val$favailable.length == 0) {
                    // empty if block
                }
                SubProjectPicker.this.dialog.init(this.val$favailable, false);
            }
        });
    }

    private void walkNodes(TGNode tGNode, ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        if (!(tGNode instanceof GanttWBS)) {
            return;
        }
        GanttWBS ganttWBS = (GanttWBS)tGNode;
        if (ganttWBS.isSubProject()) {
            String string = ganttWBS.getSubProject().getId();
            arrayList.add(string);
            if (ganttWBS.getAllSubTaskCount() > 0) {
                arrayList2.add(string);
            }
        }
        for (int i = 0; i < tGNode.getAllSubTaskCount(); ++i) {
            TGNode tGNode2 = tGNode.getSubtaskInAll(i);
            this.walkNodes(tGNode2, arrayList, arrayList2);
        }
    }
}

