/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.pe.app;

import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.TGDuration;
import com.triloggroup.gantt.TaskResource;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.AppGanttChartModel;
import com.triloggroup.gantt.app.ChangeCanceledException;
import com.triloggroup.gantt.app.Status;
import com.triloggroup.gantt.app.UnexpectedChangeException;
import com.triloggroup.gantt.app.change.Change;
import com.triloggroup.gantt.app.change.ChangeException;
import com.triloggroup.gantt.app.change.ParentFieldValue;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.pe.app.AppScheduleComputation;
import com.triloggroup.gantt.pe.app.NodeUpdater;
import com.triloggroup.gantt.pe.app.PEAppGanttChartModel;
import com.triloggroup.project.schedule.ITaskSchedule;
import com.triloggroup.project.schedule.Predecessor;
import com.triloggroup.project.schedule.ScheduleCst;
import com.triloggroup.util.UString;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Date;
import org.jfree.data.time.TimePeriod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskUpdater
extends NodeUpdater<GanttTask> {
    private int interactiveMode;
    private static boolean isRevertingChangeOnError = false;

    public TaskUpdater(GanttTask ganttTask, GanttTask ganttTask2, AppGanttChartModel appGanttChartModel, Component component, int n) {
        super(ganttTask, ganttTask2, (PEAppGanttChartModel)appGanttChartModel, component);
        this.interactiveMode = n;
    }

    public void checkAndCompute() throws ChangeException {
        this.firstLevelCheck();
        if (((GanttTask)this.copy).getLevel() > 32) {
            throw new ChangeException("error_max_level_32", "parentInternalId", this.getSourceName());
        }
        if (this.isScheduleShouldBeUpdated()) {
            try {
                this.ganttModel.getProjectModel(((GanttTask)this.copy).getProjectId()).getScheduleComputation().computeTaskValues((GanttTask)this.copy, (GanttTask)this.original);
            }
            catch (ChangeException changeException) {
                throw changeException;
            }
            catch (Exception exception) {
                throw new UnexpectedChangeException(exception);
            }
        }
    }

    protected void firstLevelCheck() throws ChangeException {
        double d;
        if (((GanttTask)this.copy).getParent() == null) {
            throw new ChangeException("wbs_empty", "parentInternalId", this.getSourceName());
        }
        if (UString.isEmpty(((GanttTask)this.copy).getName())) {
            throw new ChangeException("name_empty", "name", this.getSourceName());
        }
        Double d2 = ((GanttTask)this.copy).getPercentComplete();
        double d3 = d = d2 == null ? -1.0 : d2;
        if (d < 0.0 || d > 1.0) {
            throw new ChangeException("percentCompletNumberError", "percentComplete", this.getSourceName());
        }
        if (((GanttTask)this.copy).getSchedulingMode() == 2 && ((GanttTask)this.copy).getStartDate().after(((GanttTask)this.copy).getFinishDate())) {
            throw new ChangeException("startAfterEnd", "startDate", this.getSourceName());
        }
        if (((GanttTask)this.copy).getDurationDisplay() < 0.0) {
            throw new ChangeException("durationDisplayError", "durationdisplay", this.getSourceName());
        }
        if (((GanttTask)this.copy).getWorkDisplay() < 0.0) {
            throw new ChangeException("workDisplayError", "workdisplay", this.getSourceName());
        }
        int n = ((GanttTask)this.copy).getPriority();
        if (n < 0 || n > 1000) {
            throw new ChangeException("priorityNumberError", "priority", this.getSourceName());
        }
        Date date = ((GanttTask)this.copy).getActualStartDate();
        Date date2 = ((GanttTask)this.copy).getActualFinishDate();
        if (date != null && date2 != null && date.after(date2)) {
            throw new ChangeException("actualStartAfterActualEnd", "actualstart", this.getSourceName());
        }
    }

    public void beforeUpdate() throws ChangeCanceledException {
        if (this.ganttModel.getProjectModel(((GanttTask)this.copy).getProjectId()).isAutomaticReschedule()) {
            this.beforeUpdateSmartScheduling();
            return;
        }
        Status status = Status.fromCode(((GanttTask)this.copy).getStatus());
        double d = ((GanttTask)this.copy).getPercentComplete();
        boolean bl = ((GanttTask)this.copy).getActualStartDate() != null;
        boolean bl2 = ((GanttTask)this.copy).getActualFinishDate() != null;
        Date date = this.ganttModel.getGlobalContext().convertToServerTimeZone(this.ganttModel.getGlobalContext().getServerTime());
        if (status == Status.PENDING) {
            if (bl2) {
                this.ask(bl ? "invalid_status_pending_actualStartEnd" : "invalid_status_pending_actualEnd");
                status = Status.DONE;
                ((GanttTask)this.copy).setPercentComplete(1.0);
                if (!bl) {
                    ((GanttTask)this.copy).setActualStartDate(this.min(date, this.min(((GanttTask)this.copy).getStartDate(), ((GanttTask)this.copy).getActualFinishDate())));
                }
            } else if (d == 1.0) {
                this.ask("invalid_status_pending_100");
                status = Status.DONE;
                if (!bl) {
                    ((GanttTask)this.copy).setActualStartDate(this.min(date, ((GanttTask)this.copy).getStartDate()));
                }
            } else if (bl) {
                this.ask("invalid_status_pending_actualStart");
                status = Status.IN_PROGRESS;
            } else if (d > 0.0) {
                this.ask("invalid_status_pending_1-99");
                status = Status.IN_PROGRESS;
                ((GanttTask)this.copy).setActualStartDate((Date)date.clone());
            }
        } else if (status == Status.IN_PROGRESS) {
            if (bl2) {
                this.ask(bl ? "invalid_status_in_progress_actualStartEnd" : "invalid_status_in_progress_actualEnd");
                status = Status.DONE;
                ((GanttTask)this.copy).setPercentComplete(1.0);
                if (!bl) {
                    ((GanttTask)this.copy).setActualStartDate(this.min(date, this.min(((GanttTask)this.copy).getStartDate(), ((GanttTask)this.copy).getActualFinishDate())));
                }
            } else if (d == 1.0) {
                this.ask("invalid_status_in_progress_100");
                status = Status.DONE;
                if (!bl) {
                    ((GanttTask)this.copy).setActualStartDate(this.min(date, ((GanttTask)this.copy).getStartDate()));
                }
            } else if (!bl) {
                if (d == 0.0) {
                    this.ask("invalid_status_in_progress_noActualStart_0");
                    status = Status.PENDING;
                } else {
                    this.ask("invalid_status_in_progress_noActualStart");
                    ((GanttTask)this.copy).setActualStartDate((Date)date.clone());
                }
            }
        } else if (d != 1.0) {
            this.ask("invalid_status_done_0-99");
            status = Status.IN_PROGRESS;
            ((GanttTask)this.copy).setActualFinishDate(null);
            if (!bl) {
                ((GanttTask)this.copy).setActualStartDate((Date)date.clone());
            }
        } else if (!bl) {
            if (bl2) {
                ((GanttTask)this.copy).setActualStartDate(this.min(date, this.min(((GanttTask)this.copy).getStartDate(), ((GanttTask)this.copy).getActualFinishDate())));
            } else {
                ((GanttTask)this.copy).setActualStartDate(this.min(date, ((GanttTask)this.copy).getStartDate()));
            }
        }
        if (!UString.equals(status.getCode(), ((GanttTask)this.copy).getStatus())) {
            ((GanttTask)this.copy).setStatus(status.getCode());
        }
        if (status == Status.DONE) {
            ((GanttTask)this.copy).resetSpecifiedRemainingWork();
            if (!bl2) {
                ((GanttTask)this.copy).setActualFinishDate(this.max(date, ((GanttTask)this.copy).getActualStartDate()));
            }
        } else if (status == Status.PENDING) {
            ((GanttTask)this.copy).resetSpecifiedActualWork();
        }
    }

    private void beforeUpdateSmartScheduling() throws ChangeCanceledException {
        boolean bl;
        Status status = Status.fromCode(((GanttTask)this.copy).getStatus());
        double d = ((GanttTask)this.copy).getPercentComplete();
        boolean bl2 = ((GanttTask)this.copy).getActualStartDate() != null;
        boolean bl3 = bl = ((GanttTask)this.copy).getActualFinishDate() != null;
        if (status == Status.PENDING) {
            if (bl) {
                this.ask(bl2 ? "invalid_status_pending_actualStartEnd" : "invalid_status_pending_actualEnd");
                status = Status.DONE;
                ((GanttTask)this.copy).setPercentComplete(1.0);
                if (!bl2) {
                    ((GanttTask)this.copy).setActualStartDate(this.min(((GanttTask)this.copy).getStartDate(), ((GanttTask)this.copy).getActualFinishDate()));
                }
            } else if (d == 1.0) {
                this.ask("invalid_status_pending_100");
                status = Status.DONE;
                if (!bl2) {
                    ((GanttTask)this.copy).setActualStartDate((Date)((GanttTask)this.copy).getStartDate().clone());
                    ((GanttTask)this.copy).setActualFinishDate((Date)((GanttTask)this.copy).getFinishDate().clone());
                } else {
                    ((GanttTask)this.copy).setActualFinishDate(this.max(((GanttTask)this.copy).getFinishDate(), ((GanttTask)this.copy).getActualStartDate()));
                }
            } else if (bl2) {
                this.ask("invalid_status_pending_actualStart");
                status = Status.IN_PROGRESS;
            } else if (d > 0.0) {
                this.ask("invalid_status_pending_1-99");
                status = Status.IN_PROGRESS;
                ((GanttTask)this.copy).setActualStartDate((Date)((GanttTask)this.copy).getStartDate().clone());
            }
        } else if (status == Status.IN_PROGRESS) {
            if (bl) {
                this.ask(bl2 ? "invalid_status_in_progress_actualStartEnd" : "invalid_status_in_progress_actualEnd");
                status = Status.DONE;
                ((GanttTask)this.copy).setPercentComplete(1.0);
                if (!bl2) {
                    ((GanttTask)this.copy).setActualStartDate(this.min(((GanttTask)this.copy).getStartDate(), ((GanttTask)this.copy).getActualFinishDate()));
                }
            } else if (d == 1.0) {
                this.ask("invalid_status_in_progress_100");
                status = Status.DONE;
                if (!bl2) {
                    ((GanttTask)this.copy).setActualStartDate((Date)((GanttTask)this.copy).getStartDate().clone());
                    ((GanttTask)this.copy).setActualFinishDate((Date)((GanttTask)this.copy).getFinishDate().clone());
                } else {
                    ((GanttTask)this.copy).setActualFinishDate(this.max(((GanttTask)this.copy).getFinishDate(), ((GanttTask)this.copy).getActualStartDate()));
                }
            } else if (!bl2) {
                if (d == 0.0) {
                    this.ask("invalid_status_in_progress_noActualStart_0");
                    status = Status.PENDING;
                } else {
                    this.ask("invalid_status_in_progress_noActualStart");
                    ((GanttTask)this.copy).setActualStartDate((Date)((GanttTask)this.copy).getStartDate().clone());
                }
            }
        } else if (d != 1.0) {
            this.ask("invalid_status_done_0-99");
            status = Status.IN_PROGRESS;
            ((GanttTask)this.copy).setActualFinishDate(null);
            if (!bl2) {
                ((GanttTask)this.copy).setActualStartDate((Date)((GanttTask)this.copy).getStartDate().clone());
            }
        } else if (!bl2) {
            if (bl) {
                ((GanttTask)this.copy).setActualStartDate(this.min(((GanttTask)this.copy).getStartDate(), ((GanttTask)this.copy).getActualFinishDate()));
            } else {
                ((GanttTask)this.copy).setActualStartDate((Date)((GanttTask)this.copy).getStartDate().clone());
                ((GanttTask)this.copy).setActualFinishDate((Date)((GanttTask)this.copy).getFinishDate().clone());
            }
        } else if (!bl) {
            ((GanttTask)this.copy).setActualFinishDate(this.max(((GanttTask)this.copy).getFinishDate(), ((GanttTask)this.copy).getActualStartDate()));
        }
        if (!UString.equals(status.getCode(), ((GanttTask)this.copy).getStatus())) {
            ((GanttTask)this.copy).setStatus(status.getCode());
        }
        if (status == Status.DONE) {
            ((GanttTask)this.copy).resetSpecifiedRemainingWork();
        } else if (status == Status.PENDING) {
            ((GanttTask)this.copy).resetSpecifiedActualWork();
        }
    }

    private void ask(String string) throws ChangeCanceledException {
        if (this.interactiveMode < 100) {
            return;
        }
        String string2 = "<html>" + this.getSourceName() + "<br>";
        String string3 = AppGanttChart.NLS_BUNDLE.getString(string);
        string2 = string3.startsWith("<html>") ? string2 + string3.substring(6) : string2 + string3 + "</html>";
        if (!WDDialog.showYesNoDialog(this.getUIComponent(), this.getSourceName(), string2)) {
            throw new ChangeCanceledException();
        }
    }

    private AppScheduleComputation getScheduleComputation() {
        return this.ganttModel.getProjectModel(((GanttTask)this.copy).getProjectId()).getScheduleComputation();
    }

    protected void setWorkFromDuration(GanttTask ganttTask, TGDuration tGDuration) throws Exception {
        this.getScheduleComputation().setWorkFromDuration(ganttTask, tGDuration);
    }

    protected void setDurationFromWork(GanttTask ganttTask, TGDuration tGDuration) throws Exception {
        this.getScheduleComputation().setDurationFromWork(ganttTask, tGDuration);
    }

    protected void setDurationFromDates(GanttTask ganttTask, Date date) throws Exception {
        this.getScheduleComputation().setDurationFromDates(ganttTask, date);
    }

    protected boolean isSameDay(Date date, Date date2) {
        return this.getScheduleComputation().isSameDay(date, date2);
    }

    private Date max(Date date, Date date2) {
        if (date == null) {
            return date2 == null ? null : (Date)date2.clone();
        }
        if (date2 == null || date.after(date2)) {
            return (Date)date.clone();
        }
        return (Date)date2.clone();
    }

    private Date min(Date date, Date date2) {
        if (date == null) {
            return date2 == null ? null : (Date)date2.clone();
        }
        if (date2 == null || date.before(date2)) {
            return (Date)date.clone();
        }
        return (Date)date2.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Change checkComputeAndUpdateOriginal() throws ChangeException, ChangeCanceledException {
        Change change = null;
        this.checkAndCompute();
        this.beforeUpdate();
        boolean bl = false;
        GanttWBS ganttWBS = null;
        if (this.original != null) {
            if (((GanttTask)this.copy).getStartDate().getTime() != ((GanttTask)this.original).getStartDate().getTime() || ((GanttTask)this.copy).getFinishDate().getTime() != ((GanttTask)this.original).getFinishDate().getTime()) {
                bl = true;
            }
            if (!UString.equals(((GanttTask)this.copy).getHierarchicalId(), ((GanttTask)this.original).getHierarchicalId())) {
                ganttWBS = this.ganttModel.getProjectModel(((GanttTask)this.original).getProjectId()).getWBSByHierarchicalId(((GanttTask)this.original).getParentHierarchicalId());
            }
        }
        if (!Change.isNullOperation(change = this.updateTask())) {
            try {
                if (this.original != null) {
                    this.ganttModel.getProjectModel(((GanttTask)this.original).getProjectId()).getScheduleComputation().onPostUpdateTaskValues((GanttTask)this.original, bl, ganttWBS);
                } else {
                    this.ganttModel.getProjectModel(((GanttTask)this.copy).getProjectId()).getScheduleComputation().onPostUpdateTaskValues((GanttTask)this.copy, bl, ganttWBS);
                }
            }
            catch (Exception exception) {
                if (isRevertingChangeOnError) {
                    System.out.println("Unable to revert change");
                } else {
                    System.out.println("Task update failed. Revert change.");
                    try {
                        isRevertingChangeOnError = true;
                        this.ganttModel.getChangeManager().applyChange(change, true, true, null);
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                    finally {
                        isRevertingChangeOnError = false;
                    }
                    this.ganttModel.getProjectModel(((GanttTask)this.copy).getProjectId()).setUpdatingResources(false);
                }
                throw new UnexpectedChangeException(exception);
            }
        }
        return change;
    }

    protected Change updateTask() {
        Object object;
        TimePeriod timePeriod;
        Change change = this.updateNode();
        if (this.original != null) {
            if (((GanttTask)this.copy).getProgress() != ((GanttTask)this.original).getProgress()) {
                change.addModification("percentComplete", ((GanttTask)this.original).getPercentComplete(), ((GanttTask)this.copy).getPercentComplete());
                ((GanttTask)this.original).setPercentComplete(((GanttTask)this.copy).getPercentComplete());
            }
        } else {
            change.addModification("percentComplete", null, ((GanttTask)this.copy).getPercentComplete());
        }
        if (this.original != null) {
            timePeriod = ((GanttTask)this.copy).getDuration();
            object = ((GanttTask)this.original).getDuration();
            if (!this.isDatesEquals(timePeriod.getStart(), object.getStart())) {
                change.addModification("startDate", object.getStart(), timePeriod.getStart());
                if (!this.isDatesEquals(timePeriod.getEnd(), object.getEnd())) {
                    change.addModification("endDate", object.getEnd(), timePeriod.getEnd());
                    ((GanttTask)this.original).setDuration(timePeriod.getStart(), timePeriod.getEnd());
                } else {
                    object.getStart().setTime(timePeriod.getStart().getTime());
                }
            } else if (!this.isDatesEquals(timePeriod.getEnd(), object.getEnd())) {
                change.addModification("endDate", object.getEnd(), timePeriod.getEnd());
                object.getEnd().setTime(timePeriod.getEnd().getTime());
            }
        } else {
            timePeriod = ((GanttTask)this.copy).getDuration();
            if (timePeriod != null) {
                change.addModification("startDate", null, timePeriod.getStart());
                change.addModification("endDate", null, timePeriod.getEnd());
            }
        }
        if (this.original != null) {
            if (!UString.equals(((GanttTask)this.copy).getStatus(), ((GanttTask)this.original).getStatus())) {
                change.addModification("status", ((GanttTask)this.original).getStatus(), ((GanttTask)this.copy).getStatus());
                ((GanttTask)this.original).setStatus(((GanttTask)this.copy).getStatus());
            }
        } else {
            change.addModification("status", null, ((GanttTask)this.copy).getStatus());
        }
        if (this.original != null) {
            if (!this.isDatesEquals(((GanttTask)this.copy).getActualStartDate(), ((GanttTask)this.original).getActualStartDate())) {
                change.addModification("actualstart", ((GanttTask)this.original).getActualStartDate(), ((GanttTask)this.copy).getActualStartDate());
                ((GanttTask)this.original).setActualStartDate(((GanttTask)this.copy).getActualStartDate());
            }
        } else if (((GanttTask)this.copy).getActualStartDate() != null) {
            change.addModification("actualstart", null, ((GanttTask)this.copy).getActualStartDate());
        }
        if (this.original != null) {
            if (!this.isDatesEquals(((GanttTask)this.copy).getActualFinishDate(), ((GanttTask)this.original).getActualFinishDate())) {
                change.addModification("actualfinish", ((GanttTask)this.original).getActualFinishDate(), ((GanttTask)this.copy).getActualFinishDate());
                ((GanttTask)this.original).setActualFinishDate(((GanttTask)this.copy).getActualFinishDate());
            }
        } else if (((GanttTask)this.copy).getActualFinishDate() != null) {
            change.addModification("actualfinish", null, ((GanttTask)this.copy).getActualFinishDate());
        }
        if (this.original != null) {
            if (((GanttTask)this.copy).isSkipAutoReschedule() != ((GanttTask)this.original).isSkipAutoReschedule()) {
                change.addBooleanModification("skipautoreschedule", ((GanttTask)this.original).isSkipAutoReschedule(), ((GanttTask)this.copy).isSkipAutoReschedule());
                ((GanttTask)this.original).setSkipAutoReschedule(((GanttTask)this.copy).isSkipAutoReschedule());
            }
        } else {
            change.addBooleanModification("skipautoreschedule", false, ((GanttTask)this.copy).isSkipAutoReschedule());
        }
        if (this.original != null) {
            if (((GanttTask)this.copy).getWorkDisplay() != ((GanttTask)this.original).getWorkDisplay()) {
                change.addDoubleModification("workdisplay", ((GanttTask)this.original).getWorkDisplay(), ((GanttTask)this.copy).getWorkDisplay());
                ((GanttTask)this.original).setWorkDisplay(((GanttTask)this.copy).getWorkDisplay());
            }
        } else {
            change.addDoubleModification("workdisplay", -1.0, ((GanttTask)this.copy).getWorkDisplay());
        }
        if (this.original != null) {
            if (((GanttTask)this.copy).getWorkFormat() != ((GanttTask)this.original).getWorkFormat()) {
                change.addIntModification("workformat", ((GanttTask)this.original).getWorkFormat(), ((GanttTask)this.copy).getWorkFormat());
                ((GanttTask)this.original).setWorkFormat(((GanttTask)this.copy).getWorkFormat());
            }
        } else {
            change.addIntModification("workformat", -1, ((GanttTask)this.copy).getWorkFormat());
        }
        if (this.original != null) {
            if (((GanttTask)this.copy).getWorkInHours() != ((GanttTask)this.original).getWorkInHours()) {
                change.addDoubleModification("work", ((GanttTask)this.original).getWorkInHours(), ((GanttTask)this.copy).getWorkInHours());
                ((GanttTask)this.original).setWorkInHours(((GanttTask)this.copy).getWorkInHours());
            }
        } else {
            change.addDoubleModification("work", -1.0, ((GanttTask)this.copy).getWorkInHours());
        }
        if (this.original != null) {
            if (((GanttTask)this.copy).getDurationFormat() != ((GanttTask)this.original).getDurationFormat()) {
                change.addIntModification("durationformat", ((GanttTask)this.original).getDurationFormat(), ((GanttTask)this.copy).getDurationFormat());
                ((GanttTask)this.original).setDurationFormat(((GanttTask)this.copy).getDurationFormat());
            }
        } else {
            change.addIntModification("durationformat", -1, ((GanttTask)this.copy).getDurationFormat());
        }
        if (this.original != null) {
            if (((GanttTask)this.copy).getDurationInHours() != ((GanttTask)this.original).getDurationInHours()) {
                change.addDoubleModification("durationInHours", ((GanttTask)this.original).getDurationInHours(), ((GanttTask)this.copy).getDurationInHours());
                ((GanttTask)this.original).setDurationInHours(((GanttTask)this.copy).getDurationInHours());
            }
        } else {
            change.addDoubleModification("durationInHours", -1.0, ((GanttTask)this.copy).getDurationInHours());
        }
        if (this.original != null) {
            if (((GanttTask)this.copy).getDurationDisplay() != ((GanttTask)this.original).getDurationDisplay()) {
                change.addDoubleModification("durationdisplay", ((GanttTask)this.original).getDurationDisplay(), ((GanttTask)this.copy).getDurationDisplay());
                ((GanttTask)this.original).setDurationDisplay(((GanttTask)this.copy).getDurationDisplay());
            }
        } else {
            change.addDoubleModification("durationdisplay", -1.0, ((GanttTask)this.copy).getDurationDisplay());
        }
        if (this.original != null) {
            if (!this.areSameTaskResources(((GanttTask)this.copy).getResources(), ((GanttTask)this.original).getResources())) {
                change.addModification("taskResources", ((GanttTask)this.original).getResourcesCopy(), ((GanttTask)this.copy).getResourcesCopy());
                ((GanttTask)this.original).setResources(((GanttTask)this.copy).getResourcesCopy());
            } else {
                timePeriod = ((GanttTask)this.copy).getResources();
                object = ((GanttTask)this.original).getResources();
                for (int i = 0; i < ((TaskResource[])timePeriod).length; ++i) {
                    object[i].setWork(timePeriod[i].getWork());
                }
            }
        } else if (((GanttTask)this.copy).getResourcesCopy() != null) {
            change.addModification("taskResources", null, ((GanttTask)this.copy).getResourcesCopy());
        }
        if (this.original != null) {
            if (!this.haveSamePredecessors((GanttTask)this.copy, (GanttTask)this.original)) {
                change.addModification("taskPredecessors", ((GanttTask)this.original).getPredecessorsCopy(), ((GanttTask)this.copy).getPredecessorsCopy());
                ((GanttTask)this.original).setPredecessors(((GanttTask)this.copy).getPredecessorsCopy());
            }
        } else if (((GanttTask)this.copy).getPredecessorsCopy() != null) {
            change.addModification("taskPredecessors", null, ((GanttTask)this.copy).getPredecessorsCopy());
        }
        if (this.original != null) {
            if (!this.isDatesEquals(((GanttTask)this.copy).getDeadlineDate(), ((GanttTask)this.original).getDeadlineDate())) {
                change.addModification("deadline", ((GanttTask)this.original).getDeadlineDate(), ((GanttTask)this.copy).getDeadlineDate());
                ((GanttTask)this.original).setDeadlineDate(((GanttTask)this.copy).getDeadlineDate());
            }
        } else if (((GanttTask)this.copy).getDeadlineDate() != null) {
            change.addModification("deadline", null, ((GanttTask)this.copy).getDeadlineDate());
        }
        if (this.original != null) {
            if (((GanttTask)this.copy).getPriority() != ((GanttTask)this.original).getPriority()) {
                change.addIntModification("priority", ((GanttTask)this.original).getPriority(), ((GanttTask)this.copy).getPriority());
                ((GanttTask)this.original).setPriority(((GanttTask)this.copy).getPriority());
            }
        } else {
            change.addIntModification("priority", -1, ((GanttTask)this.copy).getPriority());
        }
        if (this.original != null) {
            if (((GanttTask)this.copy).getSchedulingMode() != ((GanttTask)this.original).getSchedulingMode()) {
                change.addIntModification("schedulingmode", ((GanttTask)this.original).getSchedulingMode(), ((GanttTask)this.copy).getSchedulingMode());
                ((GanttTask)this.original).setSchedulingMode(((GanttTask)this.copy).getSchedulingMode());
            }
        } else {
            change.addIntModification("schedulingmode", -1, ((GanttTask)this.copy).getSchedulingMode());
        }
        if (this.original != null) {
            if (!UString.equals(((GanttTask)this.copy).getCalendarId(), ((GanttTask)this.original).getCalendarId())) {
                change.addModification("calendarid", ((GanttTask)this.original).getCalendarId(), ((GanttTask)this.copy).getCalendarId());
                ((GanttTask)this.original).setCalendarId(((GanttTask)this.copy).getCalendarId());
            }
        } else {
            change.addModification("calendarid", null, ((GanttTask)this.copy).getCalendarId());
        }
        if (this.original != null) {
            if (((GanttTask)this.copy).isIgnoreResourcesCalendar() != ((GanttTask)this.original).isIgnoreResourcesCalendar()) {
                change.addBooleanModification("ignoreresourcecalendar", ((GanttTask)this.original).isIgnoreResourcesCalendar(), ((GanttTask)this.copy).isIgnoreResourcesCalendar());
                ((GanttTask)this.original).setIgnoreResourcesCalendar(((GanttTask)this.copy).isIgnoreResourcesCalendar());
            }
        } else {
            change.addBooleanModification("ignoreresourcecalendar", false, ((GanttTask)this.copy).isIgnoreResourcesCalendar());
        }
        if (this.original == null || !UString.equals(((GanttTask)this.copy).getHierarchicalId(), ((GanttTask)this.original).getHierarchicalId())) {
            timePeriod = this.original == null ? null : ((GanttTask)this.original).getHierarchicalId();
            object = null;
            GanttWBS ganttWBS = null;
            if (this.original != null) {
                ganttWBS = this.ganttModel.getProjectModel(((GanttTask)this.original).getProjectId()).getWBSByHierarchicalId(((GanttTask)this.original).getParentHierarchicalId());
                object = ganttWBS.getUid();
                ganttWBS.removeSubtask(this.original);
            }
            ParentFieldValue parentFieldValue = new ParentFieldValue((String)object, (String)timePeriod);
            GanttWBS ganttWBS2 = this.ganttModel.getProjectModel(((GanttTask)this.copy).getProjectId()).getWBSByHierarchicalId(((GanttTask)this.copy).getParentHierarchicalId());
            String string = ganttWBS2.getUid();
            ParentFieldValue parentFieldValue2 = new ParentFieldValue(string);
            change.addModification("parentInternalId", parentFieldValue, parentFieldValue2);
            if (this.original != null) {
                ((GanttTask)this.original).setHierarchicalId(((GanttTask)this.copy).getHierarchicalId());
                ganttWBS2.addSubtask(this.original);
                this.ganttModel.recomputeIdsForWbsIfChanged(ganttWBS);
            } else {
                ganttWBS2.addSubtask(this.copy);
            }
            this.ganttModel.recomputeIdsForWbsIfChanged(ganttWBS2);
        }
        if (this.original != null) {
            if (((GanttTask)this.copy).getSpecifiedActualWork() != ((GanttTask)this.original).getSpecifiedActualWork()) {
                change.addDoubleModification("actualWork", ((GanttTask)this.original).getSpecifiedActualWork(), ((GanttTask)this.copy).getSpecifiedActualWork());
                ((GanttTask)this.original).setSpecifiedActualWork(((GanttTask)this.copy).getSpecifiedActualWork());
            }
        } else {
            change.addDoubleModification("actualWork", -1.0, ((GanttTask)this.copy).getSpecifiedActualWork());
        }
        if (this.original != null) {
            if (((GanttTask)this.copy).getSpecifiedRemainingWork() != ((GanttTask)this.original).getSpecifiedRemainingWork()) {
                change.addDoubleModification("remainWork", ((GanttTask)this.original).getSpecifiedRemainingWork(), ((GanttTask)this.copy).getSpecifiedRemainingWork());
                ((GanttTask)this.original).setSpecifiedRemainingWork(((GanttTask)this.copy).getSpecifiedRemainingWork());
            }
        } else {
            change.addDoubleModification("remainWork", -1.0, ((GanttTask)this.copy).getSpecifiedRemainingWork());
        }
        return change;
    }

    protected boolean isDatesEquals(Date date, Date date2) {
        if (date == null || date2 == null) {
            return date == null && date2 == null;
        }
        return date.getTime() == date2.getTime();
    }

    protected boolean areSameTaskResources(TaskResource[] taskResourceArray, TaskResource[] taskResourceArray2) {
        if (taskResourceArray != null) {
            if (taskResourceArray2 != null) {
                if (taskResourceArray.length != taskResourceArray2.length) {
                    return false;
                }
                for (int i = 0; i < taskResourceArray.length; ++i) {
                    if (UString.equals(taskResourceArray[i].getResource().getDn(), taskResourceArray2[i].getResource().getDn()) && taskResourceArray[i].isWorkSpecified() == taskResourceArray2[i].isWorkSpecified() && taskResourceArray[i].getUnit() == taskResourceArray2[i].getUnit() && (!taskResourceArray[i].isWorkSpecified() || taskResourceArray[i].getWork() == taskResourceArray2[i].getWork())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return taskResourceArray2 == null;
    }

    protected boolean haveSamePredecessors(GanttTask ganttTask, GanttTask ganttTask2) {
        if (ganttTask.getPredecessorsCount() != ganttTask2.getPredecessorsCount()) {
            return false;
        }
        for (int i = 0; i < ganttTask.getPredecessorsCount(); ++i) {
            Predecessor predecessor = ganttTask.getPredecessor(i);
            Predecessor predecessor2 = ganttTask2.getPredecessor(i);
            if (!predecessor.getId().equals(predecessor2.getId())) {
                return false;
            }
            if (predecessor.getType() != predecessor2.getType()) {
                return false;
            }
            if (predecessor.getLag() != predecessor2.getLag()) {
                return false;
            }
            if (predecessor.getLagFormat() == predecessor2.getLagFormat()) continue;
            return false;
        }
        return true;
    }

    protected boolean isScheduleShouldBeUpdated() {
        if (this.original == null) {
            return true;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!UString.equals(((GanttTask)this.copy).getName(), ((GanttTask)this.original).getName())) {
            arrayList.add("taskname");
        }
        if (!UString.equals(((GanttTask)this.copy).getNodeDescription(), ((GanttTask)this.original).getNodeDescription())) {
            arrayList.add("taskdescription");
        }
        if (((GanttTask)this.copy).getProgress() != ((GanttTask)this.original).getProgress()) {
            arrayList.add("percentage");
        }
        TimePeriod timePeriod = ((GanttTask)this.copy).getDuration();
        TimePeriod timePeriod2 = ((GanttTask)this.original).getDuration();
        if (!this.isDatesEquals(timePeriod.getStart(), timePeriod2.getStart())) {
            arrayList.add("startdate");
        }
        if (!this.isDatesEquals(timePeriod.getEnd(), timePeriod2.getEnd())) {
            arrayList.add("enddate");
        }
        if (!UString.equals(((GanttTask)this.copy).getStatus(), ((GanttTask)this.original).getStatus())) {
            arrayList.add("status");
        }
        if (!this.isDatesEquals(((GanttTask)this.copy).getActualStartDate(), ((GanttTask)this.original).getActualStartDate())) {
            arrayList.add("actualstart");
        }
        if (!this.isDatesEquals(((GanttTask)this.copy).getActualFinishDate(), ((GanttTask)this.original).getActualFinishDate())) {
            arrayList.add("actualfinish");
        }
        if (((GanttTask)this.copy).isSkipAutoReschedule() != ((GanttTask)this.original).isSkipAutoReschedule()) {
            arrayList.add("skipautoreschedule");
        }
        if (((GanttTask)this.copy).getWorkDisplay() != ((GanttTask)this.original).getWorkDisplay()) {
            arrayList.add("workinworkformat");
        }
        if (((GanttTask)this.copy).getWorkFormat() != ((GanttTask)this.original).getWorkFormat()) {
            arrayList.add("workformat");
        }
        if (((GanttTask)this.copy).getWorkInHours() != ((GanttTask)this.original).getWorkInHours()) {
            arrayList.add("work");
        }
        if (((GanttTask)this.copy).getDurationFormat() != ((GanttTask)this.original).getDurationFormat()) {
            arrayList.add("durationformat");
        }
        if (((GanttTask)this.copy).getDurationInHours() != ((GanttTask)this.original).getDurationInHours()) {
            arrayList.add("durationinhours");
        }
        if (((GanttTask)this.copy).getDurationDisplay() != ((GanttTask)this.original).getDurationDisplay()) {
            arrayList.add("duration");
        }
        if (!this.areSameTaskResources(((GanttTask)this.copy).getResources(), ((GanttTask)this.original).getResources())) {
            arrayList.add("user");
        }
        if (!this.haveSamePredecessors((GanttTask)this.copy, (GanttTask)this.original)) {
            arrayList.add("predecessors");
        }
        if (!this.isDatesEquals(((GanttTask)this.copy).getDeadlineDate(), ((GanttTask)this.original).getDeadlineDate())) {
            arrayList.add("deadline");
        }
        if (((GanttTask)this.copy).getPriority() != ((GanttTask)this.original).getPriority()) {
            arrayList.add("priority");
        }
        if (((GanttTask)this.copy).getSchedulingMode() != ((GanttTask)this.original).getSchedulingMode()) {
            arrayList.add("schedulingmode");
        }
        if (!UString.equals(((GanttTask)this.copy).getCalendarId(), ((GanttTask)this.original).getCalendarId())) {
            arrayList.add("calendarid");
        }
        if (((GanttTask)this.copy).isIgnoreResourcesCalendar() != ((GanttTask)this.original).isIgnoreResourcesCalendar()) {
            arrayList.add("ignoreresourcecalendar");
        }
        if (!UString.equals(((GanttTask)this.copy).getHierarchicalId(), ((GanttTask)this.original).getHierarchicalId())) {
            arrayList.add("wbsid");
            arrayList.add("wbssubid");
        }
        if (((GanttTask)this.copy).getSpecifiedRemainingWork() != ((GanttTask)this.original).getSpecifiedRemainingWork()) {
            arrayList.add("specifiedhrstocomplete");
        }
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return ScheduleCst.shouldComputeTaskSchedule(stringArray, this.ganttModel.getProjectModel(((GanttTask)this.copy).getProjectId()).getScheduleComputation().mustApplyAutomaticRescheduleOnTask((ITaskSchedule)((Object)this.copy)));
    }
}

