/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.pe.app;

import com.flowbuilder.util.xml.JDOMUtil;
import com.triloggroup.gantt.app.AppGlobalContext;
import java.util.Date;
import org.jdom.Element;

public class PEAppGlobalContext
extends AppGlobalContext {
    private String pePlatform;
    private boolean isLCActivityEnabled;
    private boolean hasChangesModule;
    private boolean hasIssuesModule;
    private boolean hasTimesheetModule;
    private boolean hasFinancialModule;
    private boolean hasBookmarkExtension = false;
    private Long clientServerTimeOffset = null;

    public PEAppGlobalContext(String string) {
        super(string);
    }

    public String getProjExecPlatform() {
        return this.pePlatform;
    }

    public boolean isLCActivityEnabled() {
        return this.isLCActivityEnabled;
    }

    public boolean hasChangesModule() {
        return this.hasChangesModule;
    }

    public boolean hasIssuesModule() {
        return this.hasIssuesModule;
    }

    public boolean hasFinancialModule() {
        return this.hasFinancialModule;
    }

    public boolean hasTimesheetModule() {
        return this.hasTimesheetModule;
    }

    public boolean hasBookmarkExtension() {
        return this.hasBookmarkExtension;
    }

    public void additionalInit(Element element) {
        Element element2 = element.getChild("global");
        try {
            this.setTimePrecision(JDOMUtil.getBoolean(element2, "TimePrecision"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Element element3 = element2.getChild("CurrentUser");
        if (element3 != null) {
            this.currentUserDn = element3.getChildText("dn");
            this.currentUserCn = element3.getChildText("cn");
        }
        this.hasBookmarkExtension = JDOMUtil.getBoolean(element2, "hasBookmarkExtension");
        this.pePlatform = element2.getChildText("ProjExecPlatform");
        this.isLCActivityEnabled = JDOMUtil.getBoolean(element2, "isLCActivity");
        this.hasChangesModule = JDOMUtil.getBoolean(element2, "hasChangesModule");
        this.hasIssuesModule = JDOMUtil.getBoolean(element2, "hasIssuesModule");
        this.hasFinancialModule = JDOMUtil.getBoolean(element, "FinancialsModule");
        this.hasTimesheetModule = JDOMUtil.getInteger(element, "TimesheetLevel") > 0;
        this.setEditable(JDOMUtil.getBoolean(element, "EditAccess"));
    }

    public Date getServerTime() {
        return new Date(System.currentTimeMillis() + this.clientServerTimeOffset);
    }

    public void computeClientServerTimeOffset(long l) {
        try {
            this.clientServerTimeOffset = l - System.currentTimeMillis();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.clientServerTimeOffset = 0L;
        }
    }
}

