/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.pe.app;

import com.triloggroup.gantt.GanttChartException;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.TGDuration;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.TaskResource;
import com.triloggroup.gantt.app.UnexpectedChangeException;
import com.triloggroup.gantt.app.change.ChangeException;
import com.triloggroup.gantt.pe.app.CalendarAccessor;
import com.triloggroup.gantt.pe.app.ChangeResult;
import com.triloggroup.gantt.pe.app.PEAppProjectModel;
import com.triloggroup.project.schedule.AbstractScheduleComputation;
import com.triloggroup.project.schedule.CalendarUtil;
import com.triloggroup.project.schedule.IPredecessor;
import com.triloggroup.project.schedule.ITaskSchedule;
import com.triloggroup.project.schedule.Predecessor;
import com.triloggroup.project.schedule.ScheduleCalendar;
import com.triloggroup.project.schedule.WBSComputation;
import com.triloggroup.util.UString;
import com.triloggroup.util.date.TGTime;
import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppScheduleComputation
extends AbstractScheduleComputation {
    private PEAppProjectModel model;

    public AppScheduleComputation(PEAppProjectModel pEAppProjectModel) {
        this.model = pEAppProjectModel;
    }

    @Override
    protected boolean isWorkDistributionModeShortest() {
        return this.model.isWorkDistributionModeShortest();
    }

    @Override
    public java.util.Date getProjectStartDate() throws Exception {
        return this.model.getProjectStartDate();
    }

    @Override
    public double getHoursPerDay() {
        return this.model.getProjectHoursPerDay();
    }

    @Override
    public double getHoursPerWeek() throws Exception {
        return this.model.getProjectHoursPerWeek();
    }

    @Override
    public double getHoursPerMonth() throws Exception {
        return this.model.getProjectHoursPerMonth();
    }

    @Override
    protected double getTaskDuration(String string) throws Exception {
        GanttNode ganttNode = this.model.getNodeByUid(string);
        if (ganttNode != null && ganttNode instanceof GanttTask) {
            return ((GanttTask)ganttNode).getDurationInHours();
        }
        throw new GanttChartException(2, "Predecessor " + string + " not found");
    }

    @Override
    protected java.util.Date getTaskEndDateTime(String string) throws Exception {
        GanttNode ganttNode = this.model.getNodeByUid(string);
        if (ganttNode != null && ganttNode instanceof GanttTask) {
            java.util.Date date = ((GanttTask)ganttNode).getDuration().getEnd();
            if (date instanceof Date) {
                date = new java.util.Date(date.getTime());
            }
            return date;
        }
        throw new GanttChartException(2, "Predecessor " + string + " not found");
    }

    @Override
    protected java.util.Date getTaskStartDateTime(String string) throws Exception {
        GanttNode ganttNode = this.model.getNodeByUid(string);
        if (ganttNode != null && ganttNode instanceof GanttTask) {
            java.util.Date date = ((GanttTask)ganttNode).getDuration().getStart();
            if (date instanceof Date) {
                date = new java.util.Date(date.getTime());
            }
            return date;
        }
        throw new GanttChartException(2, "Predecessor " + string + " not found");
    }

    @Override
    public boolean isAutomaticRescheduleProject() {
        return this.model.isAutomaticReschedule();
    }

    public void computeTaskValues(GanttTask ganttTask, GanttTask ganttTask2) throws Exception {
        this.computeTaskValues(ganttTask, ganttTask2, true);
    }

    public void computeTaskValues(GanttTask ganttTask, GanttTask ganttTask2, boolean bl) throws Exception {
        int n = ganttTask.getWorkFormat();
        double d = ganttTask.getWorkDisplay();
        double d2 = this.getDurationInHours(d, n);
        double d3 = ganttTask.getWorkInHours();
        if (d3 != d2) {
            ganttTask.setWorkInHours(d2);
        }
        CalendarAccessor calendarAccessor = this.model.getCalendarAccessor();
        ScheduleCalendar scheduleCalendar = calendarAccessor.getProjectCalendar();
        ScheduleCalendar scheduleCalendar2 = calendarAccessor.getTaskCalendar(ganttTask);
        ScheduleCalendar[] scheduleCalendarArray = calendarAccessor.getTaskCalendars(ganttTask);
        if (bl) {
            boolean bl2 = this.mustApplyAutomaticRescheduleOnTask(ganttTask);
            int n2 = this.validateTask(ganttTask, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray, bl2);
            if (n2 == 9) {
                this.fixAutoRescheduleConstraints(ganttTask, ganttTask2.getActualStartDate(), ganttTask2.getActualFinishDate(), ganttTask2.getProgress(), this.model.getProjectHandlePredConstraint());
                n2 = this.validateTask(ganttTask, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray, bl2);
            }
            if (n2 != 0) {
                String string = ChangeResult.getTaskErrorMessageKey(n2);
                throw new ChangeException(string);
            }
            this.onQuerySaveTaskDocument(ganttTask, false, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray, bl2);
        } else {
            this.calculateTaskComputedValues(ganttTask, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray);
        }
    }

    public void fixAutoRescheduleConstraints(GanttTask ganttTask, java.util.Date date, java.util.Date date2, double d, int n) {
        if (n == 1) {
            if (ganttTask.hasPredecessors()) {
                ganttTask.getPredecessorsList().clear();
            }
        } else if (n == 2) {
            ganttTask.setActualStartDate(date);
            ganttTask.setActualFinishDate(date2);
            ganttTask.setPercentComplete(d);
        } else {
            ganttTask.setActualStartDate(null);
            ganttTask.setActualFinishDate(null);
            ganttTask.setPercentComplete(1.0);
        }
    }

    public void onPostUpdateTaskValues(GanttTask ganttTask, boolean bl, GanttWBS ganttWBS) throws Exception {
        HashSet<GanttWBS> hashSet = new HashSet<GanttWBS>();
        CalendarAccessor calendarAccessor = this.model.getCalendarAccessor();
        ScheduleCalendar scheduleCalendar = calendarAccessor.getProjectCalendar();
        if (bl) {
            this.updateTaskSuccessors(ganttTask, scheduleCalendar, calendarAccessor, hashSet);
        }
        GanttWBS ganttWBS2 = this.model.getWBSByHierarchicalId(ganttTask.getParentHierarchicalId());
        hashSet.add(ganttWBS2);
        this.addAllNodeParentToSet(ganttWBS2, hashSet);
        if (ganttWBS != null) {
            hashSet.add(ganttWBS);
            this.addAllNodeParentToSet(ganttWBS, hashSet);
        }
        this.rescheduleWBS(scheduleCalendar, hashSet);
        this.model.updateFinancial();
    }

    public void onPostUpdateWbsValues(GanttWBS ganttWBS, GanttWBS ganttWBS2) throws Exception {
        HashSet<GanttWBS> hashSet = new HashSet<GanttWBS>();
        CalendarAccessor calendarAccessor = this.model.getCalendarAccessor();
        ScheduleCalendar scheduleCalendar = calendarAccessor.getProjectCalendar();
        hashSet.add(ganttWBS);
        GanttWBS ganttWBS3 = this.model.getWBSByHierarchicalId(ganttWBS.getParentHierarchicalId());
        if (ganttWBS3 != null) {
            hashSet.add(ganttWBS3);
            this.addAllNodeParentToSet(ganttWBS3, hashSet);
        }
        if (ganttWBS2 != null) {
            hashSet.add(ganttWBS2);
            this.addAllNodeParentToSet(ganttWBS2, hashSet);
        }
        this.rescheduleWBS(scheduleCalendar, hashSet);
        this.model.updateFinancial();
    }

    private HashMap<String, ArrayList<GanttTask>> computeSuccessorsMapNotDone() {
        Iterator<TGNode> iterator = this.model.getAllNodes().iterator();
        HashMap<String, ArrayList<GanttTask>> hashMap = new HashMap<String, ArrayList<GanttTask>>();
        while (iterator.hasNext()) {
            IPredecessor[] iPredecessorArray;
            GanttTask ganttTask;
            TGNode tGNode = iterator.next();
            if (!(tGNode instanceof GanttTask) || UString.equals((ganttTask = (GanttTask)tGNode).getStatus(), "Done") || (iPredecessorArray = ganttTask.getPredecessors()) == null) continue;
            for (int i = 0; i < iPredecessorArray.length; ++i) {
                ArrayList<GanttTask> arrayList = hashMap.get(iPredecessorArray[i].getId());
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    hashMap.put(iPredecessorArray[i].getId(), arrayList);
                }
                arrayList.add(ganttTask);
            }
        }
        return hashMap;
    }

    private void addAllNodeParentToSet(GanttNode ganttNode, HashSet<GanttWBS> hashSet) {
        boolean bl;
        do {
            if ((ganttNode = (GanttWBS)ganttNode.getParent()) == null) {
                return;
            }
            if (this.model.getProjectContext() == ganttNode.getProjectContext()) continue;
            return;
        } while (bl = hashSet.add((GanttWBS)ganttNode));
    }

    public void updateTaskSuccessors(GanttTask ganttTask) throws Exception {
        HashSet<GanttWBS> hashSet = new HashSet<GanttWBS>();
        CalendarAccessor calendarAccessor = this.model.getCalendarAccessor();
        ScheduleCalendar scheduleCalendar = calendarAccessor.getProjectCalendar();
        this.updateTaskSuccessors(ganttTask, scheduleCalendar, calendarAccessor, hashSet);
    }

    private void updateTaskSuccessors(GanttTask ganttTask, ScheduleCalendar scheduleCalendar, CalendarAccessor calendarAccessor, HashSet<GanttWBS> hashSet) throws Exception {
        HashMap<String, ArrayList<GanttTask>> hashMap = this.computeSuccessorsMapNotDone();
        HashSet<GanttTask> hashSet2 = new HashSet<GanttTask>();
        this.updateTaskSuccessors(ganttTask, scheduleCalendar, calendarAccessor, hashMap, hashSet, hashSet2);
    }

    private void updateTaskSuccessors(GanttTask ganttTask, ScheduleCalendar scheduleCalendar, CalendarAccessor calendarAccessor, HashMap<String, ArrayList<GanttTask>> hashMap, HashSet<GanttWBS> hashSet, HashSet<GanttTask> hashSet2) throws Exception {
        if (!hashSet2.add((GanttTask)ganttTask)) {
            throw new IllegalStateException("Circular reference detected.");
        }
        ArrayList<GanttTask> arrayList = hashMap.get(ganttTask.getUid());
        if (arrayList != null && arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                GanttTask ganttTask2 = arrayList.get(i);
                ScheduleCalendar scheduleCalendar2 = calendarAccessor.getTaskCalendar(ganttTask2);
                ScheduleCalendar[] scheduleCalendarArray = calendarAccessor.getTaskCalendars(ganttTask2);
                java.util.Date date = ganttTask2.getStartDate();
                java.util.Date date2 = ganttTask2.getFinishDate();
                this.calculateTaskComputedValues(ganttTask2, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray);
                java.util.Date date3 = ganttTask2.getStartDate();
                java.util.Date date4 = ganttTask2.getFinishDate();
                if (date3.equals(date) && date4.equals(date2)) continue;
                this.model.updateResourceMaps(ganttTask2, date.getTime(), date2.getTime(), ganttTask2.getResources(), ganttTask2.getStatus());
                this.addAllNodeParentToSet(ganttTask2, hashSet);
                HashSet hashSet3 = i < arrayList.size() - 1 ? (HashSet)hashSet2.clone() : hashSet2;
                this.updateTaskSuccessors(ganttTask2, scheduleCalendar, calendarAccessor, hashMap, hashSet, hashSet3);
            }
        }
    }

    public void runFullReschedule() throws ChangeException {
        try {
            CalendarAccessor calendarAccessor = this.model.getCalendarAccessor();
            ScheduleCalendar scheduleCalendar = calendarAccessor.getProjectCalendar();
            this.updateAllTasks(scheduleCalendar, calendarAccessor);
            this.rescheduleAllProjectWBS(scheduleCalendar);
        }
        catch (Exception exception) {
            throw new UnexpectedChangeException(exception);
        }
    }

    private void updateAllTasks(ScheduleCalendar scheduleCalendar, CalendarAccessor calendarAccessor) throws Exception {
        ScheduleCalendar[] scheduleCalendarArray;
        Serializable serializable;
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        ArrayList<Serializable> arrayList2 = new ArrayList<Serializable>();
        Iterator<TGNode> iterator = this.model.getAllNodes().iterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            TGNode tGNode = iterator.next();
            if (!(tGNode instanceof GanttTask) || "Done".equals(((GanttNode)(serializable = (GanttTask)tGNode)).getStatus())) continue;
            if (((GanttTask)serializable).getPredecessorsCount() == 0) {
                arrayList.add(serializable);
                continue;
            }
            arrayList2.add(serializable);
            hashSet.add(((GanttNode)serializable).getUid());
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            serializable = (GanttTask)arrayList.get(i);
            ScheduleCalendar scheduleCalendar2 = calendarAccessor.getTaskCalendar((GanttTask)serializable);
            scheduleCalendarArray = calendarAccessor.getTaskCalendars((GanttTask)serializable);
            this.calculateTaskComputedValues((ITaskSchedule)((Object)serializable), scheduleCalendar, scheduleCalendar2, scheduleCalendarArray);
        }
        block2: while (arrayList2.size() > 0) {
            GanttTask ganttTask = (GanttTask)arrayList2.remove(0);
            serializable = ganttTask.getPredecessorsList();
            if (serializable != null) {
                for (int i = 0; i < ((ArrayList)serializable).size(); ++i) {
                    if (!hashSet.contains(((Predecessor)((ArrayList)serializable).get(i)).getId())) continue;
                    arrayList2.add(ganttTask);
                    continue block2;
                }
            }
            ScheduleCalendar scheduleCalendar3 = calendarAccessor.getTaskCalendar(ganttTask);
            scheduleCalendarArray = calendarAccessor.getTaskCalendars(ganttTask);
            this.calculateTaskComputedValues(ganttTask, scheduleCalendar, scheduleCalendar3, scheduleCalendarArray);
            hashSet.remove(ganttTask.getUid());
        }
    }

    protected void computeAllWBSProgress() {
        GanttWBS ganttWBS = this.model.getRootNode();
        if (ganttWBS == null) {
            return;
        }
        WBSComputation wBSComputation = new WBSComputation();
        wBSComputation.setReferenceDate(ganttWBS.getGlobalContext().getCurrentDate());
        wBSComputation.rescheduleAllWBSProgress(ganttWBS);
    }

    protected void rescheduleAllProjectWBS(ScheduleCalendar scheduleCalendar) {
        GanttWBS ganttWBS = this.model.getRootNode();
        if (ganttWBS == null) {
            return;
        }
        WBSComputation wBSComputation = new WBSComputation();
        wBSComputation.setReferenceDate(ganttWBS.getGlobalContext().getCurrentDate());
        wBSComputation.rescheduleAllWBS(scheduleCalendar, ganttWBS, 3, this.getHoursPerDay());
        this.model.updateProjectDates();
        this.model.rescheduleParentProject();
    }

    public void rescheduleWBSAndParents(GanttWBS ganttWBS) {
        CalendarAccessor calendarAccessor = this.model.getCalendarAccessor();
        ScheduleCalendar scheduleCalendar = calendarAccessor.getProjectCalendar();
        HashSet<GanttWBS> hashSet = new HashSet<GanttWBS>();
        hashSet.add(ganttWBS);
        this.addAllNodeParentToSet(ganttWBS, hashSet);
        this.rescheduleWBS(scheduleCalendar, hashSet);
    }

    private void rescheduleWBS(ScheduleCalendar scheduleCalendar, HashSet<GanttWBS> hashSet) {
        if (hashSet.size() == 0) {
            return;
        }
        WBSComputation.IWBS[] iWBSArray = hashSet.toArray(new GanttWBS[0]);
        Arrays.sort(iWBSArray, TGNode.sortedIdComparator);
        WBSComputation wBSComputation = new WBSComputation();
        wBSComputation.setReferenceDate(iWBSArray[0].getGlobalContext().getCurrentDate());
        wBSComputation.rescheduleWBS(scheduleCalendar, iWBSArray, 3, this.getHoursPerDay());
        this.model.updateProjectDates();
        this.model.rescheduleParentProject();
    }

    public void setWorkFromDuration(GanttTask ganttTask, TGDuration tGDuration) throws Exception {
        TaskResource[] taskResourceArray = ganttTask.getResources();
        int n = 0;
        if (taskResourceArray == null || taskResourceArray.length == 0) {
            n = 100;
        } else {
            for (int i = 0; i < taskResourceArray.length; ++i) {
                n += taskResourceArray[i].getUnit();
            }
        }
        double d = tGDuration.getValue() * (double)n / 100.0;
        double d2 = this.getDurationInHours(d, tGDuration.getUnit().getCode());
        long l = (long)(d2 * 3600000.0);
        double d3 = this.getDurationInDurationFormat(l, ganttTask.getWorkFormat());
        ganttTask.setWorkDisplay(d3);
    }

    public void setDurationFromWork(GanttTask ganttTask, TGDuration tGDuration) throws Exception {
        TaskResource[] taskResourceArray = ganttTask.getResources();
        int n = 0;
        if (taskResourceArray == null || taskResourceArray.length == 0) {
            n = 100;
        } else {
            for (int i = 0; i < taskResourceArray.length; ++i) {
                n += taskResourceArray[i].getUnit();
            }
        }
        double d = tGDuration.getValue() * 100.0 / (double)n;
        double d2 = this.getDurationInHours(d, tGDuration.getUnit().getCode());
        long l = (long)(d2 * 3600000.0);
        double d3 = this.getDurationInDurationFormat(l, ganttTask.getDurationFormat());
        ganttTask.setDurationDisplay(d3);
    }

    public void setDurationFromDates(GanttTask ganttTask, java.util.Date date) throws Exception {
        ScheduleCalendar[] scheduleCalendarArray;
        ScheduleCalendar scheduleCalendar = this.model.getProjectCalendar();
        ScheduleCalendar scheduleCalendar2 = this.model.getCalendarAccessor().getTaskCalendar(ganttTask);
        ScheduleCalendar[] scheduleCalendarArray2 = this.model.getCalendarAccessor().getTaskCalendars(ganttTask);
        TGTime tGTime = new TGTime(date);
        if (tGTime.hours == 0 && tGTime.minutes == 0) {
            date = new TGTime(23, 59, 59).applyTime(date);
        }
        if (scheduleCalendarArray2 != null && scheduleCalendarArray2.length > 0) {
            scheduleCalendarArray = scheduleCalendarArray2;
        } else {
            ScheduleCalendar[] scheduleCalendarArray3 = new ScheduleCalendar[1];
            scheduleCalendarArray = scheduleCalendarArray3;
            scheduleCalendarArray3[0] = scheduleCalendar2 != null ? scheduleCalendar2 : scheduleCalendar;
        }
        date = CalendarUtil.getLastEndDate(date, scheduleCalendarArray);
        ganttTask.setFinishDate(date);
        this.calculateDurationAndWorkFromDates(ganttTask, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray2);
    }
}

