/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.ui;

import com.triloggroup.gantt.app.ui.CancelAsyncActionException;
import com.triloggroup.gantt.app.ui.IAsyncAction;
import com.triloggroup.gantt.app.ui.WDWaitDialog;
import com.triloggroup.gantt.app.ui.WDWaitDialog2;
import com.triloggroup.ui.ErrorDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class AsyncActionRunner {
    private boolean useNewUI = true;
    private static final int PENDING = 0;
    private static final int STARTED = 1;
    private static final int DONE = 2;
    private IAsyncAction action;
    private Component parentComponent;
    private String message;
    private JDialog dlg;
    private Component oldGlassPane;
    private Object tempResult;
    private Throwable tempException;
    private volatile int status = 0;
    private Rectangle waitUiBounds;

    public AsyncActionRunner(IAsyncAction iAsyncAction) {
        this.action = iAsyncAction;
        if (iAsyncAction == null) {
            this.status = 2;
        }
    }

    public AsyncActionRunner(IAsyncAction iAsyncAction, Component component, String string) {
        this(iAsyncAction);
        if (component != null) {
            Container container = component.getParent();
            if (container instanceof JViewport) {
                component = container;
            }
            this.parentComponent = component;
        }
        this.message = string;
    }

    public void setUseNewUI(boolean bl) {
        this.useNewUI = bl;
    }

    public void setWaitUIBounds(Rectangle rectangle) {
        this.waitUiBounds = rectangle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAction() {
        if (this.action == null) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AsyncActionRunner.this.runAction();
                }
            });
            return;
        }
        Object object = this;
        synchronized (object) {
            if (this.status != 0) {
                throw new IllegalStateException("Action already started (code=" + this.status + ')');
            }
            this.status = 1;
        }
        try {
            this.tempResult = this.action.awtBeforeRun();
        }
        catch (CancelAsyncActionException cancelAsyncActionException) {
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (this.parentComponent != null) {
                ErrorDialog.showError(this.parentComponent, throwable);
            }
            return;
        }
        new Thread(){

            public void run() {
                AsyncActionRunner.this.runActionPart2();
            }
        }.start();
        if (this.parentComponent != null) {
            if (this.useNewUI) {
                Container container;
                if (this.parentComponent instanceof JComponent) {
                    object = ((JComponent)this.parentComponent).getRootPane();
                    this.oldGlassPane = ((JRootPane)object).getGlassPane();
                    container = new JComponent(){

                        public void paint(Graphics graphics) {
                            if (AsyncActionRunner.this.waitUiBounds != null) {
                                return;
                            }
                            if (graphics instanceof Graphics2D) {
                                int n = this.getHeight();
                                Paint paint = n < 250 ? Color.WHITE : new GradientPaint(0.0f, 200.0f, Color.WHITE, 0.0f, 500.0f, new Color(255, 255, 255, 180), false);
                                Graphics2D graphics2D = (Graphics2D)graphics;
                                graphics2D.setPaint(paint);
                                graphics.fillRect(0, 30, this.getWidth(), this.getHeight());
                            }
                        }
                    };
                    ((JComponent)container).setOpaque(false);
                    ((JRootPane)object).setGlassPane(container);
                    ((JComponent)container).setVisible(true);
                }
                this.dlg = WDWaitDialog2.createDialog(this.parentComponent, this.message, this.waitUiBounds);
                if (this.waitUiBounds == null) {
                    object = new Point(0, 5);
                    container = this.parentComponent.getParent();
                    SwingUtilities.convertPointToScreen((Point)object, container);
                    this.dlg.setSize(container.getWidth(), this.dlg.getHeight());
                    this.dlg.setLocation((Point)object);
                }
                ((WDWaitDialog2)this.dlg).ensureVisible();
            } else {
                this.dlg = WDWaitDialog.createWDDialog(this.parentComponent, this.message, false);
                ((WDWaitDialog)this.dlg).progressBar.setIndeterminate(true);
                this.dlg.pack();
                this.dlg.setLocationRelativeTo(this.parentComponent);
            }
            this.dlg.setVisible(true);
        }
    }

    private void runActionPart2() {
        try {
            this.tempResult = this.action.asyncRun(this.tempResult);
        }
        catch (Throwable throwable) {
            this.tempException = throwable;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AsyncActionRunner.this.runActionPart3();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runActionPart3() {
        Object object;
        block7: {
            if (this.dlg != null) {
                this.dlg.dispose();
                this.dlg = null;
            }
            if (this.oldGlassPane != null) {
                object = ((JComponent)this.parentComponent).getRootPane();
                ((JRootPane)object).getGlassPane().setVisible(false);
                ((JRootPane)object).setGlassPane(this.oldGlassPane);
                this.oldGlassPane = null;
            }
            try {
                this.action.awtAfterRun(this.tempResult, this.tempException);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                if (this.parentComponent == null) break block7;
                ErrorDialog.showError(this.parentComponent, throwable);
            }
        }
        object = this;
        synchronized (object) {
            this.status = 2;
            this.notifyAll();
        }
    }

    public synchronized int getStatus() {
        return this.status;
    }

    public synchronized void waitUntilDone() {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Method waitUntilDone called from UI thread.");
        }
        while (this.status != 2) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

