/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.treetable.resource;

import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.TGDuration;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.change.ChangeException;
import com.triloggroup.gantt.app.treetable.resource.ComputableInt;
import com.triloggroup.gantt.app.treetable.resource.ResourceEditorDialog;
import com.triloggroup.gantt.app.treetable.resource.ResourceUnitsEditor;
import com.triloggroup.gantt.app.treetable.resource.ResourceUnitsRenderer;
import com.triloggroup.gantt.app.treetable.resource.ResourceWorkEditor;
import com.triloggroup.gantt.app.treetable.resource.TaskResourceTableModel;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.gantt.pe.app.TaskUpdater;
import com.triloggroup.gantt.treetable.DurationRenderer;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.awt.event.ActionListener;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class TaskResourceEditorDialog
extends ResourceEditorDialog
implements ActionListener {
    private TaskResourceTableModel.EditInPlace model;
    private AppGanttChart chart;
    private boolean updating = false;

    public static TaskResourceEditorDialog create(Component component) {
        Window window = SwingUtilities.getWindowAncestor(component);
        GraphicsConfiguration graphicsConfiguration = WDUtil.getGraphicsConfiguration(component);
        return new TaskResourceEditorDialog(window, graphicsConfiguration);
    }

    protected TaskResourceEditorDialog(Window window, GraphicsConfiguration graphicsConfiguration) {
        super(window, graphicsConfiguration);
    }

    protected boolean isHighlightRow(Resource resource) {
        return this.model.isHighlightedResource(resource);
    }

    public void init(AppGanttChart appGanttChart, GanttTask ganttTask, Resource[] resourceArray) {
        this.chart = appGanttChart;
        this.model = new TaskResourceTableModel.EditInPlace(appGanttChart, ganttTask.clone(), resourceArray);
        JTable jTable = new JTable(this.model);
        this.initUI(jTable);
        this.model.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                TaskResourceEditorDialog.this.resourcesModified();
            }
        });
    }

    protected void updateTableUI() {
        super.updateTableUI();
        this.table.setDefaultRenderer(TGDuration.class, new DurationRenderer(this.chart.getDateLocale()));
        this.table.setDefaultEditor(TGDuration.class, new ResourceWorkEditor());
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        ResourceUnitsEditor resourceUnitsEditor = new ResourceUnitsEditor();
        TableColumn tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setCellEditor(resourceUnitsEditor);
        tableColumn.setCellRenderer(new ResourceUnitsRenderer());
        int n = this.table.getTableHeader().getDefaultRenderer().getTableCellRendererComponent((JTable)this.table, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)-1, (int)1).getPreferredSize().width;
        Component component = this.table.getCellRenderer(0, 1).getTableCellRendererComponent(this.table, new ComputableInt(100, true), true, true, 0, 1);
        n = Math.max(n, component.getPreferredSize().width) + 5;
        tableColumn.setPreferredWidth(n);
    }

    protected void collectResult() {
        this.result = this.model.getSelectedResources();
    }

    protected Resource getResource(int n) {
        return this.model.getResources()[n].getResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean resourcesModified() {
        if (this.updating) {
            return true;
        }
        this.model.task.setResources(this.model.getSelectedResources());
        TaskUpdater taskUpdater = new TaskUpdater(null, this.model.task, this.chart.getModel(), this, 0);
        try {
            taskUpdater.checkAndCompute();
        }
        catch (ChangeException changeException) {
            WDDialog.showErrorMsgDialog(this, changeException);
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            WDDialog.showMsgDialog(this, AppGanttChart.NLS_BUNDLE.getString("schedule_commputation_error"));
            return false;
        }
        this.updating = true;
        try {
            this.model.updateHighlightedRows();
            this.model.fireTableDataChanged();
        }
        finally {
            this.updating = false;
        }
        return true;
    }
}

