/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.treetable.resource;

import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.TaskResource;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.AppProjectModel;
import com.triloggroup.gantt.app.treetable.resource.ResourceEditorDialog;
import com.triloggroup.gantt.app.treetable.resource.TaskResourceEditorDialog;
import com.triloggroup.gantt.app.treetable.resource.WBSResourceEditorDialog;
import com.triloggroup.project.components.resourceeditor.ProjectResource;
import com.triloggroup.project.components.ui.table.CellEditorWithDialog;
import java.awt.Component;
import java.awt.Point;
import java.io.Serializable;
import java.util.Arrays;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcesEditor
extends CellEditorWithDialog<Object> {
    protected ProjectResource[] availableResources;
    protected AppGanttChart chart;
    protected int currentRow;

    public ResourcesEditor(AppGanttChart appGanttChart, AppProjectModel appProjectModel) {
        int n;
        this.chart = appGanttChart;
        this.availableResources = appProjectModel.getProjectResources();
        int n2 = 0;
        for (n = 0; n < this.availableResources.length; ++n) {
            if (this.availableResources[n].isEnabled()) continue;
            this.availableResources[n] = null;
            ++n2;
        }
        Arrays.sort(this.availableResources, Resource.COMPARATOR);
        if (n2 > 0) {
            n = this.availableResources.length - n2;
            ProjectResource[] projectResourceArray = new ProjectResource[n];
            System.arraycopy(this.availableResources, n2, projectResourceArray, 0, n);
            this.availableResources = projectResourceArray;
        }
    }

    @Override
    protected void showDialog() {
        Serializable serializable;
        ResourceEditorDialog resourceEditorDialog;
        if (this.currentValue instanceof TaskResource[]) {
            resourceEditorDialog = TaskResourceEditorDialog.create(this.lb);
            serializable = (GanttTask)this.chart.getModel().getNodeByRowIndex(this.currentRow);
            ((TaskResourceEditorDialog)resourceEditorDialog).init(this.chart, (GanttTask)serializable, this.availableResources);
        } else if (this.currentValue instanceof Resource[]) {
            resourceEditorDialog = WBSResourceEditorDialog.create(this.lb);
            ((WBSResourceEditorDialog)resourceEditorDialog).init(this.availableResources, (Resource[])this.currentValue);
        } else {
            this.cancelCellEditing();
            return;
        }
        resourceEditorDialog.ensureMinMaxSize(this.lb.getWidth(), -1, -1, 500);
        serializable = new Point(0, 0);
        SwingUtilities.convertPointToScreen((Point)serializable, this.lb);
        resourceEditorDialog.setLocation((Point)serializable);
        resourceEditorDialog.setVisibleDisableMouseEvents(500L);
        this.currentValue = resourceEditorDialog.getSelectedValue();
        if (this.currentValue == null) {
            this.cancelCellEditing();
        } else {
            this.stopCellEditing();
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.currentRow = n;
        return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
    }
}

