/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.treetable;

import com.triloggroup.gantt.EmptyNode;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.TGChart;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.TaskResource;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.AppGanttChartModel;
import com.triloggroup.gantt.app.Cursors;
import com.triloggroup.gantt.app.DropAction;
import com.triloggroup.gantt.app.TransferableResource;
import com.triloggroup.gantt.app.change.Change;
import com.triloggroup.gantt.app.treetable.AppGanttTreeTable;
import com.triloggroup.gantt.app.treetable.TransferableNode;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.project.ObjectRef;
import com.triloggroup.project.components.resourceeditor.ProjectResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;

class TableDnDManager
implements DropTargetListener,
DragSourceListener,
DragGestureListener {
    private final Insets autoscrollInsets = new Insets(20, 20, 20, 20);
    private final AppGanttTreeTable table;
    private Cursor cursor;
    private JLayeredPane dragPane;
    private JLabel draggedLabel;
    private JLabel interRowHighlightLabel;
    private JLabel rowHighlightLabel;

    TableDnDManager(AppGanttTreeTable appGanttTreeTable) {
        this.table = appGanttTreeTable;
        appGanttTreeTable.setTransferHandler(null);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(appGanttTreeTable, 2, this);
        DropTarget dropTarget = new DropTarget(appGanttTreeTable, this);
        appGanttTreeTable.setDropTarget(dropTarget);
    }

    void setRowHeader(JComponent jComponent) {
        jComponent.setTransferHandler(null);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(jComponent, 2, this);
        DropTarget dropTarget = new DropTarget(jComponent, this);
        jComponent.setDropTarget(dropTarget);
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        if ((dragGestureEvent.getTriggerEvent().getModifiers() & 0x10) == 0) {
            return;
        }
        try {
            AppGanttChartModel appGanttChartModel;
            if (!this.table.ganttCtrl.isEditable()) {
                return;
            }
            TGNode tGNode = this.table.getNodeAtPoint(dragGestureEvent.getDragOrigin());
            if (tGNode == null || tGNode instanceof EmptyNode) {
                return;
            }
            if (!this.table.stopCellEditing(false)) {
                return;
            }
            this.table.ganttCtrl.setSelectedNode(tGNode);
            if (tGNode instanceof GanttWBS && ((GanttWBS)tGNode).isProjectRoot() && tGNode.getParent() != null) {
                tGNode = tGNode.getParent();
            }
            if (!(appGanttChartModel = (AppGanttChartModel)this.table.getModel().getChartModel()).isProjectScheduleEditable((GanttNode)tGNode)) {
                return;
            }
            TransferableNode transferableNode = new TransferableNode((GanttNode)tGNode);
            this.initDragLabels();
            this.rowHighlightLabel.setSize(this.table.getWidth(), this.table.getRowHeight() + 3);
            this.interRowHighlightLabel.setSize(this.table.getWidth(), 5);
            dragGestureEvent.startDrag(Cursors.dropNotAvailableCursor, transferableNode, this);
        }
        catch (InvalidDnDOperationException invalidDnDOperationException) {
            System.err.println(invalidDnDOperationException);
        }
    }

    private void initDragLabels() {
        if (this.dragPane == null) {
            this.dragPane = this.table.getRootPane().getLayeredPane();
            this.draggedLabel = new JLabel();
            this.draggedLabel.setOpaque(true);
            this.draggedLabel.setBackground(Color.WHITE);
            this.draggedLabel.setFont(this.table.getFont());
            this.draggedLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.interRowHighlightLabel = new JLabel();
            this.interRowHighlightLabel.setOpaque(true);
            this.interRowHighlightLabel.setBackground(Color.WHITE);
            this.interRowHighlightLabel.setBorder(LineBorder.createBlackLineBorder());
            this.rowHighlightLabel = new JLabel();
            this.rowHighlightLabel.setOpaque(false);
            Border border = LineBorder.createBlackLineBorder();
            Border border2 = BorderFactory.createLineBorder(Color.WHITE);
            Border border3 = LineBorder.createBlackLineBorder();
            CompoundBorder compoundBorder = new CompoundBorder(border, border2);
            compoundBorder = new CompoundBorder(compoundBorder, border3);
            this.rowHighlightLabel.setBorder(compoundBorder);
        }
        this.dragPane.add((Component)this.draggedLabel, JLayeredPane.DRAG_LAYER);
        this.dragPane.add((Component)this.interRowHighlightLabel, JLayeredPane.DRAG_LAYER);
        this.dragPane.add((Component)this.rowHighlightLabel, JLayeredPane.DRAG_LAYER);
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        DropActionWithRow dropActionWithRow;
        Object object;
        Object object2;
        Point point = dropTargetDragEvent.getLocation();
        boolean bl = dropTargetDragEvent.isDataFlavorSupported(TransferableResource.RESOURCE_FLAVOR);
        if (bl) {
            TGNode tGNode = this.table.getNodeAtPoint(point);
            if (tGNode == null || !(tGNode instanceof GanttNode)) {
                dropTargetDragEvent.rejectDrag();
                return;
            }
            if (tGNode instanceof GanttTask && ((GanttTask)tGNode).isDone()) {
                dropTargetDragEvent.rejectDrag();
                return;
            }
            Transferable transferable = dropTargetDragEvent.getTransferable();
            try {
                ObjectRef[] objectRefArray = (ObjectRef[])transferable.getTransferData(TransferableResource.RESOURCE_FLAVOR);
                String string = ((GanttNode)tGNode).getProjectId();
                if (!objectRefArray[0].projectId.equals(string)) {
                    dropTargetDragEvent.rejectDrag();
                    return;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                dropTargetDragEvent.rejectDrag();
            }
            dropTargetDragEvent.acceptDrag(1);
            this.autoscroll(point);
            return;
        }
        Transferable transferable = dropTargetDragEvent.getTransferable();
        if (transferable == null) {
            this.cursor = null;
            return;
        }
        try {
            object2 = (ObjectRef[])transferable.getTransferData(TransferableNode.NODE_FLAVOR);
            object = this.getNodes((ObjectRef[])object2);
            dropActionWithRow = this.getDropActionAvailableAt(point, (TGNode[])object);
        }
        catch (Exception exception) {
            dropActionWithRow = new DropActionWithRow();
            exception.printStackTrace();
        }
        switch (dropActionWithRow.code) {
            case 32: {
                this.cursor = Cursors.getCursor(Cursors.changeParentCursor, dropActionWithRow.available);
                this.interRowHighlightLabel.setVisible(false);
                this.draggedLabel.setVisible(false);
                object2 = new Point(0, dropActionWithRow.rowIdx * this.table.getRowHeight() - 2);
                object2 = SwingUtilities.convertPoint(this.table, (Point)object2, this.dragPane);
                this.rowHighlightLabel.setLocation((Point)object2);
                this.rowHighlightLabel.setVisible(true);
                break;
            }
            case 144: {
                this.cursor = Cursors.getCursor(Cursors.reorderCursor, dropActionWithRow.available);
                object2 = new Point(0, dropActionWithRow.rowIdx * this.table.getRowHeight() - 2);
                object2 = SwingUtilities.convertPoint(this.table, (Point)object2, this.dragPane);
                this.interRowHighlightLabel.setLocation((Point)object2);
                this.interRowHighlightLabel.setVisible(true);
                this.rowHighlightLabel.setVisible(false);
                if (!dropActionWithRow.available) break;
                this.draggedLabel.setText((String)dropActionWithRow.data);
                this.draggedLabel.setSize(this.draggedLabel.getPreferredSize());
                object = dropTargetDragEvent.getDropTargetContext().getComponent();
                object2 = SwingUtilities.convertPoint((Component)object, point, this.dragPane);
                object2.x += 15;
                object2.y -= 15;
                this.draggedLabel.setLocation((Point)object2);
                this.draggedLabel.setVisible(true);
                break;
            }
            default: {
                this.cursor = Cursors.dropNotAvailableCursor;
                this.interRowHighlightLabel.setVisible(false);
                this.rowHighlightLabel.setVisible(false);
                this.draggedLabel.setVisible(false);
            }
        }
        this.autoscroll(point);
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Point point = dropTargetDropEvent.getLocation();
        try {
            if (dropTargetDropEvent.isDataFlavorSupported(TransferableResource.RESOURCE_FLAVOR)) {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                ObjectRef[] objectRefArray = (ObjectRef[])transferable.getTransferData(TransferableResource.RESOURCE_FLAVOR);
                LinkedHashSet<ProjectResource> linkedHashSet = new LinkedHashSet<ProjectResource>();
                for (ObjectRef i : objectRefArray) {
                    linkedHashSet.add(this.table.getGanttControler().getModel().getProjectModel(i.projectId).getProjectResource(i.id));
                }
                TGNode string = this.table.getNodeAtPoint(point);
                if (string instanceof GanttTask) {
                    GanttTask ganttWBS = (GanttTask)string;
                    TaskResource[] resourceArray = ganttWBS.getResources();
                    for (int taskResourceArray2 = 0; taskResourceArray2 < resourceArray.length; ++taskResourceArray2) {
                        linkedHashSet.remove(resourceArray[taskResourceArray2].getResource());
                    }
                    if (linkedHashSet.isEmpty()) {
                        dropTargetDropEvent.dropComplete(false);
                        return;
                    }
                    TaskResource[] i = new TaskResource[resourceArray.length + linkedHashSet.size()];
                    for (int iterator = 0; iterator < resourceArray.length; ++iterator) {
                        i[iterator] = resourceArray[iterator].clone();
                    }
                    Iterator iterator = linkedHashSet.iterator();
                    for (int ganttTask2 = resourceArray.length; ganttTask2 < i.length; ++ganttTask2) {
                        i[ganttTask2] = new TaskResource((Resource)iterator.next(), 100);
                    }
                    GanttTask i2 = ganttWBS.clone();
                    i2.setResources(i);
                    this.table.getGanttControler().getModel().checkComputeAndUpdateTaskValues(ganttWBS, i2, this.table, 0);
                    dropTargetDropEvent.dropComplete(true);
                } else if (string instanceof GanttWBS) {
                    GanttWBS wDDialog = (GanttWBS)string;
                    Resource[] n = wDDialog.getResources();
                    for (int resourceArray2 = 0; resourceArray2 < n.length; ++resourceArray2) {
                        linkedHashSet.remove(n[resourceArray2]);
                    }
                    if (linkedHashSet.isEmpty()) {
                        dropTargetDropEvent.dropComplete(false);
                        return;
                    }
                    Resource[] string2 = new Resource[n.length + linkedHashSet.size()];
                    System.arraycopy(n, 0, string2, 0, n.length);
                    Iterator string3 = linkedHashSet.iterator();
                    for (int ganttWBS2 = n.length; ganttWBS2 < string2.length; ++ganttWBS2) {
                        string2[ganttWBS2] = (Resource)string3.next();
                    }
                    GanttWBS n2 = wDDialog.clone();
                    n2.setResources(string2);
                    this.table.getGanttControler().getModel().checkComputeAndUpdateWBSValues(wDDialog, n2, this.table);
                    dropTargetDropEvent.dropComplete(true);
                } else {
                    dropTargetDropEvent.dropComplete(false);
                }
                return;
            }
            if (!dropTargetDropEvent.isDataFlavorSupported(TransferableNode.NODE_FLAVOR)) {
                dropTargetDropEvent.dropComplete(false);
                return;
            }
            ObjectRef[] objectRefArray = (ObjectRef[])dropTargetDropEvent.getTransferable().getTransferData(TransferableNode.NODE_FLAVOR);
            TGNode[] tGNodeArray = this.getNodes(objectRefArray);
            DropActionWithRow dropActionWithRow = this.getDropActionAvailableAt(point, tGNodeArray);
            if (!dropActionWithRow.available) {
                if (dropActionWithRow.messageKeyNotAvailable != null) {
                    String appGanttChart = AppGanttChart.NLS_BUNDLE.getString(dropActionWithRow.messageKeyNotAvailable);
                    WDDialog string = WDDialog.createMsgDialog((Component)this.table, appGanttChart);
                    SwingUtilities.convertPointToScreen(point, this.table);
                    string.setVisibleCenteredAtScreenPoint(point);
                }
                dropTargetDropEvent.dropComplete(false);
                return;
            }
            AppGanttChart appGanttChart = this.table.ganttCtrl;
            if (dropActionWithRow.code == 144) {
                String ganttWBS = (String)dropActionWithRow.data;
                int appGanttChartModel = ganttWBS.lastIndexOf(46);
                String i = ganttWBS.substring(0, appGanttChartModel);
                String tGNode = ganttWBS.substring(appGanttChartModel + 1);
                int change = Integer.parseInt(tGNode);
                TGNode tGNode2 = tGNodeArray[0];
                if (tGNode2.getParentHierarchicalId().equals(i)) {
                    appGanttChart.getModel().reorderNodeToPosition(tGNode2, change, false);
                } else {
                    GanttWBS ganttWBS2 = this.table.getGanttControler().getModel().getProjectModel(((GanttNode)tGNode2).getProjectId()).getWBSByHierarchicalId(i);
                    if (tGNode2 instanceof GanttTask) {
                        appGanttChart.getModel().changeParentTask((GanttTask)tGNode2, ganttWBS2, this.table, false);
                    } else {
                        appGanttChart.getModel().changeParentWBS((GanttWBS)tGNode2, ganttWBS2, this.table);
                    }
                    if (ganttWBS2.getAllNonEmptySubTaskCount() > change) {
                        appGanttChart.getModel().reorderNodeToPosition(tGNode2, change, true);
                    }
                }
                dropTargetDropEvent.dropComplete(true);
                return;
            }
            if (dropActionWithRow.code == 32) {
                GanttWBS ganttWBS = (GanttWBS)this.table.getModel().nodeForRow(dropActionWithRow.rowIdx);
                AppGanttChartModel appGanttChartModel = appGanttChart.getModel();
                for (int i = 0; i < tGNodeArray.length; ++i) {
                    TGNode tGNode = tGNodeArray[i];
                    if (tGNode instanceof GanttTask) {
                        appGanttChartModel.changeParentTask((GanttTask)tGNode, ganttWBS, this.table, i > 0);
                        continue;
                    }
                    appGanttChartModel.changeParentWBS((GanttWBS)tGNode, ganttWBS, this.table);
                    if (i <= 0) continue;
                    Change change = appGanttChartModel.getChangeManager().getLastChange();
                    change.setLinkedToPreviousChange(true);
                }
                dropTargetDropEvent.dropComplete(true);
                return;
            }
        }
        catch (Exception exception) {
            SwingUtilities.convertPointToScreen(point, this.table);
            WDDialog.showErrorMsgDialog(this.table, exception, point, true);
        }
        dropTargetDropEvent.dropComplete(false);
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(TransferableNode.NODE_FLAVOR)) {
            dropTargetDragEvent.acceptDrag(2);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        this.dragPane.remove(this.draggedLabel);
        this.dragPane.remove(this.interRowHighlightLabel);
        this.dragPane.remove(this.rowHighlightLabel);
        this.dragPane.repaint();
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.getDragSourceContext().setCursor(null);
        this.draggedLabel.setVisible(false);
        this.interRowHighlightLabel.setVisible(false);
        this.rowHighlightLabel.setVisible(false);
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
        if (dragSourceContext.getCursor() != this.cursor) {
            dragSourceContext.setCursor(this.cursor);
        }
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    private void autoscroll(Point point) {
        Insets insets = this.autoscrollInsets;
        Rectangle rectangle = this.table.getVisibleRect();
        Rectangle rectangle2 = new Rectangle(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - (insets.left + insets.right), rectangle.height - (insets.top + insets.bottom));
        if (!rectangle2.contains(point)) {
            Rectangle rectangle3 = new Rectangle(point.x - insets.left, point.y - insets.top, insets.left + insets.right, insets.top + insets.bottom);
            this.table.scrollRectToVisible(rectangle3);
        }
    }

    private GanttNode[] getNodes(ObjectRef[] objectRefArray) {
        AppGanttChartModel appGanttChartModel = this.table.getGanttControler().getModel();
        GanttNode[] ganttNodeArray = new GanttNode[objectRefArray.length];
        for (int i = 0; i < objectRefArray.length; ++i) {
            ganttNodeArray[i] = appGanttChartModel.getProjectModel(objectRefArray[i].projectId).getNodeByUid(objectRefArray[i].id);
        }
        return ganttNodeArray;
    }

    protected DropActionWithRow getDropActionAvailableAt(Point point, TGNode[] tGNodeArray) {
        int n;
        DropActionWithRow dropActionWithRow = new DropActionWithRow();
        if (tGNodeArray == null || tGNodeArray.length == 0) {
            return dropActionWithRow;
        }
        int n2 = point.y;
        int n3 = this.table.getRowHeight();
        int n4 = n2 / n3;
        if (n4 < 0 || n4 >= this.table.getRowCount()) {
            return dropActionWithRow;
        }
        TGNode tGNode = this.table.getModel().nodeForRow(n4);
        if (tGNode == null) {
            return dropActionWithRow;
        }
        if (tGNodeArray.length > 1) {
            TGNode[] tGNodeArray2 = tGNodeArray[0].getParent();
            for (n = 1; n < tGNodeArray.length; ++n) {
                if (tGNodeArray2 == tGNodeArray[n].getParent()) continue;
                return dropActionWithRow;
            }
        }
        if (((GanttNode)tGNodeArray[0]).isProjectRoot()) {
            return dropActionWithRow;
        }
        for (TGNode tGNode2 : tGNodeArray) {
            if (tGNode2 != tGNode) continue;
            return dropActionWithRow;
        }
        int n5 = 0;
        n = 3;
        if (n2 < n4 * n3 + n) {
            n5 = -1;
        } else if (n2 > (n4 + 1) * n3 - n) {
            n5 = 1;
        }
        if (n5 != 0) {
            int n6;
            TGNode tGNode3;
            TGNode tGNode2;
            if (tGNodeArray.length > 1) {
                return dropActionWithRow;
            }
            TGNode tGNode4 = tGNodeArray[0];
            if (n5 < 0) {
                tGNode3 = this.table.getModel().nodeForRow(n4 - 1);
                tGNode2 = tGNode;
            } else {
                tGNode3 = tGNode;
                tGNode2 = ++n4 == this.table.getRowCount() ? null : this.table.getModel().nodeForRow(n4);
            }
            if (tGNode3 == null || tGNode3 instanceof EmptyNode) {
                return dropActionWithRow;
            }
            if (tGNode2 instanceof EmptyNode) {
                tGNode2 = null;
            }
            if (tGNode2 == tGNode4 || tGNode3 == tGNode4) {
                return dropActionWithRow;
            }
            TGNode tGNode5 = tGNode4.getParent();
            TGNode tGNode6 = null;
            if (tGNode3.getParent() == tGNode5) {
                if (tGNode2 == null) {
                    GanttWBS ganttWBS = (GanttWBS)tGNode5;
                    n6 = ganttWBS.getAllSubTaskCount();
                } else if (tGNode2.getParent() == tGNode3) {
                    tGNode6 = tGNode3;
                    n6 = 1;
                } else {
                    int n7;
                    int n8 = tGNode3.getSubId();
                    n6 = n8 > (n7 = tGNode4.getSubId()) ? n8 : n8 + 1;
                }
            } else if (tGNode3 == tGNode5) {
                n6 = 1;
            } else if (tGNode2 == null) {
                tGNode6 = TGChart.getUIParentNode(tGNode3);
                n6 = tGNode6.getAllNonEmptySubTaskCount() + 1;
            } else if (TGChart.getUIParentNode(tGNode2) == TGChart.getUIParentNode(tGNode3)) {
                tGNode6 = TGChart.getUIParentNode(tGNode3);
                n6 = tGNode3.getSubId() + 1;
            } else if (TGChart.getUIParentNode(tGNode2) != tGNode3) {
                tGNode6 = TGChart.getUIParentNode(tGNode3);
                n6 = tGNode6.getAllNonEmptySubTaskCount() + 1;
            } else {
                tGNode6 = tGNode3;
                n6 = 1;
            }
            dropActionWithRow.setAction(144);
            if (tGNode6 == null) {
                tGNode6 = tGNode5;
            } else {
                this.checkCanChangeParent(tGNodeArray, (GanttWBS)tGNode6, dropActionWithRow);
            }
            dropActionWithRow.data = tGNode6.getHierarchicalId() + '.' + n6;
            dropActionWithRow.rowIdx = n4;
        } else if (tGNode instanceof GanttWBS) {
            dropActionWithRow.setAction(32);
            dropActionWithRow.rowIdx = n4;
            this.checkCanChangeParent(tGNodeArray, (GanttWBS)tGNode, dropActionWithRow);
        }
        return dropActionWithRow;
    }

    private void checkCanChangeParent(TGNode[] tGNodeArray, GanttWBS ganttWBS, DropActionWithRow dropActionWithRow) {
        if (ganttWBS.isSubProject()) {
            dropActionWithRow.setNotAvailable(null);
            return;
        }
        for (TGNode tGNode : tGNodeArray) {
            if (tGNode.getParent() == ganttWBS) {
                dropActionWithRow.setNotAvailable("operation_not_available_same_parent");
                return;
            }
            if (!(tGNode instanceof GanttTask) && this.isDescendant(ganttWBS, tGNode)) {
                dropActionWithRow.setNotAvailable("operation_not_available_child_node");
                return;
            }
            if (ganttWBS.isSameProject((GanttNode)tGNode)) continue;
            dropActionWithRow.setNotAvailable(null);
            return;
        }
    }

    private boolean isDescendant(TGNode tGNode, TGNode tGNode2) {
        while (tGNode != null) {
            if (tGNode == tGNode2) {
                return true;
            }
            tGNode = tGNode.getParent();
        }
        return false;
    }

    private class DropActionWithRow
    extends DropAction {
        int rowIdx = -1;

        private DropActionWithRow() {
        }
    }
}

