/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.social;

import com.flowbuilder.util.TString;
import com.flowbuilder.util.xml.JDOMUtil;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.AppGlobalContext;
import com.triloggroup.gantt.app.applet.GanttAppletBase;
import com.triloggroup.gantt.app.applet.IJSCallBack;
import com.triloggroup.gantt.app.applet.JSCallBack;
import com.triloggroup.gantt.app.social.BookmarksAndCommentsDialog;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.xsp.XSPActions;
import com.triloggroup.project.social.Bookmark;
import com.triloggroup.util.UString;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jdom.Document;
import org.jdom.Element;
import org.json.JSONException;
import org.json.JSONObject;

public class XSPSocialActions
extends XSPActions {
    public XSPSocialActions(JComponent jComponent, GanttAppletBase ganttAppletBase) {
        super(jComponent, ganttAppletBase);
    }

    public boolean showBookmarkForm(int n, String string) {
        GanttAppletBase ganttAppletBase = this.getApplet();
        if (ganttAppletBase == null) {
            return false;
        }
        this.exitFullScreenMode();
        ganttAppletBase.callJS("tg_showBookmarkForm(\"" + n + "\", \"" + string + "\");");
        return true;
    }

    public boolean showCustomBookmark(Bookmark bookmark, String string) {
        GanttAppletBase ganttAppletBase = this.getApplet();
        if (ganttAppletBase == null) {
            return false;
        }
        this.exitFullScreenMode();
        ganttAppletBase.callJSWithResult("tg_showCustomBookmark", bookmark.toJSON(), string);
        return true;
    }

    public void addChangeBookmark(GanttNode ganttNode, BookmarksAndCommentsDialog bookmarksAndCommentsDialog) {
        AddBookmarkCallBack addBookmarkCallBack = new AddBookmarkCallBack(ganttNode, bookmarksAndCommentsDialog){

            protected Bookmark loadBookmark(String string) {
                String[] stringArray = UString.splitString(string, '|');
                if (stringArray.length < 7) {
                    throw new IllegalArgumentException("Invalid Change data");
                }
                Bookmark bookmark = new Bookmark();
                bookmark.type = 5;
                bookmark.authorCn = stringArray[0];
                bookmark.authorDn = stringArray[1];
                bookmark.title = stringArray[2];
                bookmark.peId = stringArray[3];
                bookmark.date = JDOMUtil.parseUtilDate(stringArray[4]);
                bookmark.docId = stringArray[5];
                this.addReverseBookmark = Boolean.valueOf(stringArray[6]);
                return bookmark;
            }
        };
        if (bookmarksAndCommentsDialog != null) {
            bookmarksAndCommentsDialog.setVisible(false);
        }
        this.showBookmarkPickerForm(ganttNode, 5, addBookmarkCallBack);
    }

    public void addIssueBookmark(GanttNode ganttNode, BookmarksAndCommentsDialog bookmarksAndCommentsDialog) {
        AddBookmarkCallBack addBookmarkCallBack = new AddBookmarkCallBack(ganttNode, bookmarksAndCommentsDialog){

            protected Bookmark loadBookmark(String string) {
                String[] stringArray = UString.splitString(string, '|');
                if (stringArray.length < 7) {
                    throw new IllegalArgumentException("Invalid Issue data");
                }
                Bookmark bookmark = new Bookmark();
                bookmark.type = 4;
                bookmark.authorCn = stringArray[0];
                bookmark.authorDn = stringArray[1];
                bookmark.title = stringArray[2];
                bookmark.peId = stringArray[3];
                bookmark.date = JDOMUtil.parseUtilDate(stringArray[4]);
                bookmark.docId = stringArray[5];
                this.addReverseBookmark = Boolean.valueOf(stringArray[6]);
                return bookmark;
            }
        };
        if (bookmarksAndCommentsDialog != null) {
            bookmarksAndCommentsDialog.setVisible(false);
        }
        this.showBookmarkPickerForm(ganttNode, 4, addBookmarkCallBack);
    }

    public void addActivityBookmark(GanttNode ganttNode, BookmarksAndCommentsDialog bookmarksAndCommentsDialog) {
        AddBookmarkCallBack addBookmarkCallBack = new AddBookmarkCallBack(ganttNode, bookmarksAndCommentsDialog){

            protected Bookmark loadBookmark(String string) {
                String[] stringArray = UString.splitString(string, '|');
                if (stringArray.length < 8) {
                    throw new IllegalArgumentException("Invalid Activity data");
                }
                Bookmark bookmark = new Bookmark();
                bookmark.type = 7;
                bookmark.authorCn = stringArray[0];
                bookmark.authorDn = stringArray[1];
                bookmark.title = stringArray[2];
                bookmark.date = JDOMUtil.parseUtilDate(stringArray[3]);
                bookmark.docId = stringArray[5];
                bookmark.url = stringArray[7];
                return bookmark;
            }
        };
        if (bookmarksAndCommentsDialog != null) {
            bookmarksAndCommentsDialog.setVisible(false);
        }
        this.showBookmarkPickerForm(ganttNode, 7, addBookmarkCallBack);
    }

    public void addDocumentBookmark(final GanttNode ganttNode, final BookmarksAndCommentsDialog bookmarksAndCommentsDialog) {
        if (bookmarksAndCommentsDialog != null) {
            bookmarksAndCommentsDialog.setVisible(false);
        }
        this.selectDocument(ganttNode, new DocPickerCallback(){

            public void documentSelected(Bookmark[] bookmarkArray) throws Exception {
                boolean[] blArray = new boolean[bookmarkArray.length];
                XSPSocialActions.this.applet.getGanttChart().getSocialManager().addBookmarksAndShow(ganttNode, bookmarkArray, blArray, bookmarksAndCommentsDialog);
            }
        }, bookmarksAndCommentsDialog);
    }

    public void selectDocument(GanttNode ganttNode, final DocPickerCallback docPickerCallback, final BookmarksAndCommentsDialog bookmarksAndCommentsDialog) {
        JSCallBack jSCallBack = new JSCallBack(){

            public void actionCancelled() {
                if (bookmarksAndCommentsDialog != null && !bookmarksAndCommentsDialog.isShowing()) {
                    bookmarksAndCommentsDialog.setVisible(true);
                }
            }

            public void actionPerformed(final String string) {
                if (UString.isEmpty(string)) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        try {
                            Document document = JDOMUtil.read(string);
                            Element element = document.getRootElement();
                            List list = element.getChildren("entry");
                            Bookmark[] bookmarkArray = new Bookmark[list.size()];
                            for (int i = 0; i < bookmarkArray.length; ++i) {
                                Element element2 = (Element)list.get(i);
                                bookmarkArray[i] = new Bookmark();
                                bookmarkArray[i].type = 1;
                                bookmarkArray[i].authorCn = element2.getChildText("authorName");
                                try {
                                    bookmarkArray[i].date = new Date(JDOMUtil.getLong(element2, "publishedDateTime"));
                                }
                                catch (Throwable throwable) {
                                    System.out.println("Error to parse date time " + element2.getChildText("publishedDateTime"));
                                    bookmarkArray[i].date = new Date();
                                }
                                bookmarkArray[i].docId = element2.getChildText("id");
                                bookmarkArray[i].title = element2.getChildText("title");
                                bookmarkArray[i].url = element2.getChildText("viewHtmlUrl");
                                bookmarkArray[i].entryUrl = element2.getChildText("entryUrl");
                                bookmarkArray[i].contentUrl = element2.getChildText("contentUrl");
                            }
                            docPickerCallback.documentSelected(bookmarkArray);
                        }
                        catch (Exception exception) {
                            WDDialog.showErrorMsgDialog(XSPSocialActions.this.applet, exception);
                        }
                    }
                });
            }
        };
        this.showBookmarkPickerForm(ganttNode, 1, jSCallBack);
    }

    private void showBookmarkPickerForm(GanttNode ganttNode, int n, IJSCallBack iJSCallBack) {
        GanttAppletBase ganttAppletBase = this.getApplet();
        if (ganttAppletBase == null) {
            return;
        }
        this.exitFullScreenMode();
        String string = ganttNode.getGlobalContext().getSiteId();
        String string2 = ganttNode.getProjectContext().getProjectId();
        ganttAppletBase.callJS("tg_showBookmarkPickerForm(" + n + ", '" + string + "', '" + string2 + "', '" + ganttNode.getUid() + "', '" + ganttAppletBase.getHtmlTagId() + "');", iJSCallBack);
    }

    public void addCustomBookmark(GanttNode ganttNode, BookmarksAndCommentsDialog bookmarksAndCommentsDialog, final int n, String string) {
        GanttAppletBase ganttAppletBase = this.getApplet();
        if (ganttAppletBase == null) {
            return;
        }
        this.exitFullScreenMode();
        AppGlobalContext appGlobalContext = (AppGlobalContext)ganttNode.getGlobalContext();
        String string2 = appGlobalContext.getSiteId();
        String string3 = ganttNode.getProjectContext().getProjectId();
        final String string4 = appGlobalContext.getCurrentUserCn();
        final String string5 = appGlobalContext.getCurrentUserDn();
        AddBookmarkCallBack addBookmarkCallBack = new AddBookmarkCallBack(ganttNode, bookmarksAndCommentsDialog){
            {
                super(ganttNode, bookmarksAndCommentsDialog);
                this.forceRefresh = true;
            }

            protected Bookmark loadBookmark(String string) {
                try {
                    JSONObject jSONObject = new JSONObject(string);
                    Bookmark bookmark = new Bookmark();
                    bookmark.type = n;
                    bookmark.authorCn = string4;
                    bookmark.authorDn = string5;
                    bookmark.date = new Date();
                    bookmark.title = this.getString(jSONObject, "title");
                    bookmark.url = this.getString(jSONObject, "url");
                    bookmark.docId = this.getString(jSONObject, "id");
                    bookmark.deliverable = this.getBoolean(jSONObject, "deliverable");
                    return bookmark;
                }
                catch (JSONException jSONException) {
                    throw new IllegalArgumentException("Invalid custom bookmark string: " + string, jSONException);
                }
            }

            private String getString(JSONObject jSONObject, String string) {
                try {
                    return jSONObject.getString(string);
                }
                catch (JSONException jSONException) {
                    return "";
                }
            }

            private boolean getBoolean(JSONObject jSONObject, String string) {
                try {
                    return jSONObject.getBoolean(string);
                }
                catch (JSONException jSONException) {
                    return false;
                }
            }
        };
        ganttAppletBase.callJS("tg_createCustomBookmark(" + n + ",'" + string2 + "','" + string3 + "','" + ganttNode.getUid() + "','" + ganttAppletBase.getHtmlTagId() + "'," + TString.toJavaString(string, true) + ',' + n + ");", addBookmarkCallBack);
    }

    private abstract class AddBookmarkCallBack
    implements IJSCallBack {
        GanttNode node;
        BookmarksAndCommentsDialog dialog;
        boolean forceRefresh = false;
        boolean addReverseBookmark = false;

        AddBookmarkCallBack(GanttNode ganttNode, BookmarksAndCommentsDialog bookmarksAndCommentsDialog) {
            this.node = ganttNode;
            this.dialog = bookmarksAndCommentsDialog;
        }

        public void actionCancelled() {
            this.showDialog();
        }

        private void showDialog() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (AddBookmarkCallBack.this.dialog != null && !AddBookmarkCallBack.this.dialog.isShowing()) {
                        AddBookmarkCallBack.this.dialog.setVisible(true);
                    }
                }
            });
        }

        private void showError(final Exception exception) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WDDialog.showErrorMsgDialog(XSPSocialActions.this.applet, exception);
                }
            });
        }

        public void actionPerformed(String string) {
            if (UString.isEmpty(string)) {
                this.showDialog();
                return;
            }
            Bookmark bookmark = this.loadBookmark(string);
            if (bookmark == null) {
                this.showDialog();
                return;
            }
            try {
                XSPSocialActions.this.applet.getGanttChart().getSocialManager().addBookmarksOnServer(this.node, new Bookmark[]{bookmark}, new boolean[]{this.addReverseBookmark}, this.forceRefresh);
            }
            catch (Exception exception) {
                this.showError(exception);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AppGanttChart appGanttChart = XSPSocialActions.this.applet.getGanttChart();
                    appGanttChart.getTreeTable().repaint();
                    if (AddBookmarkCallBack.this.dialog != null) {
                        AddBookmarkCallBack.this.dialog.load();
                    } else {
                        appGanttChart.getActions().showSocialData(AddBookmarkCallBack.this.node, false);
                    }
                }
            });
        }

        protected abstract Bookmark loadBookmark(String var1);
    }

    public static interface DocPickerCallback {
        public void documentSelected(Bookmark[] var1) throws Exception;
    }
}

