/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.social;

import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.change.Change;
import com.triloggroup.gantt.app.change.TransformTaskIntoWBSChange;
import com.triloggroup.gantt.app.change.TransformWBSIntoTaskChange;
import com.triloggroup.gantt.app.social.BookmarksAndCommentsDialog;
import com.triloggroup.gantt.app.social.NodeSocialData;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.project.components.ui.NetworkImageIcon;
import com.triloggroup.project.social.Bookmark;
import com.triloggroup.project.social.BookmarksAndComments;
import com.triloggroup.project.social.CommentEntry;
import com.triloggroup.project.social.NotificationConfig;
import com.triloggroup.util.UString;
import java.awt.Image;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SocialManager
implements ChangeListener {
    public static Icon MESSAGE_ICON = WDUtil.getIcon("social/comment.png");
    public static Icon MESSAGE_HIGHLIGHT_ICON = WDUtil.getIcon("social/commentHighlight.png");
    public static Icon BOOKMARK_ICON = WDUtil.getIcon("social/bookmark.gif");
    public static Icon DELIVERABLE_ICON = WDUtil.getIcon("social/deliverable.gif");
    private HashMap<String, ImageIcon> userPicturesCache;
    private AppGanttChart gantt;
    private ChangeListener userIconChangeListener;
    private static ImageIcon defaultUserIcon = null;
    static Comparator<CommentEntry> COMMENT_DATE_COMPARATOR = new Comparator<CommentEntry>(){

        @Override
        public int compare(CommentEntry commentEntry, CommentEntry commentEntry2) {
            return commentEntry2.date.compareTo(commentEntry.date);
        }
    };

    public SocialManager(AppGanttChart appGanttChart) {
        this.gantt = appGanttChart;
        this.userPicturesCache = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BookmarksAndComments getBookmarksAndCommentsForNode(GanttNode ganttNode) throws Exception {
        GanttNode ganttNode2 = ganttNode;
        synchronized (ganttNode2) {
            NodeSocialData nodeSocialData = ganttNode.getSocialData();
            if (nodeSocialData.bookmarksAndComments == null) {
                if (ganttNode.getDocId() == null && !GanttNode.isSubprojectLink(ganttNode)) {
                    BookmarksAndComments bookmarksAndComments = this.getBookmarksAndCommentsForPotentiallyTransformedNode(ganttNode);
                    if (bookmarksAndComments != null) {
                        return bookmarksAndComments;
                    }
                    nodeSocialData.bookmarksAndComments = new BookmarksAndComments();
                } else {
                    nodeSocialData.bookmarksAndComments = this.loadBookmarksAndThreadsForNode(ganttNode);
                }
                this.bookmarksAndCommentsModified(nodeSocialData);
            }
            return nodeSocialData.bookmarksAndComments;
        }
    }

    private BookmarksAndComments getBookmarksAndCommentsForPotentiallyTransformedNode(GanttNode ganttNode) throws Exception {
        block3: {
            ArrayList<Change> arrayList;
            block2: {
                arrayList = this.gantt.getModel().getChangeManager().getAllChanges();
                if (!(ganttNode instanceof GanttWBS)) break block2;
                for (Change change : arrayList) {
                    if (change.getOperation() != 6 || ((TransformTaskIntoWBSChange)change).getWBS() != ganttNode) continue;
                    GanttTask ganttTask = (GanttTask)change.getTarget();
                    return this.getBookmarksAndCommentsForTransformedNode(ganttNode, ganttTask);
                }
                break block3;
            }
            if (!(ganttNode instanceof GanttTask)) break block3;
            for (Change change : arrayList) {
                if (change.getOperation() != 7 || ((TransformWBSIntoTaskChange)change).getTask() != ganttNode) continue;
                GanttWBS ganttWBS = (GanttWBS)change.getTarget();
                return this.getBookmarksAndCommentsForTransformedNode(ganttNode, ganttWBS);
            }
        }
        return null;
    }

    private BookmarksAndComments getBookmarksAndCommentsForTransformedNode(GanttNode ganttNode, GanttNode ganttNode2) throws Exception {
        BookmarksAndComments bookmarksAndComments = ganttNode2.getSocialData().bookmarksAndComments;
        if (bookmarksAndComments != null) {
            ganttNode.getSocialData().bookmarksAndComments = bookmarksAndComments;
            this.bookmarksAndCommentsModified(ganttNode.getSocialData());
            return bookmarksAndComments;
        }
        if (ganttNode2.getDocId() != null) {
            ganttNode.getSocialData().bookmarksAndComments = bookmarksAndComments = this.loadBookmarksAndThreadsForNode(ganttNode2);
            this.bookmarksAndCommentsModified(ganttNode.getSocialData());
            return bookmarksAndComments;
        }
        return this.getBookmarksAndCommentsForPotentiallyTransformedNode(ganttNode2);
    }

    public ImageIcon getUserIcon(String string) {
        ImageIcon imageIcon = this.userPicturesCache.get(string);
        if (imageIcon == null) {
            imageIcon = this.loadUserIcon(string);
            if (imageIcon == null) {
                imageIcon = this.getDefaultUserIcon();
            }
            this.userPicturesCache.put(string, imageIcon);
        }
        return imageIcon;
    }

    private ImageIcon loadUserIcon(String string) {
        try {
            String string2 = this.gantt.getModel().getGlobalContext().getServerBaseUrl() + "/projexec/shared/pe_shared_ajaxdatadispatcher.xsp?javaHandlerClass=com.triloggroup.pe.user.UserImage&dn=";
            string2 = string2 + URLEncoder.encode(string, "UTF-8");
            Image image = this.getDefaultUserIcon().getImage();
            String string3 = this.gantt.getModel().getGlobalContext().getCookies();
            NetworkImageIcon networkImageIcon = new NetworkImageIcon(new URL(string2), image, true, string3);
            networkImageIcon.setChangeListener(this);
            return networkImageIcon;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageIcon getDefaultUserIcon() {
        if (defaultUserIcon == null) {
            SocialManager socialManager = this;
            synchronized (socialManager) {
                if (defaultUserIcon == null) {
                    defaultUserIcon = WDUtil.getIcon("social/photo35.png");
                }
            }
        }
        return defaultUserIcon;
    }

    private BookmarksAndComments loadBookmarksAndThreadsForNode(GanttNode ganttNode) throws Exception {
        BookmarksAndComments bookmarksAndComments = this.gantt.getSocialDataProvider(ganttNode.getProjectContext()).getBookmarksAndComments(ganttNode);
        return bookmarksAndComments;
    }

    public boolean canAddComment() {
        return true;
    }

    public boolean canAddBookmark() {
        return true;
    }

    void postCommentOnServer(CommentEntry commentEntry, NotificationConfig notificationConfig, GanttNode ganttNode, boolean bl) throws Exception {
        if (ganttNode.getDocId() == null) {
            throw new IllegalStateException("Node has no doc id");
        }
        NodeSocialData nodeSocialData = ganttNode.getSocialData();
        if (nodeSocialData.bookmarksAndComments == null) {
            throw new IllegalStateException("Comments not loaded for node " + ganttNode);
        }
        commentEntry.date = new Date();
        commentEntry.authorDn = this.gantt.getModel().getGlobalContext().getCurrentUserDn();
        commentEntry.authorCn = this.gantt.getModel().getGlobalContext().getCurrentUserCn();
        String string = this.gantt.getSocialDataProvider(ganttNode.getProjectContext()).postComment(commentEntry, notificationConfig, ganttNode, bl);
        String[] stringArray = UString.splitString(string, '|');
        commentEntry.id = stringArray[0];
        ganttNode.setLastModificationTime(Long.parseLong(stringArray[1]));
        CommentEntry[] commentEntryArray = nodeSocialData.bookmarksAndComments.comments;
        CommentEntry[] commentEntryArray2 = new CommentEntry[commentEntryArray.length + 1];
        System.arraycopy(commentEntryArray, 0, commentEntryArray2, 0, commentEntryArray.length);
        commentEntryArray2[commentEntryArray2.length - 1] = commentEntry;
        nodeSocialData.bookmarksAndComments.comments = commentEntryArray2;
        nodeSocialData.commentCount = commentEntryArray2.length;
        if (nodeSocialData.getLastCommentDate() == null || nodeSocialData.getLastCommentDate().before(commentEntry.date)) {
            nodeSocialData.lastComment = commentEntry.date;
        }
    }

    void updateCommentOnServer(CommentEntry commentEntry, CommentEntry commentEntry2, GanttNode ganttNode) throws Exception {
        if (ganttNode.getDocId() == null) {
            throw new IllegalStateException("Node has no doc id");
        }
        NodeSocialData nodeSocialData = ganttNode.getSocialData();
        if (nodeSocialData.bookmarksAndComments == null) {
            throw new IllegalStateException("Comments not loaded for node " + ganttNode);
        }
        long l = this.gantt.getSocialDataProvider(ganttNode.getProjectContext()).updateComment(commentEntry2, ganttNode);
        ganttNode.setLastModificationTime(l);
        commentEntry.date = new Date();
        commentEntry.body = commentEntry2.body;
        commentEntry.attachments = commentEntry2.attachments;
        commentEntry.bookmarks = commentEntry2.bookmarks;
        if (nodeSocialData.getLastCommentDate() == null || nodeSocialData.getLastCommentDate().before(commentEntry.date)) {
            nodeSocialData.lastComment = commentEntry.date;
        }
    }

    void deleteCommentOnServer(CommentEntry commentEntry, GanttNode ganttNode) throws Exception {
        if (ganttNode.getDocId() == null) {
            throw new IllegalStateException("Node has no doc id");
        }
        NodeSocialData nodeSocialData = ganttNode.getSocialData();
        BookmarksAndComments bookmarksAndComments = nodeSocialData.bookmarksAndComments;
        if (bookmarksAndComments == null) {
            throw new IllegalStateException("Comments not loaded for node " + ganttNode);
        }
        ArrayList<CommentEntry> arrayList = new ArrayList<CommentEntry>();
        Date date = null;
        for (CommentEntry commentEntry2 : bookmarksAndComments.comments) {
            if (commentEntry2 == commentEntry || commentEntry2.parentId != null && commentEntry2.parentId.equals(commentEntry.id)) continue;
            arrayList.add(commentEntry2);
            if (date != null && !commentEntry2.date.after(date)) continue;
            date = commentEntry2.date;
        }
        if (arrayList.size() >= bookmarksAndComments.comments.length) {
            throw new IllegalStateException("Comment to delete not found");
        }
        long l = this.gantt.getSocialDataProvider(ganttNode.getProjectContext()).deleteComment(commentEntry, ganttNode);
        ganttNode.setLastModificationTime(l);
        bookmarksAndComments.comments = arrayList.toArray(new CommentEntry[0]);
        nodeSocialData.commentCount = bookmarksAndComments.comments.length;
        nodeSocialData.lastComment = date;
    }

    void deleteBookmarkOnServer(Bookmark bookmark, GanttNode ganttNode) throws Exception {
        if (ganttNode.getDocId() == null) {
            throw new IllegalStateException("Node has no doc id");
        }
        NodeSocialData nodeSocialData = ganttNode.getSocialData();
        BookmarksAndComments bookmarksAndComments = nodeSocialData.bookmarksAndComments;
        if (bookmarksAndComments == null) {
            throw new IllegalStateException("bookmarks not loaded for node " + ganttNode);
        }
        ArrayList<Bookmark> arrayList = new ArrayList<Bookmark>();
        for (Bookmark bookmark2 : bookmarksAndComments.bookmarks) {
            if (bookmark2 == bookmark) continue;
            arrayList.add(bookmark2);
        }
        if (arrayList.size() >= bookmarksAndComments.bookmarks.length) {
            throw new IllegalStateException("bookmark to delete not found");
        }
        long l = this.gantt.getSocialDataProvider(ganttNode.getProjectContext()).deleteBookmark(bookmark, ganttNode);
        if (l == -1L) {
            throw new Exception("Bookmark not deleted on server");
        }
        ganttNode.setLastModificationTime(l);
        bookmarksAndComments.bookmarks = arrayList.toArray(new Bookmark[0]);
        this.bookmarksModified(nodeSocialData);
    }

    NotificationConfig loadNotificationConfig(GanttNode ganttNode) throws Exception {
        return this.gantt.getSocialDataProvider(ganttNode.getProjectContext()).getNotificationConfig(ganttNode);
    }

    public void addBookmarksAndShow(GanttNode ganttNode, Bookmark[] bookmarkArray, boolean[] blArray, BookmarksAndCommentsDialog bookmarksAndCommentsDialog) throws Exception {
        boolean bl = this.addBookmarksOnServer(ganttNode, bookmarkArray, blArray, false);
        for (int i = 0; i < bookmarkArray.length; ++i) {
            NodeSocialData nodeSocialData;
            GanttNode ganttNode2;
            if (!blArray[i] || bookmarkArray[i].type != 3 || (ganttNode2 = this.gantt.getModel().getProjectModel(ganttNode.getProjectId()).getNodeByUid(bookmarkArray[i].peId)) == null || (nodeSocialData = ganttNode2.getSocialData()) == null) continue;
            boolean bl2 = false;
            for (int j = 0; j < nodeSocialData.getBookmarkCount(); ++j) {
                Bookmark bookmark = nodeSocialData.bookmarksAndComments.bookmarks[j];
                if (bookmark.type != 3 || !UString.equals(bookmark.peId, ganttNode.getUid())) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            nodeSocialData.updateSummary(nodeSocialData.getBookmarkCount() + 1, nodeSocialData.getCommentCount(), nodeSocialData.lastComment, nodeSocialData.deliverableCount);
        }
        if (bl) {
            this.gantt.getTreeTable().repaint();
        }
        if (bookmarksAndCommentsDialog == null) {
            this.gantt.getActions().showSocialData(ganttNode, false);
        } else if (bl) {
            bookmarksAndCommentsDialog.bookmarksAdded(bookmarkArray);
            if (!bookmarksAndCommentsDialog.isShowing()) {
                bookmarksAndCommentsDialog.setVisible(true);
            }
        }
    }

    boolean addBookmarksOnServer(GanttNode ganttNode, Bookmark[] bookmarkArray, boolean[] blArray, boolean bl) throws Exception {
        BookmarksAndComments bookmarksAndComments;
        if (ganttNode.getDocId() == null) {
            throw new IllegalStateException("Node has no doc id");
        }
        if (bl) {
            bookmarksAndComments = null;
            ganttNode.getSocialData().bookmarksAndComments = null;
        } else {
            bookmarksAndComments = this.getBookmarksAndCommentsForNode(ganttNode);
        }
        long l = this.gantt.getSocialDataProvider(ganttNode.getProjectContext()).addBookmarks(bookmarkArray, blArray, ganttNode);
        if (l < 0L) {
            return false;
        }
        ganttNode.setLastModificationTime(l);
        NodeSocialData nodeSocialData = ganttNode.getSocialData();
        if (bl) {
            int n = 0;
            for (Bookmark bookmark : bookmarkArray) {
                if (!bookmark.deliverable) continue;
                ++n;
            }
            nodeSocialData.deliverableCount += n;
            nodeSocialData.bookmarkCount += bookmarkArray.length;
        } else {
            if (bookmarksAndComments.bookmarks == null || bookmarksAndComments.bookmarks.length == 0) {
                bookmarksAndComments.bookmarks = bookmarkArray;
            } else {
                Bookmark[] bookmarkArray2 = new Bookmark[bookmarksAndComments.bookmarks.length + bookmarkArray.length];
                System.arraycopy(bookmarksAndComments.bookmarks, 0, bookmarkArray2, 0, bookmarksAndComments.bookmarks.length);
                System.arraycopy(bookmarkArray, 0, bookmarkArray2, bookmarksAndComments.bookmarks.length, bookmarkArray.length);
                bookmarksAndComments.bookmarks = bookmarkArray2;
            }
            this.bookmarksModified(nodeSocialData);
        }
        return true;
    }

    public boolean checkOnServer(TGNode tGNode) {
        return this.checkOnServer(tGNode, null);
    }

    public boolean checkOnServer(TGNode tGNode, Runnable runnable) {
        if (this.isOnServer(tGNode)) {
            return true;
        }
        if (WDDialog.showYesNoDialog(this.gantt.getView(), AppGanttChart.NLS_BUNDLE.getString("socialNeedSavingPendingChangesQuestion"))) {
            if (runnable != null) {
                runnable.run();
            }
            this.gantt.saveChanges();
        }
        return false;
    }

    public boolean isOnServer(TGNode tGNode) {
        return tGNode.getDocId() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.userIconChangeListener != null) {
            SocialManager socialManager = this;
            synchronized (socialManager) {
                if (this.userIconChangeListener != null) {
                    this.userIconChangeListener.stateChanged(changeEvent);
                }
            }
        }
    }

    synchronized void setIconChangeListener(ChangeListener changeListener) {
        this.userIconChangeListener = changeListener;
    }

    private void bookmarksModified(NodeSocialData nodeSocialData) {
        Bookmark[] bookmarkArray;
        int n = 0;
        for (Bookmark bookmark : bookmarkArray = nodeSocialData.bookmarksAndComments.bookmarks) {
            if (!bookmark.deliverable) continue;
            ++n;
        }
        nodeSocialData.deliverableCount = n;
        nodeSocialData.bookmarkCount = bookmarkArray.length;
    }

    private void bookmarksAndCommentsModified(NodeSocialData nodeSocialData) {
        this.bookmarksModified(nodeSocialData);
        CommentEntry[] commentEntryArray = nodeSocialData.bookmarksAndComments.comments;
        nodeSocialData.commentCount = commentEntryArray.length;
        Date date = null;
        for (CommentEntry commentEntry : commentEntryArray) {
            if (date != null && (commentEntry.date == null || !date.before(commentEntry.date))) continue;
            date = commentEntry.date;
        }
        nodeSocialData.lastComment = date;
    }
}

