/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.filter;

import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.app.AppProjectModel;
import com.triloggroup.gantt.app.filter.AndOr;
import com.triloggroup.gantt.app.filter.CriteriaDef;
import com.triloggroup.gantt.app.filter.IRuntimeFilterNode;
import com.triloggroup.gantt.app.filter.Operator;
import com.triloggroup.gantt.app.filter.ValueType;

class Criteria
implements IRuntimeFilterNode,
Cloneable {
    public CriteriaDef def;
    public AndOr andOr;
    public boolean negation;
    public Operator operator;
    public Object[] value;
    private static final char SEPARATOR = '|';

    Criteria() {
    }

    public Criteria clone() {
        try {
            return (Criteria)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Not cloneable", cloneNotSupportedException);
        }
    }

    public Object getFirstValue() {
        if (this.value == null || this.value.length == 0) {
            return null;
        }
        return this.value[0];
    }

    public boolean accept(GanttTask ganttTask) {
        if (this.def == null) {
            return true;
        }
        boolean bl = this.def.accept(ganttTask, this.operator, this.value);
        return this.negation ? !bl : bl;
    }

    String encode() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.andOr.name()).append('|');
        if (this.negation) {
            stringBuilder.append('!');
        }
        stringBuilder.append(this.def.code).append('|');
        stringBuilder.append(this.operator.name()).append('|');
        stringBuilder.append(ValueType.writeValue(this.def.getValueType(), this.value));
        return stringBuilder.toString();
    }

    static Criteria decode(AppProjectModel appProjectModel, String string) {
        Criteria criteria = new Criteria();
        int n = string.indexOf(124);
        String string2 = string.substring(0, n);
        criteria.andOr = Enum.valueOf(AndOr.class, string2);
        int n2 = string.indexOf(124, n + 1);
        string2 = string.substring(n + 1, n2);
        if (string2.startsWith("!")) {
            criteria.negation = true;
            string2 = string2.substring(1);
        }
        criteria.def = CriteriaDef.fromCode(string2);
        n = n2;
        n2 = string.indexOf(124, n + 1);
        string2 = string.substring(n + 1, n2);
        criteria.operator = Enum.valueOf(Operator.class, string2);
        string2 = string.substring(n2 + 1);
        criteria.value = ValueType.readValue(appProjectModel, criteria.def.getValueType(), string2);
        return criteria;
    }
}

