/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.filter;

import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.INodeFilter;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.app.AppProjectModel;
import com.triloggroup.gantt.app.filter.AndOr;
import com.triloggroup.gantt.app.filter.ConditionFilterNode;
import com.triloggroup.gantt.app.filter.Criteria;
import com.triloggroup.gantt.app.filter.IRuntimeFilterNode;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedFilter
implements INodeFilter {
    private final String id;
    private String name;
    private boolean hideEmptyWBS;
    private boolean sharedAcrossProjects;
    private ArrayList<Criteria> criteria;
    private IRuntimeFilterNode filterTree;

    public AdvancedFilter(String string) {
        this.id = string;
    }

    public AdvancedFilter() {
        this.id = "filter_" + Long.toHexString(System.currentTimeMillis());
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public boolean isHideEmptyWBS() {
        return this.hideEmptyWBS;
    }

    public void setHideEmptyWBS(boolean bl) {
        this.hideEmptyWBS = bl;
    }

    public boolean isSharedAcrossProjects() {
        return this.sharedAcrossProjects;
    }

    public void setSharedAcrossProjects(boolean bl) {
        this.sharedAcrossProjects = bl;
    }

    public ArrayList<Criteria> getCriteria() {
        return this.criteria;
    }

    public void setCriteria(ArrayList<Criteria> arrayList) {
        this.criteria = arrayList;
        this.build();
    }

    public void build() {
        this.filterTree = null;
        ConditionFilterNode conditionFilterNode = null;
        for (Criteria criteria : this.criteria) {
            ConditionFilterNode conditionFilterNode2;
            IRuntimeFilterNode iRuntimeFilterNode;
            if (this.filterTree == null) {
                this.filterTree = criteria;
                continue;
            }
            if (criteria.andOr == AndOr.OR) {
                iRuntimeFilterNode = this.filterTree;
                conditionFilterNode = conditionFilterNode2 = ConditionFilterNode.or(iRuntimeFilterNode, criteria);
                this.filterTree = conditionFilterNode;
                continue;
            }
            iRuntimeFilterNode = conditionFilterNode != null ? conditionFilterNode.rightNode : this.filterTree;
            conditionFilterNode2 = ConditionFilterNode.and(iRuntimeFilterNode, criteria);
            if (conditionFilterNode != null) {
                conditionFilterNode.rightNode = conditionFilterNode2;
            } else {
                this.filterTree = conditionFilterNode2;
            }
            conditionFilterNode = conditionFilterNode2;
        }
    }

    public void loadCriteria(AppProjectModel appProjectModel, String[] stringArray) {
        ArrayList<Criteria> arrayList = new ArrayList<Criteria>();
        for (String string : stringArray) {
            arrayList.add(Criteria.decode(appProjectModel, string));
        }
        this.setCriteria(arrayList);
    }

    public String[] saveCriteria() {
        String[] stringArray = new String[this.criteria.size()];
        for (int i = 0; i < this.criteria.size(); ++i) {
            stringArray[i] = this.criteria.get(i).encode();
        }
        return stringArray;
    }

    @Override
    public boolean accept(TGNode tGNode) {
        if (this.filterTree != null && tGNode instanceof GanttTask) {
            return this.filterTree.accept((GanttTask)tGNode);
        }
        return true;
    }

    @Override
    public boolean acceptAll() {
        return this.filterTree == null;
    }
}

