/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.dialog;

import com.flowbuilder.util.TString;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.TaskResource;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.AppGanttChartModel;
import com.triloggroup.gantt.app.AppProjectModel;
import com.triloggroup.gantt.app.Status;
import com.triloggroup.gantt.app.ui.WDButton;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.gantt.pe.app.SchedulingMode;
import com.triloggroup.project.components.resourceeditor.ProjectResource;
import com.triloggroup.project.financial.FinancialSettings;
import com.triloggroup.util.NLSBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class PasteNodeFieldsDialog
extends WDDialog
implements ActionListener {
    private AppGanttChart ganttCtrl;
    private GanttNode sourceNode;
    private GanttNode[] targetsNodes;
    private JPanel mainPanel;
    private WDButton okButton;

    public static void showDialog(AppGanttChart appGanttChart, GanttNode ganttNode, GanttNode[] ganttNodeArray) {
        Window window = SwingUtilities.getWindowAncestor(appGanttChart.getView());
        GraphicsConfiguration graphicsConfiguration = WDUtil.getGraphicsConfiguration(appGanttChart.getView());
        PasteNodeFieldsDialog pasteNodeFieldsDialog = new PasteNodeFieldsDialog(window, graphicsConfiguration, appGanttChart, ganttNode, ganttNodeArray);
        pasteNodeFieldsDialog.setVisible(-1, -1, -1, -1, appGanttChart.getView());
    }

    protected PasteNodeFieldsDialog(Window window, GraphicsConfiguration graphicsConfiguration, AppGanttChart appGanttChart, GanttNode ganttNode, GanttNode[] ganttNodeArray) {
        super(window, graphicsConfiguration);
        this.ganttCtrl = appGanttChart;
        this.init(ganttNode, ganttNodeArray);
    }

    protected void init(GanttNode ganttNode, GanttNode[] ganttNodeArray) {
        FieldCheckBox fieldCheckBox;
        JComponent jComponent;
        JComponent jComponent2;
        JComponent jComponent3;
        JComponent jComponent4;
        FieldCheckBox fieldCheckBox2;
        this.sourceNode = ganttNode;
        this.targetsNodes = ganttNodeArray;
        boolean bl = ganttNode instanceof GanttTask;
        boolean bl2 = this.iAllTargetsAreTasks();
        NLSBundle nLSBundle = AppGanttChart.NLS_BUNDLE;
        boolean bl3 = this.isCrossProject();
        this.setDragHeader(true);
        this.setResizable(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createButtonsPanel(), "North");
        this.mainPanel = new JPanel(new GridBagLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JScrollPane jScrollPane = new JScrollPane(this.mainPanel);
        this.getContentPane().add((Component)jScrollPane, "Center");
        Insets insets = new Insets(0, 2, 2, 2);
        Insets insets2 = new Insets(5, 2, 2, 2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, insets2, 0, 0);
        FieldCheckBox fieldCheckBox3 = new FieldCheckBox(nLSBundle.getString("Name"), "name");
        this.mainPanel.add((Component)fieldCheckBox3, gridBagConstraints);
        FieldCheckBox fieldCheckBox4 = new FieldCheckBox(nLSBundle.getString("description"), "description");
        this.mainPanel.add((Component)fieldCheckBox4, gridBagConstraints);
        if (!bl3) {
            fieldCheckBox2 = new FieldCheckBox(nLSBundle.getString("wbsEntry"), "parentInternalId");
            this.mainPanel.add((Component)fieldCheckBox2, gridBagConstraints);
        }
        fieldCheckBox2 = new FieldCheckBox(nLSBundle.getString("resources"), "taskResources");
        this.mainPanel.add((Component)fieldCheckBox2, gridBagConstraints);
        if (bl && bl2) {
            FieldCheckBox fieldCheckBox5;
            jComponent4 = new FieldCheckBox(nLSBundle.getString("status"), "status");
            this.mainPanel.add((Component)jComponent4, gridBagConstraints);
            jComponent3 = new FieldCheckBox(nLSBundle.getString("percentComplete"), "percentComplete");
            this.mainPanel.add((Component)jComponent3, gridBagConstraints);
            jComponent2 = new JLabel(nLSBundle.getString("advanced"));
            this.mainPanel.add((Component)jComponent2, gridBagConstraints2);
            jComponent = new JSeparator();
            this.mainPanel.add((Component)jComponent, gridBagConstraints);
            fieldCheckBox = new FieldCheckBox(nLSBundle.getString("Priority"), "priority");
            this.mainPanel.add((Component)fieldCheckBox, gridBagConstraints);
            FieldCheckBox fieldCheckBox6 = new FieldCheckBox(nLSBundle.getString("schedulingConstraint"), "schedulingmode");
            this.mainPanel.add((Component)fieldCheckBox6, gridBagConstraints);
            if (!bl3) {
                fieldCheckBox5 = new FieldCheckBox(nLSBundle.getString("calendar"), "calendarid");
                this.mainPanel.add((Component)fieldCheckBox5, gridBagConstraints);
            }
            fieldCheckBox5 = new FieldCheckBox(nLSBundle.getString("ignoreUserCalendar"), "ignoreresourcecalendar");
            this.mainPanel.add((Component)fieldCheckBox5, gridBagConstraints);
        }
        if (this.canPasteFinancial()) {
            jComponent4 = new JLabel(nLSBundle.getString("costs"));
            this.mainPanel.add((Component)jComponent4, gridBagConstraints2);
            jComponent3 = new JSeparator();
            this.mainPanel.add((Component)jComponent3, gridBagConstraints);
            jComponent2 = new FieldCheckBox(nLSBundle.getString("AdditionalCost"), "additionalcost");
            this.mainPanel.add((Component)jComponent2, gridBagConstraints);
            jComponent = new FieldCheckBox(nLSBundle.getString("ActualAdditionalCost"), "actualadditionalcost");
            this.mainPanel.add((Component)jComponent, gridBagConstraints);
            fieldCheckBox = new FieldCheckBox(nLSBundle.getString("AdditionalCostDescription"), "additionalcostdescription");
            this.mainPanel.add((Component)fieldCheckBox, gridBagConstraints);
        }
    }

    private JPanel createButtonsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.okButton = WDUtil.createOkButton();
        jPanel.add(this.okButton);
        this.okButton.addActionListener(this);
        WDButton wDButton = WDUtil.createCancelButton();
        jPanel.add(wDButton);
        wDButton.addActionListener(this);
        return jPanel;
    }

    private boolean iAllTargetsAreTasks() {
        for (int i = 0; i < this.targetsNodes.length; ++i) {
            if (this.targetsNodes[i] instanceof GanttTask) continue;
            return false;
        }
        return true;
    }

    private boolean isCrossProject() {
        String string = this.sourceNode.getProjectId();
        for (GanttNode ganttNode : this.targetsNodes) {
            if (string.equals(ganttNode.getProjectId())) continue;
            return true;
        }
        return false;
    }

    private boolean canPasteFinancial() {
        AppGanttChartModel appGanttChartModel = this.ganttCtrl.getModel();
        if (!appGanttChartModel.getGlobalContext().hasFinancialModule()) {
            return false;
        }
        AppProjectModel appProjectModel = this.ganttCtrl.getModel().getProjectModel(this.sourceNode);
        FinancialSettings financialSettings = appProjectModel.getFinancialSettings();
        if (financialSettings == null) {
            return false;
        }
        String string = financialSettings.getCurrencyISOCode();
        for (GanttNode ganttNode : this.targetsNodes) {
            appProjectModel = this.ganttCtrl.getModel().getProjectModel(ganttNode);
            if (!appProjectModel.isFinancialEditable()) {
                return false;
            }
            financialSettings = appProjectModel.getFinancialSettings();
            if (financialSettings == null) {
                return false;
            }
            if (TString.equals(string, financialSettings.getCurrencyISOCode())) continue;
            return false;
        }
        return true;
    }

    private TaskResource[] validateResources(TaskResource[] taskResourceArray, GanttNode ganttNode) {
        if (this.sourceNode.getProjectId().equals(ganttNode.getProjectId())) {
            return taskResourceArray;
        }
        ArrayList<TaskResource> arrayList = new ArrayList<TaskResource>();
        AppProjectModel appProjectModel = this.ganttCtrl.getModel().getProjectModel(ganttNode);
        for (int i = 0; i < taskResourceArray.length; ++i) {
            ProjectResource projectResource = appProjectModel.getProjectResource(taskResourceArray[i].getDn());
            if (projectResource == null && appProjectModel.isResourceEditable()) {
                projectResource = this.ganttCtrl.getModel().copyResourceToProject((ProjectResource)taskResourceArray[i].getResource(), appProjectModel);
            }
            if (projectResource == null) continue;
            TaskResource taskResource = new TaskResource(projectResource, taskResourceArray[i].getUnit());
            arrayList.add(taskResource);
        }
        return arrayList.toArray(new TaskResource[arrayList.size()]);
    }

    private Resource[] validateResources(Resource[] resourceArray, GanttNode ganttNode) {
        if (this.sourceNode.getProjectId().equals(ganttNode.getProjectId())) {
            return resourceArray;
        }
        ArrayList<ProjectResource> arrayList = new ArrayList<ProjectResource>();
        AppProjectModel appProjectModel = this.ganttCtrl.getModel().getProjectModel(ganttNode);
        for (int i = 0; i < resourceArray.length; ++i) {
            ProjectResource projectResource = appProjectModel.getProjectResource(resourceArray[i].getDn());
            if (projectResource == null && appProjectModel.isResourceEditable()) {
                projectResource = this.ganttCtrl.getModel().copyResourceToProject((ProjectResource)resourceArray[i], appProjectModel);
            }
            if (projectResource == null) continue;
            arrayList.add(projectResource);
        }
        return arrayList.toArray(new Resource[arrayList.size()]);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            int n;
            HashSet<String> hashSet = new HashSet<String>();
            Component[] componentArray = this.mainPanel.getComponents();
            for (n = 0; n < componentArray.length; ++n) {
                if (!(componentArray[n] instanceof FieldCheckBox) || !((FieldCheckBox)componentArray[n]).isSelected()) continue;
                hashSet.add(((FieldCheckBox)componentArray[n]).fieldType);
            }
            if (!hashSet.isEmpty()) {
                n = this.sourceNode instanceof GanttTask;
                for (GanttNode ganttNode : this.targetsNodes) {
                    if (this.sourceNode == ganttNode) continue;
                    GanttNode ganttNode2 = ganttNode.clone();
                    boolean bl = ganttNode2 instanceof GanttTask;
                    for (String string : hashSet) {
                        int n2;
                        Cloneable[] cloneableArray;
                        Object object;
                        if (string == "name") {
                            ganttNode2.setName(this.sourceNode.getName());
                        } else if (string == "description") {
                            ganttNode2.setNodeDescription(this.sourceNode.getNodeDescription());
                        } else if (string == "parentInternalId") {
                            object = (GanttWBS)this.sourceNode.getParent();
                            if (object != ganttNode2.getParent()) {
                                cloneableArray = object.getHierarchicalId();
                                n2 = this.ganttCtrl.getModel().getNextTaskSubId((GanttWBS)object);
                                ganttNode2.setHierarchicalId((String)cloneableArray + '.' + n2);
                                ganttNode2.setParent((TGNode)object);
                            }
                        } else if (string == "taskResources") {
                            if (n != 0) {
                                object = ((GanttTask)this.sourceNode).getResourcesCopy();
                                object = this.validateResources((TaskResource[])object, ganttNode2);
                                if (bl) {
                                    ((GanttTask)ganttNode2).setResources((TaskResource[])object);
                                } else {
                                    cloneableArray = null;
                                    if (object != null) {
                                        cloneableArray = new Resource[((Cloneable[])object).length];
                                        for (int i = 0; i < ((Cloneable[])object).length; ++i) {
                                            cloneableArray[i] = ((TaskResource)object[i]).getResource();
                                        }
                                    }
                                    ((GanttWBS)ganttNode2).setResources((Resource[])cloneableArray);
                                }
                            } else {
                                object = ((GanttWBS)this.sourceNode).getResourcesCopy();
                                object = this.validateResources((Resource[])object, ganttNode2);
                                if (bl) {
                                    cloneableArray = null;
                                    if (object != null) {
                                        cloneableArray = new TaskResource[((Cloneable[])object).length];
                                        for (int i = 0; i < ((Cloneable[])object).length; ++i) {
                                            cloneableArray[i] = new TaskResource((Resource)object[i], 100);
                                        }
                                    }
                                    ((GanttTask)ganttNode2).setResources((TaskResource[])cloneableArray);
                                } else {
                                    ((GanttWBS)ganttNode2).setResources((Resource[])object);
                                }
                            }
                        } else if (string == "additionalcost") {
                            ganttNode2.setAdditionalCost(this.sourceNode.getAdditionalCost());
                        } else if (string == "actualadditionalcost") {
                            ganttNode2.setSpecifiedActualAdditionalCost(this.sourceNode.getSpecifiedActualAdditionalCost());
                        } else if (string == "additionalcostdescription") {
                            ganttNode2.setAdditionalCostDescription(this.sourceNode.getAdditionalCostDescription());
                        }
                        if (n == 0 || !bl) continue;
                        object = (GanttTask)this.sourceNode;
                        cloneableArray = (GanttTask)ganttNode2;
                        if (string == "status") {
                            cloneableArray.setStatus(object.getStatus());
                            Status status = Status.fromCode(cloneableArray.getStatus());
                            if (status == Status.PENDING) {
                                cloneableArray.setPercentComplete(0.0);
                                cloneableArray.setActualStartDate(null);
                                cloneableArray.setActualFinishDate(null);
                                cloneableArray.setStatus(status.getCode());
                                continue;
                            }
                            if (status == Status.DONE) {
                                cloneableArray.setPercentComplete(1.0);
                                continue;
                            }
                            double d = cloneableArray.getProgress();
                            if (d == 1.0) {
                                cloneableArray.setPercentComplete(0.99);
                                continue;
                            }
                            if (d != 0.0 || cloneableArray.getActualStartDate() != null) continue;
                            Date date = this.ganttCtrl.getModel().getProjectModel(cloneableArray.getProjectId()).isAutomaticReschedule() ? (Date)cloneableArray.getStartDate().clone() : this.ganttCtrl.getModel().getGlobalContext().convertToServerTimeZone(this.ganttCtrl.getModel().getGlobalContext().getServerTime());
                            cloneableArray.setActualStartDate(date);
                            continue;
                        }
                        if (string == "percentComplete") {
                            cloneableArray.setPercentComplete(object.getPercentComplete());
                            continue;
                        }
                        if (string == "priority") {
                            cloneableArray.setPriority(object.getPriority());
                            continue;
                        }
                        if (string == "schedulingmode") {
                            n2 = object.getSchedulingMode();
                            if ((n2 == SchedulingMode.DEADLINE_DRIVEN.getCode() || n2 == SchedulingMode.FORCE_DATES.getCode()) && cloneableArray.hasPredecessors()) {
                                String string2 = "<html>" + ganttNode.getName() + "<br>";
                                String string3 = AppGanttChart.NLS_BUNDLE.getString("scheduling_constraint_no_predecessor");
                                string2 = string3.startsWith("<html>") ? string2 + string3.substring(6) : string2 + string2 + "</html>";
                                if (!WDDialog.showYesNoDialog(this, string2)) {
                                    cloneableArray.setSchedulingMode(((GanttTask)ganttNode).getSchedulingMode());
                                    continue;
                                }
                                cloneableArray.getPredecessorsList().clear();
                            }
                            cloneableArray.setSchedulingMode(object.getSchedulingMode());
                            continue;
                        }
                        if (string == "calendarid") {
                            cloneableArray.setCalendarId(object.getCalendarId());
                            continue;
                        }
                        if (string != "ignoreresourcecalendar") continue;
                        cloneableArray.setIgnoreResourcesCalendar(object.isIgnoreResourcesCalendar());
                    }
                    try {
                        if (bl) {
                            if (this.ganttCtrl.getModel().checkComputeAndUpdateTaskValues((GanttTask)ganttNode, (GanttTask)ganttNode2, this, 0, true)) continue;
                            continue;
                        }
                        this.ganttCtrl.getModel().checkComputeAndUpdateWBSValues((GanttWBS)ganttNode, (GanttWBS)ganttNode2, this);
                    }
                    catch (Exception exception) {
                        WDDialog.showErrorMsgDialog(this, exception);
                    }
                }
            }
            this.dispose();
        } else {
            this.dispose();
        }
    }

    private static class FieldCheckBox
    extends JCheckBox {
        private String fieldType;

        public FieldCheckBox(String string, String string2) {
            super(string);
            this.fieldType = string2;
        }
    }
}

