/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.dialog;

import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.ui.WDButton;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.gantt.treetable.GanttTreeTableModel;
import com.triloggroup.gantt.treetable.TGTreeTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnsDialog
extends WDDialog
implements ActionListener {
    private static final int DEBUG_MODIFIERS_MASK = 11;
    private AppGanttChart ganttCtrl;
    private String[] currentCols;
    private ArrayList<JCheckBox> checkBoxes;
    private JCheckBox cbName;
    private JCheckBox cbId;
    private ArrayList<String> columns;
    private WDButton okButton;

    public static boolean isDebug(int n) {
        return (n & 0xB) == 11;
    }

    public static void showDialog(AppGanttChart appGanttChart, Component component, Point point, boolean bl) {
        Point point2 = point;
        if (point2 == null) {
            point2 = component.getLocationOnScreen();
            point2.y += component.getHeight() / 2;
            point2.x += component.getWidth() / 2;
        }
        GraphicsConfiguration graphicsConfiguration = WDUtil.getGraphicsConfiguration(point2);
        Window window = SwingUtilities.getWindowAncestor(component);
        ColumnsDialog columnsDialog = new ColumnsDialog(window, appGanttChart, bl, graphicsConfiguration);
        columnsDialog.setLocation(point2);
        columnsDialog.setVisible(true);
    }

    private ColumnsDialog(Window window, AppGanttChart appGanttChart, boolean bl, GraphicsConfiguration graphicsConfiguration) {
        super(window, graphicsConfiguration);
        this.init(appGanttChart, bl);
    }

    private void init(AppGanttChart appGanttChart, boolean bl) {
        this.ganttCtrl = appGanttChart;
        this.checkBoxes = new ArrayList();
        this.columns = new ArrayList();
        GanttTreeTableModel ganttTreeTableModel = (GanttTreeTableModel)appGanttChart.getTreeTable().getModel();
        TGTreeTable tGTreeTable = appGanttChart.getTreeTable();
        this.currentCols = new String[ganttTreeTableModel.getColumnCount()];
        for (int i = 0; i < this.currentCols.length; ++i) {
            this.currentCols[i] = ganttTreeTableModel.getColumnKeyName(tGTreeTable.convertColumnIndexToModel(i));
        }
        this.initUI(bl);
    }

    private void initUI(boolean bl) {
        Object object;
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        AbstractBorder abstractBorder = BorderFactory.createTitledBorder((String)null);
        abstractBorder = new CompoundBorder(new EmptyBorder(5, 5, 5, 5), abstractBorder);
        jPanel.setBorder(abstractBorder);
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.currentCols) {
            hashSet.add(string);
        }
        Object object3 = null;
        if (this.ganttCtrl.getModel().getGlobalContext().hasFinancialModule()) {
            object3 = new HashSet();
            ((HashSet)object3).add("AdditionalCost");
            ((HashSet)object3).add("ActualAdditionalCost");
            ((HashSet)object3).add("AdditionalCostDescription");
            ((HashSet)object3).add("InitiallyPlannedResourceCostSum");
            ((HashSet)object3).add("InitiallyPlannedAdditionalCostSum");
            ((HashSet)object3).add("InitiallyPlannedCostSum");
            ((HashSet)object3).add("ProjectedResourceCostSum");
            ((HashSet)object3).add("ProjectedAdditionalCostSum");
            ((HashSet)object3).add("ProjectedCostSum");
            ((HashSet)object3).add("ActualResourceCostSum");
            ((HashSet)object3).add("ActualAdditionalCostSum");
            ((HashSet)object3).add("ActualCostSum");
        }
        for (String string : this.currentCols) {
            if (object3 != null && ((HashSet)object3).contains(string)) continue;
            this.addCheckBox(string, true, jPanel);
        }
        String[] stringArray = new String[]{"Name", "Id", "StartDate", "EndDate", "Resources", "Status", "Work", "Duration", "Progress", "ActualStart", "ActualFinish", "ActualWork", "RemainingWork", "Priority", "Deadline", "Description", "TotalSlack", "predecessors", "schedulingConstraint"};
        if (this.ganttCtrl.getModel().getGlobalContext().hasTimesheetModule()) {
            String[] stringArray2 = new String[stringArray.length + 1];
            stringArray2[0] = "WorkedHours";
            System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
            stringArray = stringArray2;
        }
        Arrays.sort(stringArray, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                String string3 = AppGanttChart.NLS_BUNDLE.getString(string);
                String string4 = AppGanttChart.NLS_BUNDLE.getString(string2);
                return string3.compareTo(string4);
            }
        });
        for (String object22 : stringArray) {
            this.addCheckBoxIfNotSelected(object22, hashSet, jPanel);
        }
        if (bl) {
            this.addCheckBoxIfNotSelected("Internal Id", hashSet, jPanel);
        }
        if (object3 != null) {
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1));
            jPanel2.setBorder(BorderFactory.createTitledBorder(AppGanttChart.NLS_BUNDLE.getString("financial")));
            jPanel2.add(new JLabel(AppGanttChart.NLS_BUNDLE.getString("CostSum")));
            this.addCheckBox("InitiallyPlannedCostSum", hashSet, jPanel2);
            this.addCheckBox("ProjectedCostSum", hashSet, jPanel2);
            this.addCheckBox("ActualCostSum", hashSet, jPanel2);
            jPanel2.add(new JLabel(AppGanttChart.NLS_BUNDLE.getString("ResourceCostSum")));
            this.addCheckBox("InitiallyPlannedResourceCostSum", hashSet, jPanel2);
            this.addCheckBox("ProjectedResourceCostSum", hashSet, jPanel2);
            this.addCheckBox("ActualResourceCostSum", hashSet, jPanel2);
            jPanel2.add(new JLabel(AppGanttChart.NLS_BUNDLE.getString("AdditionalCostSum")));
            this.addCheckBox("InitiallyPlannedAdditionalCostSum", hashSet, jPanel2);
            this.addCheckBox("ProjectedAdditionalCostSum", hashSet, jPanel2);
            this.addCheckBox("ActualAdditionalCostSum", hashSet, jPanel2);
            jPanel2.add(new JLabel(AppGanttChart.NLS_BUNDLE.getString("AdditionalCost")));
            this.addCheckBox("AdditionalCost", hashSet, jPanel2);
            this.addCheckBox("ActualAdditionalCost", hashSet, jPanel2);
            this.addCheckBox("AdditionalCostDescription", hashSet, jPanel2);
            object = new JPanel(new GridLayout());
            ((Container)object).add(jPanel);
            JPanel jPanel3 = new JPanel(new FlowLayout(1, 0, 0));
            jPanel3.add(jPanel2);
            ((Container)object).add(jPanel3);
        } else {
            object = jPanel;
        }
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        this.okButton = WDUtil.createOkButton();
        jPanel4.add(this.okButton);
        WDButton wDButton = WDUtil.createCancelButton();
        jPanel4.add(wDButton);
        this.okButton.addActionListener(this);
        wDButton.addActionListener(this);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == ColumnsDialog.this.cbName && !ColumnsDialog.this.cbName.isSelected() && !ColumnsDialog.this.cbId.isSelected()) {
                    ColumnsDialog.this.cbId.setSelected(true);
                }
                if (actionEvent.getSource() == ColumnsDialog.this.cbId && !ColumnsDialog.this.cbId.isSelected() && !ColumnsDialog.this.cbName.isSelected()) {
                    ColumnsDialog.this.cbName.setSelected(true);
                }
            }
        };
        this.cbName.addActionListener(actionListener);
        this.cbId.addActionListener(actionListener);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel4, "North");
        jPanel2.add((Component)new JScrollPane((Component)object), "Center");
        this.getContentPane().add(jPanel2);
        this.setDragHeader(true);
        this.setMaximizable(false);
    }

    private void addCheckBoxIfNotSelected(String string, HashSet<String> hashSet, JPanel jPanel) {
        if (hashSet.contains(string)) {
            return;
        }
        this.addCheckBox(string, false, jPanel);
    }

    private void addCheckBox(String string, HashSet<String> hashSet, JPanel jPanel) {
        boolean bl = hashSet.contains(string);
        JCheckBox jCheckBox = this.addCheckBox(string, bl, jPanel);
        jCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
    }

    private JCheckBox addCheckBox(String string, boolean bl, JPanel jPanel) {
        JCheckBox jCheckBox = this.createCheckBox(AppGanttChart.NLS_BUNDLE.getString(string));
        if (bl) {
            jCheckBox.setSelected(true);
        }
        jPanel.add(jCheckBox);
        this.checkBoxes.add(jCheckBox);
        this.columns.add(string);
        if (string == "Name") {
            this.cbName = jCheckBox;
        } else if (string == "Id") {
            this.cbId = jCheckBox;
        }
        return jCheckBox;
    }

    private JCheckBox createCheckBox(String string) {
        JCheckBox jCheckBox = new JCheckBox(string);
        jCheckBox.setOpaque(false);
        jCheckBox.setMargin(new Insets(0, 0, 0, 0));
        jCheckBox.setFocusable(false);
        return jCheckBox;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < this.checkBoxes.size(); ++i) {
                JCheckBox jCheckBox = this.checkBoxes.get(i);
                if (!jCheckBox.isSelected()) continue;
                String string = this.columns.get(i);
                arrayList.add(string);
            }
            String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
            this.ganttCtrl.updateTableColumnOption(stringArray);
            this.ganttCtrl.getUserPreferences().setTableColumns(stringArray);
        }
        this.dispose();
    }
}

