/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app;

import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.TGDuration;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.ui.WDCmdButton;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.gantt.treetable.DurationRenderer;
import com.triloggroup.project.components.ui.table.LeftLineBorder;
import com.triloggroup.project.components.ui.table.TGTableCellRenderer;
import com.triloggroup.project.components.ui.table.TGTableHeaderRenderer;
import com.triloggroup.util.NLSBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;

public abstract class TablePanel
extends JPanel {
    protected static Icon addIcon = WDUtil.getIcon("table_add.gif");
    protected static Icon deleteIcon = WDUtil.getIcon("table_remove.gif");
    protected AppGanttChart ganttChart;
    protected GanttNode node;
    protected NLSBundle nlsBundle = AppGanttChart.NLS_BUNDLE;
    protected JTable table;
    protected JPanel buttonsPanel;
    protected JButton addButton;
    protected JButton deleteButton;

    public TablePanel(AppGanttChart appGanttChart, GanttNode ganttNode) {
        this.ganttChart = appGanttChart;
        this.node = ganttNode;
        this.init();
    }

    protected boolean isUseScrollPane() {
        return false;
    }

    protected void init() {
        this.initTable();
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.setLayout(new FlowLayout(0));
        this.addButton = new WDCmdButton(addIcon);
        this.deleteButton = new WDCmdButton(deleteIcon);
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TablePanel.this.doAdd();
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TablePanel.this.doDelete();
            }
        });
        if (this.ganttChart != null) {
            this.addButton.setEnabled(this.ganttChart.isEditable());
            this.deleteButton.setEnabled(this.ganttChart.isEditable());
        }
        this.buttonsPanel.add(this.addButton);
        this.buttonsPanel.add(this.deleteButton);
        this.add((Component)this.buttonsPanel, "North");
        LeftLineBorder leftLineBorder = new LeftLineBorder();
        if (this.isUseScrollPane()) {
            this.table.setBorder(leftLineBorder);
            this.table.getTableHeader().setBorder(leftLineBorder);
            this.add((Component)new JScrollPane(this.table), "Center");
        } else {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(leftLineBorder);
            jPanel.add((Component)this.table.getTableHeader(), "North");
            jPanel.add((Component)this.table, "Center");
            this.add((Component)jPanel, "Center");
        }
    }

    protected void initTable() {
        this.initTable(new JTable());
    }

    protected void initTable(JTable jTable) {
        this.table = jTable;
        jTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        jTable.setSurrendersFocusOnKeystroke(true);
        jTable.setDefaultRenderer(Object.class, new TGTableCellRenderer());
        jTable.setDefaultRenderer(Number.class, new TGTableCellRenderer(4));
        jTable.setDefaultRenderer(Resource.class, new TGTableCellRenderer(){

            protected void setValue(Object object) {
                if (object == null) {
                    this.setText("");
                    this.setToolTipText(null);
                } else {
                    String string = ((Resource)object).getEmail();
                    if ("".equals(string)) {
                        string = null;
                    }
                    this.setToolTipText(string);
                    this.setText(object.toString());
                }
            }
        });
        jTable.setDefaultRenderer(TGDuration.class, new DurationRenderer(this.ganttChart.getDateLocale()));
        JTableHeader jTableHeader = jTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setDefaultRenderer(new TGTableHeaderRenderer(true));
        jTable.validate();
    }

    protected abstract void doAdd();

    protected abstract void doDelete();

    protected boolean askStopCellEditing() {
        if (!this.stopCellEditing(false)) {
            JOptionPane.showMessageDialog(this, this.nlsBundle.getString("invalidValue"), this.nlsBundle.getString("Warning_msg_title"), 2);
            return false;
        }
        return true;
    }

    public boolean stopCellEditing(boolean bl) {
        TableCellEditor tableCellEditor;
        if (this.table.isEditing() && (tableCellEditor = this.table.getCellEditor()) != null && !tableCellEditor.stopCellEditing()) {
            if (bl) {
                tableCellEditor.cancelCellEditing();
            } else {
                return false;
            }
        }
        return true;
    }

    public void selectRow(int n) {
        this.table.getSelectionModel().setSelectionInterval(n, n);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.table.setEnabled(bl);
        this.addButton.setEnabled(bl);
        this.deleteButton.setEnabled(bl && this.table.getModel().getRowCount() > 0);
    }

    public AbstractTableModel getTableModel() {
        return (AbstractTableModel)this.table.getModel();
    }
}

